/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.marketing.export.service.impl;

import com.baijia.tianxiao.biz.marketing.export.dto.ConsultMessageStatisticData;
import com.baijia.tianxiao.biz.marketing.export.service.ConsultMessageStatisticService;
import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.dal.push.dao.MessageDao;
import com.baijia.tianxiao.util.GenericsUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConsultMessageStatisticServiceImpl
implements ConsultMessageStatisticService {
    @Autowired
    private MessageDao messageDao;

    @Override
    public Map<Long, ConsultMessageStatisticData> getConsultMessageData(Date startDate, Date endDate, List<Long> TianxiaoOrgIds) {
        ConsultMessageStatisticData consultMessage;
        HashMap<Long, ConsultMessageStatisticData> consultMessageDatas = new HashMap<Long, ConsultMessageStatisticData>();
        Map leaveBillCountMap = this.messageDao.getConsultCountByTypeAndOrgIds(startDate, endDate, MessageSource.APPOINTMENT.getValue(), TianxiaoOrgIds);
        Map wechatCountMap = this.messageDao.getConsultCountByTypeAndOrgIds(startDate, endDate, MessageSource.WECHAT.getValue(), TianxiaoOrgIds);
        Map callCountMap = this.messageDao.getConsultCountByTypeAndOrgIds(startDate, endDate, MessageSource.TELEPHONE.getValue(), TianxiaoOrgIds);
        Map clueTotalCountMap = this.messageDao.getConsultTotalByOrgIds(startDate, endDate, TianxiaoOrgIds);
        for (Long orgId : leaveBillCountMap.keySet()) {
            Integer leaveBillCount;
            consultMessage = (ConsultMessageStatisticData)consultMessageDatas.get(orgId);
            if (consultMessage == null) {
                consultMessage = new ConsultMessageStatisticData();
                consultMessageDatas.put(orgId, consultMessage);
            }
            consultMessage.setClueReserve((leaveBillCount = (Integer)leaveBillCountMap.get(orgId)) == null ? 0 : leaveBillCount);
        }
        for (Long orgId : wechatCountMap.keySet()) {
            Integer wechatCount;
            consultMessage = (ConsultMessageStatisticData)consultMessageDatas.get(orgId);
            if (consultMessage == null) {
                consultMessage = new ConsultMessageStatisticData();
                consultMessageDatas.put(orgId, consultMessage);
            }
            consultMessage.setClueWechat((wechatCount = (Integer)wechatCountMap.get(orgId)) == null ? 0 : wechatCount);
        }
        for (Long orgId : callCountMap.keySet()) {
            Integer callCount;
            consultMessage = (ConsultMessageStatisticData)consultMessageDatas.get(orgId);
            if (consultMessage == null) {
                consultMessage = new ConsultMessageStatisticData();
                consultMessageDatas.put(orgId, consultMessage);
            }
            consultMessage.setClueCall((callCount = (Integer)callCountMap.get(orgId)) == null ? 0 : callCount);
        }
        for (Long orgId : clueTotalCountMap.keySet()) {
            Integer wechatTotal;
            consultMessage = (ConsultMessageStatisticData)consultMessageDatas.get(orgId);
            if (consultMessage == null) {
                consultMessage = new ConsultMessageStatisticData();
                consultMessageDatas.put(orgId, consultMessage);
            }
            if (GenericsUtils.isNullOrEmpty((Object)(wechatTotal = (Integer)wechatCountMap.get(orgId)))) {
                wechatTotal = 0;
            }
            Integer clueTotal = (Integer)clueTotalCountMap.get(orgId) + wechatTotal;
            consultMessage.setClueTotal(clueTotal);
        }
        return consultMessageDatas;
    }
}

