/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.marketing.export.service.impl;

import com.baijia.tianxiao.biz.marketing.export.dto.CRMStatisticData;
import com.baijia.tianxiao.biz.marketing.export.service.CRMStatisticService;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.solr.enums.StudentLessonStatus;
import com.baijia.tianxiao.util.GenericsUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CRMStatisticServiceImpl
implements CRMStatisticService {
    private static final Logger log = LoggerFactory.getLogger(CRMStatisticServiceImpl.class);
    @Autowired
    private TxConsultUserDao txConsultUserDao;
    @Autowired
    private OrgStudentDao orgStudentDao;

    @Override
    public Map<Long, CRMStatisticData> getConsultUserSData(Date startDate, Date endDate, List<Long> TianxiaoOrgIds) {
        CRMStatisticData crmStatisticData;
        Map studyingStudentTotalMap;
        HashMap<Long, CRMStatisticData> crmStatisticDataMap = new HashMap<Long, CRMStatisticData>();
        Map consultUserCountsMap = this.txConsultUserDao.getConsultUserTotal(startDate, endDate, TianxiaoOrgIds);
        Map duringStudentCountsMap = this.orgStudentDao.getStudentTotal(startDate, endDate, TianxiaoOrgIds);
        Map studentTotalMap = this.orgStudentDao.getStudentTotal(null, null, TianxiaoOrgIds);
        if (GenericsUtils.notNullAndEmpty((Object)studentTotalMap)) {
            for (Long orgId : studentTotalMap.keySet()) {
                Integer studentTotal;
                CRMStatisticData crmStatisticData2 = (CRMStatisticData)crmStatisticDataMap.get(orgId);
                if (crmStatisticData2 == null) {
                    crmStatisticData2 = new CRMStatisticData();
                    crmStatisticDataMap.put(orgId, crmStatisticData2);
                }
                crmStatisticData2.setStudentTotal((studentTotal = (Integer)studentTotalMap.get(orgId)) == null ? 0 : studentTotal);
            }
        }
        if (GenericsUtils.notNullAndEmpty((Object)(studyingStudentTotalMap = this.orgStudentDao.getStudentTotalByStatus(TianxiaoOrgIds, Integer.valueOf(StudentLessonStatus.STUDYING.getStatus()))))) {
            for (Long orgId : studentTotalMap.keySet()) {
                Integer studyStudentTotal;
                crmStatisticData = (CRMStatisticData)crmStatisticDataMap.get(orgId);
                if (crmStatisticData == null) {
                    crmStatisticData = new CRMStatisticData();
                    crmStatisticDataMap.put(orgId, crmStatisticData);
                }
                crmStatisticData.setStudyStudentTotal((studyStudentTotal = (Integer)studyingStudentTotalMap.get(orgId)) == null ? 0 : studyStudentTotal);
            }
        }
        if (GenericsUtils.notNullAndEmpty((Object)consultUserCountsMap)) {
            for (Long orgId : consultUserCountsMap.keySet()) {
                Integer consultUserTotal;
                crmStatisticData = (CRMStatisticData)crmStatisticDataMap.get(orgId);
                if (crmStatisticData == null) {
                    crmStatisticData = new CRMStatisticData();
                    crmStatisticDataMap.put(orgId, crmStatisticData);
                }
                crmStatisticData.setConsultUserTotal((consultUserTotal = (Integer)consultUserCountsMap.get(orgId)) == null ? 0 : consultUserTotal);
            }
        }
        for (Long orgId : duringStudentCountsMap.keySet()) {
            Integer increaseStudentTotal;
            crmStatisticData = (CRMStatisticData)crmStatisticDataMap.get(orgId);
            if (crmStatisticData == null) {
                crmStatisticData = new CRMStatisticData();
                crmStatisticDataMap.put(orgId, crmStatisticData);
            }
            crmStatisticData.setIncrementStudentTotal((increaseStudentTotal = (Integer)duringStudentCountsMap.get(orgId)) == null ? 0 : increaseStudentTotal);
        }
        return crmStatisticDataMap;
    }
}

