/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.marketing.export.service.impl;

import com.baijia.commons.lang.utils.PropertiesReader;
import com.baijia.commons.lang.utils.collection.CollectionUtils;
import com.baijia.tianxiao.biz.marketing.export.dto.CRMStatisticData;
import com.baijia.tianxiao.biz.marketing.export.dto.ConsultMessageStatisticData;
import com.baijia.tianxiao.biz.marketing.export.dto.ERPStatisticData;
import com.baijia.tianxiao.biz.marketing.export.dto.HagTianxiaoOrgNumber;
import com.baijia.tianxiao.biz.marketing.export.dto.TxBacklogStatisticData;
import com.baijia.tianxiao.biz.marketing.export.dto.WechatStatisticData;
import com.baijia.tianxiao.biz.marketing.export.service.CRMStatisticService;
import com.baijia.tianxiao.biz.marketing.export.service.ConsultMessageStatisticService;
import com.baijia.tianxiao.biz.marketing.export.service.ERPStatisticService;
import com.baijia.tianxiao.biz.marketing.export.service.ExportOrgInfoService;
import com.baijia.tianxiao.biz.marketing.export.service.TxBacklogStatisticService;
import com.baijia.tianxiao.biz.marketing.export.service.WechatStatisticService;
import com.baijia.tianxiao.dal.activity.dao.UploadRecordDao;
import com.baijia.tianxiao.dal.activity.po.UploadRecord;
import com.baijia.tianxiao.dal.advisory.dao.OrgCallRecorderDao;
import com.baijia.tianxiao.dal.msg.dao.TxSmsDao;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgAppLoginLogDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseRoomDao;
import com.baijia.tianxiao.dal.org.dao.OrgGroupMsgDao;
import com.baijia.tianxiao.dal.org.dao.OrgGroupMsgReceiverDao;
import com.baijia.tianxiao.dal.org.dao.OrgHomepageConfigDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.dao.TtsSmsDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.sync.dao.TxMonitorTypeDayDao;
import com.baijia.tianxiao.dal.sync.po.TxMonitorTypeDay;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dto.upload.UploadResult;
import com.baijia.tianxiao.sal.marketing.activity.dto.ActivityStatisticsData;
import com.baijia.tianxiao.sal.marketing.activity.service.ActivityDataExportService;
import com.baijia.tianxiao.sal.marketing.commons.utils.ExcelMailSender;
import com.baijia.tianxiao.sal.marketing.draw.dto.DrawStatisticData;
import com.baijia.tianxiao.sal.marketing.draw.service.DrawDataExportService;
import com.baijia.tianxiao.sal.marketing.export.dto.ExportDto;
import com.baijia.tianxiao.sal.marketing.export.dto.ExportKeyData;
import com.baijia.tianxiao.sal.marketing.referral.dto.ReferralStatisticData;
import com.baijia.tianxiao.sal.marketing.referral.service.ReferralStatisticsService;
import com.baijia.tianxiao.sal.marketing.vote.dto.VoteStatistics;
import com.baijia.tianxiao.sal.marketing.vote.service.VoteDataStatisticService;
import com.baijia.tianxiao.upload.AliyunUploadUtil;
import com.baijia.tianxiao.util.GenericsUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExportOrgInfoServiceImpl
implements ExportOrgInfoService {
    private static final Logger log = LoggerFactory.getLogger(ExportOrgInfoServiceImpl.class);
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private ActivityDataExportService activityDataExportService;
    @Autowired
    private DrawDataExportService drawDataExportService;
    @Autowired
    private VoteDataStatisticService voteDataStatisticService;
    @Autowired
    private ReferralStatisticsService referralStatisticsService;
    @Autowired
    private TxBacklogStatisticService txBacklogStatisticService;
    @Autowired
    private ConsultMessageStatisticService consultMessageStatisticService;
    @Autowired
    private CRMStatisticService crmStatisticService;
    @Autowired
    private WechatStatisticService wechatStatisticService;
    @Autowired
    private ERPStatisticService erpStatisticService;
    @Autowired
    private TeacherDao teacherDao;
    @Autowired
    private OrgCourseRoomDao courseRoomDao;
    @Autowired
    private OrgGroupMsgDao groupMsgDao;
    @Autowired
    private OrgGroupMsgReceiverDao groupMsgReceiverDao;
    @Autowired
    private OrgHomepageConfigDao orgHomepageConfigDao;
    @Autowired
    private TxMonitorTypeDayDao txMonitorTypeDayDao;
    @Autowired
    private OrgAppLoginLogDao orgAppLoginLogDao;
    @Autowired
    private TtsSmsDao ttsSmSDao;
    @Autowired
    private TxSmsDao txSmsDao;
    @Autowired
    private UploadRecordDao uploadRecordDao;
    @Autowired
    private OrgStorageDao orgStorageDao;
    @Autowired
    private OrgCallRecorderDao OrgCallRecorderDao;

    @Override
    public void createExcel(Date startTime, Date endTime) {
        Properties prop = PropertiesReader.fillProperties((String)"upload.properties");
        String url = prop.getProperty("upload.server");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String uid = "tx_statistics_day_" + sdf.format(startTime);
        File file = new File("test.txt");
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        UploadResult result = AliyunUploadUtil.uploadToRemote((String)url, (String)uid, (File)file, (boolean)false);
        if (result.getFiles() != null && result.getFiles().size() > 0) {
            OrgStorage storage = new OrgStorage();
            storage.setFid(((UploadResult.UploadFile)result.getFiles().get(0)).getFid());
            storage.setCreateTime(new Date());
            storage.setUpdateTime(new Date());
            storage.setSize(Integer.valueOf(((UploadResult.UploadFile)result.getFiles().get(0)).getSize()));
            storage.setSn(((UploadResult.UploadFile)result.getFiles().get(0)).getSn());
            storage.setMimeType(Integer.valueOf(0));
            this.orgStorageDao.save(storage);
            UploadRecord record = new UploadRecord();
            record.setCreateTime(new Date());
            record.setFileType(1);
            record.setStorageId(Long.valueOf(storage.getId().longValue()));
            record.setUid(uid);
            this.uploadRecordDao.insertUploadRecord(record);
        }
    }

    @Override
    public List<ExportDto> getExportDtoByDay(Date startDate, Date endDate) {
        Map extensionMap;
        ExportDto exportDto;
        ExportDto exportDto2;
        List txMonitorTypes;
        ExportDto exportDto3;
        Map groupMsgCountMap;
        ExportDto exportDto4;
        ExportDto exportDto5;
        HashMap<Long, ExportDto> exportDtoMap = new HashMap<Long, ExportDto>();
        ArrayList<ExportDto> dataList = new ArrayList<ExportDto>();
        String curDate = null;
        if (startDate != null) {
            curDate = this.getCurDate(startDate);
        }
        List<Integer> TianxiaoOrgNumbers = HagTianxiaoOrgNumber.getOrgNumbers();
        log.info("taixiao\u673a\u6784\u8d26\u53f7\u5217\u8868\u957f\u5ea6==================" + TianxiaoOrgNumbers.size());
        List TianxiaoOrgAccounts = this.orgAccountDao.getAccountByNumbers(TianxiaoOrgNumbers, new String[]{"id", "number"});
        List TianxiaoOrgIds = CollectionUtils.extractList((Collection)TianxiaoOrgAccounts, (CollectionUtils.Extracter)new CollectionUtils.Extracter<Long, OrgAccount>(){

            public Long extract(OrgAccount arg0) {
                return arg0.getId().longValue();
            }
        });
        long start = System.currentTimeMillis();
        Map activityDatas = this.activityDataExportService.getActivityData(startDate, endDate, curDate, TianxiaoOrgIds);
        if (GenericsUtils.notNullAndEmpty((Object)activityDatas)) {
            for (Long orgId : activityDatas.keySet()) {
                ExportDto exportDto6 = (ExportDto)exportDtoMap.get(orgId);
                ActivityStatisticsData activityStaticData = (ActivityStatisticsData)activityDatas.get(orgId);
                if (exportDto6 == null) {
                    exportDto6 = new ExportDto();
                    exportDto6.setDate(curDate == null ? "" : curDate);
                    this.buidExportDtoByOrgId(exportDto6, orgId);
                    exportDtoMap.put(orgId, exportDto6);
                }
                ActivityStatisticsData.setExportDto((ActivityStatisticsData)activityStaticData, (ExportDto)exportDto6);
            }
        }
        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());
        Map drawDatas = this.drawDataExportService.getDrawData(startDate, endDate, curDate, TianxiaoOrgIds);
        if (GenericsUtils.notNullAndEmpty((Object)drawDatas)) {
            for (Long orgId : drawDatas.keySet()) {
                ExportDto exportDto7 = (ExportDto)exportDtoMap.get(orgId);
                DrawStatisticData drawData = (DrawStatisticData)drawDatas.get(orgId);
                if (exportDto7 == null) {
                    exportDto7 = new ExportDto();
                    exportDto7.setDate(curDate);
                    this.buidExportDtoByOrgId(exportDto7, orgId);
                    exportDtoMap.put(orgId, exportDto7);
                }
                DrawStatisticData.setExportDto((DrawStatisticData)drawData, (ExportDto)exportDto7);
            }
        }
        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());
        Map voteDatas = this.voteDataStatisticService.getVoteData(startDate, endDate, curDate, TianxiaoOrgIds);
        if (GenericsUtils.notNullAndEmpty((Object)voteDatas)) {
            for (Long orgId : voteDatas.keySet()) {
                ExportDto exportDto8 = (ExportDto)exportDtoMap.get(orgId);
                VoteStatistics voteData = (VoteStatistics)voteDatas.get(orgId);
                if (exportDto8 == null) {
                    exportDto8 = new ExportDto();
                    exportDto8.setDate(curDate);
                    this.buidExportDtoByOrgId(exportDto8, orgId);
                    exportDtoMap.put(orgId, exportDto8);
                }
                VoteStatistics.buildExportDtoByVoteStatistics((ExportDto)exportDto8, (VoteStatistics)voteData);
            }
        }
        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());
        Map referralDatas = this.referralStatisticsService.getPeriodReferralData(startDate, endDate, curDate, TianxiaoOrgIds);
        if (GenericsUtils.notNullAndEmpty((Object)referralDatas)) {
            for (Long orgId : referralDatas.keySet()) {
                ExportDto exportDto9 = (ExportDto)exportDtoMap.get(orgId);
                ReferralStatisticData referralData = (ReferralStatisticData)referralDatas.get(orgId);
                log.info(referralData.getBrokerNum() + ":" + referralData.getBrowseCount() + ":" + referralData.getReferralActivityTotal() + ":" + referralData.getCustomerNum());
                if (exportDto9 == null) {
                    exportDto9 = new ExportDto();
                    exportDto9.setDate(curDate);
                    this.buidExportDtoByOrgId(exportDto9, orgId);
                    exportDtoMap.put(orgId, exportDto9);
                }
                ReferralStatisticData.buildExportDtoByReferralStatisticData((ExportDto)exportDto9, (ReferralStatisticData)referralData);
            }
        }
        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());
        Map<Long, TxBacklogStatisticData> txBacklogDatas = this.txBacklogStatisticService.getTxBacklogData(startDate, endDate, curDate, TianxiaoOrgIds);
        if (GenericsUtils.notNullAndEmpty(txBacklogDatas)) {
            for (Long orgId : txBacklogDatas.keySet()) {
                TxBacklogStatisticData txBacklogData = txBacklogDatas.get(orgId);
                ExportDto exportDto10 = (ExportDto)exportDtoMap.get(orgId);
                if (exportDto10 == null) {
                    exportDto10 = new ExportDto();
                    exportDto10.setDate(curDate);
                    this.buidExportDtoByOrgId(exportDto10, orgId);
                    exportDtoMap.put(orgId, exportDto10);
                }
                TxBacklogStatisticData.buildExportDtoByTxBacklogStatisticData(exportDto10, txBacklogData);
            }
        }
        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());
        Map<Integer, ConsultMessageStatisticData> consultMessageDatas = this.consultMessageStatisticService.getConsultMessageData(startDate, endDate, curDate, TianxiaoOrgNumbers);
        List orgAccounts = this.orgAccountDao.getAccountByNumbers(consultMessageDatas.keySet(), new String[]{"id", "number"});
        if (GenericsUtils.notNullAndEmpty(consultMessageDatas)) {
            for (OrgAccount orgAccount : orgAccounts) {
                ConsultMessageStatisticData consultMessageStatisticData = consultMessageDatas.get(orgAccount.getNumber());
                Long orgId = orgAccount.getId().longValue();
                exportDto5 = (ExportDto)exportDtoMap.get(orgId);
                if (exportDto5 == null) {
                    exportDto5 = new ExportDto();
                    exportDto5.setDate(curDate);
                    this.buidExportDtoByOrgId(exportDto5, orgId);
                    exportDtoMap.put(orgId, exportDto5);
                }
                ConsultMessageStatisticData.buildExportDtoByConsultMessageStatisticData(exportDto5, consultMessageStatisticData);
            }
        }
        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());
        Map<Long, CRMStatisticData> consultUserCounts = this.crmStatisticService.getConsultUserSData(startDate, endDate, curDate, TianxiaoOrgIds);
        if (GenericsUtils.notNullAndEmpty(consultUserCounts)) {
            for (Long orgId : consultUserCounts.keySet()) {
                ExportDto exportDto11 = (ExportDto)exportDtoMap.get(orgId);
                CRMStatisticData crmStatisticData = consultUserCounts.get(orgId);
                if (exportDto11 == null) {
                    exportDto11 = new ExportDto();
                    exportDto11.setDate(curDate);
                    this.buidExportDtoByOrgId(exportDto11, orgId);
                    exportDtoMap.put(orgId, exportDto11);
                }
                CRMStatisticData.buidExportDtoByCRMStatisticData(crmStatisticData, exportDto11);
            }
        }
        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());
        Map<Long, WechatStatisticData> wechatDatas = this.wechatStatisticService.getWechatStatisticData(startDate, endDate, TianxiaoOrgIds);
        if (GenericsUtils.notNullAndEmpty(wechatDatas)) {
            for (Long orgId : wechatDatas.keySet()) {
                exportDto5 = (ExportDto)exportDtoMap.get(orgId);
                WechatStatisticData wechatData = wechatDatas.get(orgId);
                if (exportDto5 == null) {
                    exportDto5 = new ExportDto();
                    exportDto5.setDate(curDate);
                    this.buidExportDtoByOrgId(exportDto5, orgId);
                    exportDtoMap.put(orgId, exportDto5);
                }
                WechatStatisticData.buildExportDtoByWechatStatisticData(exportDto5, wechatData);
            }
        }
        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());
        Map<Long, ERPStatisticData> ERPDatas = this.erpStatisticService.getERPDatas(startDate, endDate, curDate, TianxiaoOrgNumbers, TianxiaoOrgIds);
        if (GenericsUtils.notNullAndEmpty(ERPDatas)) {
            for (Long orgId : ERPDatas.keySet()) {
                ExportDto exportDto12 = (ExportDto)exportDtoMap.get(orgId);
                ERPStatisticData ERPData = ERPDatas.get(orgId);
                if (exportDto12 == null) {
                    exportDto12 = new ExportDto();
                    this.buidExportDtoByOrgId(exportDto12, orgId);
                    exportDtoMap.put(orgId, exportDto12);
                    exportDto12.setDate(curDate);
                }
                ERPStatisticData.buildExportDtoByERPStatisticData(exportDto12, ERPData);
            }
        }
        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());
        Map teacherCountMap = this.teacherDao.getPeriodOrgTeacher(null, startDate, endDate, TianxiaoOrgIds);
        if (GenericsUtils.notNullAndEmpty((Object)teacherCountMap)) {
            for (Long orgId : teacherCountMap.keySet()) {
                Integer teacherCount = (Integer)teacherCountMap.get(orgId);
                ExportDto exportDto13 = (ExportDto)exportDtoMap.get(orgId);
                if (exportDto13 == null) {
                    exportDto13 = new ExportDto();
                    this.buidExportDtoByOrgId(exportDto13, orgId);
                    exportDtoMap.put(orgId, exportDto13);
                }
                exportDto13.setDate(curDate);
                exportDto13.setTeacherTotal(teacherCount.intValue());
            }
        }
        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());
        Map roomCountMap = this.courseRoomDao.getOrgRoomTotal(startDate, endDate);
        if (GenericsUtils.notNullAndEmpty((Object)roomCountMap) && startDate == null) {
            for (Long orgId : roomCountMap.keySet()) {
                Integer roomCount = (Integer)roomCountMap.get(orgId);
                if (exportDtoMap.containsKey(orgId)) {
                    exportDto4 = (ExportDto)exportDtoMap.get(orgId);
                    exportDto4.setRoomTotal(roomCount.intValue());
                    continue;
                }
                exportDto4 = new ExportDto();
                exportDto4.setRoomTotal(roomCount.intValue());
                this.buidExportDtoByOrgId(exportDto4, orgId);
            }
        }
        if (GenericsUtils.notNullAndEmpty((Object)(groupMsgCountMap = this.groupMsgDao.getOrgGroupMsgTotal(startDate, endDate, TianxiaoOrgIds)))) {
            for (Long orgId : groupMsgCountMap.keySet()) {
                exportDto4 = (ExportDto)exportDtoMap.get(orgId);
                Integer groupMsgCount = (Integer)groupMsgCountMap.get(orgId);
                if (exportDto4 == null) {
                    exportDto4 = new ExportDto();
                    this.buidExportDtoByOrgId(exportDto4, orgId);
                    exportDtoMap.put(orgId, exportDto4);
                }
                exportDto4.setDate(curDate);
                exportDto4.setGroupMsgTotal(groupMsgCount == null ? 0 : groupMsgCount);
            }
        }
        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());
        Map msgReceiverCountMap = this.groupMsgReceiverDao.getMsgReceiverTotal(Boolean.valueOf(true), startDate, endDate, TianxiaoOrgIds);
        if (GenericsUtils.notNullAndEmpty((Object)msgReceiverCountMap)) {
            for (Long orgId : msgReceiverCountMap.keySet()) {
                Integer msgReceiverCount = (Integer)msgReceiverCountMap.get(orgId);
                log.info("\u65b0\u63a5\u53d7\u4eba\u6570================" + msgReceiverCount);
                exportDto3 = (ExportDto)exportDtoMap.get(orgId);
                if (exportDto3 == null) {
                    exportDto3 = new ExportDto();
                    this.buidExportDtoByOrgId(exportDto3, orgId);
                    exportDtoMap.put(orgId, exportDto3);
                }
                exportDto3.setDate(curDate);
                exportDto3.setMsgReceiverTotal(msgReceiverCount == null ? 0 : msgReceiverCount);
            }
        }
        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());
        Set useTemplateOrgIds = this.orgHomepageConfigDao.getUseTemplateOrgIds(TianxiaoOrgIds);
        if (GenericsUtils.notNullAndEmpty((Object)useTemplateOrgIds)) {
            for (Long orgId : useTemplateOrgIds) {
                exportDto3 = (ExportDto)exportDtoMap.get(orgId);
                if (exportDto3 == null) {
                    exportDto3 = new ExportDto();
                    this.buidExportDtoByOrgId(exportDto3, orgId);
                    exportDtoMap.put(orgId, exportDto3);
                }
                exportDto3.setDate(curDate);
                exportDto3.setIsUseHomePage(true);
            }
        }
        if (GenericsUtils.notNullAndEmpty((Object)(txMonitorTypes = this.txMonitorTypeDayDao.listUseMonitorType(startDate, endDate, TianxiaoOrgNumbers)))) {
            Map homePageMonitorOrgNumberMap = CollectionUtils.extractMap((Collection)txMonitorTypes, (CollectionUtils.Extracter)new CollectionUtils.Extracter<Integer, TxMonitorTypeDay>(){

                public Integer extract(TxMonitorTypeDay txMonitorTypeDay) {
                    return txMonitorTypeDay.getOrgNumber().intValue();
                }
            });
            List orgHomePageAccounts = this.orgAccountDao.getAccountByNumbers(homePageMonitorOrgNumberMap.keySet(), new String[]{"id", "number"});
            for (OrgAccount account : orgHomePageAccounts) {
                TxMonitorTypeDay monitorTypeDay;
                exportDto2 = (ExportDto)exportDtoMap.get(account.getId().longValue());
                if (exportDto2 == null) {
                    exportDto2 = new ExportDto();
                    this.buidExportDtoByOrgId(exportDto2, account.getId().longValue());
                    exportDto2.setDate(curDate);
                    exportDtoMap.put(account.getId().longValue(), exportDto2);
                }
                exportDto2.setPvTotal((monitorTypeDay = (TxMonitorTypeDay)homePageMonitorOrgNumberMap.get(account.getNumber())).getPv() == null ? 0 : monitorTypeDay.getPv());
                exportDto2.setUvTotal(monitorTypeDay.getUv() == null ? 0 : monitorTypeDay.getUv());
            }
        }
        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());
        Map loginCountMap = this.orgAppLoginLogDao.getOrgAppLoginTotal(null, startDate, endDate, TianxiaoOrgIds);
        if (GenericsUtils.notNullAndEmpty((Object)loginCountMap)) {
            for (Long orgId : loginCountMap.keySet()) {
                Integer loginCount = (Integer)loginCountMap.get(orgId);
                exportDto2 = (ExportDto)exportDtoMap.get(orgId);
                if (exportDto2 == null) {
                    exportDto2 = new ExportDto();
                    this.buidExportDtoByOrgId(exportDto2, orgId);
                    exportDtoMap.put(orgId, exportDto2);
                }
                exportDto2.setDate(curDate);
                exportDto2.setLoginTotal(loginCount == null ? 0 : loginCount);
            }
        }
        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());
        Map ttsMsgCountMap = this.ttsSmSDao.getOrgTtsSmsCount(startDate, endDate, TianxiaoOrgIds);
        Map txMsgCountMap = this.txSmsDao.getOrgTxSmsCount(startDate, endDate, TianxiaoOrgIds);
        if (GenericsUtils.notNullAndEmpty((Object)ttsMsgCountMap)) {
            for (Long orgId : ttsMsgCountMap.keySet()) {
                if (txMsgCountMap.get(orgId) == null) {
                    txMsgCountMap.put(orgId, ttsMsgCountMap.get(orgId));
                    continue;
                }
                txMsgCountMap.put(orgId, (Integer)txMsgCountMap.get(orgId) + (Integer)ttsMsgCountMap.get(orgId));
            }
        }
        if (GenericsUtils.notNullAndEmpty((Object)txMsgCountMap)) {
            for (Long orgId : txMsgCountMap.keySet()) {
                Integer smsCount = (Integer)txMsgCountMap.get(orgId);
                exportDto = (ExportDto)exportDtoMap.get(orgId);
                if (exportDto == null) {
                    exportDto = new ExportDto();
                    this.buidExportDtoByOrgId(exportDto, orgId);
                    exportDtoMap.put(orgId, exportDto);
                }
                exportDto.setDate(curDate);
                exportDto.setSmsTotal(smsCount == null ? 0 : smsCount);
            }
        }
        if (GenericsUtils.notNullAndEmpty((Object)(extensionMap = this.orgInfoDao.getExtentionsByOrgIds(TianxiaoOrgIds)))) {
            for (Long orgId : exportDtoMap.keySet()) {
                String extension = (String)extensionMap.get(orgId);
                Integer orgCallRecordCount = this.OrgCallRecorderDao.getOrgCallRecordCountByExtexsion(startDate, endDate, extension);
                Integer orgCallRecordTime = this.OrgCallRecorderDao.getOrgCallRecordTimeByExtension(startDate, endDate, extension);
                ExportDto exportDto14 = (ExportDto)exportDtoMap.get(orgId);
                if (exportDto14 == null) {
                    exportDto14 = new ExportDto();
                    exportDtoMap.put(orgId, exportDto14);
                    this.buidExportDtoByOrgId(exportDto14, orgId);
                }
                exportDto14.setDate(curDate);
                exportDto14.setOrgCallRecordCount(orgCallRecordCount == null ? 0 : orgCallRecordCount);
                exportDto14.setOrgCallRecordTime(orgCallRecordTime == null ? 0 : orgCallRecordTime);
            }
        }
        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + ttsMsgCountMap.size());
        for (Long orgId : TianxiaoOrgIds) {
            exportDto = (ExportDto)exportDtoMap.get(orgId);
            if (exportDto == null) {
                exportDto = new ExportDto();
                this.buidExportDtoByOrgId(exportDto, orgId);
                exportDto.setDate(curDate);
            }
            dataList.add(exportDto);
        }
        return dataList;
    }

    private void buidExportDtoByOrgId(ExportDto exportDto, Long orgId) {
        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(orgId.intValue()), new String[0]);
        OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgId.intValue(), new String[0]);
        if (orgAccount == null) {
            // empty if block
        }
        exportDto.setOrgNumber(orgAccount.getNumber());
        if (orgInfo == null) {
            exportDto.setOrgShortName("");
        } else {
            exportDto.setOrgShortName(orgInfo.getShortName());
        }
    }

    private String getCurDate(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String curDate = dateFormat.format(date);
        return curDate;
    }

    public List<ExportKeyData> writeDataToSheet0(HSSFSheet sheet, List<ExportDto> data) {
        ArrayList<ExportKeyData> keyDatas = new ArrayList<ExportKeyData>();
        log.info("[Statistics]Day Size=" + data.size());
        for (int i = 3; i < data.size() + 3; ++i) {
            ExportKeyData keyData = new ExportKeyData();
            HSSFRow row = sheet.createRow(i);
            ExportDto exportDto = data.get(i - 3);
            keyData.setOrgShortName(exportDto.getOrgShortName());
            keyData.setOrgNumber(exportDto.getOrgNumber());
            keyData.setLoginTotal(exportDto.getLoginTotal() + keyData.getLoginTotal());
            keyData.setBacklogFinish(exportDto.getBacklogFinish());
            keyData.setClueTotal(exportDto.getClueTotal());
            keyData.setStudentTotal(exportDto.getStudentTotal());
            keyData.setWechatFansTotal(exportDto.getWechatFansTotal());
            keyData.setCourseTotal(exportDto.getCourseTotal());
            keyData.setArrangedClassTotal(exportDto.getArrangedClassTotal());
            keyData.setCourseSmsTotal(exportDto.getCourseSmsTotal());
            keyData.setSignLessonTotal(exportDto.getSignLessonTotal());
            keyData.setSignStudentTotal(exportDto.getSignStudentTotal());
            keyData.setCommentByTeacher(exportDto.getCommentByTeacher());
            int activityTotal = exportDto.getActivityTotal() + exportDto.getDrawActivityTotal() + exportDto.getVoteActivityTotal() + exportDto.getReferralActivityTotal();
            keyData.setActivityTotal(activityTotal);
            int activityAccessTotal = exportDto.getActivityAccessTotal() + exportDto.getReferralAccessTotal() + exportDto.getVoteAccessTotal();
            keyData.setActivityAccessTotal(activityAccessTotal);
            keyData.setCommentByTeacher(exportDto.getCommentByTeacher());
            keyData.setPvTotal(exportDto.getPvTotal());
            keyData.setUvTotal(exportDto.getUvTotal());
            keyData.setWechatAuthorizerOfStudentTotal(exportDto.getWechatAuthorizerOfStudentTotal());
            keyData.setSmsTotal(exportDto.getSmsTotal());
            keyData.setOrgCallRecordCount(exportDto.getOrgCallRecordCount());
            keyData.setOrgCallRecordTime(exportDto.getOrgCallRecordTime());
            row.createCell((short)0).setCellValue(exportDto.getDate());
            row.createCell((short)1).setCellValue(exportDto.getOrgShortName());
            if (exportDto.getOrgNumber() == null) {
                log.info("[Excel] null=" + ToStringBuilder.reflectionToString((Object)exportDto));
            }
            row.createCell((short)2).setCellValue((double)exportDto.getOrgNumber().intValue());
            if (exportDto.getBacklogTotal() != 0) {
                row.createCell((short)5).setCellValue((double)exportDto.getBacklogTotal());
            }
            if (exportDto.getBacklogFinish() != 0) {
                row.createCell((short)6).setCellValue((double)exportDto.getBacklogFinish());
            }
            if (exportDto.getBacklogExpire() != 0) {
                row.createCell((short)7).setCellValue((double)exportDto.getBacklogExpire());
            }
            if (exportDto.getClueTotal() != 0) {
                row.createCell((short)8).setCellValue((double)exportDto.getClueTotal());
            }
            if (exportDto.getClueWechat() != 0) {
                row.createCell((short)9).setCellValue((double)exportDto.getClueWechat());
            }
            if (exportDto.getClueReserve() != 0) {
                row.createCell((short)10).setCellValue((double)exportDto.getClueReserve());
            }
            if (exportDto.getClueCall() != 0) {
                row.createCell((short)11).setCellValue((double)exportDto.getClueCall());
            }
            if (exportDto.getConsultUserTotal() != 0) {
                row.createCell((short)12).setCellValue((double)exportDto.getConsultUserTotal());
            }
            if (exportDto.getStudentTotal() != 0) {
                row.createCell((short)13).setCellValue((double)exportDto.getStudentTotal());
            }
            if (exportDto.getIsWechatAuthorizer()) {
                row.createCell((short)14).setCellValue(exportDto.getIsWechatAuthorizer());
            }
            if (exportDto.getIsWechatMenu()) {
                row.createCell((short)15).setCellValue(exportDto.getIsWechatMenu());
            }
            if (exportDto.getWechatFansTotal() != 0) {
                row.createCell((short)16).setCellValue((double)exportDto.getWechatFansTotal());
            }
            if (exportDto.getCourseTotal() != 0) {
                row.createCell((short)17).setCellValue((double)exportDto.getCourseTotal());
            }
            if (exportDto.getArrangedClassTotal() != 0) {
                row.createCell((short)18).setCellValue((double)exportDto.getArrangedClassTotal());
            }
            if (exportDto.getLessonTotal() != 0) {
                row.createCell((short)19).setCellValue((double)exportDto.getLessonTotal());
            }
            if (exportDto.getCourseSmsTotal() != 0) {
                row.createCell((short)20).setCellValue((double)exportDto.getCourseSmsTotal());
            }
            if (exportDto.getIncomeSum() != 0.0) {
                row.createCell((short)21).setCellValue(exportDto.getIncomeSum());
            }
            if (exportDto.getIncomeTotal() != 0) {
                row.createCell((short)22).setCellValue((double)exportDto.getIncomeTotal());
            }
            if (exportDto.getSignLessonTotal() != 0) {
                row.createCell((short)23).setCellValue((double)exportDto.getSignLessonTotal());
            }
            if (exportDto.getSignStudentTotal() != 0) {
                row.createCell((short)24).setCellValue((double)exportDto.getSignStudentTotal());
            }
            if (exportDto.getCashPurchaseSum() != 0.0) {
                row.createCell((short)25).setCellValue(exportDto.getCashPurchaseSum());
            }
            if (exportDto.getCommentByStudent() != 0) {
                row.createCell((short)26).setCellValue((double)exportDto.getCommentByStudent());
            }
            if (exportDto.getCommentByTeacher() != 0) {
                row.createCell((short)27).setCellValue((double)exportDto.getCommentByTeacher());
            }
            if (exportDto.getTeacherTotal() != 0) {
                row.createCell((short)28).setCellValue((double)exportDto.getTeacherTotal());
            }
            if (exportDto.getRoomTotal() != 0) {
                row.createCell((short)29).setCellValue((double)exportDto.getRoomTotal());
            }
            if (exportDto.getActivityTotal() != 0) {
                row.createCell((short)30).setCellValue((double)exportDto.getActivityTotal());
            }
            if (exportDto.getActivityAccessTotal() != 0) {
                row.createCell((short)31).setCellValue((double)exportDto.getActivityAccessTotal());
            }
            if (exportDto.getActivityEnrollTotal() != 0) {
                row.createCell((short)32).setCellValue((double)exportDto.getActivityEnrollTotal());
            }
            if (exportDto.getDrawActivityTotal() != 0) {
                row.createCell((short)33).setCellValue((double)exportDto.getDrawActivityTotal());
            }
            if (exportDto.getDrawUserTotal() != 0) {
                row.createCell((short)34).setCellValue((double)exportDto.getDrawUserTotal());
            }
            if (exportDto.getDrawWinnerTotal() != 0) {
                row.createCell((short)35).setCellValue((double)exportDto.getDrawWinnerTotal());
            }
            if (exportDto.getVoteActivityTotal() != 0) {
                row.createCell((short)36).setCellValue((double)exportDto.getVoteActivityTotal());
            }
            if (exportDto.getVoteAccessTotal() != 0) {
                row.createCell((short)37).setCellValue((double)exportDto.getVoteAccessTotal());
            }
            if (exportDto.getVoteTotal() != 0) {
                row.createCell((short)38).setCellValue((double)exportDto.getVoteTotal());
            }
            if (exportDto.getReferralActivityTotal() != 0) {
                row.createCell((short)39).setCellValue((double)exportDto.getReferralActivityTotal());
            }
            if (exportDto.getReferralAccessTotal() != 0) {
                row.createCell((short)40).setCellValue((double)exportDto.getReferralAccessTotal());
            }
            if (exportDto.getBrokerTotal() != 0) {
                row.createCell((short)41).setCellValue((double)exportDto.getBrokerTotal());
            }
            if (exportDto.getReferralTotal() != 0) {
                row.createCell((short)42).setCellValue((double)exportDto.getReferralTotal());
            }
            if (exportDto.getGroupMsgTotal() != 0) {
                row.createCell((short)43).setCellValue((double)exportDto.getGroupMsgTotal());
            }
            if (exportDto.getMsgReceiverTotal() != 0) {
                row.createCell((short)44).setCellValue((double)exportDto.getMsgReceiverTotal());
            }
            if (exportDto.getIsUseHomePage()) {
                row.createCell((short)45).setCellValue(exportDto.getIsUseHomePage());
            }
            if (exportDto.getUvTotal() != 0) {
                row.createCell((short)46).setCellValue((double)exportDto.getUvTotal());
            }
            if (exportDto.getPvTotal() != 0) {
                row.createCell((short)47).setCellValue((double)exportDto.getPvTotal());
            }
            if (exportDto.getLoginTotal() != 0) {
                row.createCell((short)48).setCellValue((double)exportDto.getLoginTotal());
            }
            if (exportDto.getWechatAuthorizerOfStudentTotal() != 0) {
                row.createCell((short)49).setCellValue((double)exportDto.getWechatAuthorizerOfStudentTotal());
            }
            if (exportDto.getSmsTotal() != 0) {
                row.createCell((short)50).setCellValue((double)exportDto.getSmsTotal());
            }
            if (exportDto.getOrgCallRecordCount() != 0) {
                row.createCell((short)51).setCellValue((double)exportDto.getOrgCallRecordCount());
            }
            if (exportDto.getOrgCallRecordTime() != 0) {
                row.createCell((short)52).setCellValue((double)exportDto.getOrgCallRecordTime());
            }
            keyDatas.add(keyData);
        }
        return keyDatas;
    }

    public void writeDataToSheet1(HSSFSheet sheet, List<ExportDto> data) {
        log.info("[Statistics]Total Size=" + data.size());
        for (int i = 3; i < data.size() + 3; ++i) {
            HSSFRow row = sheet.createRow(i);
            ExportDto exportDto = data.get(i - 3);
            row.createCell((short)0).setCellValue(exportDto.getOrgShortName());
            row.createCell((short)1).setCellValue((double)exportDto.getOrgNumber().intValue());
            if (exportDto.getBacklogTotal() != 0) {
                row.createCell((short)4).setCellValue((double)exportDto.getBacklogTotal());
            }
            if (exportDto.getBacklogFinish() != 0) {
                row.createCell((short)5).setCellValue((double)exportDto.getBacklogFinish());
            }
            if (exportDto.getBacklogExpire() != 0) {
                row.createCell((short)6).setCellValue((double)exportDto.getBacklogExpire());
            }
            if (exportDto.getClueTotal() != 0) {
                row.createCell((short)7).setCellValue((double)exportDto.getClueTotal());
            }
            if (exportDto.getClueWechat() != 0) {
                row.createCell((short)8).setCellValue((double)exportDto.getClueWechat());
            }
            if (exportDto.getClueReserve() != 0) {
                row.createCell((short)9).setCellValue((double)exportDto.getClueReserve());
            }
            if (exportDto.getClueCall() != 0) {
                row.createCell((short)10).setCellValue((double)exportDto.getClueCall());
            }
            if (exportDto.getConsultUserTotal() != 0) {
                row.createCell((short)11).setCellValue((double)exportDto.getConsultUserTotal());
            }
            if (exportDto.getStudentTotal() != 0) {
                row.createCell((short)12).setCellValue((double)exportDto.getStudentTotal());
            }
            if (exportDto.getIsWechatAuthorizer()) {
                row.createCell((short)13).setCellValue(exportDto.getIsWechatAuthorizer());
            }
            if (exportDto.getIsWechatMenu()) {
                row.createCell((short)14).setCellValue(exportDto.getIsWechatMenu());
            }
            if (exportDto.getWechatFansTotal() != 0) {
                row.createCell((short)15).setCellValue((double)exportDto.getWechatFansTotal());
            }
            if (exportDto.getCourseTotal() != 0) {
                row.createCell((short)16).setCellValue((double)exportDto.getCourseTotal());
            }
            if (exportDto.getArrangedClassTotal() != 0) {
                row.createCell((short)17).setCellValue((double)exportDto.getArrangedClassTotal());
            }
            if (exportDto.getLessonTotal() != 0) {
                row.createCell((short)18).setCellValue((double)exportDto.getLessonTotal());
            }
            if (exportDto.getCourseSmsTotal() != 0) {
                row.createCell((short)19).setCellValue((double)exportDto.getCourseSmsTotal());
            }
            if (exportDto.getIncomeSum() != 0.0) {
                row.createCell((short)20).setCellValue(exportDto.getIncomeSum());
            }
            if (exportDto.getIncomeTotal() != 0) {
                row.createCell((short)21).setCellValue((double)exportDto.getIncomeTotal());
            }
            if (exportDto.getSignLessonTotal() != 0) {
                row.createCell((short)22).setCellValue((double)exportDto.getSignLessonTotal());
            }
            if (exportDto.getSignStudentTotal() != 0) {
                row.createCell((short)23).setCellValue((double)exportDto.getSignStudentTotal());
            }
            if (exportDto.getCashPurchaseSum() != 0.0) {
                row.createCell((short)24).setCellValue(exportDto.getCashPurchaseSum());
            }
            if (exportDto.getCommentByStudent() != 0) {
                row.createCell((short)25).setCellValue((double)exportDto.getCommentByStudent());
            }
            if (exportDto.getCommentByTeacher() != 0) {
                row.createCell((short)26).setCellValue((double)exportDto.getCommentByTeacher());
            }
            if (exportDto.getTeacherTotal() != 0) {
                row.createCell((short)27).setCellValue((double)exportDto.getTeacherTotal());
            }
            if (exportDto.getRoomTotal() != 0) {
                row.createCell((short)28).setCellValue((double)exportDto.getRoomTotal());
            }
            if (exportDto.getActivityTotal() != 0) {
                row.createCell((short)29).setCellValue((double)exportDto.getActivityTotal());
            }
            if (exportDto.getActivityAccessTotal() != 0) {
                row.createCell((short)30).setCellValue((double)exportDto.getActivityAccessTotal());
            }
            if (exportDto.getActivityEnrollTotal() != 0) {
                row.createCell((short)31).setCellValue((double)exportDto.getActivityEnrollTotal());
            }
            if (exportDto.getDrawActivityTotal() != 0) {
                row.createCell((short)32).setCellValue((double)exportDto.getDrawActivityTotal());
            }
            if (exportDto.getDrawUserTotal() != 0) {
                row.createCell((short)33).setCellValue((double)exportDto.getDrawUserTotal());
            }
            if (exportDto.getDrawWinnerTotal() != 0) {
                row.createCell((short)34).setCellValue((double)exportDto.getDrawWinnerTotal());
            }
            if (exportDto.getVoteActivityTotal() != 0) {
                row.createCell((short)35).setCellValue((double)exportDto.getVoteActivityTotal());
            }
            if (exportDto.getVoteAccessTotal() != 0) {
                row.createCell((short)36).setCellValue((double)exportDto.getVoteAccessTotal());
            }
            if (exportDto.getVoteTotal() != 0) {
                row.createCell((short)37).setCellValue((double)exportDto.getVoteTotal());
            }
            if (exportDto.getReferralActivityTotal() != 0) {
                row.createCell((short)38).setCellValue((double)exportDto.getReferralActivityTotal());
            }
            if (exportDto.getReferralAccessTotal() != 0) {
                row.createCell((short)39).setCellValue((double)exportDto.getReferralAccessTotal());
            }
            if (exportDto.getBrokerTotal() != 0) {
                row.createCell((short)40).setCellValue((double)exportDto.getBrokerTotal());
            }
            if (exportDto.getReferralTotal() != 0) {
                row.createCell((short)41).setCellValue((double)exportDto.getReferralTotal());
            }
            if (exportDto.getGroupMsgTotal() != 0) {
                row.createCell((short)42).setCellValue((double)exportDto.getGroupMsgTotal());
            }
            if (exportDto.getMsgReceiverTotal() != 0) {
                row.createCell((short)43).setCellValue((double)exportDto.getMsgReceiverTotal());
            }
            if (exportDto.getIsUseHomePage()) {
                row.createCell((short)44).setCellValue(exportDto.getIsUseHomePage());
            }
            if (exportDto.getUvTotal() != 0) {
                row.createCell((short)45).setCellValue((double)exportDto.getUvTotal());
            }
            if (exportDto.getPvTotal() != 0) {
                row.createCell((short)46).setCellValue((double)exportDto.getPvTotal());
            }
            if (exportDto.getLoginTotal() != 0) {
                row.createCell((short)47).setCellValue((double)exportDto.getLoginTotal());
            }
            if (exportDto.getWechatAuthorizerOfStudentTotal() != 0) {
                row.createCell((short)48).setCellValue((double)exportDto.getWechatAuthorizerOfStudentTotal());
            }
            if (exportDto.getSmsTotal() != 0) {
                row.createCell((short)49).setCellValue((double)exportDto.getSmsTotal());
            }
            if (exportDto.getOrgCallRecordCount() != 0) {
                row.createCell((short)50).setCellValue((double)exportDto.getOrgCallRecordCount());
            }
            if (exportDto.getOrgCallRecordTime() == 0) continue;
            row.createCell((short)51).setCellValue((double)exportDto.getOrgCallRecordTime());
        }
    }

    @Override
    public void createHSSFWorkbook(Date startTime, Date endTime) {
        List<ExportDto> dayData = this.getExportDtoByDay(startTime, endTime);
        List<ExportDto> totalData = this.getExportDtoByDay(null, endTime);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String curDate = dateFormat.format(startTime);
        try {
            HSSFSheet sheet;
            HSSFWorkbook wb;
            InputStream dayIn = this.getClass().getResourceAsStream("/template/template-excelByDay.xls");
            InputStream totaIn = this.getClass().getResourceAsStream("/template/template-excelTotal.xls");
            File[] files = new File[2];
            List<ExportKeyData> keyDatas = new ArrayList<ExportKeyData>();
            if (GenericsUtils.notNullAndEmpty(dayData)) {
                wb = new HSSFWorkbook(dayIn);
                sheet = wb.getSheetAt(0);
                wb.setSheetName(0, wb.getSheetName(0));
                keyDatas = this.writeDataToSheet0(sheet, dayData);
                files[0] = this.createFil(wb, curDate + "excelByDay.xls");
            }
            if (GenericsUtils.notNullAndEmpty(totalData)) {
                wb = new HSSFWorkbook(totaIn);
                sheet = wb.getSheetAt(0);
                wb.setSheetName(0, wb.getSheetName(0));
                this.writeDataToSheet1(sheet, totalData);
                files[1] = this.createFil(wb, curDate + "excelTotal.xls");
            }
            String email = "gaodan@baijiahulian.com,taoyaping@baijiahulian.com,lishaoheng@baijiahulian.com,zhangxiang@baijiahulian.com,liuxiaopeng@baijiahulian.com,denghong@baijiahulian.com,lujia@baijiahulian.com,liyannan@baijiahulian.com,tx-pm@baijiahulian.com";
            String content = this.getContent(keyDatas);
            ExcelMailSender.sendMail((String)email, (String)(curDate + "\u5929\u6821\u76d1\u63a7\u6570\u636e"), (String)content, (File[])files);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            log.info("excel\u6587\u4ef6\u521b\u5efa\u5931\u8d25");
        }
        catch (IOException e) {
            e.printStackTrace();
            log.info("excel\u6587\u4ef6\u521b\u5efa\u5931\u8d25");
        }
    }

    private String getContent(List<ExportKeyData> keyDatas) {
        StringBuffer sb = new StringBuffer("<head style=\"font-size:14px\"> \n<style>.c-gray{ background-color: #D8D9DB;}\n .c-orange{background-color: #FDC20E;}\n .c-yellow{background-color: #FEFF0D;}\n .c-green{background-color: #94D351;}\n .c-blue { background-color: #1AAFF1;}\n .c-purple {background-color: #D9E0F2;}\n </style>\n</head>\n<body>\n <table class=\"table table-bordered\" cellpadding=\"8\" cellspacing=\"0\" style=\"width:100%;text-align:center; border: 1px solid #ddd;font-size:13px\">\n<thead>\n<tr>\n<th width=\"100\" class=\"c-gray\">\u673a\u6784\u540d\u79f0</th>\n <th width=\"100\"class=\"c-gray\">\u673a\u6784ID</th>\n<th width=\"100\" class=\"c-orange\">\u4eca\u65e5\u673a\u6784\u767b\u9646\u6b21\u6570(\u5305\u542b\u5b50\u8d26\u53f7)</th>\n<th width=\"100\" class=\"c-yellow\">\u7ebf\u7d22\u65b0\u589e\u603b\u6570</th>\n<th width=\"100\" class=\"c-yellow\">\u65b0\u589e\u5b66\u5458\u6570</th>\n<th width=\"100\" class=\"c-yellow\">\u5fae\u4fe1\u7c89\u4e1d\u65b0\u589e\u6570\uff08\u51c0\u589e\u957f\uff09</th>\n<th width=\"100\" class=\"c-green\">\u65b0\u589e\u5fae\u8bfe\u6570</th>\n<th width=\"100\" class=\"c-green\">\u65b0\u6392\u8bfe\u73ed\u7ea7\u6570</th>\n<th width=\"100\" class=\"c-green\">\u65b0\u53d1\u9001\u8bfe\u8868\u6570\u91cf</th>\n<th width=\"100\" class=\"c-green\">\u4eca\u65e5\u7b7e\u5230\u8bfe\u8282\u6570</th>\n<th width=\"100\" class=\"c-green\">\u4eca\u65e5\u7b7e\u5230\u4eba\u6b21</th>\n<th width=\"100\" class=\"c-green\">\u4eca\u65e5\u8001\u5e08\u4e3b\u52a8\u70b9\u8bc4\u6570</th>\n<th width=\"100\" class=\"c-blue\">\u4eca\u65e5\u65b0\u589e\u6d3b\u52a8\u603b\u6570</th>\n<th width=\"100\"class=\"c-blue\">\u4eca\u65e5\u65b0\u589e\u8bbf\u95ee\u603b\u6570</th>\n<th width=\"100\" class=\"c-purple\">\u4eca\u65e5\u65b0\u589eUV</th>\n<th width=\"100\" class=\"c-purple\">\u4eca\u65e5\u65b0\u589ePV</th>\n<th width=\"100\" class=\"c-purple\">\u65b0\u589e\u7ed1\u5b9a\u5fae\u4fe1\u516c\u4f17\u53f7\u5b66\u751f\u6570</th>\n<th width=\"100\" class=\"c-purple\">\u65b0\u53d1\u77ed\u4fe1\u6570</th>\n<th width=\"100\" class=\"c-purple\">\u65b0\u589e400\u7535\u8bdd\u603b\u547c\u51fa\u6570</th>\n<th width=\"100\" class=\"c-purple\">\u65b0\u589e400\u7535\u8bdd\u603b\u547c\u51fa\u65f6\u957f</th>\n</tr>\n</thead>\n<tbody>\n");
        for (ExportKeyData keyData : keyDatas) {
            sb.append("<tr>");
            sb.append("<td>" + keyData.getOrgShortName() + "</td>");
            sb.append("<td>" + keyData.getOrgNumber() + "</td>");
            if (keyData.getLoginTotal() == 0) {
                sb.append("<td></td>");
            } else {
                sb.append("<td>" + keyData.getLoginTotal() + "</td>");
            }
            if (keyData.getClueTotal() == 0) {
                sb.append("<td></td>");
            } else {
                sb.append("<td>" + keyData.getClueTotal() + "</td>");
            }
            if (keyData.getStudentTotal() == 0) {
                sb.append("<td></td>");
            } else {
                sb.append("<td>" + keyData.getStudentTotal() + "</td>");
            }
            if (keyData.getWechatFansTotal() == 0) {
                sb.append("<td></td>");
            } else {
                sb.append("<td>" + keyData.getWechatFansTotal() + "</td>");
            }
            if (keyData.getCourseTotal() == 0) {
                sb.append("<td></td>");
            } else {
                sb.append("<td>" + keyData.getCourseTotal() + "</td>");
            }
            if (keyData.getArrangedClassTotal() == 0) {
                sb.append("<td></td>");
            } else {
                sb.append("<td>" + keyData.getArrangedClassTotal() + "</td>");
            }
            if (keyData.getCourseSmsTotal() == 0) {
                sb.append("<td></td>");
            } else {
                sb.append("<td>" + keyData.getCourseSmsTotal() + "</td>");
            }
            if (keyData.getSignLessonTotal() == 0) {
                sb.append("<td></td>");
            } else {
                sb.append("<td>" + keyData.getSignLessonTotal() + "</td>");
            }
            if (keyData.getSignStudentTotal() == 0) {
                sb.append("<td></td>");
            } else {
                sb.append("<td>" + keyData.getSignStudentTotal() + "</td>");
            }
            if (keyData.getCommentByTeacher() == 0) {
                sb.append("<td></td>");
            } else {
                sb.append("<td>" + keyData.getCommentByTeacher() + "</td>");
            }
            if (keyData.getActivityTotal() == 0) {
                sb.append("<td></td>");
            } else {
                sb.append("<td>" + keyData.getActivityTotal() + "</td>");
            }
            if (keyData.getActivityAccessTotal() == 0) {
                sb.append("<td></td>");
            } else {
                sb.append("<td>" + keyData.getActivityAccessTotal() + "</td>");
            }
            if (keyData.getUvTotal() == 0) {
                sb.append("<td></td>");
            } else {
                sb.append("<td>" + keyData.getUvTotal() + "</td>");
            }
            if (keyData.getPvTotal() == 0) {
                sb.append("<td></td>");
            } else {
                sb.append("<td>" + keyData.getPvTotal() + "</td>");
            }
            if (keyData.getWechatAuthorizerOfStudentTotal() == 0) {
                sb.append("<td></td>");
            } else {
                sb.append("<td>" + keyData.getWechatAuthorizerOfStudentTotal() + "</td>");
            }
            if (keyData.getSmsTotal() == 0) {
                sb.append("<td></td>");
            } else {
                sb.append("<td>" + keyData.getSmsTotal() + "</td>");
            }
            if (keyData.getOrgCallRecordCount() == 0) {
                sb.append("<td></td>");
            } else {
                sb.append("<td>" + keyData.getOrgCallRecordCount() + "</td>");
            }
            if (keyData.getOrgCallRecordTime() == 0) {
                sb.append("<td></td>");
            } else {
                sb.append("<td>" + keyData.getOrgCallRecordTime() + "</td>");
            }
            sb.append("</tr>");
        }
        sb.append("</tbody></table></article>");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private File createFil(HSSFWorkbook wb, String fileName) {
        File localFile = new File(fileName);
        if (!localFile.exists()) {
            try {
                localFile.createNewFile();
            }
            catch (IOException e) {
                return null;
            }
        }
        FileOutputStream out = null;
        BufferedOutputStream bos = null;
        try {
            out = new FileOutputStream(localFile);
            bos = new BufferedOutputStream(out);
            wb.write((OutputStream)bos);
            wb = null;
        }
        catch (Exception exception) {
            IOUtils.closeQuietly(bos);
            IOUtils.closeQuietly((OutputStream)out);
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bos);
                IOUtils.closeQuietly((OutputStream)out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)bos);
        IOUtils.closeQuietly((OutputStream)out);
        return localFile;
    }
}

