/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.marketing.export.dto;

import com.baijia.commons.lang.utils.JacksonUtil;
import com.baijia.tianxiao.biz.marketing.export.dto.HagDownload;
import com.baijia.tianxiao.biz.marketing.export.dto.TianxiaoOrgNumber;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HagTianxiaoOrgNumber {
    private static final Logger log = LoggerFactory.getLogger(HagTianxiaoOrgNumber.class);

    public static List<Integer> getOrgNumbers() {
        ArrayList<Integer> orgNumbers = new ArrayList<Integer>();
        String numberStr = null;
        try {
            HashMap params = Maps.newHashMap();
            params.put("resource", "jigou_tianxiao_orgNumber");
            log.info("jigou_tianxiao_orgNumber");
            String url = "http://xiaoliuliang.baijiahulian.com/downloadList.action";
            String response = HttpClientUtils.doPost((String)url, (Map)params);
            HagDownload hagDto = (HagDownload)JacksonUtil.str2Obj((String)response, HagDownload.class);
            if (hagDto == null || GenericsUtils.isNullOrEmpty((Object)hagDto.getData())) {
                log.info("hagDto\u6570\u636e\u4e3a\u7a7a=========================");
                return null;
            }
            List<Integer> orgTestNumbers = HagTianxiaoOrgNumber.getOrgTestNumbers();
            for (int i = 0; i < hagDto.getData().size(); ++i) {
                numberStr = ((String)hagDto.getData().get(i)).split("#")[0];
                if (orgTestNumbers.contains(Integer.parseInt(numberStr))) continue;
                orgNumbers.add(Integer.parseInt(numberStr));
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
        log.info("\u53bb\u9664\u6d4b\u8bd5\u673a\u6784\u540e\u7684\u957f\u5ea6==============" + orgNumbers.size());
        return orgNumbers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Integer> getOrgTestNumbers() {
        String path = TianxiaoOrgNumber.class.getResource("/").getPath();
        ArrayList<Integer> orgTestNumbers = new ArrayList<Integer>();
        File file1 = new File(path + "template/orgNumberTest.txt");
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(file1));
            String numberStr = "";
            while ((numberStr = br.readLine()) != null) {
                orgTestNumbers.add(Integer.parseInt(numberStr));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return orgTestNumbers;
    }

    public static void main(String[] args) {
        HagTianxiaoOrgNumber.getOrgNumbers();
    }
}

