/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.marketing.export.service.impl;

import com.baijia.commons.lang.utils.PropertiesReader;
import com.baijia.commons.lang.utils.collection.CollectionUtils;
import com.baijia.tianxiao.biz.marketing.export.constant.AccountTypeEnum;
import com.baijia.tianxiao.biz.marketing.export.constant.TeacherStatus;
import com.baijia.tianxiao.biz.marketing.export.dto.CRMStatisticData;
import com.baijia.tianxiao.biz.marketing.export.dto.ClassLessonDetailDto;
import com.baijia.tianxiao.biz.marketing.export.dto.ConsultMessageStatisticData;
import com.baijia.tianxiao.biz.marketing.export.dto.ERPStatisticData;
import com.baijia.tianxiao.biz.marketing.export.dto.ExportClientDemandDto;
import com.baijia.tianxiao.biz.marketing.export.dto.OrgCourseDetailDto;
import com.baijia.tianxiao.biz.marketing.export.dto.OrgSignDto;
import com.baijia.tianxiao.biz.marketing.export.dto.OrgTypeDto;
import com.baijia.tianxiao.biz.marketing.export.dto.StatisticByWeekOrMonthDto;
import com.baijia.tianxiao.biz.marketing.export.dto.TxBacklogStatisticData;
import com.baijia.tianxiao.biz.marketing.export.dto.WechatStatisticData;
import com.baijia.tianxiao.biz.marketing.export.service.CRMStatisticService;
import com.baijia.tianxiao.biz.marketing.export.service.ConsultMessageStatisticService;
import com.baijia.tianxiao.biz.marketing.export.service.ERPStatisticService;
import com.baijia.tianxiao.biz.marketing.export.service.ExportOrgInfoService;
import com.baijia.tianxiao.biz.marketing.export.service.OrgTypeService;
import com.baijia.tianxiao.biz.marketing.export.service.TxBacklogStatisticService;
import com.baijia.tianxiao.biz.marketing.export.service.WechatStatisticService;
import com.baijia.tianxiao.biz.marketing.utils.BIzConf;
import com.baijia.tianxiao.biz.marketing.utils.HagTianxiaoOrgNumber;
import com.baijia.tianxiao.constant.SignStatus;
import com.baijia.tianxiao.dal.activity.dao.ActivityAccessLogDao;
import com.baijia.tianxiao.dal.activity.dao.ActivityDao;
import com.baijia.tianxiao.dal.activity.dao.UploadRecordDao;
import com.baijia.tianxiao.dal.activity.dao.draw.ActivityUserDao;
import com.baijia.tianxiao.dal.activity.dao.draw.DrawActivityDao;
import com.baijia.tianxiao.dal.activity.dao.referral.ReferralInfoDao;
import com.baijia.tianxiao.dal.activity.dao.vote.VoteInfoDao;
import com.baijia.tianxiao.dal.activity.po.UploadRecord;
import com.baijia.tianxiao.dal.advisory.dao.OrgCallRecorderDao;
import com.baijia.tianxiao.dal.advisory.dao.dto.CallStatisticDto;
import com.baijia.tianxiao.dal.callservice.dao.CallServiceInfoDao;
import com.baijia.tianxiao.dal.export.dao.TXLogStatEventDao;
import com.baijia.tianxiao.dal.export.dao.TXStatisticDataDao;
import com.baijia.tianxiao.dal.export.dto.LogStatisticDto;
import com.baijia.tianxiao.dal.export.po.TXStatisticData;
import com.baijia.tianxiao.dal.msg.dao.TxSmsDao;
import com.baijia.tianxiao.dal.org.constant.OrgSubAccountStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgAppLoginLogDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassRoomDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseRoomDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseTeacherDao;
import com.baijia.tianxiao.dal.org.dao.OrgGroupMsgDao;
import com.baijia.tianxiao.dal.org.dao.OrgGroupMsgReceiverDao;
import com.baijia.tianxiao.dal.org.dao.OrgHomepageConfigDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonCommentDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonSignDao;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherLessonDao;
import com.baijia.tianxiao.dal.org.dao.TXAccountDao;
import com.baijia.tianxiao.dal.org.dao.TtsSmsDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgClassRoom;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgGroupMsg;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgLessonSign;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.OrgTeacher;
import com.baijia.tianxiao.dal.org.po.OrgTeacherLesson;
import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.dal.push.constant.MsgType;
import com.baijia.tianxiao.dal.push.dao.MessageDao;
import com.baijia.tianxiao.dal.push.dto.MsgRecordDto;
import com.baijia.tianxiao.dal.roster.constant.AddType;
import com.baijia.tianxiao.dal.roster.dao.TxStudentCommentDao;
import com.baijia.tianxiao.dal.sync.dao.TxMonitorTypeDayDao;
import com.baijia.tianxiao.dal.sync.po.TxMonitorTypeDay;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dal.user.po.Teacher;
import com.baijia.tianxiao.dto.upload.UploadResult;
import com.baijia.tianxiao.sal.course.service.OrgCourseListService;
import com.baijia.tianxiao.sal.marketing.activity.dto.ActivityStatisticsData;
import com.baijia.tianxiao.sal.marketing.activity.service.ActivityDataExportService;
import com.baijia.tianxiao.sal.marketing.commons.constants.Config;
import com.baijia.tianxiao.sal.marketing.commons.enums.TemplateTypeCategory;
import com.baijia.tianxiao.sal.marketing.commons.utils.ExcelMailSender;
import com.baijia.tianxiao.sal.marketing.commons.utils.ExcelUtil;
import com.baijia.tianxiao.sal.marketing.draw.dto.DrawStatisticData;
import com.baijia.tianxiao.sal.marketing.draw.service.DrawDataExportService;
import com.baijia.tianxiao.sal.marketing.export.dto.ExportDto;
import com.baijia.tianxiao.sal.marketing.export.dto.ExportKeyData;
import com.baijia.tianxiao.sal.marketing.referral.dto.ReferralStatisticData;
import com.baijia.tianxiao.sal.marketing.referral.service.ReferralStatisticsService;
import com.baijia.tianxiao.sal.marketing.vote.dto.VoteStatistics;
import com.baijia.tianxiao.sal.marketing.vote.service.VoteDataStatisticService;
import com.baijia.tianxiao.upload.AliyunUploadUtil;
import com.baijia.tianxiao.util.GenericsUtils;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;

@Service
public class ExportOrgInfoServiceImpl
implements ExportOrgInfoService {
    private static final Logger log = LoggerFactory.getLogger(ExportOrgInfoServiceImpl.class);
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private ActivityDataExportService activityDataExportService;
    @Autowired
    private DrawDataExportService drawDataExportService;
    @Autowired
    private VoteDataStatisticService voteDataStatisticService;
    @Autowired
    private ReferralStatisticsService referralStatisticsService;
    @Autowired
    private TxBacklogStatisticService txBacklogStatisticService;
    @Autowired
    private ConsultMessageStatisticService consultMessageStatisticService;
    @Autowired
    private CRMStatisticService crmStatisticService;
    @Autowired
    private WechatStatisticService wechatStatisticService;
    @Autowired
    private ERPStatisticService erpStatisticService;
    @Autowired
    private TeacherDao teacherDao;
    @Autowired
    private OrgCourseRoomDao courseRoomDao;
    @Autowired
    private OrgGroupMsgDao groupMsgDao;
    @Autowired
    private OrgGroupMsgReceiverDao groupMsgReceiverDao;
    @Autowired
    private OrgHomepageConfigDao orgHomepageConfigDao;
    @Autowired
    private TxMonitorTypeDayDao txMonitorTypeDayDao;
    @Autowired
    private OrgAppLoginLogDao orgAppLoginLogDao;
    @Autowired
    private TtsSmsDao ttsSmSDao;
    @Autowired
    private TxSmsDao txSmsDao;
    @Autowired
    private UploadRecordDao uploadRecordDao;
    @Autowired
    private OrgStorageDao orgStorageDao;
    @Autowired
    private OrgCallRecorderDao OrgCallRecorderDao;
    @Autowired
    private FreeMarkerConfigurer freeMarkerConfigurer;
    @Autowired
    private OrgLessonSignDao orgLessonSignDao;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private OrgStudentDao orgStudentDao;
    @Autowired
    private OrgTeacherLessonDao orgTeacherLessonDao;
    @Autowired
    private TXStatisticDataDao txStatisticDataDao;
    @Autowired
    private MessageDao messageDao;
    @Autowired
    private ActivityDao activityDao;
    @Autowired
    private DrawActivityDao drawActivityDao;
    @Autowired
    private VoteInfoDao voteInfoDao;
    @Autowired
    private ReferralInfoDao referralInfoDao;
    @Autowired
    private ActivityAccessLogDao activityAccessLogDao;
    @Autowired
    private ActivityUserDao activityUserDao;
    @Autowired
    private OrgGroupMsgDao orgGroupMsgDao;
    @Autowired
    private OrgGroupMsgReceiverDao orgGroupMsgReceiverDao;
    @Autowired
    private CallServiceInfoDao callServiceInfoDao;
    @Autowired
    private OrgTeacherDao orgTeacherDao;
    @Autowired
    private OrgCourseListService orgCourseListService;
    @Autowired
    private OrgClassLessonDao orgClassLessonDao;
    @Autowired
    private OrgStudentLessonDao orgStudentLessonDao;
    @Autowired
    private OrgClassRoomDao OrgClassRoomDao;
    @Autowired
    private OrgCourseTeacherDao orgCourseTeacherDao;
    @Autowired
    private OrgStudentCourseDao orgStudentCourseDao;
    @Autowired
    private OrgCourseRoomDao orgCourseRoomDao;
    @Autowired
    private OrgSubAccountDao orgSubAccountDao;
    @Autowired
    private TXAccountDao txAccountDao;
    @Autowired
    private OrgLessonCommentDao orgLessonCommentDao;
    @Autowired
    private OrgTypeService orgTypeService;
    @Autowired
    private TxStudentCommentDao txStudentCommentDao;
    @Autowired
    private TXLogStatEventDao txLogStatEventDao;

    @Override
    public void createExcelOrgSignInfo() {
        Integer accountType = AccountTypeEnum.ZHENGSHI.getCode();
        List<Long> TianxiaoOrgIds = this.getOrgIdsByAccount(accountType);
        Map orgNumberMap = this.orgAccountDao.getorgNumbersByOrgIds(TianxiaoOrgIds);
        ArrayList<Integer> TianxiaoOrgNumbers = new ArrayList<Integer>();
        for (Long orgId : orgNumberMap.keySet()) {
            Integer orgNumber = (Integer)orgNumberMap.get(orgId);
            TianxiaoOrgNumbers.add(orgNumber);
        }
        List signs = this.orgLessonSignDao.getOrgClassLesson(TianxiaoOrgIds);
        HashSet<Long> userIds = new HashSet<Long>();
        HashSet<Long> orgIds = new HashSet<Long>();
        HashSet<Long> courseIds = new HashSet<Long>();
        HashSet<Long> lessonIds = new HashSet<Long>();
        for (OrgLessonSign sign : signs) {
            Long userId = sign.getUserId();
            userIds.add(userId);
            Long orgId = sign.getOrgId();
            orgIds.add(orgId);
            Long courseId = sign.getCourseId();
            courseIds.add(courseId);
            Long lessonId = sign.getLessonId();
            lessonIds.add(lessonId);
        }
        Map orgCourseMap = this.orgCourseDao.getOrgCourseMap(courseIds);
        Map orgStudentMap = this.orgStudentDao.getOrgStudentMapByUserIds(userIds);
        Map orgTeacherLessonMap = this.orgTeacherLessonDao.getOrgTeacherLessonMapByLessonIds(lessonIds);
        HashSet<Long> userIdsofTeacher = new HashSet<Long>();
        for (Long lessonId : orgTeacherLessonMap.keySet()) {
            OrgTeacherLesson orgTeacherLesson = (OrgTeacherLesson)orgTeacherLessonMap.get(lessonId);
            Long userId = orgTeacherLesson.getTeacherId();
            userIdsofTeacher.add(userId);
        }
        Map teacherNameMap = this.teacherDao.getTeacherRealNameMap(userIdsofTeacher);
        log.info("\u5f97\u5230signs\u7684\u957f\u5ea6\u4e3a==========" + signs.size());
        if (GenericsUtils.notNullAndEmpty((Object)signs)) {
            ArrayList rows = new ArrayList();
            for (OrgLessonSign sign : signs) {
                OrgStudent orgStudent = (OrgStudent)orgStudentMap.get(sign.getUserId());
                if (!GenericsUtils.notNullAndEmpty((Object)orgStudent)) continue;
                OrgSignDto orgSignDto = new OrgSignDto();
                String studentName = orgStudent.getName();
                orgSignDto.setStudentId(orgStudent.getId());
                orgSignDto.setStudentName(studentName == null ? "" : studentName);
                Integer orgNumber = (Integer)orgNumberMap.get(sign.getOrgId());
                orgSignDto.setOrgNumber(orgNumber);
                orgSignDto.setLessonId(sign.getLessonId());
                Date date = sign.getCreateTime();
                SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd");
                String signDate = sdf1.format(date);
                SimpleDateFormat sdf2 = new SimpleDateFormat("HH:mm:ss");
                String signTime = sdf2.format(date);
                orgSignDto.setSignDate(signDate);
                orgSignDto.setSignTime(signTime);
                int status = sign.getStatus();
                orgSignDto.setStatusDesc(SignStatus.getSignStatusByCode((Integer)status).getMessage());
                OrgCourse orgCourse = (OrgCourse)orgCourseMap.get(sign.getCourseId());
                if (GenericsUtils.notNullAndEmpty((Object)orgCourse)) {
                    String courseName = orgCourse.getName();
                    orgSignDto.setCourseName(courseName == null ? "" : courseName);
                } else {
                    orgSignDto.setCourseName("");
                }
                OrgTeacherLesson orgTeacherLesson = (OrgTeacherLesson)orgTeacherLessonMap.get(sign.getLessonId());
                if (GenericsUtils.notNullAndEmpty((Object)orgTeacherLesson)) {
                    Long userId = orgTeacherLesson.getTeacherId();
                    String teacherName = (String)teacherNameMap.get(userId);
                    if (teacherName == null || teacherName == "") {
                        // empty if block
                    }
                    orgSignDto.setTeacherName(teacherName == null ? "" : teacherName);
                } else {
                    orgSignDto.setTeacherName("");
                }
                LinkedHashMap<String, String> rowMap = new LinkedHashMap<String, String>();
                rowMap.put("\u673a\u6784number", orgSignDto.getOrgNumber() + "");
                rowMap.put("\u5fae\u5ba2\u540d\u79f0", orgSignDto.getCourseName());
                rowMap.put("\u8bfe\u8282id", orgSignDto.getLessonId() + "");
                rowMap.put("\u7b7e\u5230\u65e5\u671f", orgSignDto.getSignDate());
                rowMap.put("\u7b7e\u5230\u65f6\u95f4", orgSignDto.getSignTime());
                rowMap.put("\u8bfe\u8282\u8001\u5e08", orgSignDto.getTeacherName());
                rowMap.put("\u5b66\u5458\u59d3\u540d", orgSignDto.getStudentName());
                rowMap.put("\u5b66\u5458id", orgSignDto.getStudentId() + "");
                rowMap.put("\u7b7e\u5230\u72b6\u6001", orgSignDto.getStatusDesc());
                rows.add(rowMap);
            }
            String subject = "\u8bfe\u7a0b\u7b7e\u5230\u4fe1\u606f";
            String content = "";
            String mail = "gaodan@baijiahulian.com";
            String fileName = "signInfo";
            ExcelMailSender.sendMail((String)mail, (String)subject, (String)content, (String)fileName, rows);
        }
    }

    @Override
    public void createExcelOrgGroupMsgInfo() {
        List<Integer> TianxiaoOrgNumbers = HagTianxiaoOrgNumber.getOrgNumbers();
        log.info("taixiao\u673a\u6784\u8d26\u53f7\u5217\u8868\u957f\u5ea6==================" + TianxiaoOrgNumbers.size());
        List<Long> TianxiaoOrgIds = this.getTianxiaoOrgIds(TianxiaoOrgNumbers);
        Map orgNumberMap = this.orgAccountDao.getorgNumbersByOrgIds(TianxiaoOrgIds);
        ArrayList rows = new ArrayList();
        Map orgGroupMsgMap = this.orgGroupMsgDao.getOrgGroupMsgMap(null, null, TianxiaoOrgIds);
        for (Long orgId : orgGroupMsgMap.keySet()) {
            List orgGroupMsgs = (List)orgGroupMsgMap.get(orgId);
            HashMap<Long, OrgGroupMsg> orgGroupMsgMapByMsgId = new HashMap<Long, OrgGroupMsg>();
            ArrayList<Long> ids = new ArrayList<Long>();
            if (!GenericsUtils.notNullAndEmpty((Object)orgGroupMsgs)) continue;
            for (OrgGroupMsg orgGroupMsg : orgGroupMsgs) {
                Long id = orgGroupMsg.getId();
                orgGroupMsgMapByMsgId.put(id, orgGroupMsg);
                ids.add(id);
            }
            Map msgReceiverTotalMap = this.orgGroupMsgReceiverDao.getMsgReceiverTotalByMsgId(null, ids);
            Map msgReceiverViewTotalMap = this.orgGroupMsgReceiverDao.getMsgReceiverTotalByMsgId(Boolean.valueOf(true), ids);
            for (Long msgId : ids) {
                LinkedHashMap<String, String> rowMap = new LinkedHashMap<String, String>();
                Integer msgReceiverTotal = (Integer)msgReceiverTotalMap.get(msgId);
                log.info("\u63a5\u6536\u4eba\u6570===========" + msgReceiverTotal);
                Integer msgReceiverViewTotal = (Integer)msgReceiverViewTotalMap.get(msgId);
                log.info("\u67e5\u770b\u5450\u4eba\u6570===========" + msgReceiverViewTotal);
                Integer orgNumber = (Integer)orgNumberMap.get(orgId);
                rowMap.put("\u673a\u6784number", orgNumber + "");
                rowMap.put("\u7fa4\u53d1\u6d88\u606fid", msgId + "");
                String subject = ((OrgGroupMsg)orgGroupMsgMapByMsgId.get(msgId)).getSubject();
                rowMap.put("\u7fa4\u53d1\u6d88\u606f\u540d\u79f0", subject == null ? "" : subject);
                Date time = ((OrgGroupMsg)orgGroupMsgMapByMsgId.get(msgId)).getCreateTime();
                rowMap.put("\u53d1\u9001\u65f6\u95f4", time + "");
                int total1 = msgReceiverTotal == null ? 0 : msgReceiverTotal;
                int total2 = msgReceiverViewTotal == null ? 0 : msgReceiverViewTotal;
                rowMap.put("\u63a5\u6536\u4eba\u6570", total1 + "");
                rowMap.put("\u67e5\u770b\u4eba\u6570", total2 + "");
                rows.add(rowMap);
            }
        }
        String subject = "\u7fa4\u53d1\u6d88\u606f\u4fe1\u606f\u7edf\u8ba1";
        String content = "";
        String mail = "gaodan@baijiahulian.com";
        String fileName = "signInfo";
        ExcelMailSender.sendMail((String)mail, (String)subject, (String)content, (String)fileName, rows);
    }

    private List<Long> getTianxiaoOrgIds(List<Integer> TianxiaoOrgNumbers) {
        List TianxiaoOrgAccounts = this.orgAccountDao.getAccountByNumbers(TianxiaoOrgNumbers, new String[]{"id", "number"});
        List TianxiaoOrgIds = CollectionUtils.extractList((Collection)TianxiaoOrgAccounts, (CollectionUtils.Extracter)new CollectionUtils.Extracter<Long, OrgAccount>(){

            public Long extract(OrgAccount arg0) {
                return arg0.getId().longValue();
            }
        });
        return TianxiaoOrgIds;
    }

    @Override
    public void createExcel(Date startTime, Date endTime) {
        Properties prop = PropertiesReader.fillProperties((String)"upload.properties");
        String url = prop.getProperty("upload.server");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String uid = "tx_statistics_day_" + sdf.format(startTime);
        File file = new File("test.txt");
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        UploadResult result = AliyunUploadUtil.uploadToRemote((String)url, (String)uid, (File)file, (boolean)false);
        if (result.getFiles() != null && result.getFiles().size() > 0) {
            OrgStorage storage = new OrgStorage();
            storage.setFid(((UploadResult.UploadFile)result.getFiles().get(0)).getFid());
            storage.setCreateTime(new Date());
            storage.setUpdateTime(new Date());
            storage.setSize(Integer.valueOf(((UploadResult.UploadFile)result.getFiles().get(0)).getSize()));
            storage.setSn(((UploadResult.UploadFile)result.getFiles().get(0)).getSn());
            storage.setMimeType(Integer.valueOf(0));
            this.orgStorageDao.save(storage);
            UploadRecord record = new UploadRecord();
            record.setCreateTime(new Date());
            record.setFileType(1);
            record.setStorageId(Long.valueOf(storage.getId().longValue()));
            record.setUid(uid);
            this.uploadRecordDao.insertUploadRecord(record);
        }
    }

    @Override
    public void getOrgTypeInfo(Date startTime, Date endTime) {
        Map getArrangedClassCountMap;
        Map map;
        OrgTypeDto orgTypeDto;
        Map map2;
        Map<Long, CRMStatisticData> crmStatistics;
        long start = System.currentTimeMillis();
        HashMap<Object, OrgTypeDto> orgTypeDtoMap = new HashMap<Object, OrgTypeDto>();
        Integer accountType = AccountTypeEnum.ZHENGSHI.getCode();
        List<Long> TianxiaoOrgIds = this.getOrgIdsByAccount(accountType);
        Map orgNumberMap = this.orgAccountDao.getorgNumbersByOrgIds(TianxiaoOrgIds);
        Map<Long, ConsultMessageStatisticData> consultMessageDatas = this.consultMessageStatisticService.getConsultMessageData(startTime, endTime, TianxiaoOrgIds);
        if (GenericsUtils.notNullAndEmpty(consultMessageDatas)) {
            for (Long l : consultMessageDatas.keySet()) {
                ConsultMessageStatisticData consultMessageStatisticData = consultMessageDatas.get(l);
                OrgTypeDto orgTypeDto3 = (OrgTypeDto)orgTypeDtoMap.get(l);
                if (GenericsUtils.isNullOrEmpty((Object)orgTypeDto3)) {
                    orgTypeDto3 = new OrgTypeDto();
                    orgTypeDtoMap.put(l, orgTypeDto3);
                }
                orgTypeDto3.setClueTotal(consultMessageStatisticData.getClueTotal());
                orgTypeDto3.setClueWechat(consultMessageStatisticData.getClueWechat());
                orgTypeDto3.setClueReserve(consultMessageStatisticData.getClueReserve());
                orgTypeDto3.setClueCall(consultMessageStatisticData.getClueCall());
            }
        }
        if (GenericsUtils.notNullAndEmpty(crmStatistics = this.crmStatisticService.getConsultUserSData(startTime, endTime, TianxiaoOrgIds))) {
            for (Long l : crmStatistics.keySet()) {
                CRMStatisticData statistic = crmStatistics.get(l);
                int studentTotal = statistic.getStudentTotal();
                int studyStudentTotal = statistic.getStudyStudentTotal();
                OrgTypeDto orgTypeDto2 = (OrgTypeDto)orgTypeDtoMap.get(l);
                if (GenericsUtils.isNullOrEmpty((Object)orgTypeDto2)) {
                    orgTypeDto2 = new OrgTypeDto();
                    orgTypeDtoMap.put(l, orgTypeDto2);
                }
                orgTypeDto2.setStudentTotal(studentTotal);
                orgTypeDto2.setStudyStudentTotal(studyStudentTotal);
            }
        }
        if (GenericsUtils.notNullAndEmpty((Object)(map2 = this.txLogStatEventDao.getLogStatisticDtoMap(TianxiaoOrgIds, startTime, endTime)))) {
            for (Object orgId : map2.keySet()) {
                LogStatisticDto logStatisticDto = (LogStatisticDto)map2.get(orgId);
                Integer loginAccountTotal = logStatisticDto.getLoginAccountTotal();
                Integer loginDeviceTotal = logStatisticDto.getLoginDeviceTotal();
                orgTypeDto = (OrgTypeDto)orgTypeDtoMap.get(orgId);
                if (GenericsUtils.isNullOrEmpty((Object)orgTypeDto)) {
                    orgTypeDto = new OrgTypeDto();
                    orgTypeDtoMap.put(orgId, orgTypeDto);
                }
                orgTypeDto.setLoginAccountTotal(loginAccountTotal == null ? 0 : loginAccountTotal);
                orgTypeDto.setLoginDeviceTotal(loginDeviceTotal == null ? 0 : loginDeviceTotal);
            }
        }
        if (GenericsUtils.notNullAndEmpty((Object)(map = this.txLogStatEventDao.getOrgOpenTotalMap(TianxiaoOrgIds, startTime, endTime)))) {
            for (Long orgId : map.keySet()) {
                Integer orgOpenTotal = (Integer)map.get(orgId);
                OrgTypeDto orgTypeDto2 = (OrgTypeDto)orgTypeDtoMap.get(orgId);
                if (GenericsUtils.isNullOrEmpty((Object)orgTypeDto2)) {
                    orgTypeDto2 = new OrgTypeDto();
                    orgTypeDtoMap.put(orgId, orgTypeDto2);
                }
                orgTypeDto2.setOrgOpenTotal(orgOpenTotal == null ? 0 : orgOpenTotal);
            }
        }
        if (GenericsUtils.notNullAndEmpty((Object)(getArrangedClassCountMap = this.orgClassLessonDao.getArrangedClassCount(null, null, TianxiaoOrgIds)))) {
            for (Long orgId : getArrangedClassCountMap.keySet()) {
                Integer arrangeCourse = (Integer)getArrangedClassCountMap.get(orgId);
                orgTypeDto = (OrgTypeDto)orgTypeDtoMap.get(orgId);
                if (GenericsUtils.isNullOrEmpty((Object)orgTypeDto)) {
                    orgTypeDto = new OrgTypeDto();
                    orgTypeDtoMap.put(orgId, orgTypeDto);
                }
                orgTypeDto.setArrangeClass(arrangeCourse == null ? 0 : arrangeCourse);
            }
        }
        if (GenericsUtils.notNullAndEmpty(orgTypeDtoMap)) {
            ArrayList rows = new ArrayList();
            for (Long orgId : orgTypeDtoMap.keySet()) {
                orgTypeDto = (OrgTypeDto)orgTypeDtoMap.get(orgId);
                LinkedHashMap<String, String> rowMap = new LinkedHashMap<String, String>();
                rowMap.put("\u673a\u6784Id", orgId + "");
                rowMap.put("\u673a\u6784number", orgNumberMap.get(orgId) + "");
                rowMap.put("\u767b\u5f55\u7528\u6237\u6b21\u6570", orgTypeDto.getLoginAccountTotal() + "");
                rowMap.put("\u767b\u5f55\u8bbe\u5907\u6570\u636e", orgTypeDto.getLoginDeviceTotal() + "");
                rowMap.put("\u7ebf\u7d22\u603b\u6570", orgTypeDto.getClueTotal() + "");
                rowMap.put("\u5fae\u4fe1\u7ebf\u7d22\u603b\u6570", orgTypeDto.getClueWechat() + "");
                rowMap.put("\u7559\u5355\u7ebf\u7d22\u603b\u6570", orgTypeDto.getClueReserve() + "");
                rowMap.put("\u7535\u8bdd\u7ebf\u7d22\u603b\u6570", orgTypeDto.getClueCall() + "");
                rowMap.put("\u6253\u5f00\u6b21\u6570", orgTypeDto.getOrgOpenTotal() + "");
                rowMap.put("\u5b66\u5458\u603b\u6570", orgTypeDto.getStudentTotal() + "");
                rowMap.put("\u5728\u8bfb\u5b66\u5458\u603b\u6570", orgTypeDto.getStudyStudentTotal() + "");
                rowMap.put("\u5df2\u6709\u6392\u8bfe", orgTypeDto.getArrangeClass() + "");
                rows.add(rowMap);
            }
            String subject = "\u673a\u6784\u4e3b\u5206\u6821\u533a\u8be6\u7ec6\u4fe1\u606f";
            String content = "";
            String mail = "gaodan@baijiahulian.com";
            String fileName = "msgRecordDetailInfo";
            ExcelMailSender.sendMail((String)mail, (String)subject, (String)content, (String)fileName, rows);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<ExportDto> getExportDtoByDay(Date startTime, Date endTime, int way) {
        ExportDto exportDto;
        Map orgOpenTotalMap;
        List txMonitorTypes;
        Map groupMsgCountMap;
        Map<Long, CRMStatisticData> consultUserCounts;
        HashMap<Object, ExportDto> exportDtoMap = new HashMap<Object, ExportDto>();
        ArrayList<ExportDto> dataList = new ArrayList<ExportDto>();
        String curDate = null;
        String startDate = null;
        if (GenericsUtils.notNullAndEmpty((Object)startTime)) {
            startDate = this.getDate(startTime);
        }
        if (GenericsUtils.notNullAndEmpty((Object)endTime)) {
            curDate = this.getDate(endTime);
        }
        List<Integer> TianxiaoOrgNumbers = HagTianxiaoOrgNumber.getOrgNumbers();
        log.info("taixiao\u673a\u6784\u8d26\u53f7==================" + TianxiaoOrgNumbers.size());
        List<Long> TianxiaoOrgIds = this.getTianxiaoOrgIds(TianxiaoOrgNumbers);
        Map<Long, OrgTypeDto> orgTypeDtoMap = this.orgTypeService.getOrgTypeDtoMap(TianxiaoOrgIds);
        if (GenericsUtils.notNullAndEmpty(orgTypeDtoMap)) {
            for (Long orgId : orgTypeDtoMap.keySet()) {
                ExportDto exportDto6 = (ExportDto)exportDtoMap.get(orgId);
                OrgTypeDto orgTypeDto = orgTypeDtoMap.get(orgId);
                if (exportDto6 == null) {
                    exportDto6 = new ExportDto();
                    this.buidExportDtoByOrgId(exportDto6, orgId, startDate, curDate);
                    exportDtoMap.put(orgId, exportDto6);
                }
                String accountTypeDesc = orgTypeDto.getAccountTypeDesc();
                Integer accountType = orgTypeDto.getAccountType();
                exportDto6.setAccountTypeDesc(accountTypeDesc == null ? "" : accountTypeDesc);
                exportDto6.setAccountType(accountType.intValue());
                String compusTypeDesc = orgTypeDto.getCompusTypeDesc();
                exportDto6.setCompusTypeDesc(compusTypeDesc == null ? "" : compusTypeDesc);
                exportDto6.setSubOrgNumber(orgTypeDto.getSubOrgNumber());
            }
        }
        long start = System.currentTimeMillis();
        Map activityDatas = this.activityDataExportService.getActivityData(startTime, endTime, startDate, curDate, TianxiaoOrgIds, way);
        if (GenericsUtils.notNullAndEmpty((Object)activityDatas)) {
            for (Object orgId : activityDatas.keySet()) {
                ExportDto exportDto7 = (ExportDto)exportDtoMap.get(orgId);
                ActivityStatisticsData activityStaticData = (ActivityStatisticsData)activityDatas.get(orgId);
                if (exportDto7 == null) {
                    exportDto7 = new ExportDto();
                    this.buidExportDtoByOrgId(exportDto7, (Long)orgId, startDate, curDate);
                    exportDtoMap.put(orgId, exportDto7);
                }
                ActivityStatisticsData.setExportDto((ActivityStatisticsData)activityStaticData, (ExportDto)exportDto7);
            }
        }
        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());
        Map drawDatas = this.drawDataExportService.getDrawData(startTime, endTime, TianxiaoOrgIds);
        if (GenericsUtils.notNullAndEmpty((Object)drawDatas)) {
            for (Object orgId : drawDatas.keySet()) {
                ExportDto exportDto8 = (ExportDto)exportDtoMap.get(orgId);
                DrawStatisticData drawData = (DrawStatisticData)drawDatas.get(orgId);
                if (exportDto8 == null) {
                    exportDto8 = new ExportDto();
                    this.buidExportDtoByOrgId(exportDto8, (Long)orgId, startDate, curDate);
                    exportDtoMap.put(orgId, exportDto8);
                }
                DrawStatisticData.setExportDto((DrawStatisticData)drawData, (ExportDto)exportDto8);
            }
        }
        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());
        Map voteDatas = this.voteDataStatisticService.getVoteData(startTime, endTime, startDate, curDate, TianxiaoOrgIds, way);
        if (GenericsUtils.notNullAndEmpty((Object)voteDatas)) {
            for (Object orgId : voteDatas.keySet()) {
                ExportDto exportDto9 = (ExportDto)exportDtoMap.get(orgId);
                VoteStatistics voteStatistics = (VoteStatistics)voteDatas.get(orgId);
                if (exportDto9 == null) {
                    exportDto9 = new ExportDto();
                    this.buidExportDtoByOrgId(exportDto9, (Long)orgId, startDate, curDate);
                    exportDtoMap.put(orgId, exportDto9);
                }
                VoteStatistics.buildExportDtoByVoteStatistics((ExportDto)exportDto9, (VoteStatistics)voteStatistics);
            }
        }
        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());
        Map referralDatas = this.referralStatisticsService.getPeriodReferralData(startTime, endTime, startDate, curDate, TianxiaoOrgIds, way);
        if (GenericsUtils.notNullAndEmpty((Object)referralDatas)) {
            for (Object orgId : referralDatas.keySet()) {
                void var19_24;
                ExportDto exportDto2 = (ExportDto)exportDtoMap.get(orgId);
                ReferralStatisticData referralData = (ReferralStatisticData)referralDatas.get(orgId);
                log.info(referralData.getBrokerNum() + ":" + referralData.getBrowseCount() + ":" + referralData.getReferralActivityTotal() + ":" + referralData.getCustomerNum());
                if (exportDto2 == null) {
                    ExportDto exportDto3 = new ExportDto();
                    this.buidExportDtoByOrgId(exportDto3, (Long)orgId, startDate, curDate);
                    exportDtoMap.put(orgId, exportDto3);
                }
                ReferralStatisticData.buildExportDtoByReferralStatisticData((ExportDto)var19_24, (ReferralStatisticData)referralData);
            }
        }
        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());
        Map<Long, TxBacklogStatisticData> txBacklogDatas = this.txBacklogStatisticService.getTxBacklogData(startTime, endTime, TianxiaoOrgIds, way);
        if (GenericsUtils.notNullAndEmpty(txBacklogDatas)) {
            for (Long l : txBacklogDatas.keySet()) {
                TxBacklogStatisticData txBacklogData = txBacklogDatas.get(l);
                ExportDto exportDto11 = (ExportDto)exportDtoMap.get(l);
                if (exportDto11 == null) {
                    exportDto11 = new ExportDto();
                    this.buidExportDtoByOrgId(exportDto11, l, startDate, curDate);
                    exportDtoMap.put(l, exportDto11);
                }
                TxBacklogStatisticData.buildExportDtoByTxBacklogStatisticData(exportDto11, txBacklogData);
            }
        }
        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());
        Map<Long, ConsultMessageStatisticData> consultMessageDatas = this.consultMessageStatisticService.getConsultMessageData(startTime, endTime, TianxiaoOrgIds);
        if (GenericsUtils.notNullAndEmpty(consultMessageDatas)) {
            for (Long orgId : consultMessageDatas.keySet()) {
                ConsultMessageStatisticData consultMessageStatisticData = consultMessageDatas.get(orgId);
                ExportDto exportDto12 = (ExportDto)exportDtoMap.get(orgId);
                if (exportDto12 == null) {
                    exportDto12 = new ExportDto();
                    this.buidExportDtoByOrgId(exportDto12, orgId, startDate, curDate);
                    exportDtoMap.put(orgId, exportDto12);
                }
                ConsultMessageStatisticData.buildExportDtoByConsultMessageStatisticData(exportDto12, consultMessageStatisticData);
            }
        }
        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());
        Map map = this.txStudentCommentDao.getCommentTotal(startTime, endTime, TianxiaoOrgIds, Integer.valueOf(AddType.SYSTEM.getCode()), Boolean.valueOf(false));
        Map commentStudentSystemTotalMap = this.txStudentCommentDao.getCommentTotal(startTime, endTime, TianxiaoOrgIds, Integer.valueOf(AddType.SYSTEM.getCode()), Boolean.valueOf(true));
        if (GenericsUtils.notNullAndEmpty((Object)map)) {
            for (Long orgId : map.keySet()) {
                int commentSystemTotal = (Integer)map.get(orgId);
                int commentStudentSystemTotal = 0;
                if (commentStudentSystemTotalMap.get(orgId) != null) {
                    commentStudentSystemTotal = (Integer)commentStudentSystemTotalMap.get(orgId);
                }
                int commentConsultSystemTotal = commentSystemTotal - commentStudentSystemTotal;
                ExportDto exportDto13 = (ExportDto)exportDtoMap.get(orgId);
                if (exportDto13 == null) {
                    exportDto13 = new ExportDto();
                    this.buidExportDtoByOrgId(exportDto13, orgId, startDate, curDate);
                    exportDtoMap.put(orgId, exportDto13);
                }
                exportDto13.setCommentStudentSystemTotal(commentStudentSystemTotal);
                exportDto13.setCommentConsultSystemTotal(commentConsultSystemTotal);
            }
        }
        Map commentNotSystemTotalMap = this.txStudentCommentDao.getCommentTotal(startTime, endTime, TianxiaoOrgIds, Integer.valueOf(AddType.NOT_SYSTEM.getCode()), Boolean.valueOf(false));
        Map commentStudentNotSystemTotalMap = this.txStudentCommentDao.getCommentTotal(startTime, endTime, TianxiaoOrgIds, Integer.valueOf(AddType.NOT_SYSTEM.getCode()), Boolean.valueOf(true));
        if (GenericsUtils.notNullAndEmpty((Object)commentNotSystemTotalMap)) {
            for (Long orgId : commentNotSystemTotalMap.keySet()) {
                int commentNotSystemTotal = (Integer)commentNotSystemTotalMap.get(orgId);
                int commentNotStudentSystemTotal = 0;
                if (commentStudentNotSystemTotalMap.get(orgId) != null) {
                    commentNotStudentSystemTotal = (Integer)commentStudentNotSystemTotalMap.get(orgId);
                }
                int commentConsultNotSystemTotal = commentNotSystemTotal - commentNotStudentSystemTotal;
                ExportDto exportDto5 = (ExportDto)exportDtoMap.get(orgId);
                if (exportDto5 == null) {
                    exportDto5 = new ExportDto();
                    this.buidExportDtoByOrgId(exportDto5, orgId, startDate, curDate);
                    exportDtoMap.put(orgId, exportDto5);
                }
                exportDto5.setCommentStudentNotSystemTotal(commentNotStudentSystemTotal);
                exportDto5.setCommentConsultNotSystemTotal(commentConsultNotSystemTotal);
            }
        }
        if (GenericsUtils.notNullAndEmpty(consultUserCounts = this.crmStatisticService.getConsultUserSData(startTime, endTime, TianxiaoOrgIds))) {
            for (Long orgId : consultUserCounts.keySet()) {
                ExportDto exportDto14 = (ExportDto)exportDtoMap.get(orgId);
                CRMStatisticData crmStatisticData = consultUserCounts.get(orgId);
                if (exportDto14 == null) {
                    exportDto14 = new ExportDto();
                    this.buidExportDtoByOrgId(exportDto14, orgId, startDate, curDate);
                    exportDtoMap.put(orgId, exportDto14);
                }
                CRMStatisticData.buidExportDtoByCRMStatisticData(crmStatisticData, exportDto14);
            }
        }
        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());
        Map<Long, WechatStatisticData> wechatDatas = this.wechatStatisticService.getWechatStatisticData(startTime, endTime, TianxiaoOrgIds, way);
        if (GenericsUtils.notNullAndEmpty(wechatDatas)) {
            for (Long orgId : wechatDatas.keySet()) {
                ExportDto exportDto15 = (ExportDto)exportDtoMap.get(orgId);
                WechatStatisticData wechatData = wechatDatas.get(orgId);
                if (exportDto15 == null) {
                    exportDto15 = new ExportDto();
                    this.buidExportDtoByOrgId(exportDto15, orgId, startDate, curDate);
                    exportDtoMap.put(orgId, exportDto15);
                }
                WechatStatisticData.buildExportDtoByWechatStatisticData(exportDto15, wechatData);
            }
        }
        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());
        Map<Long, ERPStatisticData> ERPDatas = this.erpStatisticService.getERPDatas(startTime, endTime, TianxiaoOrgNumbers, TianxiaoOrgIds);
        if (GenericsUtils.notNullAndEmpty(ERPDatas)) {
            for (Long orgId : ERPDatas.keySet()) {
                ExportDto exportDto4 = (ExportDto)exportDtoMap.get(orgId);
                ERPStatisticData ERPData = ERPDatas.get(orgId);
                if (exportDto4 == null) {
                    exportDto4 = new ExportDto();
                    this.buidExportDtoByOrgId(exportDto4, orgId, startDate, curDate);
                    exportDtoMap.put(orgId, exportDto4);
                }
                ERPStatisticData.buildExportDtoByERPStatisticData(exportDto4, ERPData);
            }
        }
        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());
        Map teacherCountMap = this.orgTeacherDao.getTeacherTotalMapByOrgIds(startTime, endTime, TianxiaoOrgIds);
        if (GenericsUtils.notNullAndEmpty((Object)teacherCountMap)) {
            for (Object orgId : teacherCountMap.keySet()) {
                Integer teacherCount = (Integer)teacherCountMap.get(orgId);
                ExportDto exportDto16 = (ExportDto)exportDtoMap.get(orgId);
                if (exportDto16 == null) {
                    exportDto16 = new ExportDto();
                    this.buidExportDtoByOrgId(exportDto16, (Long)orgId, startDate, curDate);
                    exportDtoMap.put(orgId, exportDto16);
                }
                exportDto16.setTeacherTotal(teacherCount.intValue());
            }
        }
        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());
        Map roomCountMap = this.courseRoomDao.getOrgRoomTotal();
        if (GenericsUtils.notNullAndEmpty((Object)roomCountMap) && way != 0) {
            for (Object orgId : roomCountMap.keySet()) {
                Integer roomCount = (Integer)roomCountMap.get(orgId);
                ExportDto exportDto4 = (ExportDto)exportDtoMap.get(orgId);
                if (exportDto4 == null) {
                    exportDto4 = new ExportDto();
                    this.buidExportDtoByOrgId(exportDto4, (Long)orgId, startDate, curDate);
                    exportDtoMap.put(orgId, exportDto4);
                }
                exportDto4.setRoomTotal(roomCount.intValue());
            }
        }
        if (GenericsUtils.notNullAndEmpty((Object)(groupMsgCountMap = this.groupMsgDao.getOrgGroupMsgTotal(startTime, endTime, TianxiaoOrgIds)))) {
            for (Object orgId : groupMsgCountMap.keySet()) {
                ExportDto exportDto5 = (ExportDto)exportDtoMap.get(orgId);
                Integer groupMsgCount = (Integer)groupMsgCountMap.get(orgId);
                if (exportDto5 == null) {
                    exportDto5 = new ExportDto();
                    this.buidExportDtoByOrgId(exportDto5, (Long)orgId, startDate, curDate);
                    exportDtoMap.put(orgId, exportDto5);
                }
                exportDto5.setGroupMsgTotal(groupMsgCount == null ? 0 : groupMsgCount);
            }
        }
        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());
        Map msgReceiverCountMap = this.groupMsgReceiverDao.getMsgReceiverTotal(Boolean.valueOf(true), startTime, endTime, TianxiaoOrgIds);
        if (GenericsUtils.notNullAndEmpty((Object)msgReceiverCountMap)) {
            for (Object orgId : msgReceiverCountMap.keySet()) {
                Integer msgReceiverCount = (Integer)msgReceiverCountMap.get(orgId);
                log.info("\u65b0\u63a5\u53d7\u4eba\u6570================" + msgReceiverCount);
                ExportDto exportDto3 = (ExportDto)exportDtoMap.get(orgId);
                if (exportDto3 == null) {
                    exportDto3 = new ExportDto();
                    this.buidExportDtoByOrgId(exportDto3, (Long)orgId, startDate, curDate);
                    exportDtoMap.put(orgId, exportDto3);
                }
                exportDto3.setMsgReceiverTotal(msgReceiverCount == null ? 0 : msgReceiverCount);
            }
        }
        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());
        Set useTemplateOrgIds = this.orgHomepageConfigDao.getUseTemplateOrgIds(TianxiaoOrgIds);
        if (GenericsUtils.notNullAndEmpty((Object)useTemplateOrgIds)) {
            for (Long orgId : useTemplateOrgIds) {
                ExportDto exportDto6 = (ExportDto)exportDtoMap.get(orgId);
                if (exportDto6 == null) {
                    exportDto6 = new ExportDto();
                    this.buidExportDtoByOrgId(exportDto6, orgId, startDate, curDate);
                    exportDtoMap.put(orgId, exportDto6);
                }
                exportDto6.setIsUseHomePage(true);
            }
        }
        if (GenericsUtils.notNullAndEmpty((Object)(txMonitorTypes = this.txMonitorTypeDayDao.listUseMonitorType(startTime, endTime, TianxiaoOrgNumbers)))) {
            Map homePageMonitorOrgNumberMap = CollectionUtils.extractMap((Collection)txMonitorTypes, (CollectionUtils.Extracter)new CollectionUtils.Extracter<Integer, TxMonitorTypeDay>(){

                public Integer extract(TxMonitorTypeDay txMonitorTypeDay) {
                    return txMonitorTypeDay.getOrgNumber().intValue();
                }
            });
            List orgHomePageAccounts = this.orgAccountDao.getAccountByNumbers(homePageMonitorOrgNumberMap.keySet(), new String[]{"id", "number"});
            Iterator iterator = orgHomePageAccounts.iterator();
            while (iterator.hasNext()) {
                TxMonitorTypeDay monitorTypeDay;
                OrgAccount account = (OrgAccount)iterator.next();
                ExportDto exportDto2 = (ExportDto)exportDtoMap.get(account.getId().longValue());
                if (exportDto2 == null) {
                    exportDto2 = new ExportDto();
                    this.buidExportDtoByOrgId(exportDto2, account.getId().longValue(), startDate, curDate);
                    exportDtoMap.put(account.getId().longValue(), exportDto2);
                }
                exportDto2.setPvTotal((monitorTypeDay = (TxMonitorTypeDay)homePageMonitorOrgNumberMap.get(account.getNumber())).getPv() == null ? 0 : monitorTypeDay.getPv());
                exportDto2.setUvTotal(monitorTypeDay.getUv() == null ? 0 : monitorTypeDay.getUv());
            }
        }
        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());
        Map loginCountMap = this.orgAppLoginLogDao.getOrgAppLoginTotal(null, startTime, endTime, TianxiaoOrgIds);
        if (GenericsUtils.notNullAndEmpty((Object)loginCountMap)) {
            for (Object orgId : loginCountMap.keySet()) {
                Integer loginCount = (Integer)loginCountMap.get(orgId);
                ExportDto exportDto7 = (ExportDto)exportDtoMap.get(orgId);
                if (exportDto7 == null) {
                    exportDto7 = new ExportDto();
                    this.buidExportDtoByOrgId(exportDto7, (Long)orgId, startDate, curDate);
                    exportDtoMap.put(orgId, exportDto7);
                }
                exportDto7.setLoginTotal(loginCount == null ? 0 : loginCount);
            }
        }
        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());
        Map logStatisticDtoMap = this.txLogStatEventDao.getLogStatisticDtoMap(TianxiaoOrgIds, startTime, endTime);
        if (GenericsUtils.notNullAndEmpty((Object)logStatisticDtoMap)) {
            for (Object orgId : logStatisticDtoMap.keySet()) {
                LogStatisticDto logDto = (LogStatisticDto)logStatisticDtoMap.get(orgId);
                Integer loginAccount = logDto.getLoginAccountTotal();
                Integer loginDevice = logDto.getLoginDeviceTotal();
                ExportDto exportDto17 = (ExportDto)exportDtoMap.get(orgId);
                if (exportDto17 == null) {
                    exportDto17 = new ExportDto();
                    this.buidExportDtoByOrgId(exportDto17, (Long)orgId, startDate, curDate);
                    exportDtoMap.put(orgId, exportDto17);
                }
                exportDto17.setLoginAccountTotal(loginAccount == null ? 0 : loginAccount);
                exportDto17.setLoginDeviceTotal(loginDevice == null ? 0 : loginDevice);
            }
        }
        if (GenericsUtils.notNullAndEmpty((Object)(orgOpenTotalMap = this.txLogStatEventDao.getOrgOpenTotalMap(TianxiaoOrgIds, startTime, endTime)))) {
            for (Long orgId : orgOpenTotalMap.keySet()) {
                Iterator orgOpenTotal = (Integer)orgOpenTotalMap.get(orgId);
                ExportDto exportDto18 = (ExportDto)exportDtoMap.get(orgId);
                if (exportDto18 == null) {
                    exportDto18 = new ExportDto();
                    this.buidExportDtoByOrgId(exportDto18, orgId, startDate, curDate);
                    exportDtoMap.put(orgId, exportDto18);
                }
                exportDto18.setOrgOpenTotal(((Integer)((Object)orgOpenTotal)).intValue());
            }
        }
        Map ttsMsgCountMap = this.ttsSmSDao.getOrgTtsSmsCount(startTime, endTime, TianxiaoOrgIds);
        Map txMsgCountMap = this.txSmsDao.getOrgTxSmsCount(startTime, endTime, TianxiaoOrgIds);
        if (GenericsUtils.notNullAndEmpty((Object)ttsMsgCountMap)) {
            for (Object orgId : ttsMsgCountMap.keySet()) {
                if (txMsgCountMap.get(orgId) == null) {
                    txMsgCountMap.put(orgId, ttsMsgCountMap.get(orgId));
                    continue;
                }
                txMsgCountMap.put(orgId, (Integer)txMsgCountMap.get(orgId) + (Integer)ttsMsgCountMap.get(orgId));
            }
        }
        if (GenericsUtils.notNullAndEmpty((Object)txMsgCountMap)) {
            for (Object orgId : txMsgCountMap.keySet()) {
                Integer smsCount = (Integer)txMsgCountMap.get(orgId);
                ExportDto exportDto19 = (ExportDto)exportDtoMap.get(orgId);
                if (exportDto19 == null) {
                    exportDto19 = new ExportDto();
                    this.buidExportDtoByOrgId(exportDto19, (Long)orgId, startDate, curDate);
                    exportDtoMap.put(orgId, exportDto19);
                }
                exportDto19.setSmsTotal(smsCount == null ? 0 : smsCount);
            }
        }
        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());
        Map extensionMap = this.orgInfoDao.getExtentionsByOrgIds(TianxiaoOrgIds);
        if (GenericsUtils.notNullAndEmpty((Object)extensionMap)) {
            for (Object orgId : exportDtoMap.keySet()) {
                String extension = (String)extensionMap.get(orgId);
                Integer orgCallRecordCount = this.OrgCallRecorderDao.getOrgCallRecordCountByExtexsion(startTime, endTime, extension);
                Integer orgCallRecordTime = this.OrgCallRecorderDao.getOrgCallRecordTimeByExtension(startTime, endTime, extension);
                exportDto = (ExportDto)exportDtoMap.get(orgId);
                if (exportDto == null) {
                    exportDto = new ExportDto();
                    exportDtoMap.put(orgId, exportDto);
                    this.buidExportDtoByOrgId(exportDto, (Long)orgId, startDate, curDate);
                }
                exportDto.setOrgCallRecordCount(orgCallRecordCount == null ? 0 : orgCallRecordCount);
                exportDto.setOrgCallRecordTime(orgCallRecordTime == null ? 0 : orgCallRecordTime);
            }
        }
        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());
        Map callStatisticDtoMap = this.callServiceInfoDao.getTotalDurationAndCount(startTime, endTime, TianxiaoOrgIds);
        if (GenericsUtils.notNullAndEmpty((Object)callStatisticDtoMap)) {
            for (Long orgId : callStatisticDtoMap.keySet()) {
                CallStatisticDto callStatisticDto = (CallStatisticDto)callStatisticDtoMap.get(orgId);
                Integer count = callStatisticDto.getCount();
                Integer duration = callStatisticDto.getDuration();
                ExportDto exportDto20 = (ExportDto)exportDtoMap.get(orgId);
                if (exportDto20 == null) {
                    exportDto20 = new ExportDto();
                    exportDtoMap.put(orgId, exportDto20);
                    this.buidExportDtoByOrgId(exportDto20, orgId, startDate, curDate);
                }
                exportDto20.setCallServiceCount(count.intValue());
                exportDto20.setCallServiceDuration(duration.intValue());
            }
        }
        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + ttsMsgCountMap.size());
        Map orgIdMap = this.orgAccountDao.batchSearchOrgIds(TianxiaoOrgNumbers);
        log.info("orgIdMap size param{}", (Object)orgIdMap.size());
        for (Integer orgNumber : TianxiaoOrgNumbers) {
            Long orgId = (Long)orgIdMap.get(orgNumber);
            if (orgId == null) {
                log.info("orgNumber param:{}", (Object)orgNumber);
            }
            if (!GenericsUtils.notNullAndEmpty((Object)orgId)) continue;
            exportDto = (ExportDto)exportDtoMap.get(orgId);
            if (exportDto == null) {
                exportDto = new ExportDto();
                log.info("exportDto parm:{}, orgId param:{}, startDate param:{}, curDate param:{}", new Object[]{exportDto, orgId, startDate, curDate});
                this.buidExportDtoByOrgId(exportDto, orgId, startDate, curDate);
            }
            dataList.add(exportDto);
            TXStatisticData txStatisticData = ExportDto.buildTXStatisticDataByExportDto((ExportDto)exportDto, (int)way);
            TXStatisticData statisticData = this.txStatisticDataDao.getTXStatisticDataByOrgNumber(orgNumber, curDate, Integer.valueOf(way));
            if (GenericsUtils.notNullAndEmpty((Object)statisticData)) {
                txStatisticData.setId(statisticData.getId());
                this.txStatisticDataDao.updateTXStatisticData(txStatisticData);
                continue;
            }
            this.txStatisticDataDao.addTXStatisticData(txStatisticData);
        }
        return dataList;
    }

    private void buidExportDtoByOrgId(ExportDto exportDto, Long orgId, String startDate, String curDate) {
        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(orgId.intValue()), new String[0]);
        OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgId.intValue(), new String[0]);
        if (orgAccount != null) {
            exportDto.setOrgNumber(orgAccount.getNumber());
        }
        if (orgInfo == null) {
            exportDto.setOrgShortName("");
        } else {
            exportDto.setOrgShortName(orgInfo.getShortName());
        }
        if (startDate != null) {
            exportDto.setStartDate(startDate);
        }
        if (curDate != null) {
            exportDto.setCurDate(curDate);
        }
    }

    private String getDate(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String curDate = dateFormat.format(date);
        return curDate;
    }

    public List<ExportKeyData> writeDayDataToSheet(HSSFSheet sheet, List<ExportDto> data) {
        ArrayList<ExportKeyData> keyDatas = new ArrayList<ExportKeyData>();
        log.info("[Statistics]Day Size=" + data.size());
        for (int i = 3; i < data.size() + 3; ++i) {
            ExportKeyData keyData = new ExportKeyData();
            HSSFRow row = sheet.createRow(i);
            ExportDto exportDto = data.get(i - 3);
            keyData.setOrgShortName(exportDto.getOrgShortName());
            keyData.setOrgNumber(exportDto.getOrgNumber());
            keyData.setCompusTypeDesc(exportDto.getCompusTypeDesc() == null ? "" : exportDto.getCompusTypeDesc());
            keyData.setAccountTypeDesc(exportDto.getAccountTypeDesc() == null ? "" : exportDto.getAccountTypeDesc());
            keyData.setLoginTotal(exportDto.getLoginTotal() + keyData.getLoginTotal());
            keyData.setBacklogFinish(exportDto.getBacklogFinish());
            keyData.setClueTotal(exportDto.getClueTotal());
            keyData.setIncrementStudentTotal(exportDto.getIncrementStudentTotal());
            keyData.setWechatFansTotal(exportDto.getWechatFansTotal());
            keyData.setCourseTotal(exportDto.getCourseTotal());
            keyData.setArrangedClassTotal(exportDto.getArrangedClassTotal());
            keyData.setCourseSmsTotal(exportDto.getCourseSmsTotal());
            keyData.setSignLessonTotal(exportDto.getSignLessonTotal());
            keyData.setSignStudentTotal(exportDto.getSignStudentTotal());
            keyData.setCommentByTeacher(exportDto.getCommentByTeacher());
            int activityTotal = exportDto.getActivityTotal() + exportDto.getDrawActivityTotal() + exportDto.getVoteActivityTotal() + exportDto.getReferralActivityTotal();
            keyData.setActivityTotal(activityTotal);
            int activityAccessTotal = exportDto.getActivityAccessTotal() + exportDto.getReferralAccessTotal() + exportDto.getVoteAccessTotal();
            keyData.setActivityAccessTotal(activityAccessTotal);
            keyData.setCommentByTeacher(exportDto.getCommentByTeacher());
            keyData.setPvTotal(exportDto.getPvTotal());
            keyData.setUvTotal(exportDto.getUvTotal());
            keyData.setWechatAuthorizerOfStudentTotal(exportDto.getWechatAuthorizerOfStudentTotal());
            keyData.setSmsTotal(exportDto.getSmsTotal());
            keyData.setOrgCallRecordCount(exportDto.getOrgCallRecordCount());
            Integer orgCallRecordTime = exportDto.getOrgCallRecordTime();
            String callTime = this.getTwoPrecision(orgCallRecordTime, 60);
            keyData.setOrgCallRecordTime(callTime);
            keyData.setCallServiceCount(exportDto.getCallServiceCount());
            Integer callServiceDuration = exportDto.getCallServiceDuration();
            String callServiceTime = this.getTwoPrecision(callServiceDuration, 60);
            keyData.setCallServiceDuration(callServiceTime);
            ExcelUtil.createCell((HSSFRow)row, (int)0, (String)exportDto.getCurDate());
            ExcelUtil.createCell((HSSFRow)row, (int)1, (String)exportDto.getOrgShortName());
            ExcelUtil.createCell((HSSFRow)row, (int)2, (int)exportDto.getOrgNumber());
            ExcelUtil.createCell((HSSFRow)row, (int)3, (String)exportDto.getCompusTypeDesc());
            ExcelUtil.createCell((HSSFRow)row, (int)4, (int)exportDto.getSubOrgNumber());
            ExcelUtil.createCell((HSSFRow)row, (int)5, (String)exportDto.getAccountTypeDesc());
            ExcelUtil.createCell((HSSFRow)row, (int)6, (boolean)exportDto.getIsWechatAuthorizer());
            ExcelUtil.createCell((HSSFRow)row, (int)7, (boolean)exportDto.getIsWechatMenu());
            ExcelUtil.createCell((HSSFRow)row, (int)8, (String)exportDto.getServiceTypeDesc());
            ExcelUtil.createCell((HSSFRow)row, (int)9, (int)exportDto.getStudentTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)10, (int)exportDto.getStudyStudentTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)11, (boolean)exportDto.getIsUseHomePage());
            ExcelUtil.createCell((HSSFRow)row, (int)12, (int)exportDto.getBacklogTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)13, (int)exportDto.getBacklogFinish());
            ExcelUtil.createCell((HSSFRow)row, (int)14, (int)exportDto.getBacklogExpire());
            ExcelUtil.createCell((HSSFRow)row, (int)15, (int)exportDto.getClueTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)16, (int)exportDto.getClueWechat());
            ExcelUtil.createCell((HSSFRow)row, (int)17, (int)exportDto.getClueReserve());
            ExcelUtil.createCell((HSSFRow)row, (int)18, (int)exportDto.getClueCall());
            ExcelUtil.createCell((HSSFRow)row, (int)19, (int)exportDto.getCommentStudentSystemTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)20, (int)exportDto.getCommentConsultSystemTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)21, (int)exportDto.getCommentStudentNotSystemTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)22, (int)exportDto.getCommentConsultNotSystemTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)23, (int)exportDto.getConsultUserTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)24, (int)exportDto.getIncrementStudentTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)25, (int)exportDto.getWechatFansTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)26, (int)exportDto.getCourseTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)27, (int)exportDto.getArrangedClassTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)28, (int)exportDto.getLessonTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)29, (int)exportDto.getCourseSmsTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)30, (double)exportDto.getIncomeSum());
            ExcelUtil.createCell((HSSFRow)row, (int)31, (int)exportDto.getIncomeTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)32, (int)exportDto.getSignLessonTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)33, (int)exportDto.getSignStudentTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)34, (double)exportDto.getCashPurchaseSum());
            ExcelUtil.createCell((HSSFRow)row, (int)35, (int)exportDto.getCommentByStudent());
            ExcelUtil.createCell((HSSFRow)row, (int)36, (int)exportDto.getCommentByTeacher());
            ExcelUtil.createCell((HSSFRow)row, (int)37, (int)exportDto.getTeacherTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)38, (int)exportDto.getRoomTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)39, (int)exportDto.getActivityTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)40, (int)exportDto.getActivityAccessTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)41, (int)exportDto.getActivityEnrollTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)42, (int)exportDto.getDrawActivityTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)43, (int)exportDto.getDrawUserTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)44, (int)exportDto.getDrawWinnerTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)45, (int)exportDto.getVoteActivityTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)46, (int)exportDto.getVoteAccessTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)47, (int)exportDto.getVoteTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)48, (int)exportDto.getReferralActivityTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)49, (int)exportDto.getReferralAccessTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)50, (int)exportDto.getBrokerTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)51, (int)exportDto.getReferralTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)52, (int)exportDto.getGroupMsgTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)53, (int)exportDto.getMsgReceiverTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)54, (int)exportDto.getUvTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)55, (int)exportDto.getPvTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)56, (int)exportDto.getLoginTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)57, (int)exportDto.getLoginAccountTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)58, (int)exportDto.getLoginDeviceTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)59, (int)exportDto.getOrgOpenTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)60, (int)exportDto.getWechatAuthorizerOfStudentTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)61, (int)exportDto.getSmsTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)62, (int)exportDto.getOrgCallRecordCount());
            if (callTime == "0") {
                ExcelUtil.createCell((HSSFRow)row, (int)63, (String)"");
            } else {
                ExcelUtil.createCell((HSSFRow)row, (int)63, (String)callTime);
            }
            ExcelUtil.createCell((HSSFRow)row, (int)64, (int)exportDto.getCallServiceCount());
            if (callServiceTime == "0") {
                ExcelUtil.createCell((HSSFRow)row, (int)65, (String)"");
            } else {
                ExcelUtil.createCell((HSSFRow)row, (int)65, (String)callServiceTime);
            }
            keyDatas.add(keyData);
        }
        return keyDatas;
    }

    public void writeTotalDataToSheet(HSSFSheet sheet, List<ExportDto> data) {
        log.info("[Statistics]Total Size=" + data.size());
        for (int i = 3; i < data.size() + 3; ++i) {
            HSSFRow row = sheet.createRow(i);
            ExportDto exportDto = data.get(i - 3);
            ExcelUtil.createCell((HSSFRow)row, (int)0, (String)exportDto.getOrgShortName());
            ExcelUtil.createCell((HSSFRow)row, (int)1, (int)exportDto.getOrgNumber());
            ExcelUtil.createCell((HSSFRow)row, (int)2, (String)exportDto.getCompusTypeDesc());
            ExcelUtil.createCell((HSSFRow)row, (int)3, (int)exportDto.getSubOrgNumber());
            ExcelUtil.createCell((HSSFRow)row, (int)4, (String)exportDto.getAccountTypeDesc());
            ExcelUtil.createCell((HSSFRow)row, (int)5, (boolean)exportDto.getIsWechatAuthorizer());
            ExcelUtil.createCell((HSSFRow)row, (int)6, (boolean)exportDto.getIsWechatMenu());
            ExcelUtil.createCell((HSSFRow)row, (int)7, (String)exportDto.getServiceTypeDesc());
            ExcelUtil.createCell((HSSFRow)row, (int)8, (int)exportDto.getStudentTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)9, (int)exportDto.getStudyStudentTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)10, (boolean)exportDto.getIsUseHomePage());
            ExcelUtil.createCell((HSSFRow)row, (int)11, (int)exportDto.getBacklogTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)12, (int)exportDto.getBacklogFinish());
            ExcelUtil.createCell((HSSFRow)row, (int)13, (int)exportDto.getBacklogExpire());
            ExcelUtil.createCell((HSSFRow)row, (int)14, (int)exportDto.getClueTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)15, (int)exportDto.getClueWechat());
            ExcelUtil.createCell((HSSFRow)row, (int)16, (int)exportDto.getClueReserve());
            ExcelUtil.createCell((HSSFRow)row, (int)17, (int)exportDto.getClueCall());
            ExcelUtil.createCell((HSSFRow)row, (int)18, (int)exportDto.getCommentStudentSystemTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)19, (int)exportDto.getCommentConsultSystemTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)20, (int)exportDto.getCommentStudentNotSystemTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)21, (int)exportDto.getCommentConsultNotSystemTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)22, (int)exportDto.getConsultUserTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)23, (int)exportDto.getWechatFansTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)24, (int)exportDto.getCourseTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)25, (int)exportDto.getArrangedClassTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)26, (int)exportDto.getLessonTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)27, (int)exportDto.getCourseSmsTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)28, (double)exportDto.getIncomeSum());
            ExcelUtil.createCell((HSSFRow)row, (int)29, (int)exportDto.getIncomeTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)30, (int)exportDto.getSignLessonTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)31, (int)exportDto.getSignStudentTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)32, (double)exportDto.getCashPurchaseSum());
            ExcelUtil.createCell((HSSFRow)row, (int)33, (int)exportDto.getCommentByStudent());
            ExcelUtil.createCell((HSSFRow)row, (int)34, (int)exportDto.getCommentByTeacher());
            ExcelUtil.createCell((HSSFRow)row, (int)35, (int)exportDto.getTeacherTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)36, (int)exportDto.getRoomTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)37, (int)exportDto.getActivityTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)38, (int)exportDto.getActivityAccessTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)39, (int)exportDto.getActivityEnrollTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)40, (int)exportDto.getDrawActivityTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)41, (int)exportDto.getDrawUserTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)42, (int)exportDto.getDrawWinnerTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)43, (int)exportDto.getVoteActivityTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)44, (int)exportDto.getVoteAccessTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)45, (int)exportDto.getVoteTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)46, (int)exportDto.getReferralActivityTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)47, (int)exportDto.getReferralAccessTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)48, (int)exportDto.getBrokerTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)49, (int)exportDto.getReferralTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)50, (int)exportDto.getGroupMsgTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)51, (int)exportDto.getMsgReceiverTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)52, (int)exportDto.getUvTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)53, (int)exportDto.getPvTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)54, (int)exportDto.getLoginTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)55, (int)exportDto.getLoginAccountTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)56, (int)exportDto.getLoginDeviceTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)57, (int)exportDto.getOrgOpenTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)58, (int)exportDto.getWechatAuthorizerOfStudentTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)59, (int)exportDto.getSmsTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)60, (int)exportDto.getOrgCallRecordCount());
            Integer orgCallRecordTime = exportDto.getOrgCallRecordTime();
            String callTime = this.getTwoPrecision(orgCallRecordTime, 60);
            if (callTime == "0") {
                ExcelUtil.createCell((HSSFRow)row, (int)61, (String)"");
            } else {
                ExcelUtil.createCell((HSSFRow)row, (int)61, (String)callTime);
            }
            ExcelUtil.createCell((HSSFRow)row, (int)62, (int)exportDto.getCallServiceCount());
            Integer callServiceDuration = exportDto.getCallServiceDuration();
            String callServiceTime = this.getTwoPrecision(callServiceDuration, 60);
            if (callServiceTime == "0") {
                ExcelUtil.createCell((HSSFRow)row, (int)63, (String)"");
                continue;
            }
            ExcelUtil.createCell((HSSFRow)row, (int)63, (String)callServiceTime);
        }
    }

    @Override
    public void createHSSFWorkbookByDay(Date startTime, Date endTime) {
        List<ExportDto> dayData = this.getExportDtoByDay(startTime, endTime, 0);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String curDate = dateFormat.format(startTime);
        try {
            InputStream dayIn = this.getClass().getResourceAsStream("/template/template-excelByDay.xls");
            File[] files = new File[1];
            List<ExportKeyData> keyDatas = new ArrayList<ExportKeyData>();
            if (GenericsUtils.notNullAndEmpty(dayData)) {
                HSSFWorkbook wb = new HSSFWorkbook(dayIn);
                HSSFSheet sheet = wb.getSheetAt(0);
                wb.setSheetName(0, wb.getSheetName(0));
                keyDatas = this.writeDayDataToSheet(sheet, dayData);
                files[0] = this.createFil(wb, curDate + "excelByDay.xls");
            }
            String email = Config.MAIL_CONTACT_TIANXIAO_DATA;
            String content = this.getContent(keyDatas);
            ExcelMailSender.sendMail((String)email, (String)(curDate + "\u6bcf\u65e5\u5929\u6821\u76d1\u63a7\u6570\u636e"), (String)content, (File[])files);
        }
        catch (FileNotFoundException e) {
            log.warn("excel\u6587\u4ef6\u521b\u5efa\u5931\u8d25");
        }
        catch (IOException e) {
            log.warn("excel\u6587\u4ef6\u521b\u5efa\u5931\u8d25");
        }
    }

    @Override
    public void createHSSFWorkbookTotal(Date startTime, Date endTime) {
        List<ExportDto> totalData = this.getExportDtoByDay(null, endTime, 3);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String curDate = dateFormat.format(startTime);
        try {
            InputStream totaIn = this.getClass().getResourceAsStream("/template/template-excelTotal.xls");
            File[] files = new File[1];
            if (GenericsUtils.notNullAndEmpty(totalData)) {
                HSSFWorkbook wb = new HSSFWorkbook(totaIn);
                HSSFSheet sheet = wb.getSheetAt(0);
                wb.setSheetName(0, wb.getSheetName(0));
                this.writeTotalDataToSheet(sheet, totalData);
                files[0] = this.createFil(wb, curDate + "excelTotal.xls");
            }
            String email = Config.MAIL_CONTACT_TIANXIAO_DATA;
            String content = "";
            ExcelMailSender.sendMail((String)email, (String)(curDate + "\u5929\u6821\u76d1\u63a7\u603b\u6570\u636e"), (String)content, (File[])files);
        }
        catch (FileNotFoundException e) {
            log.warn("excel\u6587\u4ef6\u521b\u5efa\u5931\u8d25");
        }
        catch (IOException e) {
            log.warn("excel\u6587\u4ef6\u521b\u5efa\u5931\u8d25");
        }
    }

    private String getContent(List<ExportKeyData> keyDatas) {
        StringBuffer sb = new StringBuffer("<head style=\"font-size:14px\"> \n<style>.c-gray{ background-color: #D8D9DB;}\n .c-orange{background-color: #FDC20E;}\n .c-yellow{background-color: #FEFF0D;}\n .c-green{background-color: #94D351;}\n .c-blue { background-color: #1AAFF1;}\n .c-purple {background-color: #D9E0F2;}\n </style>\n</head>\n<body>\n <table class=\"table table-bordered\" cellpadding=\"8\" cellspacing=\"0\" style=\"width:100%;text-align:center; border: 1px solid #ddd;font-size:13px\">\n<thead>\n<tr>\n<th width=\"100\" class=\"c-gray\">\u673a\u6784\u540d\u79f0</th>\n <th width=\"100\"class=\"c-gray\">\u673a\u6784ID</th>\n <th width=\"100\"class=\"c-gray\"> \u603b\u5206\u6821\u533a\u7c7b\u578b</th>\n <th width=\"100\"class=\"c-gray\"> \u673a\u6784\u7c7b\u578b</th>\n<th width=\"100\" class=\"c-orange\">\u4eca\u65e5\u673a\u6784\u767b\u9646\u6b21\u6570(\u5305\u542b\u5b50\u8d26\u53f7)</th>\n<th width=\"100\" class=\"c-yellow\">\u7ebf\u7d22\u65b0\u589e\u603b\u6570</th>\n<th width=\"100\" class=\"c-yellow\">\u65b0\u589e\u5b66\u5458\u6570</th>\n<th width=\"100\" class=\"c-yellow\">\u5fae\u4fe1\u7c89\u4e1d\u65b0\u589e\u6570\uff08\u51c0\u589e\u957f\uff09</th>\n<th width=\"100\" class=\"c-green\">\u65b0\u589e\u5fae\u8bfe\u6570</th>\n<th width=\"100\" class=\"c-green\">\u65b0\u6392\u8bfe\u73ed\u7ea7\u6570</th>\n<th width=\"100\" class=\"c-green\">\u65b0\u53d1\u9001\u8bfe\u8868\u6570\u91cf</th>\n<th width=\"100\" class=\"c-green\">\u4eca\u65e5\u7b7e\u5230\u8bfe\u8282\u6570</th>\n<th width=\"100\" class=\"c-green\">\u4eca\u65e5\u7b7e\u5230\u4eba\u6b21</th>\n<th width=\"100\" class=\"c-green\">\u4eca\u65e5\u8001\u5e08\u4e3b\u52a8\u70b9\u8bc4\u6570</th>\n<th width=\"100\" class=\"c-blue\">\u4eca\u65e5\u65b0\u589e\u6d3b\u52a8\u603b\u6570</th>\n<th width=\"100\"class=\"c-blue\">\u4eca\u65e5\u65b0\u589e\u8bbf\u95ee\u603b\u6570</th>\n<th width=\"100\" class=\"c-purple\">\u4eca\u65e5\u65b0\u589eUV</th>\n<th width=\"100\" class=\"c-purple\">\u4eca\u65e5\u65b0\u589ePV</th>\n<th width=\"100\" class=\"c-purple\">\u65b0\u589e\u7ed1\u5b9a\u5fae\u4fe1\u516c\u4f17\u53f7\u5b66\u751f\u6570</th>\n<th width=\"100\" class=\"c-purple\">\u65b0\u53d1\u77ed\u4fe1\u6570</th>\n<th width=\"100\" class=\"c-purple\">\u65b0\u589e400\u7535\u8bdd\u603b\u6570</th>\n<th width=\"100\" class=\"c-purple\">\u65b0\u589e400\u7535\u8bdd\u603b\u65f6\u957f</th>\n<th width=\"100\" class=\"c-purple\">\u65b0\u589e\u53cc\u547c\u603b\u547c\u51fa\u6570</th>\n<th width=\"100\" class=\"c-purple\">\u65b0\u589e\u53cc\u547c\u603b\u65f6\u957f</th>\n</tr>\n</thead>\n<tbody>\n");
        for (ExportKeyData keyData : keyDatas) {
            sb.append("<tr>");
            sb.append("<td>" + keyData.getOrgShortName() + "</td>");
            sb.append("<td>" + keyData.getOrgNumber() + "</td>");
            sb.append("<td>" + keyData.getCompusTypeDesc() + "</td>");
            sb.append("<td>" + keyData.getAccountTypeDesc() + "</td>");
            sb.append(this.getTd(keyData.getLoginTotal()));
            sb.append(this.getTd(keyData.getClueTotal()));
            sb.append(this.getTd(keyData.getIncrementStudentTotal()));
            sb.append(this.getTd(keyData.getWechatFansTotal()));
            sb.append(this.getTd(keyData.getCourseTotal()));
            sb.append(this.getTd(keyData.getArrangedClassTotal()));
            sb.append(this.getTd(keyData.getCourseSmsTotal()));
            sb.append(this.getTd(keyData.getSignLessonTotal()));
            sb.append(this.getTd(keyData.getSignStudentTotal()));
            sb.append(this.getTd(keyData.getCommentByTeacher()));
            sb.append(this.getTd(keyData.getActivityTotal()));
            sb.append(this.getTd(keyData.getActivityAccessTotal()));
            sb.append(this.getTd(keyData.getUvTotal()));
            sb.append(this.getTd(keyData.getPvTotal()));
            sb.append(this.getTd(keyData.getWechatAuthorizerOfStudentTotal()));
            sb.append(this.getTd(keyData.getSmsTotal()));
            sb.append(this.getTd(keyData.getOrgCallRecordCount()));
            sb.append(this.getTd(keyData.getOrgCallRecordTime()));
            sb.append(this.getTd(keyData.getCallServiceCount()));
            sb.append(this.getTd(keyData.getCallServiceDuration()));
            sb.append("</tr>");
        }
        sb.append("</tbody></table></article>");
        return sb.toString();
    }

    private String getTd(String value) {
        if (value == null) {
            return "<td></td>";
        }
        return "<td>" + value + "</td>";
    }

    private String getTd(int value) {
        if (value == 0) {
            return "<td></td>";
        }
        return "<td>" + value + "</td>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private File createFil(HSSFWorkbook wb, String fileName) {
        File localFile = new File(fileName);
        if (!localFile.exists()) {
            try {
                localFile.createNewFile();
            }
            catch (IOException e) {
                return null;
            }
        }
        FileOutputStream out = null;
        BufferedOutputStream bos = null;
        try {
            out = new FileOutputStream(localFile);
            bos = new BufferedOutputStream(out);
            wb.write((OutputStream)bos);
            wb = null;
        }
        catch (Exception exception) {
            IOUtils.closeQuietly(bos);
            IOUtils.closeQuietly((OutputStream)out);
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bos);
                IOUtils.closeQuietly((OutputStream)out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)bos);
        IOUtils.closeQuietly((OutputStream)out);
        return localFile;
    }

    @Override
    public void createMailByWeekAndMonth(Date startTime, Date endTime, int beforeDay) {
        List<Object> exportDtos = new ArrayList();
        if (beforeDay == 7) {
            exportDtos = this.getExportDtoByDay(startTime, endTime, 1);
        } else if (beforeDay == 30) {
            exportDtos = this.getExportDtoByDay(startTime, endTime, 2);
        }
        String startDate = this.getDate(startTime);
        String endDate = this.getDate(endTime);
        ArrayList<ExportDto> internalExportDtos = new ArrayList<ExportDto>();
        ArrayList<ExportDto> externalExportDtos = new ArrayList<ExportDto>();
        for (ExportDto exportDto : exportDtos) {
            Integer accountType = exportDto.getAccountType();
            if (AccountTypeEnum.ZHENGSHI.getCode() == accountType) {
                externalExportDtos.add(exportDto);
                continue;
            }
            internalExportDtos.add(exportDto);
        }
        log.info("internalExportDtos size param:{}, externalExportDtos param:{}", (Object)internalExportDtos.size(), (Object)externalExportDtos.size());
        StatisticByWeekOrMonthDto statisticInternal = this.getStatisticByWeekOrMonthDto(internalExportDtos, beforeDay);
        List<ExportClientDemandDto> list = this.getExportClientDemandDtos(statisticInternal, internalExportDtos.size(), beforeDay);
        log.info("exportInternalClientDemandDtos param:{}", list);
        StatisticByWeekOrMonthDto statisticExternal = this.getStatisticByWeekOrMonthDto(externalExportDtos, beforeDay);
        List<ExportClientDemandDto> exportExternalClientDemandDtos = this.getExportClientDemandDtos(statisticExternal, externalExportDtos.size(), beforeDay);
        log.info("exportExternalClientDemandDtos param:{}", exportExternalClientDemandDtos);
        try {
            InputStream dayIn = this.getClass().getResourceAsStream("/template/template-excelByDay.xls");
            File[] files = new File[1];
            if (GenericsUtils.notNullAndEmpty(exportDtos)) {
                HSSFWorkbook wb = new HSSFWorkbook(dayIn);
                HSSFSheet sheet = wb.getSheetAt(0);
                wb.setSheetName(0, wb.getSheetName(0));
                this.writeDayDataToSheet(sheet, exportDtos);
                files[0] = this.createFil(wb, beforeDay + "excelData.xls");
            }
            Template parentTemplate = this.freeMarkerConfigurer.getConfiguration().getTemplate("exportClientEmail.ftl");
            HashMap<String, Object> map2 = new HashMap<String, Object>();
            map2.put("exportClientDemandDtos", exportExternalClientDemandDtos);
            map2.put("startDate", startDate);
            map2.put("endDate", endDate);
            map2.put("beforeDay", beforeDay);
            map2.put("isInternal", "\u5916\u90e8");
            String result = FreeMarkerTemplateUtils.processTemplateIntoString((Template)parentTemplate, map2);
            result = result + "\n";
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("exportClientDemandDtos", list);
            map.put("startDate", startDate);
            map.put("endDate", endDate);
            map.put("beforeDay", beforeDay);
            map.put("isInternal", "\u5185\u90e8");
            result = result + FreeMarkerTemplateUtils.processTemplateIntoString((Template)parentTemplate, map);
            String email = Config.MAIL_CONTACT_TIANXIAO_CLIENT;
            log.info("\u5929\u6821\u5ba2\u6237\u4f7f\u7528\u6570\u636e\u6536\u4ef6\u4eba" + email);
            ExcelMailSender.sendMail((String)email, (String)("\u5929\u6821\u5ba2\u6237\u4f7f\u7528\u6570\u636e(" + beforeDay + "\u5929_" + startDate + "~" + endDate + ")"), (String)result, (File[])files);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
    }

    private List<ExportClientDemandDto> getExportClientDemandDtos(StatisticByWeekOrMonthDto statistic, int orgTotal, int beforeDay) {
        ArrayList<ExportClientDemandDto> statisticDatas = new ArrayList<ExportClientDemandDto>();
        ExportClientDemandDto login = new ExportClientDemandDto();
        int loginValid = this.getValidTotal(beforeDay, BIzConf.LOGIN_VALID_7, BIzConf.LOGIN_VALID_30);
        login = this.getExportClientDemandDto(orgTotal, "\u6709\u6548\u767b\u5f55", statistic.getEfficientTotalLogin(), statistic.getLoginTotal(), "\u767b\u5f55\u6b21\u6570", "\u767b\u5f55\u5929\u6821\u6b21\u6570>=" + loginValid);
        statisticDatas.add(login);
        ExportClientDemandDto loginAccount = this.getExportClientDemandDto(orgTotal, "\u6709\u6548\u767b\u5f55\u7528\u6237\u6570", statistic.getEfficientTotalLoginAccount(), statistic.getLoginAccountTotal(), "\u767b\u5f55\u7528\u6237\u6570", "\u767b\u5f55\u7528\u6237>=" + loginValid);
        statisticDatas.add(loginAccount);
        ExportClientDemandDto loginDevice = this.getExportClientDemandDto(orgTotal, "\u6709\u6548\u767b\u5f55\u8bbe\u5907\u6570", statistic.getEfficientTotalLoginDevice(), statistic.getLoginDeviceTotal(), "\u767b\u5f55\u8bbe\u5907\u6570", "\u767b\u5f55\u8bbe\u5907>=" + loginValid);
        statisticDatas.add(loginDevice);
        int orgOpenValid = this.getValidTotal(beforeDay, BIzConf.ORG_OPEN_7, BIzConf.ORG_OPEN_30);
        ExportClientDemandDto orgOpen = this.getExportClientDemandDto(orgTotal, "\u673a\u6784\u8bbe\u5907\u6253\u5f00\u6b21\u6570", statistic.getEfficientTotalOrgOpen(), statistic.getOrgOpenTotal(), "\u6253\u5f00\u6b21\u6570", "\u6253\u5f00\u6b21\u6570>=" + orgOpenValid);
        statisticDatas.add(orgOpen);
        ExportClientDemandDto finish = this.getExportClientDemandDto(orgTotal, "\u4eca\u65e5\u4ee3\u529e", statistic.getEfficientTotalFinish(), statistic.getBacklogFinish(), "\u5b8c\u6210\u4efb\u52a1\u6b21\u6570", "\u622a\u81f3\u76ee\u524d\u5b8c\u6210\u4efb\u52a1\u603b\u6570");
        statisticDatas.add(finish);
        int wechatClueValid = this.getValidTotal(beforeDay, BIzConf.WECHAT_CLUE_VALID_7, BIzConf.WECHAT_CLUE_VALID_30);
        ExportClientDemandDto clueWechat = this.getExportClientDemandDto(orgTotal, "\u5fae\u4fe1\u7ebf\u7d22", statistic.getEfficientTotalClueWechat(), statistic.getClueWechat(), "\u5fae\u4fe1\u7ebf\u7d22\u91cf", "\u5fae\u4fe1\u7ebf\u7d22\u91cf>=" + wechatClueValid);
        statisticDatas.add(clueWechat);
        int clueValid = this.getValidTotal(beforeDay, BIzConf.CLUERESERVE_VALID_7, BIzConf.CLUERESERVE_VALID_30);
        ExportClientDemandDto clueReserve = this.getExportClientDemandDto(orgTotal, "\u9884\u7ea6\u7559\u5355", statistic.getEfficientTotalClueReserv(), statistic.getClueReserve(), "\u7559\u5355\u91cf", "\u7559\u5355\u91cf>=" + clueValid);
        statisticDatas.add(clueReserve);
        int commentStudentValid = this.getValidTotal(beforeDay, BIzConf.COMMENT_VALID_7, BIzConf.COMMENT_VALID_30);
        ExportClientDemandDto commentStudentNotSystem = this.getExportClientDemandDto(orgTotal, "\u5b66\u751f\u624b\u52a8\u5f55\u5165\u8ddf\u8fdb\u8bb0\u5f55", statistic.getEfficientTotalCommentStudentNotSystem(), statistic.getCommentStudentNotSystemTotal(), "\u5b66\u751f\u624b\u52a8\u5f55\u5165\u8ddf\u8fdb\u8bb0\u5f55\u6570", "\u8ddf\u8fdb\u8bb0\u5f55\u6570>=" + commentStudentValid);
        statisticDatas.add(commentStudentNotSystem);
        int commentNotSysValid = this.getValidTotal(beforeDay, BIzConf.COMMENT_VALID_7, BIzConf.COMMENT_VALID_30);
        ExportClientDemandDto commentConsultNotSys = this.getExportClientDemandDto(orgTotal, "\u610f\u5411\u5b66\u5458\u624b\u52a8\u8ddf\u8fdb\u8bb0\u5f55", statistic.getEfficientTotalCommentConsultNotSystem(), statistic.getCommentConsultNotSystemTotal(), "\u610f\u5411\u5b66\u5458\u624b\u52a8\u8bb0\u5f55\u6570", "\u8ddf\u8fdb\u8bb0\u5f55\u6570>=" + commentNotSysValid);
        statisticDatas.add(commentConsultNotSys);
        int studentValid = this.getValidTotal(beforeDay, BIzConf.STUDENT_TOTAL_VALID_7, BIzConf.STUDENT_TOTAL_VALID_30);
        ExportClientDemandDto student = this.getExportClientDemandDto(orgTotal, "\u5b66\u5458\u6863\u6848", statistic.getEfficientTotalIncrementStudent(), statistic.getIncrementStudentTotal(), "\u5b66\u5458\u6863\u6848\u6570", "\u5b66\u5458\u6863\u6848\u6570>=" + studentValid);
        statisticDatas.add(student);
        ExportClientDemandDto wechatAuthorizer = this.getExportClientDemandDto(orgTotal, "\u5fae\u4fe1\u516c\u4f17\u53f7\u6258\u7ba1", statistic.getEfficientTotalWechatAuthorizer(), statistic.getWechatFansTotal(), "\u5fae\u4fe1\u7c89\u4e1d\u6570", "\u5fae\u4fe1\u516c\u4f17\u53f7\u6258\u7ba1\u7ed9\u5929\u6821");
        statisticDatas.add(wechatAuthorizer);
        int courseValid = this.getValidTotal(beforeDay, BIzConf.COURSE_TOTAL_VALID_7, BIzConf.COURSE_TOTAL_VALID_30);
        ExportClientDemandDto course = this.getExportClientDemandDto(orgTotal, "\u8bbe\u73ed", statistic.getEfficientTotalCourse(), statistic.getCourseTotal(), "\u6dfb\u52a0\u8bfe\u7a0b\u6570", "\u6dfb\u52a0\u8bfe\u7a0b>=" + courseValid);
        statisticDatas.add(course);
        int arrangedClassValid = this.getValidTotal(beforeDay, BIzConf.ARRANGE_CLASS_TOTAL_VALID_7, BIzConf.ARRANGE_CLASS_TOTAL_VALID_30);
        ExportClientDemandDto arrangeCourse = this.getExportClientDemandDto(orgTotal, "\u6392\u8bfe", statistic.getEfficientTotalArrangedClassTotal(), statistic.getArrangedClassTotal(), "\u6392\u8bfe\u73ed\u7ea7\u6570", "\u6392\u8bfe\u73ed\u7ea7>=" + arrangedClassValid);
        statisticDatas.add(arrangeCourse);
        int courseSmsValid = this.getValidTotal(beforeDay, BIzConf.COURSESMS_TOTAL_VALID_7, BIzConf.COURSESMS_TOTAL_VALID_30);
        ExportClientDemandDto courseSms = this.getExportClientDemandDto(orgTotal, "\u53d1\u8bfe\u8868", statistic.getEfficientTotalCourseSms(), statistic.getCourseSmsTotal(), "\u53d1\u8bfe\u8868\u4eba\u6b21", "\u53d1\u8bfe\u8868>=" + courseSmsValid);
        statisticDatas.add(courseSms);
        ExportClientDemandDto incomeSum = new ExportClientDemandDto();
        incomeSum.setKeyFunctionName("\u6536\u6b3e");
        incomeSum.setEfficientTotal(statistic.getEfficientTotalIncomeSum());
        incomeSum.setCoverageRate(this.getPercentByTwoPrecision(statistic.getEfficientTotalIncomeSum(), orgTotal));
        if (statistic.getEfficientTotalIncomeSum() != 0) {
            incomeSum.setAverageUsers(this.getAverageUsers(statistic.getIncomeSum(), statistic.getEfficientTotalIncomeSum()));
        } else {
            incomeSum.setAverageUsers("");
        }
        incomeSum.setKeyIndex("\u6536\u6b3e\u91d1\u989d");
        incomeSum.setTotal(statistic.getIncomeSum() + "");
        int incomeSumValid = this.getValidTotal(beforeDay, BIzConf.INCOMESUM_VALID_7, BIzConf.INCOMESUM_VALID_30);
        incomeSum.setRemarks("\u6536\u6b3e>=" + incomeSumValid);
        statisticDatas.add(incomeSum);
        int signLessonValid = this.getValidTotal(beforeDay, BIzConf.SIGN_LESSON_VALID_7, BIzConf.SIGN_LESSON_VALID_30);
        ExportClientDemandDto sign = this.getExportClientDemandDto(orgTotal, "\u7b7e\u5230", statistic.getEfficientTotalSign(), statistic.getSignStudentTotal(), "\u7b7e\u5230\u4eba\u6b21", "\u7b7e\u5230\u73ed\u7ea7>=" + signLessonValid);
        statisticDatas.add(sign);
        int teacherCommentValid = this.getValidTotal(beforeDay, BIzConf.TEACHER_COMMENT_VALID_7, BIzConf.TEACHER_COMMENT_VALID_30);
        ExportClientDemandDto commentByTeacher = this.getExportClientDemandDto(orgTotal, "\u8bc4\u4ef7", statistic.getEfficientTotalCommentByTeacher(), statistic.getCommentByTeacher(), "\u8001\u5e08\u8bc4\u4ef7\u6570", "\u8001\u5e08\u8bc4\u4ef7>=" + teacherCommentValid);
        statisticDatas.add(commentByTeacher);
        int studentCommentValid = this.getValidTotal(beforeDay, BIzConf.STUDENT_COMMENT_VALID_7, BIzConf.STUDENT_COMMENT_VALID_30);
        ExportClientDemandDto commentByStudent = this.getExportClientDemandDto(orgTotal, "", statistic.getEfficientTotalCommentByStudent(), statistic.getCommentByStudent(), "\u5b66\u751f\u8bc4\u4ef7\u6570", "\u5b66\u751f\u8bc4\u4ef7>=" + studentCommentValid);
        statisticDatas.add(commentByStudent);
        int drawTotalValid = this.getValidTotal(beforeDay, BIzConf.DRAW_AVTIVITY_TOTAL_VALID_7, BIzConf.DRAW_AVTIVITY_TOTAL_VALID_30);
        int activityTotalValid = this.getValidTotal(beforeDay, BIzConf.ACTIVITY_TOTAL_VALID_7, BIzConf.ACTIVITY_TOTAL_VALID_30);
        ExportClientDemandDto activity = this.getExportClientDemandDto(orgTotal, "\u53d1\u6d3b\u52a8", statistic.getEfficientTotalActivity(), statistic.getActivityAccessTotal(), "\u6d3b\u52a8\u8bbf\u95ee\u91cf(UV)", "\u53d1\u6d3b\u52a8>=" + activityTotalValid);
        statisticDatas.add(activity);
        ExportClientDemandDto draw = this.getExportClientDemandDto(orgTotal, "\u62bd\u5956", statistic.getEfficientTotalDrawActivity(), statistic.getDrawUserTotal(), "\u62bd\u5956\u53c2\u4e0e\u91cf", "\u62bd\u5956\u6d3b\u52a8 >=" + drawTotalValid);
        statisticDatas.add(draw);
        int voteTotalValid = this.getValidTotal(beforeDay, BIzConf.VOTE_AVTIVITY_TOTAL_VALID_7, BIzConf.VOTE_AVTIVITY_TOTAL_VALID_30);
        ExportClientDemandDto vote = this.getExportClientDemandDto(orgTotal, "\u6295\u7968", statistic.getEfficientTotalvoteActivity(), statistic.getVoteAccessTotal(), "\u6295\u7968\u8bbf\u95ee\u91cf(UV)", "\u6295\u7968\u6d3b\u52a8>=" + voteTotalValid);
        statisticDatas.add(vote);
        int referralTotalValid = this.getValidTotal(beforeDay, BIzConf.REFERRAL_ACTIVITY_VALID_7, BIzConf.REFERRAL_ACTIVITY_VALID_30);
        ExportClientDemandDto referral = this.getExportClientDemandDto(orgTotal, "\u8f6c\u4ecb\u7ecd", statistic.getEfficientTotalReferralActivity(), statistic.getReferralAccessTotal(), "\u8f6c\u4ecb\u7ecd\u8bbf\u95ee\u91cf(UV)", "\u8f6c\u4ecb\u7ecd\u6d3b\u52a8>=" + referralTotalValid);
        statisticDatas.add(referral);
        int groupMsgTotalValid = this.getValidTotal(beforeDay, BIzConf.GROUP_MESSAGE_TOTAL_VALID_7, BIzConf.GROUP_MESSAGE_TOTAL_VALID_30);
        ExportClientDemandDto groupMsg = this.getExportClientDemandDto(orgTotal, "\u7fa4\u53d1\u6d88\u606f", statistic.getEfficientTotalGroupMsg(), statistic.getGroupMsgTotal(), "\u7fa4\u53d1\u6d88\u606f\u4eba\u6b21", "\u7fa4\u53d1\u6d88\u606f>=" + groupMsgTotalValid);
        statisticDatas.add(groupMsg);
        ExportClientDemandDto useHomePage = new ExportClientDemandDto();
        useHomePage.setKeyFunctionName("\u4e3b\u9875\u88c5\u4fee");
        useHomePage.setEfficientTotal(statistic.getEfficientTotalUseHomePage());
        useHomePage.setKeyIndex("");
        useHomePage.setCoverageRate(this.getPercentByTwoPrecision(statistic.getEfficientTotalUseHomePage(), orgTotal));
        useHomePage.setAverageUsers("");
        useHomePage.setTotal("");
        useHomePage.setRemarks("\u4f7f\u7528\u8fc7\u4e3b\u9875\u6a21\u677f");
        statisticDatas.add(useHomePage);
        int uvTotalValid = this.getValidTotal(beforeDay, BIzConf.UV_TOTAL_VALID_7, BIzConf.UV_TOTAL_VALID_30);
        ExportClientDemandDto UV = this.getExportClientDemandDto(orgTotal, "\u4e3b\u9875\u6709\u6548", statistic.getEfficientTotalUV(), statistic.getUvTotal(), "\u4e3b\u9875\u8bbf\u95ee\u91cf(UV)", "\u4e3b\u9875\u8bbf\u95ee>=" + uvTotalValid);
        statisticDatas.add(UV);
        ExportClientDemandDto wechatAuthorizerOfStudent = this.getExportClientDemandDto(orgTotal, "\u5b66\u751f\u7ed1\u5b9a\u4e2a\u4eba\u4e2d\u5fc3", statistic.getEfficientTotalWechatAuthorizerOfStudent(), statistic.getWechatAuthorizerOfStudentTotal(), "\u5b66\u751f\u7ed1\u5b9a\u4e2a\u4eba\u4e2d\u5fc3\u4eba\u6570", "\u603b\u91cf\u4e3a\u622a\u81f3\u76ee\u524d\u603b\u4eba\u6570");
        statisticDatas.add(wechatAuthorizerOfStudent);
        ExportClientDemandDto orgCall = this.getExportClientDemandDto(orgTotal, "400\u7535\u8bdd\u547c\u51fa", statistic.getEfficientTotalorgCallRecordCount(), statistic.getOrgCallRecordCount(), "400\u7535\u8bdd\u547c\u51fa\u91cf", "\u4f7f\u7528\u8fc7400\u7535\u8bdd");
        statisticDatas.add(orgCall);
        ExportClientDemandDto callService = this.getExportClientDemandDto(orgTotal, "\u53cc\u547c", statistic.getEfficientCallServiceCount(), statistic.getCallServiceCount(), "\u53cc\u547c\u4f7f\u7528\u91cf", "\u4f7f\u7528\u8fc7\u53cc\u547c");
        statisticDatas.add(callService);
        return statisticDatas;
    }

    private ExportClientDemandDto getExportClientDemandDto(int orgTotal, String keyFunctionName, int efficientTotal, int total, String keyIndex, String remarks) {
        ExportClientDemandDto dto = new ExportClientDemandDto();
        dto.setKeyFunctionName(keyFunctionName);
        dto.setEfficientTotal(efficientTotal);
        dto.setCoverageRate(this.getPercentByTwoPrecision(efficientTotal, orgTotal));
        if (efficientTotal != 0) {
            dto.setAverageUsers(this.getAverageUsers(total, efficientTotal));
        } else {
            dto.setAverageUsers("");
        }
        dto.setKeyIndex(keyIndex);
        dto.setTotal(total + "");
        dto.setRemarks(remarks);
        return dto;
    }

    private String getPercentByTwoPrecision(int num1, int num2) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(2);
        String result = numberFormat.format((float)num1 / (float)num2 * 100.0f);
        return result + "%";
    }

    private String getTwoPrecision(int num1, int num2) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(2);
        String result = numberFormat.format((float)num1 / (float)num2);
        return result;
    }

    private String getAverageUsers(double num1, double num2) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(0);
        double data = num1 / num2;
        data = Math.ceil(data);
        String result = numberFormat.format(data);
        return result;
    }

    private StatisticByWeekOrMonthDto getStatisticByWeekOrMonthDto(List<ExportDto> exportDtos, int beforeDay) {
        StatisticByWeekOrMonthDto statistic = new StatisticByWeekOrMonthDto();
        for (ExportDto exportDto : exportDtos) {
            int loginValid = this.getValidTotal(beforeDay, BIzConf.LOGIN_VALID_7, BIzConf.LOGIN_VALID_30);
            if (exportDto.getLoginTotal() >= loginValid) {
                statistic.setEfficientTotalLogin(statistic.getEfficientTotalLogin() + 1);
                statistic.setLoginTotal(statistic.getLoginTotal() + exportDto.getLoginTotal());
            }
            if (exportDto.getLoginAccountTotal() >= loginValid) {
                statistic.setEfficientTotalLoginAccount(statistic.getEfficientTotalLoginAccount() + 1);
                statistic.setLoginAccountTotal(statistic.getLoginAccountTotal() + exportDto.getLoginAccountTotal());
            }
            if (exportDto.getLoginAccountTotal() >= loginValid) {
                statistic.setEfficientTotalLoginDevice(statistic.getEfficientTotalLoginDevice() + 1);
                statistic.setLoginDeviceTotal(statistic.getLoginDeviceTotal() + exportDto.getLoginDeviceTotal());
            }
            int orgOpenValid = this.getValidTotal(beforeDay, BIzConf.ORG_OPEN_7, BIzConf.ORG_OPEN_30);
            if (exportDto.getOrgOpenTotal() >= orgOpenValid) {
                statistic.setEfficientTotalOrgOpen(statistic.getEfficientTotalOrgOpen() + 1);
                statistic.setOrgOpenTotal(statistic.getOrgOpenTotal() + exportDto.getOrgOpenTotal());
            }
            if (exportDto.getBacklogFinish() != 0) {
                statistic.setEfficientTotalFinish(statistic.getEfficientTotalFinish() + 1);
            }
            statistic.setBacklogFinish(statistic.getBacklogFinish() + exportDto.getBacklogFinish());
            int wechatClueValid = this.getValidTotal(beforeDay, BIzConf.WECHAT_CLUE_VALID_7, BIzConf.WECHAT_CLUE_VALID_30);
            if (exportDto.getClueWechat() >= wechatClueValid) {
                statistic.setEfficientTotalClueWechat(statistic.getEfficientTotalClueWechat() + 1);
                statistic.setClueWechat(statistic.getClueWechat() + exportDto.getClueWechat());
            }
            int clueValid = this.getValidTotal(beforeDay, BIzConf.CLUERESERVE_VALID_7, BIzConf.CLUERESERVE_VALID_30);
            if (exportDto.getClueReserve() >= clueValid) {
                statistic.setEfficientTotalClueReserv(statistic.getEfficientTotalClueReserv() + 1);
                statistic.setClueReserve(statistic.getClueReserve() + exportDto.getClueReserve());
            }
            int commentStudentValid = this.getValidTotal(beforeDay, BIzConf.COMMENT_VALID_7, BIzConf.COMMENT_VALID_30);
            if (exportDto.getCommentStudentNotSystemTotal() >= commentStudentValid) {
                statistic.setEfficientTotalCommentStudentNotSystem(statistic.getEfficientTotalCommentStudentNotSystem() + 1);
                statistic.setCommentStudentNotSystemTotal(statistic.getCommentStudentNotSystemTotal() + exportDto.getCommentStudentNotSystemTotal());
            }
            int commentConsultValid = this.getValidTotal(beforeDay, BIzConf.COMMENT_VALID_7, BIzConf.COMMENT_VALID_30);
            if (exportDto.getCommentConsultNotSystemTotal() >= commentConsultValid) {
                statistic.setEfficientTotalCommentConsultNotSystem(statistic.getEfficientTotalCommentConsultNotSystem() + 1);
                statistic.setCommentConsultNotSystemTotal(statistic.getCommentConsultNotSystemTotal() + exportDto.getCommentConsultNotSystemTotal());
            }
            int studentValid = this.getValidTotal(beforeDay, BIzConf.STUDENT_TOTAL_VALID_7, BIzConf.STUDENT_TOTAL_VALID_30);
            if (exportDto.getIncrementStudentTotal() >= studentValid) {
                statistic.setEfficientTotalIncrementStudent(statistic.getEfficientTotalIncrementStudent() + 1);
                statistic.setIncrementStudentTotal(statistic.getIncrementStudentTotal() + exportDto.getIncrementStudentTotal());
            }
            if (exportDto.getIsWechatAuthorizer()) {
                statistic.setEfficientTotalWechatAuthorizer(statistic.getEfficientTotalWechatAuthorizer() + 1);
                statistic.setWechatFansTotal(statistic.getWechatFansTotal() + exportDto.getWechatFansTotal());
            }
            int courseValid = this.getValidTotal(beforeDay, BIzConf.COURSE_TOTAL_VALID_7, BIzConf.COURSE_TOTAL_VALID_30);
            if (exportDto.getCourseTotal() >= courseValid) {
                statistic.setEfficientTotalCourse(statistic.getEfficientTotalCourse() + 1);
                statistic.setCourseTotal(statistic.getCourseTotal() + exportDto.getCourseTotal());
            }
            int arrangedClassValid = this.getValidTotal(beforeDay, BIzConf.ARRANGE_CLASS_TOTAL_VALID_7, BIzConf.ARRANGE_CLASS_TOTAL_VALID_30);
            if (exportDto.getArrangedClassTotal() >= arrangedClassValid) {
                statistic.setEfficientTotalArrangedClassTotal(statistic.getEfficientTotalArrangedClassTotal() + 1);
                statistic.setArrangedClassTotal(statistic.getArrangedClassTotal() + exportDto.getArrangedClassTotal());
            }
            int courseSmsValid = this.getValidTotal(beforeDay, BIzConf.COURSESMS_TOTAL_VALID_7, BIzConf.COURSESMS_TOTAL_VALID_30);
            if (exportDto.getCourseSmsTotal() >= courseSmsValid) {
                statistic.setEfficientTotalCourseSms(statistic.getEfficientTotalCourseSms() + 1);
                statistic.setCourseSmsTotal(statistic.getCourseSmsTotal() + exportDto.getCourseSmsTotal());
            }
            int incomeSumValid = this.getValidTotal(beforeDay, BIzConf.INCOMESUM_VALID_7, BIzConf.INCOMESUM_VALID_30);
            if (exportDto.getIncomeSum() > (double)incomeSumValid) {
                statistic.setEfficientTotalIncomeSum(statistic.getEfficientTotalIncomeSum() + 1);
                statistic.setIncomeSum(statistic.getIncomeSum() + (double)((int)Math.ceil(exportDto.getIncomeSum())));
            }
            int signLessonValid = this.getValidTotal(beforeDay, BIzConf.SIGN_LESSON_VALID_7, BIzConf.SIGN_LESSON_VALID_30);
            if (exportDto.getSignLessonTotal() >= signLessonValid) {
                statistic.setEfficientTotalSign(statistic.getEfficientTotalSign() + 1);
                statistic.setSignStudentTotal(statistic.getSignStudentTotal() + exportDto.getSignStudentTotal());
            }
            int teacherCommentValid = this.getValidTotal(beforeDay, BIzConf.TEACHER_COMMENT_VALID_7, BIzConf.TEACHER_COMMENT_VALID_30);
            if (exportDto.getCommentByTeacher() >= teacherCommentValid) {
                statistic.setEfficientTotalCommentByTeacher(statistic.getEfficientTotalCommentByTeacher() + 1);
                statistic.setCommentByTeacher(statistic.getCommentByTeacher() + exportDto.getCommentByTeacher());
            }
            int studentCommentValid = this.getValidTotal(beforeDay, BIzConf.STUDENT_COMMENT_VALID_7, BIzConf.STUDENT_COMMENT_VALID_30);
            if (exportDto.getCommentByStudent() >= studentCommentValid) {
                statistic.setEfficientTotalCommentByStudent(statistic.getEfficientTotalCommentByStudent() + 1);
                statistic.setCommentByStudent(statistic.getCommentByStudent() + exportDto.getCommentByStudent());
            }
            int activityTotalValid = this.getValidTotal(beforeDay, BIzConf.ACTIVITY_TOTAL_VALID_7, BIzConf.ACTIVITY_TOTAL_VALID_30);
            if (exportDto.getActivityTotal() >= activityTotalValid) {
                statistic.setEfficientTotalActivity(statistic.getEfficientTotalActivity() + 1);
                statistic.setActivityAccessTotal(statistic.getActivityAccessTotal() + exportDto.getActivityAccessTotal());
            }
            int drawTotalValid = this.getValidTotal(beforeDay, BIzConf.DRAW_AVTIVITY_TOTAL_VALID_7, BIzConf.DRAW_AVTIVITY_TOTAL_VALID_30);
            if (exportDto.getDrawActivityTotal() >= drawTotalValid) {
                statistic.setEfficientTotalDrawActivity(statistic.getEfficientTotalDrawActivity() + 1);
                statistic.setDrawUserTotal(statistic.getDrawUserTotal() + exportDto.getDrawUserTotal());
            }
            int voteTotalValid = this.getValidTotal(beforeDay, BIzConf.VOTE_AVTIVITY_TOTAL_VALID_7, BIzConf.VOTE_AVTIVITY_TOTAL_VALID_30);
            if (exportDto.getVoteActivityTotal() >= voteTotalValid) {
                statistic.setEfficientTotalvoteActivity(statistic.getEfficientTotalvoteActivity() + 1);
                statistic.setVoteAccessTotal(statistic.getVoteAccessTotal() + exportDto.getVoteAccessTotal());
            }
            int referralTotalValid = this.getValidTotal(beforeDay, BIzConf.REFERRAL_ACTIVITY_VALID_7, BIzConf.REFERRAL_ACTIVITY_VALID_30);
            if (exportDto.getReferralActivityTotal() >= referralTotalValid) {
                statistic.setEfficientTotalReferralActivity(statistic.getEfficientTotalReferralActivity() + 1);
                statistic.setReferralAccessTotal(statistic.getReferralAccessTotal() + exportDto.getReferralAccessTotal());
            }
            int groupMsgValid = this.getValidTotal(beforeDay, BIzConf.GROUP_MESSAGE_TOTAL_VALID_7, BIzConf.GROUP_MESSAGE_TOTAL_VALID_30);
            if (exportDto.getGroupMsgTotal() >= groupMsgValid) {
                statistic.setEfficientTotalGroupMsg(statistic.getEfficientTotalGroupMsg() + 1);
                statistic.setGroupMsgTotal(statistic.getGroupMsgTotal() + exportDto.getGroupMsgTotal());
            }
            if (exportDto.getIsUseHomePage()) {
                statistic.setEfficientTotalUseHomePage(statistic.getEfficientTotalUseHomePage() + 1);
            }
            int uvTotalValid = this.getValidTotal(beforeDay, BIzConf.UV_TOTAL_VALID_7, BIzConf.UV_TOTAL_VALID_30);
            if (exportDto.getUvTotal() >= uvTotalValid) {
                statistic.setEfficientTotalUV(statistic.getEfficientTotalUV() + 1);
                statistic.setUvTotal(statistic.getUvTotal() + exportDto.getUvTotal());
            }
            if (exportDto.getWechatAuthorizerOfStudentTotal() != 0) {
                statistic.setEfficientTotalWechatAuthorizerOfStudent(statistic.getEfficientTotalWechatAuthorizerOfStudent() + 1);
            }
            statistic.setWechatAuthorizerOfStudentTotal(statistic.getWechatAuthorizerOfStudentTotal() + exportDto.getWechatAuthorizerOfStudentTotal());
            if (exportDto.getOrgCallRecordCount() >= 1) {
                statistic.setEfficientTotalorgCallRecordCount(statistic.getEfficientTotalorgCallRecordCount() + 1);
                statistic.setOrgCallRecordCount(statistic.getOrgCallRecordCount() + exportDto.getOrgCallRecordCount());
            }
            if (exportDto.getCallServiceCount() < 1) continue;
            statistic.setEfficientCallServiceCount(statistic.getEfficientCallServiceCount() + 1);
            statistic.setCallServiceCount(statistic.getCallServiceCount() + exportDto.getCallServiceCount());
        }
        log.info("statistic param:{}", (Object)statistic);
        return statistic;
    }

    private int getValidTotal(int dayNum, int data7, int data30) {
        int result = 0;
        result = dayNum == 7 ? data7 : data30;
        return result;
    }

    @Override
    public void getMonitorData(Date startTime, Date endTime) {
        Integer activityUserTotal;
        Integer activityTotal;
        ExportDto exportDto;
        Integer accountType = AccountTypeEnum.ZHENGSHI.getCode();
        List<Long> TianxiaoOrgIds = this.getOrgIdsByAccount(accountType);
        Map orgNumberMap = this.orgAccountDao.getorgNumbersByOrgIds(TianxiaoOrgIds);
        ArrayList<Integer> TianxiaoOrgNumbers = new ArrayList<Integer>();
        for (Long orgId : orgNumberMap.keySet()) {
            Integer orgNumber = (Integer)orgNumberMap.get(orgId);
            TianxiaoOrgNumbers.add(orgNumber);
        }
        log.info("taixiao\u673a\u6784\u8d26\u53f7\u5217\u8868\u957f\u5ea6==================" + TianxiaoOrgNumbers.size());
        Map txMonitorTypeDayMap = this.txMonitorTypeDayDao.mapUseMonitorType(startTime, endTime, TianxiaoOrgNumbers);
        Map consultTotalMap = this.messageDao.getConsultTotalMapByDate(startTime, endTime, TianxiaoOrgIds);
        log.info("\u7ebf\u7d22\u603b\u91cf consultTotalMap param {}", (Object)consultTotalMap);
        Map studentTotalMap = this.orgStudentDao.getStudentTotalMap(startTime, endTime, TianxiaoOrgIds);
        Map courseTotalMap = this.orgCourseDao.getCourseTotalMap(startTime, endTime, TianxiaoOrgNumbers);
        Map commentByTeacherMap = this.orgLessonCommentDao.getOrgCommentMap(startTime, endTime, TianxiaoOrgIds, Integer.valueOf(0));
        Map commentByStudentMap = this.orgLessonCommentDao.getOrgCommentMap(startTime, endTime, TianxiaoOrgIds, Integer.valueOf(2));
        Map signLessonIdsMap = this.orgLessonSignDao.getOrgSignLessonIdsMap(startTime, endTime, TianxiaoOrgIds);
        HashMap<String, Integer> signByTeacherMap = new HashMap<String, Integer>();
        if (GenericsUtils.notNullAndEmpty((Object)signLessonIdsMap)) {
            for (String createTime : signLessonIdsMap.keySet()) {
                List lessonIds = (List)signLessonIdsMap.get(createTime);
                Map orgTeacherLessonMap = this.orgTeacherLessonDao.getOrgTeacherLessonMapByLessonIds((Collection)lessonIds);
                HashSet teacherIds = new HashSet();
                if (GenericsUtils.notNullAndEmpty((Object)orgTeacherLessonMap)) {
                    for (Long lessonId : orgTeacherLessonMap.keySet()) {
                        Long teacherId = ((OrgTeacherLesson)orgTeacherLessonMap.get(lessonId)).getTeacherId();
                        teacherIds.add(teacherId);
                    }
                }
                Integer signTeacherCount = teacherIds.size();
                signByTeacherMap.put(createTime, signTeacherCount);
            }
        }
        log.info("signByTeacherMap param{}", signByTeacherMap);
        Map signByStudentMap = this.orgLessonSignDao.getOrgSignMap(startTime, endTime, TianxiaoOrgIds, Integer.valueOf(2));
        Map loginMap = this.orgAppLoginLogDao.getOrgLoginMap(startTime, endTime, TianxiaoOrgIds);
        Map activityIdsMap = this.activityDao.getActivityIdByOrgIds(TianxiaoOrgIds, null, null);
        ArrayList activityIds = new ArrayList();
        if (GenericsUtils.notNullAndEmpty((Object)activityIdsMap)) {
            for (Long orgId : activityIdsMap.keySet()) {
                List ids = (List)activityIdsMap.get(orgId);
                if (!GenericsUtils.notNullAndEmpty((Object)ids)) continue;
                activityIds.addAll(ids);
            }
        }
        Map activityTotalMap = this.activityAccessLogDao.getActivityAccessLogTotalMap(activityIds, Integer.valueOf(TemplateTypeCategory.COMMON_TYPE.getType()), startTime, endTime);
        Map activityUserTotalMap = this.activityUserDao.getUserTotalMap(activityIds, Integer.valueOf(TemplateTypeCategory.COMMON_TYPE.getType()), startTime, endTime);
        Map drawActivityIdsMap = this.drawActivityDao.getDrawActivitysByIds(TianxiaoOrgIds, null, null);
        ArrayList drawActivityIds = new ArrayList();
        if (GenericsUtils.notNullAndEmpty((Object)drawActivityIdsMap)) {
            for (Long orgId : drawActivityIdsMap.keySet()) {
                List ids = (List)drawActivityIdsMap.get(orgId);
                if (!GenericsUtils.notNullAndEmpty((Object)ids)) continue;
                drawActivityIds.addAll(ids);
            }
        }
        Map drawActivityTotalMap = this.activityAccessLogDao.getActivityAccessLogTotalMap(drawActivityIds, Integer.valueOf(TemplateTypeCategory.DRAW_TYPE.getType()), startTime, endTime);
        Map drawActivityUserTotalMap = this.activityUserDao.getUserTotalMap(drawActivityIds, Integer.valueOf(TemplateTypeCategory.DRAW_TYPE.getType()), startTime, endTime);
        Map voteActivityIdsMap = this.voteInfoDao.getVoteActivityIdsByOrgIds(TianxiaoOrgIds, null, null);
        ArrayList voteActivityIds = new ArrayList();
        if (GenericsUtils.notNullAndEmpty((Object)voteActivityIdsMap)) {
            for (Long orgId : voteActivityIdsMap.keySet()) {
                List ids = (List)voteActivityIdsMap.get(orgId);
                if (!GenericsUtils.notNullAndEmpty((Object)ids)) continue;
                voteActivityIds.addAll(ids);
            }
        }
        Map voteActivityTotalMap = this.activityAccessLogDao.getActivityAccessLogTotalMap(voteActivityIds, Integer.valueOf(TemplateTypeCategory.VOTE_TYPE.getType()), startTime, endTime);
        Map voteActivityUserTotalMap = this.activityUserDao.getUserTotalMap(voteActivityIds, Integer.valueOf(TemplateTypeCategory.VOTE_TYPE.getType()), startTime, endTime);
        Map referralActivityIdsMap = this.referralInfoDao.getReferralActivityIdsByOrgIds(TianxiaoOrgIds, null, null);
        ArrayList referralActivityIds = new ArrayList();
        if (GenericsUtils.notNullAndEmpty((Object)referralActivityIdsMap)) {
            for (Long orgId : referralActivityIdsMap.keySet()) {
                List ids = (List)referralActivityIdsMap.get(orgId);
                if (!GenericsUtils.notNullAndEmpty((Object)ids)) continue;
                referralActivityIds.addAll(ids);
            }
        }
        Map referralActivityTotalMap = this.activityAccessLogDao.getActivityAccessLogTotalMap(referralActivityIds, Integer.valueOf(TemplateTypeCategory.REFERRAL_TYPE.getType()), startTime, endTime);
        Map referralActivityUserTotalMap = this.activityUserDao.getUserTotalMap(referralActivityIds, Integer.valueOf(TemplateTypeCategory.REFERRAL_TYPE.getType()), startTime, endTime);
        HashMap<Object, ExportDto> exportDtoMap = new HashMap<Object, ExportDto>();
        for (Object date : txMonitorTypeDayMap.keySet()) {
            TxMonitorTypeDay txMonitorTypeDay = (TxMonitorTypeDay)txMonitorTypeDayMap.get(date);
            exportDto = (ExportDto)exportDtoMap.get(date);
            if (exportDto == null) {
                exportDto = new ExportDto();
                exportDtoMap.put(date, exportDto);
                exportDto.setCurDate((String)date);
            }
            exportDto.setPvTotal(txMonitorTypeDay.getPv() == null ? 0 : txMonitorTypeDay.getPv());
            exportDto.setUvTotal(txMonitorTypeDay.getUv() == null ? 0 : txMonitorTypeDay.getUv());
        }
        for (Object date : consultTotalMap.keySet()) {
            Integer consultTotal = (Integer)consultTotalMap.get(date);
            exportDto = (ExportDto)exportDtoMap.get(date);
            if (exportDto == null) {
                log.info("");
                exportDto = new ExportDto();
                exportDtoMap.put(date, exportDto);
                exportDto.setCurDate((String)date);
            }
            exportDto.setClueTotal(consultTotal == null ? 0 : consultTotal);
        }
        for (Object date : studentTotalMap.keySet()) {
            Integer studentTotal = (Integer)studentTotalMap.get(date);
            exportDto = (ExportDto)exportDtoMap.get(date);
            if (exportDto == null) {
                exportDto = new ExportDto();
                exportDtoMap.put(date, exportDto);
                exportDto.setCurDate((String)date);
            }
            exportDto.setStudentTotal(studentTotal == null ? 0 : studentTotal);
        }
        for (Object date : courseTotalMap.keySet()) {
            Integer courseTotal = (Integer)courseTotalMap.get(date);
            exportDto = (ExportDto)exportDtoMap.get(date);
            if (exportDto == null) {
                exportDto = new ExportDto();
                exportDtoMap.put(date, exportDto);
                exportDto.setCurDate((String)date);
            }
            exportDto.setCourseTotal(courseTotal == null ? 0 : courseTotal);
        }
        for (Object date : loginMap.keySet()) {
            Integer loginTotal = (Integer)loginMap.get(date);
            exportDto = (ExportDto)exportDtoMap.get(date);
            if (exportDto == null) {
                exportDto = new ExportDto();
                exportDtoMap.put(date, exportDto);
                exportDto.setCurDate((String)date);
            }
            exportDto.setLoginTotal(loginTotal == null ? 0 : loginTotal);
        }
        for (Object date : commentByStudentMap.keySet()) {
            Integer commsentStuTotal = (Integer)commentByStudentMap.get(date);
            exportDto = (ExportDto)exportDtoMap.get(date);
            if (exportDto == null) {
                exportDto = new ExportDto();
                exportDtoMap.put(date, exportDto);
                exportDto.setCurDate((String)date);
            }
            exportDto.setCommentByStudent(commsentStuTotal == null ? 0 : commsentStuTotal);
        }
        for (Object date : commentByTeacherMap.keySet()) {
            Integer commentTeacherTotal = (Integer)commentByTeacherMap.get(date);
            exportDto = (ExportDto)exportDtoMap.get(date);
            if (exportDto == null) {
                exportDto = new ExportDto();
                exportDtoMap.put(date, exportDto);
                exportDto.setCurDate((String)date);
            }
            exportDto.setCommentByTeacher(commentTeacherTotal == null ? 0 : commentTeacherTotal);
        }
        for (Object date : signByStudentMap.keySet()) {
            Integer signStuTotal = (Integer)signByStudentMap.get(date);
            exportDto = (ExportDto)exportDtoMap.get(date);
            if (exportDto == null) {
                exportDto = new ExportDto();
                exportDtoMap.put(date, exportDto);
                exportDto.setCurDate((String)date);
            }
            exportDto.setSignStudentTotal(signStuTotal == null ? 0 : signStuTotal);
        }
        for (Object date : signByTeacherMap.keySet()) {
            Integer signTeacherTotal = (Integer)signByTeacherMap.get(date);
            exportDto = (ExportDto)exportDtoMap.get(date);
            if (exportDto == null) {
                exportDto = new ExportDto();
                exportDtoMap.put(date, exportDto);
                exportDto.setCurDate((String)date);
            }
            exportDto.setSignTeacherTotal(signTeacherTotal == null ? 0 : signTeacherTotal);
        }
        for (Object date : activityTotalMap.keySet()) {
            activityTotal = (Integer)activityTotalMap.get(date);
            exportDto = (ExportDto)exportDtoMap.get(date);
            if (exportDto == null) {
                exportDto = new ExportDto();
                exportDtoMap.put(date, exportDto);
                exportDto.setCurDate((String)date);
            }
            exportDto.setActivityTotal((activityTotal = Integer.valueOf(exportDto.getActivityTotal() + activityTotal)) == null ? 0 : activityTotal);
        }
        for (Object date : drawActivityTotalMap.keySet()) {
            activityTotal = (Integer)drawActivityTotalMap.get(date);
            exportDto = (ExportDto)exportDtoMap.get(date);
            if (exportDto == null) {
                exportDto = new ExportDto();
                exportDtoMap.put(date, exportDto);
                exportDto.setCurDate((String)date);
            }
            exportDto.setActivityTotal((activityTotal = Integer.valueOf(exportDto.getActivityTotal() + activityTotal)) == null ? 0 : activityTotal);
        }
        for (Object date : voteActivityTotalMap.keySet()) {
            activityTotal = (Integer)voteActivityTotalMap.get(date);
            exportDto = (ExportDto)exportDtoMap.get(date);
            if (exportDto == null) {
                exportDto = new ExportDto();
                exportDtoMap.put(date, exportDto);
                exportDto.setCurDate((String)date);
            }
            exportDto.setActivityTotal((activityTotal = Integer.valueOf(exportDto.getActivityTotal() + activityTotal)) == null ? 0 : activityTotal);
        }
        for (Object date : referralActivityTotalMap.keySet()) {
            activityTotal = (Integer)referralActivityTotalMap.get(date);
            exportDto = (ExportDto)exportDtoMap.get(date);
            if (exportDto == null) {
                exportDto = new ExportDto();
                exportDtoMap.put(date, exportDto);
                exportDto.setCurDate((String)date);
            }
            exportDto.setActivityTotal((activityTotal = Integer.valueOf(exportDto.getActivityTotal() + activityTotal)) == null ? 0 : activityTotal);
        }
        for (Object date : activityUserTotalMap.keySet()) {
            activityUserTotal = (Integer)activityUserTotalMap.get(date);
            exportDto = (ExportDto)exportDtoMap.get(date);
            if (exportDto == null) {
                exportDto = new ExportDto();
                exportDtoMap.put(date, exportDto);
                exportDto.setCurDate((String)date);
            }
            exportDto.setDrawUserTotal((activityUserTotal = Integer.valueOf(exportDto.getDrawUserTotal() + activityUserTotal)) == null ? 0 : activityUserTotal);
        }
        for (Object date : drawActivityUserTotalMap.keySet()) {
            activityUserTotal = (Integer)drawActivityUserTotalMap.get(date);
            exportDto = (ExportDto)exportDtoMap.get(date);
            if (exportDto == null) {
                exportDto = new ExportDto();
                exportDtoMap.put(date, exportDto);
                exportDto.setCurDate((String)date);
            }
            exportDto.setDrawUserTotal((activityUserTotal = Integer.valueOf(exportDto.getDrawUserTotal() + activityUserTotal)) == null ? 0 : activityUserTotal);
        }
        for (Object date : voteActivityUserTotalMap.keySet()) {
            activityUserTotal = (Integer)voteActivityUserTotalMap.get(date);
            exportDto = (ExportDto)exportDtoMap.get(date);
            if (exportDto == null) {
                exportDto = new ExportDto();
                exportDtoMap.put(date, exportDto);
                exportDto.setCurDate((String)date);
            }
            exportDto.setDrawUserTotal((activityUserTotal = Integer.valueOf(exportDto.getDrawUserTotal() + activityUserTotal)) == null ? 0 : activityUserTotal);
        }
        for (Object date : referralActivityUserTotalMap.keySet()) {
            activityUserTotal = (Integer)referralActivityUserTotalMap.get(date);
            exportDto = (ExportDto)exportDtoMap.get(date);
            if (exportDto == null) {
                exportDto = new ExportDto();
                exportDtoMap.put(date, exportDto);
                exportDto.setCurDate((String)date);
            }
            exportDto.setDrawUserTotal((activityUserTotal = Integer.valueOf(exportDto.getDrawUserTotal() + activityUserTotal)) == null ? 0 : activityUserTotal);
        }
        ArrayList rows = new ArrayList();
        for (String date : exportDtoMap.keySet()) {
            exportDto = (ExportDto)exportDtoMap.get(date);
            LinkedHashMap<String, String> rowMap = new LinkedHashMap<String, String>();
            rowMap.put("\u65e5\u671f", exportDto.getCurDate());
            rowMap.put("\u65b0\u589e\u7ebf\u7d22", exportDto.getClueTotal() + "");
            rowMap.put("\u65b0\u589e\u5b66\u5458", exportDto.getStudentTotal() + "");
            rowMap.put("\u673a\u6784\u4e3b\u9875UV", exportDto.getUvTotal() + "");
            rowMap.put("\u673a\u6784\u4e3b\u9875PV", exportDto.getPvTotal() + "");
            rowMap.put("\u65b0\u589e\u5fae\u8bfe\u6570\u91cf", exportDto.getCourseTotal() + "");
            rowMap.put("\u6d3b\u52a8PV", exportDto.getActivityTotal() + "");
            rowMap.put("\u6d3b\u52a8UV", exportDto.getDrawUserTotal() + "");
            rowMap.put("\u673a\u6784\u767b\u5f55", exportDto.getLoginTotal() + "");
            rowMap.put("\u5b66\u751f\u4e3b\u52a8\u8bc4\u4ef7\u6570", exportDto.getCommentByStudent() + "");
            rowMap.put("\u8001\u5e08\u4e3b\u52a8\u8bc4\u4ef7\u6570", exportDto.getCommentByTeacher() + "");
            rowMap.put("\u5b66\u751f\u7b7e\u5230", exportDto.getSignStudentTotal() + "");
            rowMap.put("\u8001\u5e08\u7b7e\u5230", exportDto.getSignTeacherTotal() + "");
            rows.add(rowMap);
        }
        String startDate = null;
        String endDate = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        startDate = dateFormat.format(startTime);
        endDate = dateFormat.format(endTime);
        String subject = "\u673a\u6784\u4e3b\u9875\u8bbf\u95ee\u4fe1\u606f(" + startDate + "~" + endDate + ")";
        String content = "";
        String mail = "gaodan@baijiahulian.com";
        String fileName = "orgInfo";
        ExcelMailSender.sendMail((String)mail, (String)subject, (String)content, (String)fileName, rows);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void createExcelOfErpData() {
        String filePath = "template/OrderOrgNumber.txt";
        List<Integer> tianXiaoOrgNumbers = HagTianxiaoOrgNumber.getOrgNumbers(filePath);
        List<Long> orgIds = this.getTianxiaoOrgIds(tianXiaoOrgNumbers);
        Map orgNumberMap = this.orgAccountDao.getorgNumbersByOrgIds(orgIds);
        List orgCourseList = this.orgCourseDao.getOrgCourseList(tianXiaoOrgNumbers);
        if (GenericsUtils.isNullOrEmpty((Object)orgCourseList)) {
            log.info("\u83b7\u53d6\u673a\u6784\u8bfe\u7a0b\u4e3a\u6570\u636e\u4f4dNull");
            return;
        }
        HashMap<Long, OrgCourse> orgCourseMap = new HashMap<Long, OrgCourse>();
        ArrayList<Long> courseIds = new ArrayList<Long>();
        HashSet<Long> roomIds = new HashSet<Long>();
        for (OrgCourse orgCourse : orgCourseList) {
            Long orgCourseId = orgCourse.getId();
            orgCourseMap.put(orgCourseId, orgCourse);
            courseIds.add(orgCourseId);
            Long roomId = orgCourse.getRoomId();
            if (!GenericsUtils.notNullAndEmpty((Object)roomId)) continue;
            roomIds.add(roomId);
        }
        HashMap<Long, OrgClassRoom> orgClassRoomMap = new HashMap<Long, OrgClassRoom>();
        if (GenericsUtils.notNullAndEmpty(roomIds)) {
            List orgClassRooms = this.OrgClassRoomDao.getOrgClassRoomListByRoomIds(roomIds);
            for (OrgClassRoom orgClassRoom : orgClassRooms) {
                Long roomId = orgClassRoom.getId();
                orgClassRoomMap.put(roomId, orgClassRoom);
            }
        }
        Map teacherUserIdsMap = this.orgCourseTeacherDao.getTeacherMap(courseIds);
        HashSet teacherUserIds = new HashSet();
        Map teacherNameMap = new HashMap();
        if (GenericsUtils.notNullAndEmpty((Object)teacherUserIdsMap)) {
            for (Long courseId : teacherUserIdsMap.keySet()) {
                List teacherIds = (List)teacherUserIdsMap.get(courseId);
                teacherUserIds.addAll(teacherIds);
            }
            teacherNameMap = this.teacherDao.getTeacherRealNameMap(teacherUserIds);
        }
        Map orgStudentCourseMapBycourseIds = this.orgStudentCourseDao.getStudentMapBycourseIds(courseIds, new String[0]);
        HashMap<Long, Integer> stuTotalMap = new HashMap<Long, Integer>();
        if (GenericsUtils.notNullAndEmpty((Object)orgStudentCourseMapBycourseIds)) {
            for (Long courseId : orgStudentCourseMapBycourseIds.keySet()) {
                List orgStudentCourses = (List)orgStudentCourseMapBycourseIds.get(courseId);
                stuTotalMap.put(courseId, orgStudentCourses.size());
            }
        }
        List orgClassLessons = this.orgClassLessonDao.getOrgClassLessonList(courseIds);
        ArrayList<Long> orgLessonIds = new ArrayList<Long>();
        HashMap orgClassLessonListMap = new HashMap();
        HashMap<Long, OrgClassLesson> orgClassLessonMap = new HashMap<Long, OrgClassLesson>();
        HashSet<Long> roomLessonIds = new HashSet<Long>();
        if (GenericsUtils.notNullAndEmpty((Object)orgClassLessons)) {
            for (OrgClassLesson orgClassLesson : orgClassLessons) {
                void var23_23;
                Long courseId = orgClassLesson.getCourseId();
                List list = (List)orgClassLessonListMap.get(courseId);
                if (GenericsUtils.isNullOrEmpty((Object)list)) {
                    ArrayList arrayList = new ArrayList();
                    orgClassLessonListMap.put(courseId, arrayList);
                }
                var23_23.add(orgClassLesson);
                Long lessonId = orgClassLesson.getId();
                orgClassLessonMap.put(lessonId, orgClassLesson);
                orgLessonIds.add(lessonId);
                Long roomId = orgClassLesson.getRoomId();
                if (!GenericsUtils.notNullAndEmpty((Object)roomId)) continue;
                roomLessonIds.add(roomId);
            }
        }
        ArrayList<Object> orgCourseDetailDtos = new ArrayList<Object>();
        for (Long courseId : courseIds) {
            OrgCourse orgCourse = (OrgCourse)orgCourseMap.get(courseId);
            OrgCourseDetailDto orgCourseDetailDto = OrgCourseDetailDto.buildOrgCourseDetailDtoByOrgCourse(orgCourse);
            String teacherNames = null;
            List teacherUserIdList = (List)teacherUserIdsMap.get(courseId);
            if (GenericsUtils.notNullAndEmpty((Object)teacherUserIdList)) {
                StringBuffer names = new StringBuffer();
                for (Long teacherId : teacherUserIdList) {
                    String teacherName = (String)teacherNameMap.get(teacherId);
                    names.append(teacherName + " ");
                }
                teacherNames = names.toString();
            }
            orgCourseDetailDto.setTeacherNames(teacherNames == null ? "" : teacherNames);
            Integer studentTotal = (Integer)stuTotalMap.get(courseId);
            orgCourseDetailDto.setStudentCount(studentTotal == null ? 0 : studentTotal);
            Integer arrangeLessonTotal = null;
            List lessonList = (List)orgClassLessonListMap.get(courseId);
            if (GenericsUtils.notNullAndEmpty((Object)lessonList)) {
                arrangeLessonTotal = lessonList.size();
            }
            orgCourseDetailDto.setLessonCount(arrangeLessonTotal == null ? 0 : arrangeLessonTotal);
            Long roomId = orgCourse.getRoomId();
            String roomName = null;
            OrgClassRoom orgClassRoom = (OrgClassRoom)orgClassRoomMap.get(roomId);
            if (GenericsUtils.notNullAndEmpty((Object)orgClassRoom)) {
                roomName = orgClassRoom.getRoomName();
            }
            orgCourseDetailDto.setRoomNames(roomName == null ? "" : roomName);
            orgCourseDetailDtos.add((Object)orgCourseDetailDto);
        }
        if (GenericsUtils.notNullAndEmpty((Object)orgClassLessons)) {
            HashMap<Long, OrgClassRoom> orgClassRoomMapOfLesson = new HashMap<Long, OrgClassRoom>();
            Map studentUserIdLessonMap = this.orgStudentLessonDao.getLessonStudentList(orgLessonIds);
            List list = this.OrgClassRoomDao.getOrgClassRoomListByRoomIds(roomLessonIds);
            for (OrgClassRoom orgClassRoom : list) {
                Long roomId = orgClassRoom.getId();
                orgClassRoomMapOfLesson.put(roomId, orgClassRoom);
            }
            Map orgTeacherLessonMap = this.orgTeacherLessonDao.getOrgTeacherLessonMapByLessonIds(orgLessonIds);
            HashSet<Long> userIdsofTeacher = new HashSet<Long>();
            for (Long lessonId : orgTeacherLessonMap.keySet()) {
                OrgTeacherLesson orgTeacherLesson = (OrgTeacherLesson)orgTeacherLessonMap.get(lessonId);
                Long userId = orgTeacherLesson.getTeacherId();
                userIdsofTeacher.add(userId);
            }
            Map teacherNameMapOfLesson = new HashMap();
            teacherNameMapOfLesson = this.teacherDao.getTeacherRealNameMap(userIdsofTeacher);
            ArrayList rows = new ArrayList();
            for (OrgClassLesson orgClassLesson : orgClassLessons) {
                Long lessonId = orgClassLesson.getId();
                List studentUserIds = (List)studentUserIdLessonMap.get(lessonId);
                Integer studentTotal = null;
                if (GenericsUtils.notNullAndEmpty((Object)studentUserIds)) {
                    studentTotal = studentUserIds.size();
                }
                Long roomId = orgClassLesson.getRoomId();
                String roomName = null;
                OrgClassRoom orgClassRoom = (OrgClassRoom)orgClassRoomMapOfLesson.get(roomId);
                if (GenericsUtils.notNullAndEmpty((Object)orgClassRoom)) {
                    roomName = orgClassRoom.getRoomName();
                }
                String teacherName = null;
                OrgTeacherLesson orgTeacherLesson = (OrgTeacherLesson)orgTeacherLessonMap.get(lessonId);
                if (GenericsUtils.notNullAndEmpty((Object)orgTeacherLesson)) {
                    Long teacherUserId = orgTeacherLesson.getTeacherId();
                    teacherName = (String)teacherNameMapOfLesson.get(teacherUserId);
                }
                Long courseId = orgClassLesson.getCourseId();
                OrgCourse orgCourse = (OrgCourse)orgCourseMap.get(courseId);
                String courseName = orgCourse.getName();
                ClassLessonDetailDto classLessonDetailDto = ClassLessonDetailDto.buildClassLessonDetailDto(orgClassLesson, studentTotal, roomName, teacherName, courseName);
                LinkedHashMap<String, String> rowMap = new LinkedHashMap<String, String>();
                rowMap.put("\u8bfe\u8282id", classLessonDetailDto.getLessonId() + "");
                rowMap.put("\u8bfe\u7a0bid", courseId + "");
                rowMap.put("\u6240\u5c5e\u73ed\u7ea7", classLessonDetailDto.getCourseName());
                rowMap.put("\u8bfe\u8282\u53f7", classLessonDetailDto.getIndex() + "");
                rowMap.put("\u4e0a\u8bfe\u65e5\u671f", classLessonDetailDto.getBeginDate() + "");
                rowMap.put("\u4e0a\u8bfe\u5f00\u59cb\u65f6\u95f4", classLessonDetailDto.getStart());
                rowMap.put("\u4e0a\u8bfe\u7ed3\u675f\u65f6\u95f4", classLessonDetailDto.getEnd());
                rowMap.put("\u8001\u5e08", classLessonDetailDto.getTeacherName());
                rowMap.put("\u6559\u5ba4 ", classLessonDetailDto.getRoomName());
                rowMap.put("\u5b66\u5458\u6570", classLessonDetailDto.getStudentTotal() + "");
                rowMap.put("\u521b\u5efa\u65f6\u95f4", classLessonDetailDto.getCreateTime() + "");
                rows.add(rowMap);
            }
            String subject = "\u8bfe\u8282\u8be6\u7ec6\u4fe1\u606f";
            String content = "";
            String mail = "gaodan@baijiahulian.com";
            String fileName = "lessonDetailInfo";
            ExcelMailSender.sendMail((String)mail, (String)subject, (String)content, (String)fileName, rows);
        }
        if (GenericsUtils.notNullAndEmpty(orgCourseDetailDtos)) {
            ArrayList rows = new ArrayList();
            for (OrgCourseDetailDto orgCourseDetailDto : orgCourseDetailDtos) {
                LinkedHashMap<String, String> rowMap = new LinkedHashMap<String, String>();
                rowMap.put("\u8bfe\u7a0bid", orgCourseDetailDto.getOrgCourseId() + "");
                rowMap.put("\u8bfe\u7a0b\u540d\u79f0", orgCourseDetailDto.getCourseName());
                rowMap.put("\u4ef7\u683c", orgCourseDetailDto.getPrice() + "");
                rowMap.put("\u4e0a\u8bfe\u6b21\u6570", orgCourseDetailDto.getFreq() + "");
                rowMap.put("\u73ed\u7ea7\u4eba\u6570", orgCourseDetailDto.getMaxStudent() + "");
                rowMap.put("\u5b66\u751f\u4eba\u6570", orgCourseDetailDto.getStudentCount() + "");
                rowMap.put("\u6dfb\u52a0\u65f6\u95f4", orgCourseDetailDto.getCreateTime() + "");
                rowMap.put("\u5f00\u8bfe\u65f6\u95f4", orgCourseDetailDto.getStartTime() + "");
                rowMap.put("\u7ed3\u675f\u65f6\u95f4", orgCourseDetailDto.getEndTime() + "");
                rowMap.put("\u4e0a\u8bfe\u5730\u5740", orgCourseDetailDto.getCourseUrl());
                rowMap.put("\u8bfe\u7a0b\u4ecb\u7ecd", orgCourseDetailDto.getIntroduction());
                rowMap.put("\u8001\u5e08", orgCourseDetailDto.getTeacherNames());
                rowMap.put("\u8bfe\u7a0b\u72b6\u6001", orgCourseDetailDto.getClassStatus());
                rowMap.put("\u673a\u6784number", orgCourseDetailDto.getOrgNumber() + "");
                rowMap.put("\u6559\u5ba4", orgCourseDetailDto.getRoomNames());
                rowMap.put("\u5df2\u5b89\u6392\u8bfe\u8282\u6570", orgCourseDetailDto.getLessonCount() + "");
                rows.add(rowMap);
            }
            String subject = "\u8bfe\u7a0b\u8be6\u7ec6\u4fe1\u606f";
            String string = "";
            String mail = "gaodan@baijiahulian.com";
            String fileName = "classDetailInfo";
            ExcelMailSender.sendMail((String)mail, (String)subject, (String)string, (String)fileName, rows);
        }
        List orgTeachers = this.orgTeacherDao.getOrgTeacherListByOrgIds(orgIds);
        ArrayList<Integer> orgIdsOfInteger = new ArrayList<Integer>();
        for (Long orgId : orgIds) {
            orgIdsOfInteger.add(orgId.intValue());
        }
        List list = this.orgInfoDao.getOrgInfos(orgIdsOfInteger, new String[0]);
        HashMap<Long, OrgInfo> orgInfoMap = new HashMap<Long, OrgInfo>();
        for (OrgInfo orgInfo : list) {
            orgInfoMap.put(orgInfo.getOrgId().longValue(), orgInfo);
        }
        if (GenericsUtils.notNullAndEmpty((Object)orgTeachers)) {
            ArrayList rows = new ArrayList();
            HashSet<Long> teachUserIds = new HashSet<Long>();
            HashMap<Long, Object> orgTeacherMap = new HashMap<Long, Object>();
            for (Object orgTeacher : orgTeachers) {
                Long userId = orgTeacher.getUserId();
                teachUserIds.add(userId);
                orgTeacherMap.put(userId, orgTeacher);
            }
            List teachers = this.teacherDao.getByUserIds(teachUserIds, new String[0]);
            for (Teacher teacher : teachers) {
                Long orgId = teacher.getOrgId();
                OrgInfo orgInfo = (OrgInfo)orgInfoMap.get(orgId);
                String orgName = null;
                if (GenericsUtils.notNullAndEmpty((Object)orgInfo)) {
                    orgName = orgInfo.getShortName();
                }
                Integer orgNumber = (Integer)orgNumberMap.get(orgId);
                LinkedHashMap<String, String> rowMap = new LinkedHashMap<String, String>();
                rowMap.put("\u8001\u5e08id", teacher.getId() + "");
                rowMap.put("\u8001\u5e08Number", teacher.getUserId() + "");
                rowMap.put("\u8001\u5e08\u540d\u79f0", teacher.getRealName());
                Long userId = teacher.getUserId();
                OrgTeacher orgTeacher = (OrgTeacher)orgTeacherMap.get(userId);
                Integer status = orgTeacher.getStatus();
                rowMap.put("\u8001\u5e08\u624b\u673a", orgTeacher.getMobile());
                rowMap.put("\u8001\u5e08\u72b6\u6001", TeacherStatus.getTeacherStatusByCode(status).getMessage());
                rowMap.put("\u673a\u6784\u540d\u79f0", orgName + "");
                rowMap.put("\u673a\u6784number", orgNumber + "");
                rows.add(rowMap);
            }
            String subject = "\u673a\u6784\u8001\u5e08\u8be6\u7ec6\u4fe1\u606f";
            String content = "";
            String mail = "gaodan@baijiahulian.com";
            String fileName = "teacherDetailInfo";
            ExcelMailSender.sendMail((String)mail, (String)subject, (String)content, (String)fileName, rows);
        }
    }

    @Override
    public void createExcelOfMsgRecordData() {
        String filePath = "template/OrderOrgNumber.txt";
        List<Integer> tianXiaoOrgNumbers = HagTianxiaoOrgNumber.getOrgNumbers(filePath);
        List<Long> orgIds = this.getTianxiaoOrgIds(tianXiaoOrgNumbers);
        ArrayList<Integer> orgIdsInteger = new ArrayList<Integer>();
        for (Long orgId : orgIds) {
            orgIdsInteger.add(orgId.intValue());
        }
        Map orgNumberMap = this.orgAccountDao.batchSearchOrgIds(tianXiaoOrgNumbers);
        List orgInfos = this.orgInfoDao.getOrgInfos(orgIdsInteger, new String[0]);
        HashMap<Long, OrgInfo> orgInfoMap = new HashMap<Long, OrgInfo>();
        for (OrgInfo orgInfo : orgInfos) {
            Long orgId = orgInfo.getOrgId().longValue();
            orgInfoMap.put(orgId, orgInfo);
        }
        List msgRecordDtos = this.messageDao.getMsgRecordDtoListByOrgIds(tianXiaoOrgNumbers);
        if (GenericsUtils.notNullAndEmpty((Object)msgRecordDtos)) {
            ArrayList rows = new ArrayList();
            for (MsgRecordDto msgRecordDto : msgRecordDtos) {
                LinkedHashMap<String, String> rowMap = new LinkedHashMap<String, String>();
                Integer orgNumber = msgRecordDto.getOrgNumber();
                Long orgId = (Long)orgNumberMap.get(orgNumber);
                String shortName = null;
                OrgInfo orgInfo = (OrgInfo)orgInfoMap.get(orgId);
                if (GenericsUtils.notNullAndEmpty((Object)orgInfo)) {
                    shortName = orgInfo.getShortName();
                }
                rowMap.put("\u673a\u6784number", orgNumber + "");
                rowMap.put("\u673a\u6784\u7b80\u79f0", shortName);
                rowMap.put("\u54a8\u8be2\u7528\u6237id", msgRecordDto.getConsultId() + "");
                Integer consultRole = msgRecordDto.getConsultRole();
                rowMap.put("\u54a8\u8be2\u7528\u6237\u7c7b\u578b", consultRole + "");
                Integer consultType = msgRecordDto.getConsultType();
                rowMap.put("\u4fe1\u606f\u6765\u6e90", MessageSource.getByType((Integer)consultType).getDesc());
                Integer msgType = msgRecordDto.getMsgType();
                rowMap.put("\u6d88\u606f\u7c7b\u578b", MsgType.getByType((Integer)msgType).getDesc());
                rowMap.put("\u54a8\u8be2\u5185\u5bb9", msgRecordDto.getContent());
                rowMap.put("\u8bbf\u95ee\u65f6\u95f4", msgRecordDto.getCreateTime() + "");
                rows.add(rowMap);
            }
            String subject = "\u54a8\u8be2\u6d88\u606f\u8be6\u7ec6\u4fe1\u606f";
            String content = "";
            String mail = "gaodan@baijiahulian.com";
            String fileName = "msgRecordDetailInfo";
            ExcelMailSender.sendMail((String)mail, (String)subject, (String)content, (String)fileName, rows);
        }
    }

    public List<Long> getOrgIdsByAccount(Integer accountType) {
        List<Integer> TianxiaoOrgNumbers = HagTianxiaoOrgNumber.getOrgNumbers();
        List<Long> TianxiaoOrgIds = this.getTianxiaoOrgIds(TianxiaoOrgNumbers);
        Map txAccountTypeMap = this.txAccountDao.getAccountTypeMap(TianxiaoOrgIds);
        List orgSubAccounts = this.orgSubAccountDao.getOrgSubAccountByOrgIds(TianxiaoOrgIds, OrgSubAccountStatus.NORMAL.getCode());
        HashMap<Long, ArrayList<Long>> orgSubIdsMap = new HashMap<Long, ArrayList<Long>>();
        if (GenericsUtils.notNullAndEmpty((Object)orgSubAccounts)) {
            for (OrgSubAccount orgSubAccount : orgSubAccounts) {
                Integer pid = orgSubAccount.getPid();
                Long orgId = orgSubAccount.getOrgId().longValue();
                if (pid == 0) continue;
                ArrayList<Long> orgSubIds = (ArrayList<Long>)orgSubIdsMap.get(pid.longValue());
                if (GenericsUtils.isNullOrEmpty((Object)orgSubIds)) {
                    orgSubIds = new ArrayList<Long>();
                    orgSubIdsMap.put(pid.longValue(), orgSubIds);
                }
                orgSubIds.add(orgId);
            }
        }
        if (GenericsUtils.notNullAndEmpty(orgSubIdsMap)) {
            log.info("\u586b\u5145\u524d txAccountTypeMap size:{}", (Object)txAccountTypeMap.size());
            for (Long mainOrgId : orgSubIdsMap.keySet()) {
                Integer accountMainType = (Integer)txAccountTypeMap.get(mainOrgId);
                log.info("mainOrgId param:{}, accountMainType param:{}", (Object)mainOrgId, (Object)accountMainType);
                if (!GenericsUtils.notNullAndEmpty((Object)accountMainType)) continue;
                List subOrgIds = (List)orgSubIdsMap.get(mainOrgId);
                log.info("subOrgIds param:{}", (Object)subOrgIds);
                for (Long subOrgId : subOrgIds) {
                    txAccountTypeMap.put(subOrgId, accountMainType);
                }
            }
            log.info("\u586b\u5145\u540etxAccountTypeMap param:{}", (Object)txAccountTypeMap.size());
        }
        ArrayList<Long> orgIds = new ArrayList<Long>();
        for (Long orgId : txAccountTypeMap.keySet()) {
            Integer type = (Integer)txAccountTypeMap.get(orgId);
            if (type != accountType) continue;
            orgIds.add(orgId);
        }
        return orgIds;
    }
}

