/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.marketing.export.service.impl;

import com.baijia.tianxiao.biz.marketing.export.dto.CRMStatisticData;
import com.baijia.tianxiao.biz.marketing.export.service.CRMStatisticService;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudentLesson;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.solr.query.CrmStudentQuery;
import com.baijia.tianxiao.util.GenericsUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CRMStatisticServiceImpl
implements CRMStatisticService {
    private static final Logger log = LoggerFactory.getLogger(CRMStatisticServiceImpl.class);
    @Autowired
    private TxConsultUserDao txConsultUserDao;
    @Autowired
    private OrgStudentDao orgStudentDao;
    @Autowired
    private OrgStudentCourseDao orgStudentCourseDao;
    @Autowired
    private OrgClassLessonDao orgClassLessonDao;
    @Autowired
    private OrgStudentLessonDao orgStudentLessonDao;
    @Autowired
    private CrmStudentQuery crmStudentQuery;

    @Override
    public Map<Long, CRMStatisticData> getConsultUserSData(Date startDate, Date endDate, List<Long> TianxiaoOrgIds) {
        CRMStatisticData crmStatisticData;
        HashMap<Long, CRMStatisticData> crmStatisticDataMap = new HashMap<Long, CRMStatisticData>();
        Map consultUserCounts = this.txConsultUserDao.getConsultUserTotal(startDate, endDate, TianxiaoOrgIds);
        Map studentCounts = this.orgStudentDao.getStudentTotal(startDate, endDate, TianxiaoOrgIds);
        Map userIdsMap = this.orgStudentDao.getUserIdMapByOrgIds(TianxiaoOrgIds);
        Date nowDate = new Date();
        log.info("nowDate :" + nowDate);
        List arrangeOrgClassLessonList = this.orgClassLessonDao.getOrgClassLessonsByOrgIds(TianxiaoOrgIds, nowDate);
        HashMap<Object, HashSet<Long>> studyUserIdsMap = new HashMap<Object, HashSet<Long>>();
        log.info("arrangeOrgClassLessonList size param:{}", (Object)arrangeOrgClassLessonList.size());
        if (GenericsUtils.notNullAndEmpty((Object)arrangeOrgClassLessonList)) {
            ArrayList<Long> studyingLessonIds = new ArrayList<Long>();
            for (Object orgClassLesson : arrangeOrgClassLessonList) {
                Long lessonId = orgClassLesson.getId();
                log.info("lessonId param:{}", (Object)lessonId);
                studyingLessonIds.add(lessonId);
            }
            List orgStudentLessons = this.orgStudentLessonDao.getOrgStudentLessonsByLessonIds(studyingLessonIds);
            if (GenericsUtils.notNullAndEmpty((Object)orgStudentLessons)) {
                log.info("orgStudentLessons size param:{}", (Object)orgStudentLessons.size());
                for (OrgStudentLesson orgStudentLesson : orgStudentLessons) {
                    Long userId = orgStudentLesson.getUserId();
                    Object orgId = orgStudentLesson.getOrgId();
                    HashSet<Long> studyUserIds = (HashSet<Long>)studyUserIdsMap.get(orgId);
                    if (GenericsUtils.isNullOrEmpty((Object)studyUserIds)) {
                        studyUserIds = new HashSet<Long>();
                        studyUserIdsMap.put(orgId, studyUserIds);
                    }
                    studyUserIds.add(userId);
                }
            }
            log.info("\u6b63\u5728\u4e0a\u8bfe\u8bfe\u8282 arrangeLessonIds param:{}", studyingLessonIds);
            log.info("\u6b63\u5728\u4e0a\u8bfe\u5b66\u751f studyUserIds param:{}", studyUserIdsMap);
        }
        List orgClassLessonAllList = this.orgClassLessonDao.getOrgClassLessonsByOrgIds(TianxiaoOrgIds, null);
        HashMap<Long, HashSet<Long>> arrangeUserIdsMap = new HashMap<Long, HashSet<Long>>();
        HashMap<Long, Long> lessonIdAndCourseIdMap = new HashMap<Long, Long>();
        HashMap<Long, ArrayList<Long>> stulessonIdsMap = new HashMap<Long, ArrayList<Long>>();
        if (GenericsUtils.notNullAndEmpty((Object)orgClassLessonAllList)) {
            ArrayList<Long> lessonAllIds = new ArrayList<Long>();
            for (Object orgClassLesson : orgClassLessonAllList) {
                Long courseId = orgClassLesson.getCourseId();
                Long lessonId = orgClassLesson.getId();
                lessonIdAndCourseIdMap.put(lessonId, courseId);
                lessonAllIds.add(lessonId);
            }
            List orgStudentLessons = this.orgStudentLessonDao.getOrgStudentLessonsByLessonIds(lessonAllIds);
            if (GenericsUtils.notNullAndEmpty((Object)orgStudentLessons)) {
                log.info("orgClassLessonAllList size param:{}", (Object)orgClassLessonAllList.size());
                for (OrgStudentLesson orgStudentLesson : orgStudentLessons) {
                    Long userId = orgStudentLesson.getUserId();
                    Long orgId = orgStudentLesson.getOrgId();
                    Long lessonId = orgStudentLesson.getLessonId();
                    ArrayList<Long> lessonIds = (ArrayList<Long>)stulessonIdsMap.get(userId);
                    if (GenericsUtils.isNullOrEmpty((Object)lessonIds)) {
                        lessonIds = new ArrayList<Long>();
                        stulessonIdsMap.put(userId, lessonIds);
                    }
                    lessonIds.add(lessonId);
                    HashSet<Long> studyUserIds = (HashSet<Long>)arrangeUserIdsMap.get(orgId);
                    if (GenericsUtils.isNullOrEmpty((Object)studyUserIds)) {
                        studyUserIds = new HashSet<Long>();
                        arrangeUserIdsMap.put(orgId, studyUserIds);
                    }
                    studyUserIds.add(userId);
                }
            }
        }
        for (Object orgId : userIdsMap.keySet()) {
            List userIds = (List)userIdsMap.get(orgId);
            List orgStudentCourses = this.orgStudentCourseDao.getOrgStudentCourseByUserIds((Long)orgId, (Collection)userIds);
            HashSet<Long> pastUserIds = new HashSet<Long>();
            HashMap<Long, ArrayList<Long>> stuCourseIdsMap = new HashMap<Long, ArrayList<Long>>();
            if (GenericsUtils.notNullAndEmpty((Object)orgStudentCourses)) {
                for (OrgStudentCourse orgStudentCourse : orgStudentCourses) {
                    Long courseId = orgStudentCourse.getCourseId();
                    Long userId = orgStudentCourse.getUserId();
                    ArrayList<Long> stuCourseIds = (ArrayList<Long>)stuCourseIdsMap.get(userId);
                    if (GenericsUtils.isNullOrEmpty((Object)stuCourseIds)) {
                        stuCourseIds = new ArrayList<Long>();
                        stuCourseIdsMap.put(userId, stuCourseIds);
                    }
                    stuCourseIds.add(courseId);
                }
                Set studyUserIds = (Set)studyUserIdsMap.get(orgId);
                Set arrangeUserIds = (Set)arrangeUserIdsMap.get(orgId);
                if ((Long)orgId == 27703L) {
                    log.info("studyUserIds param:{}", (Object)studyUserIds);
                    log.info("arrangeUserIds param:{}", (Object)arrangeUserIds);
                }
                for (Long userId : stuCourseIdsMap.keySet()) {
                    boolean isPast = true;
                    if (GenericsUtils.notNullAndEmpty((Object)studyUserIds) && studyUserIds.contains(userId)) {
                        isPast = false;
                    }
                    if (!isPast || !GenericsUtils.notNullAndEmpty((Object)arrangeUserIds) || !arrangeUserIds.contains(userId)) continue;
                    List stuAllCourseIds = (List)stuCourseIdsMap.get(userId);
                    if ((Long)orgId == 27703L) {
                        log.info("stuCourseIds param:{}, userId param:{}", (Object)stuAllCourseIds, (Object)userId);
                    }
                    List stuLessonIds = (List)stulessonIdsMap.get(userId);
                    ArrayList<Long> stuArrangeCourseIds = new ArrayList<Long>();
                    if (GenericsUtils.notNullAndEmpty((Object)stuLessonIds)) {
                        for (Long lessonId : stuLessonIds) {
                            Long arrangeCourse = (Long)lessonIdAndCourseIdMap.get(lessonId);
                            stuArrangeCourseIds.add(arrangeCourse);
                        }
                        for (Long stuCourseId : stuAllCourseIds) {
                            if (!stuArrangeCourseIds.contains(stuCourseId)) continue;
                            isPast = false;
                            break;
                        }
                    }
                    if (!isPast) continue;
                    pastUserIds.add(userId);
                    if ((Long)orgId != 27703L) continue;
                    log.info("pastUserId param:{}", (Object)userId);
                }
            }
            if ((Long)orgId == 27703L) {
                log.info("pastUserIds param:{}", pastUserIds);
            }
            int allStudentTotal = userIds.size();
            int pastStudentTotal = 0;
            if (GenericsUtils.notNullAndEmpty(pastUserIds)) {
                pastStudentTotal = pastUserIds.size();
            }
            int studyingStudentTotal = allStudentTotal - pastStudentTotal;
            CRMStatisticData crmStatisticData2 = (CRMStatisticData)crmStatisticDataMap.get(orgId);
            if (crmStatisticData2 == null) {
                crmStatisticData2 = new CRMStatisticData();
                crmStatisticDataMap.put((Long)orgId, crmStatisticData2);
            }
            crmStatisticData2.setStudyStudentTotal(studyingStudentTotal);
            crmStatisticData2.setStudentTotal(allStudentTotal);
        }
        for (Object orgId : consultUserCounts.keySet()) {
            Integer consultUserTotal;
            crmStatisticData = (CRMStatisticData)crmStatisticDataMap.get(orgId);
            if (crmStatisticData == null) {
                crmStatisticData = new CRMStatisticData();
                crmStatisticDataMap.put((Long)orgId, crmStatisticData);
            }
            crmStatisticData.setConsultUserTotal((consultUserTotal = (Integer)consultUserCounts.get(orgId)) == null ? 0 : consultUserTotal);
        }
        for (Object orgId : studentCounts.keySet()) {
            Integer studentTotal;
            crmStatisticData = (CRMStatisticData)crmStatisticDataMap.get(orgId);
            if (crmStatisticData == null) {
                crmStatisticData = new CRMStatisticData();
                crmStatisticDataMap.put((Long)orgId, crmStatisticData);
            }
            crmStatisticData.setIncrementStudentTotal((studentTotal = (Integer)studentCounts.get(orgId)) == null ? 0 : studentTotal);
        }
        return crmStatisticDataMap;
    }
}

