/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.marketing.utils;

import com.baijia.commons.lang.utils.JacksonUtil;
import com.baijia.commons.lang.utils.http.HttpClientUtils;
import com.baijia.tianxiao.biz.marketing.export.dto.HagDownload;
import com.baijia.tianxiao.biz.marketing.export.dto.TianxiaoOrgNumber;
import com.baijia.tianxiao.sal.marketing.commons.constants.Config;
import com.baijia.tianxiao.util.GenericsUtils;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HagTianxiaoOrgNumber {
    private static final Logger log = LoggerFactory.getLogger(HagTianxiaoOrgNumber.class);

    public static List<Integer> getOrgNumbers() {
        ArrayList<Integer> orgNumbers = new ArrayList<Integer>();
        String numberStr = null;
        try {
            HashMap params = Maps.newHashMap();
            params.put("resource", "jigou_tianxiao_orgNumber");
            log.info("[hag_url]" + Config.HAG_URL);
            String url = Config.HAG_URL;
            String response = HttpClientUtils.doPost((String)url, (Map)params);
            HagDownload hagDto = (HagDownload)JacksonUtil.str2Obj((String)response, HagDownload.class);
            if (hagDto == null || GenericsUtils.isNullOrEmpty((Object)hagDto.getData())) {
                log.warn("[Hag] Org number is empty");
                return Collections.EMPTY_LIST;
            }
            log.info("hagDto.getData().size() =" + hagDto.getData().size());
            List<String> orgTestNumbers = HagTianxiaoOrgNumber.getOrgTestNumbers();
            log.info("testNumber size ===" + orgTestNumbers.size());
            for (int i = 0; i < hagDto.getData().size(); ++i) {
                numberStr = ((String)hagDto.getData().get(i)).split("#")[0];
                if (orgTestNumbers.contains(numberStr)) continue;
                orgNumbers.add(Integer.parseInt(numberStr));
            }
        }
        catch (Exception e) {
            log.error("[Hag] Get org number.", (Throwable)e);
        }
        return orgNumbers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getOrgTestNumbers() {
        String path = TianxiaoOrgNumber.class.getResource("/").getPath();
        ArrayList<String> orgTestNumbers = new ArrayList<String>();
        File file1 = new File(path + "template/orgNumberTest.txt");
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(file1));
            String numberStr = "";
            while ((numberStr = br.readLine()) != null) {
                orgTestNumbers.add(numberStr);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return orgTestNumbers;
    }

    public static void main(String[] args) {
        HagTianxiaoOrgNumber.getOrgNumbers();
    }
}

