/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.marketing.referral.service.impl;

import com.baijia.tianxiao.biz.marketing.referral.service.BizReferralService;
import com.baijia.tianxiao.biz.marketing.utils.PictureUtil;
import com.baijia.tianxiao.dal.activity.dao.referral.GiftInfoDao;
import com.baijia.tianxiao.dal.activity.dao.referral.ReferralInfoDao;
import com.baijia.tianxiao.dal.activity.po.referral.ReferralInfo;
import com.baijia.tianxiao.sal.marketing.activity.dto.ShareDto;
import com.baijia.tianxiao.sal.marketing.commons.constants.Config;
import com.baijia.tianxiao.sal.marketing.commons.enums.ConstantEnums;
import com.baijia.tianxiao.sal.marketing.commons.enums.EmailType;
import com.baijia.tianxiao.sal.marketing.commons.enums.TemplateTypeCategory;
import com.baijia.tianxiao.sal.marketing.commons.service.RedisService;
import com.baijia.tianxiao.sal.marketing.commons.utils.ActivityMailSender;
import com.baijia.tianxiao.sal.marketing.commons.utils.Mail;
import com.baijia.tianxiao.sal.marketing.commons.utils.TupleUtil;
import com.baijia.tianxiao.sal.marketing.commons.utils.TwoTuple;
import com.baijia.tianxiao.sal.marketing.referral.dto.BrokerDto;
import com.baijia.tianxiao.sal.marketing.referral.dto.CommissionDto;
import com.baijia.tianxiao.sal.marketing.referral.dto.CommissionListDto;
import com.baijia.tianxiao.sal.marketing.referral.dto.ReferralCustomer;
import com.baijia.tianxiao.sal.marketing.referral.dto.ReferralOrgInfo;
import com.baijia.tianxiao.sal.marketing.referral.dto.ReferralRequest;
import com.baijia.tianxiao.sal.marketing.referral.dto.ReferralResponse;
import com.baijia.tianxiao.sal.marketing.referral.service.ReferralRecordService;
import com.baijia.tianxiao.sal.marketing.referral.service.ReferralService;
import com.baijia.tianxiao.sal.organization.org.dto.OrgInfoSimpleDto;
import com.baijia.tianxiao.sal.organization.org.service.OrgInfoService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.GenericsUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BizReferralServiceImpl
implements BizReferralService {
    private static final Logger log = LoggerFactory.getLogger(BizReferralServiceImpl.class);
    @Autowired
    private ReferralService referralService;
    @Autowired
    private OrgInfoService orgInfoService;
    @Autowired
    private GiftInfoDao giftInfoDao;
    @Autowired
    private ReferralInfoDao referralInfoDao;
    @Autowired
    private ReferralRecordService referralRecordService;
    @Autowired
    private RedisService redisService;
    private static final String SUFFIX = "<br/><br/> \u6b64\u90ae\u4ef6\u7531\u7cfb\u7edf\u81ea\u52a8\u53d1\u9001\uff0c\u4e0d\u9700\u8981\u56de\u590d";

    @Override
    public ShareDto getShareInfo(Long activityId, Long orgId) {
        ShareDto dto = new ShareDto();
        ReferralInfo referralInfo = this.referralInfoDao.getReferralInfo(activityId, orgId);
        if (referralInfo == null) {
            return dto;
        }
        dto.setTitle(referralInfo.getTitle());
        try {
            String logo = this.orgInfoService.getOrgInfo(orgId).getLogo();
            dto.setImageUrl(PictureUtil.handlePictureSize(logo));
        }
        catch (Exception e) {
            log.error("[ActivityShareService ] ", (Throwable)e);
        }
        dto.setContent(ConstantEnums.REFERRAL_SLOGAN.value());
        dto.setShareUrl(this.getUrl(activityId));
        return dto;
    }

    private String getUrl(long activityId) {
        return Config.DOMAIN + "/referral.html?activityId=" + activityId;
    }

    @Override
    public ReferralResponse renderActivity(ReferralRequest request) {
        ReferralResponse rr = this.referralService.findDetail(request);
        if (rr == null) {
            return null;
        }
        try {
            OrgInfoSimpleDto orgInfo = this.orgInfoService.getOrgInfo(rr.getOrgId());
            String logo = orgInfo.getLogo();
            String shortName = orgInfo.getShortName();
            Long orgNum = orgInfo.getOrgNumber();
            String homePage = ConstantEnums.ORG_HOME_PAGE_URL.value().trim() + orgNum;
            rr.setOrgLogo(logo);
            rr.setOrgName(shortName);
            rr.setOrgQrCodeUrl(homePage);
            List giftInfos = this.giftInfoDao.selectGifts(request.getActivityId());
            rr.setGifts(giftInfos);
        }
        catch (Exception e) {
            log.error("[error while render ]", (Throwable)e);
        }
        return rr;
    }

    @Override
    public TwoTuple<Integer, String> exportToPayAmountList(ReferralRequest request) {
        Long activityId = request.getActivityId();
        String orgName = this.findOrg(request);
        Long orgId = request.getOrgId();
        if (GenericsUtils.isNullOrEmpty((Object)orgName)) {
            log.info("can not find an org with org_ID {}", (Object)request.getOrgId());
            return TupleUtil.tuple((Object)400, (Object)"\u673a\u6784\u4e0d\u5b58\u5728");
        }
        String email = request.getEmail();
        String settleMentedMonth = request.getSettleMentedMonth();
        String needSettleMentedMonth = request.getNeedSettleMentedMonth();
        return this.createToPayAmountListMail(orgId, activityId, settleMentedMonth, needSettleMentedMonth, orgName, email);
    }

    private TwoTuple<Integer, String> createToPayAmountListMail(Long orgId, Long activityId, String settleMentedMonth, String needSettleMentedMonth, String orgName, String email) {
        PageDto pageDto = new PageDto();
        pageDto.setPageNum(Integer.valueOf(1));
        List<CommissionDto> retListOver = this.getReferralRecord(activityId, settleMentedMonth, 1, pageDto);
        pageDto.setPageNum(Integer.valueOf(1));
        List<CommissionDto> retListNotOver = this.getReferralRecord(activityId, needSettleMentedMonth, 2, pageDto);
        log.info("retListOver is : {} ", retListOver);
        log.info("retListNotOver are :{} ", retListNotOver);
        if (GenericsUtils.isNullOrEmpty(retListOver) && GenericsUtils.isNullOrEmpty(retListNotOver)) {
            log.info("\u6ca1\u6709\u7ed3\u679c\u6570\u636e");
            return TupleUtil.tuple((Object)400, (Object)"\u6682\u65e0\u7ed3\u679c\u6570\u636e");
        }
        TwoTuple<Integer, String> checkLimit = this.checkLimit(orgId, activityId);
        if (checkLimit != null) {
            return checkLimit;
        }
        String subject = "\u8f6c\u4ecb\u7ecd\u4f63\u91d1\u7ed3\u7b97\u5217\u8868\u5bfc\u51fa";
        String content = "HI " + orgName + "<br/> \u9644\u4ef6\u91cc\u662f\u60a8\u7533\u8bf7\u5bfc\u51fa\u7684\u8f6c\u4ecb\u7ecd\u4f63\u91d1\u7ed3\u7b97\u5217\u8868\uff0c\u8bf7\u60a8\u67e5\u6536 " + SUFFIX;
        Mail mail = ActivityMailSender.createMail((String)email, null, (String)subject, (String)content);
        if (GenericsUtils.notNullAndEmpty(retListOver)) {
            List<Map<String, String>> rows = this.GetRows(retListOver);
            ActivityMailSender.addAttache((Mail)mail, rows, (String[])new String[]{settleMentedMonth + "_1_" + ".xls"});
        }
        if (GenericsUtils.notNullAndEmpty(retListNotOver)) {
            List<Map<String, String>> rows2 = this.GetRows(retListNotOver);
            ActivityMailSender.addAttache((Mail)mail, rows2, (String[])new String[]{needSettleMentedMonth + "_2_.xls"});
        }
        ActivityMailSender.sendMail((String)email, (Mail)mail, (Boolean[])new Boolean[]{true});
        return TupleUtil.tuple((Object)TupleUtil.OK, (Object)"\u90ae\u4ef6\u53d1\u9001\u6210\u529f");
    }

    private List<Map<String, String>> GetRows(List<CommissionDto> retList) {
        ArrayList<Map<String, String>> rows = new ArrayList<Map<String, String>>();
        for (CommissionDto record : retList) {
            LinkedHashMap<String, String> rowMap = new LinkedHashMap<String, String>();
            String brokerName = record.getBrokerName();
            String phone = record.getBrokerPhone();
            String amountNum = record.getAccountNum();
            String amount = record.getAmount();
            String settleStatus = record.getSettleTime() == null ? "\u5f85\u7ed3\u7b97" : "\u5df2\u7ed3\u7b97";
            rowMap.put("\u7ecf\u7eaa\u4eba", brokerName);
            rowMap.put("\u7535\u8bdd", phone);
            rowMap.put("\u652f\u4ed8\u5b9d\u8d26\u6237", amountNum);
            rowMap.put("\u5f85\u4ed8\u91d1\u989d", amount);
            rowMap.put("\u652f\u4ed8\u72b6\u6001", settleStatus);
            rows.add(rowMap);
        }
        return rows;
    }

    private List<CommissionDto> getReferralRecord(Long activityId, String month, Integer status, PageDto pageDto) {
        ArrayList<CommissionDto> retList = new ArrayList<CommissionDto>();
        CommissionListDto commissionListByMonth = this.referralRecordService.getCommissionListByMonth(activityId.longValue(), month, status.intValue(), pageDto);
        retList.addAll(commissionListByMonth.getList());
        while (commissionListByMonth.getHasMore() > 0) {
            pageDto.setPageNum(Integer.valueOf(pageDto.getPageNum() + 1));
            commissionListByMonth = this.referralRecordService.getCommissionListByMonth(activityId.longValue(), month, status.intValue(), pageDto);
            retList.addAll(commissionListByMonth.getList());
        }
        return retList;
    }

    @Override
    public TwoTuple<Integer, String> exportCustomerList(ReferralRequest request) {
        Long activityId = request.getActivityId();
        String orgName = this.findOrg(request);
        Long orgId = request.getOrgId();
        if (GenericsUtils.isNullOrEmpty((Object)orgName)) {
            log.info("can not find an org with org_ID {}", (Object)request.getOrgId());
            return TupleUtil.tuple((Object)400, (Object)"\u673a\u6784\u4e0d\u5b58\u5728");
        }
        String email = request.getEmail();
        return this.createCustomerListMail(orgId, activityId, orgName, email);
    }

    private TwoTuple<Integer, String> createCustomerListMail(Long orgId, Long activityId, String orgName, String email) {
        ReferralInfo referralInfo = this.referralInfoDao.getReferralInfo(activityId, orgId);
        if (referralInfo == null) {
            return TupleUtil.tuple((Object)TupleUtil.NO_OK, (Object)"\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        List customerList = this.referralRecordService.getCustomerListByActivityId(activityId.longValue(), null);
        if (GenericsUtils.isNullOrEmpty((Object)customerList)) {
            return TupleUtil.tuple((Object)TupleUtil.NO_OK, (Object)"\u6682\u65e0\u5ba2\u6237\u6570\u636e");
        }
        TwoTuple<Integer, String> checkLimit = this.checkLimit(orgId, activityId);
        if (checkLimit != null) {
            return checkLimit;
        }
        ArrayList rows = new ArrayList();
        for (ReferralCustomer customer : customerList) {
            LinkedHashMap<String, String> rowMap = new LinkedHashMap<String, String>();
            String name = customer.getReferralName();
            String phone = customer.getReferralPhone();
            String brokerName = customer.getBrokerName();
            String brokerPhone = customer.getBrokerPhone();
            String desc = customer.getReferralDesc();
            rowMap.put("\u5ba2\u6237\u59d3\u540d", name);
            rowMap.put("\u5ba2\u6237\u7535\u8bdd", phone);
            rowMap.put("\u7ecf\u7eaa\u4eba\u59d3\u540d", brokerName);
            rowMap.put("\u7ecf\u7eaa\u4eba\u624b\u673a\u53f7", brokerPhone);
            rowMap.put("\u63a8\u8350\u65f6\u95f4", DateFormatUtils.format((Date)new Date(customer.getCreateTime()), (String)"yyyy-MM-dd HH:mm:ss"));
            rowMap.put("\u63a8\u8350\u7406\u7531", desc);
            rows.add(rowMap);
        }
        String subject = "\u8f6c\u4ecb\u7ecd\u5ba2\u6237\u5217\u8868\u5bfc\u51fa";
        String content = "HI " + orgName + "<br/> \u9644\u4ef6\u91cc\u662f\u60a8\u7533\u8bf7\u5bfc\u51fa\u7684\u8f6c\u4ecb\u7ecd\u5ba2\u6237\u5217\u8868\uff0c\u8bf7\u60a8\u67e5\u6536 " + SUFFIX;
        ActivityMailSender.sendMail((String)email, (String)subject, (String)content, (Long)activityId, rows);
        return TupleUtil.tuple((Object)TupleUtil.OK, (Object)"\u90ae\u4ef6\u53d1\u9001\u6210\u529f");
    }

    private TwoTuple<Integer, String> checkLimit(Long orgId, Long activityId) {
        boolean isNotLimited = this.redisService.addOrgEmailCount(orgId.longValue(), activityId.longValue(), TemplateTypeCategory.REFERRAL_TYPE.getType(), EmailType.BROKERS);
        if (!isNotLimited) {
            log.info("\u6b21\u6570\u5df2\u8fbe\u4e0a\u9650\uff0c\u8bf7\u660e\u5929\u518d\u53d1");
            return TupleUtil.tuple((Object)TupleUtil.NO_OK, (Object)("\u4eca\u65e5\u5df2\u53d1\u9001" + ConstantEnums.EMAIL_COUNT_LIMIT.value() + "\u6b21\uff0c\u8bf7\u660e\u65e5\u518d\u8bd5"));
        }
        return null;
    }

    @Override
    public TwoTuple<Integer, String> exportBrokerList(ReferralRequest request) {
        Long activityId = request.getActivityId();
        String orgName = this.findOrg(request);
        if (GenericsUtils.isNullOrEmpty((Object)orgName)) {
            log.info("can not find an org with org_ID {}", (Object)request.getOrgId());
            return TupleUtil.tuple((Object)400, (Object)"\u673a\u6784\u4e0d\u5b58\u5728");
        }
        String email = request.getEmail();
        return this.createBrokerListMail(request.getOrgId(), activityId, orgName, email);
    }

    public String findOrg(ReferralRequest request) {
        Long orgId = request.getOrgId();
        OrgInfoSimpleDto simple = null;
        try {
            simple = this.orgInfoService.getOrgInfo(orgId);
        }
        catch (Exception e) {
            return null;
        }
        String orgName = simple.getShortName();
        return orgName;
    }

    private TwoTuple<Integer, String> createBrokerListMail(Long orgId, Long activityId, String orgName, String email) {
        ReferralInfo referralInfo = this.referralInfoDao.getReferralInfo(activityId, orgId);
        if (referralInfo == null) {
            return TupleUtil.tuple((Object)TupleUtil.NO_OK, (Object)"\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        List result = this.referralRecordService.getBrokerList(activityId.longValue(), null);
        if (GenericsUtils.isNullOrEmpty((Object)result)) {
            return TupleUtil.tuple((Object)TupleUtil.NO_OK, (Object)"\u6682\u65e0\u7ecf\u7eaa\u4eba\u6570\u636e");
        }
        this.checkLimit(orgId, activityId);
        ArrayList rows = new ArrayList();
        for (BrokerDto broker : result) {
            LinkedHashMap<String, String> rowMap = new LinkedHashMap<String, String>();
            String name = broker.getBrokerName();
            String phone = broker.getBrokerPhone();
            String accountNum = broker.getAccountNum();
            rowMap.put("\u7ecf\u7eaa\u4eba\u59d3\u540d", name);
            rowMap.put("\u7ecf\u7eaa\u4eba\u624b\u673a\u53f7", phone);
            rowMap.put("\u7ecf\u7eaa\u4eba\u652f\u4ed8\u5b9d\u8d26\u53f7", accountNum);
            rows.add(rowMap);
        }
        String subject = "\u8f6c\u4ecb\u7ecd\u7ecf\u7eaa\u4eba\u5217\u8868\u5bfc\u51fa";
        String content = "HI " + orgName + "<br/> \u9644\u4ef6\u91cc\u662f\u60a8\u7533\u8bf7\u5bfc\u51fa\u7684\u8f6c\u4ecb\u7ecd\u7ecf\u7eaa\u4eba\u5217\u8868\uff0c\u8bf7\u60a8\u67e5\u6536 " + SUFFIX;
        ActivityMailSender.sendMail((String)email, (String)subject, (String)content, (Long)activityId, rows);
        return TupleUtil.tuple((Object)TupleUtil.OK, (Object)"\u90ae\u4ef6\u53d1\u9001\u6210\u529f");
    }

    @Override
    public ReferralOrgInfo findReferralOrgInfo(Long activityId) {
        ReferralOrgInfo dto = null;
        ReferralInfo referralInfo = this.referralInfoDao.getReferralInfo(activityId, null);
        if (referralInfo == null) {
            return dto;
        }
        try {
            OrgInfoSimpleDto orgInfo = this.orgInfoService.getOrgInfo(referralInfo.getOrgId());
            if (orgInfo == null) {
                return null;
            }
            dto = new ReferralOrgInfo();
            String logo = orgInfo.getLogo();
            String name = orgInfo.getShortName();
            String qrCode = ConstantEnums.ORG_HOME_PAGE_URL.value().trim() + orgInfo.getOrgNumber();
            dto.setOrgLogo(logo);
            dto.setOrgName(name);
            dto.setOrgQrCode(qrCode);
        }
        catch (Exception e) {
            log.error("[BizReferralService ] ", (Throwable)e);
        }
        return dto;
    }
}

