/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.marketing.export.service.impl;

import com.baijia.tianxiao.biz.marketing.export.dto.WechatStatisticData;
import com.baijia.tianxiao.biz.marketing.export.service.WechatStatisticService;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizerInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.FansDao;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatCustomMenuDao;
import com.baijia.tianxiao.util.GenericsUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WechatStatisticServiceImpl
implements WechatStatisticService {
    private static final Logger log = LoggerFactory.getLogger(WechatStatisticServiceImpl.class);
    @Autowired
    private AuthorizerInfoDao authorizerInfoDao;
    @Autowired
    private OrgWechatCustomMenuDao orgWechatCustomMenuDao;
    @Autowired
    private FansDao fansDao;
    @Autowired
    private OrgStudentDao OrgStudentDao;

    @Override
    public Map<Long, WechatStatisticData> getWechatStatisticData(Date startDate, Date endDate, List<Long> TianxiaoOrgIds, int way) {
        WechatStatisticData wechatData;
        HashMap<Long, WechatStatisticData> wechatDatas = new HashMap<Long, WechatStatisticData>();
        Map orgIdsAndAppIdMap = this.authorizerInfoDao.getExistOrgIds(TianxiaoOrgIds);
        if (GenericsUtils.isNullOrEmpty((Object)orgIdsAndAppIdMap)) {
            return wechatDatas;
        }
        ArrayList<String> appIds = new ArrayList<String>();
        for (Long orgId : orgIdsAndAppIdMap.keySet()) {
            String appId = (String)orgIdsAndAppIdMap.get(orgId);
            appIds.add(appId);
        }
        List hasOrgWechatCustomMenuOfAppIds = this.orgWechatCustomMenuDao.OrgIdsHasWechatMenu();
        Map fansTotals = this.fansDao.fansTotaByAppIds(appIds, startDate, endDate);
        Map studentsHasOrgWechat = new HashMap();
        if (way != 0) {
            studentsHasOrgWechat = this.OrgStudentDao.getOrgWechatAuthorizerOfStudentTotal(TianxiaoOrgIds);
        }
        for (Long orgId : orgIdsAndAppIdMap.keySet()) {
            Integer wechatFansTotal;
            wechatData = new WechatStatisticData();
            String appId = (String)orgIdsAndAppIdMap.get(orgId);
            Boolean isWechatAuthorizer = true;
            Boolean isWechatMenu = false;
            if (hasOrgWechatCustomMenuOfAppIds.contains(appId)) {
                isWechatMenu = true;
            }
            wechatData.setWechatFansTotal((wechatFansTotal = (Integer)fansTotals.get(appId)) == null ? 0 : wechatFansTotal);
            wechatData.setIsWechatMenu(isWechatMenu);
            wechatData.setIsWechatAuthorizer(isWechatAuthorizer);
            wechatDatas.put(orgId, wechatData);
        }
        for (Long orgId : studentsHasOrgWechat.keySet()) {
            wechatData = (WechatStatisticData)wechatDatas.get(orgId);
            if (wechatData == null) {
                wechatData = new WechatStatisticData();
                wechatDatas.put(orgId, wechatData);
            }
            Integer wechatAuthorizerOfStudentTotal = (Integer)studentsHasOrgWechat.get(orgId);
            log.info("\u673a\u6784=====" + orgId + "======\u7ed1\u5b9a\u5fae\u4fe1\u516c\u4f17\u53f7\u7684\u5b66\u751f============" + wechatAuthorizerOfStudentTotal);
            wechatData.setWechatAuthorizerOfStudentTotal(wechatAuthorizerOfStudentTotal);
        }
        return wechatDatas;
    }
}

