/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.marketing.export.service.impl;

import com.baijia.commons.lang.utils.PropertiesReader;
import com.baijia.commons.lang.utils.collection.CollectionUtils;
import com.baijia.tianxiao.biz.marketing.export.dto.CRMStatisticData;
import com.baijia.tianxiao.biz.marketing.export.dto.ConsultMessageStatisticData;
import com.baijia.tianxiao.biz.marketing.export.dto.ERPStatisticData;
import com.baijia.tianxiao.biz.marketing.export.dto.ExportClientDemandDto;
import com.baijia.tianxiao.biz.marketing.export.dto.OrgSignDto;
import com.baijia.tianxiao.biz.marketing.export.dto.StatisticByWeekOrMonthDto;
import com.baijia.tianxiao.biz.marketing.export.dto.TxBacklogStatisticData;
import com.baijia.tianxiao.biz.marketing.export.dto.WechatStatisticData;
import com.baijia.tianxiao.biz.marketing.export.service.CRMStatisticService;
import com.baijia.tianxiao.biz.marketing.export.service.ConsultMessageStatisticService;
import com.baijia.tianxiao.biz.marketing.export.service.ERPStatisticService;
import com.baijia.tianxiao.biz.marketing.export.service.ExportOrgInfoService;
import com.baijia.tianxiao.biz.marketing.export.service.TxBacklogStatisticService;
import com.baijia.tianxiao.biz.marketing.export.service.WechatStatisticService;
import com.baijia.tianxiao.biz.marketing.utils.BIzConf;
import com.baijia.tianxiao.biz.marketing.utils.HagTianxiaoOrgNumber;
import com.baijia.tianxiao.constant.SignStatus;
import com.baijia.tianxiao.dal.activity.dao.ActivityAccessLogDao;
import com.baijia.tianxiao.dal.activity.dao.ActivityDao;
import com.baijia.tianxiao.dal.activity.dao.UploadRecordDao;
import com.baijia.tianxiao.dal.activity.dao.draw.ActivityUserDao;
import com.baijia.tianxiao.dal.activity.dao.draw.DrawActivityDao;
import com.baijia.tianxiao.dal.activity.dao.referral.ReferralInfoDao;
import com.baijia.tianxiao.dal.activity.dao.vote.VoteInfoDao;
import com.baijia.tianxiao.dal.activity.po.UploadRecord;
import com.baijia.tianxiao.dal.advisory.dao.OrgCallRecorderDao;
import com.baijia.tianxiao.dal.export.dao.TXStatisticDataDao;
import com.baijia.tianxiao.dal.export.po.TXStatisticData;
import com.baijia.tianxiao.dal.msg.dao.TxSmsDao;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgAppLoginLogDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseRoomDao;
import com.baijia.tianxiao.dal.org.dao.OrgGroupMsgDao;
import com.baijia.tianxiao.dal.org.dao.OrgGroupMsgReceiverDao;
import com.baijia.tianxiao.dal.org.dao.OrgHomepageConfigDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonSignDao;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherLessonDao;
import com.baijia.tianxiao.dal.org.dao.TtsSmsDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgGroupMsg;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgLessonSign;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgTeacherLesson;
import com.baijia.tianxiao.dal.push.dao.MessageDao;
import com.baijia.tianxiao.dal.sync.dao.TxMonitorTypeDayDao;
import com.baijia.tianxiao.dal.sync.po.TxMonitorTypeDay;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dto.upload.UploadResult;
import com.baijia.tianxiao.sal.marketing.activity.dto.ActivityStatisticsData;
import com.baijia.tianxiao.sal.marketing.activity.service.ActivityDataExportService;
import com.baijia.tianxiao.sal.marketing.commons.constants.Config;
import com.baijia.tianxiao.sal.marketing.commons.enums.TemplateTypeCategory;
import com.baijia.tianxiao.sal.marketing.commons.utils.ExcelMailSender;
import com.baijia.tianxiao.sal.marketing.commons.utils.ExcelUtil;
import com.baijia.tianxiao.sal.marketing.draw.dto.DrawStatisticData;
import com.baijia.tianxiao.sal.marketing.draw.service.DrawDataExportService;
import com.baijia.tianxiao.sal.marketing.export.dto.ExportDto;
import com.baijia.tianxiao.sal.marketing.export.dto.ExportKeyData;
import com.baijia.tianxiao.sal.marketing.referral.dto.ReferralStatisticData;
import com.baijia.tianxiao.sal.marketing.referral.service.ReferralStatisticsService;
import com.baijia.tianxiao.sal.marketing.vote.dto.VoteStatistics;
import com.baijia.tianxiao.sal.marketing.vote.service.VoteDataStatisticService;
import com.baijia.tianxiao.upload.AliyunUploadUtil;
import com.baijia.tianxiao.util.GenericsUtils;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;

@Service
public class ExportOrgInfoServiceImpl
implements ExportOrgInfoService {
    private static final Logger log = LoggerFactory.getLogger(ExportOrgInfoServiceImpl.class);
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private ActivityDataExportService activityDataExportService;
    @Autowired
    private DrawDataExportService drawDataExportService;
    @Autowired
    private VoteDataStatisticService voteDataStatisticService;
    @Autowired
    private ReferralStatisticsService referralStatisticsService;
    @Autowired
    private TxBacklogStatisticService txBacklogStatisticService;
    @Autowired
    private ConsultMessageStatisticService consultMessageStatisticService;
    @Autowired
    private CRMStatisticService crmStatisticService;
    @Autowired
    private WechatStatisticService wechatStatisticService;
    @Autowired
    private ERPStatisticService erpStatisticService;
    @Autowired
    private TeacherDao teacherDao;
    @Autowired
    private OrgCourseRoomDao courseRoomDao;
    @Autowired
    private OrgGroupMsgDao groupMsgDao;
    @Autowired
    private OrgGroupMsgReceiverDao groupMsgReceiverDao;
    @Autowired
    private OrgHomepageConfigDao orgHomepageConfigDao;
    @Autowired
    private TxMonitorTypeDayDao txMonitorTypeDayDao;
    @Autowired
    private OrgAppLoginLogDao orgAppLoginLogDao;
    @Autowired
    private TtsSmsDao ttsSmSDao;
    @Autowired
    private TxSmsDao txSmsDao;
    @Autowired
    private UploadRecordDao uploadRecordDao;
    @Autowired
    private OrgStorageDao orgStorageDao;
    @Autowired
    private OrgCallRecorderDao OrgCallRecorderDao;
    @Autowired
    private FreeMarkerConfigurer freeMarkerConfigurer;
    @Autowired
    private OrgLessonSignDao orgLessonSignDao;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private OrgStudentDao orgStudentDao;
    @Autowired
    private OrgTeacherLessonDao orgTeacherLessonDao;
    @Autowired
    private TXStatisticDataDao txStatisticDataDao;
    @Autowired
    private MessageDao messageDao;
    @Autowired
    private ActivityDao activityDao;
    @Autowired
    private DrawActivityDao drawActivityDao;
    @Autowired
    private VoteInfoDao voteInfoDao;
    @Autowired
    private ReferralInfoDao referralInfoDao;
    @Autowired
    private ActivityAccessLogDao activityAccessLogDao;
    @Autowired
    private ActivityUserDao activityUserDao;
    @Autowired
    private OrgGroupMsgDao orgGroupMsgDao;
    @Autowired
    private OrgGroupMsgReceiverDao orgGroupMsgReceiverDao;

    @Override
    public void createExcelOrgSignInfo() {
        List<Integer> TianxiaoOrgNumbers = HagTianxiaoOrgNumber.getOrgNumbers();
        log.info("taixiao\u673a\u6784\u8d26\u53f7\u5217\u8868\u957f\u5ea6==================" + TianxiaoOrgNumbers.size());
        List<Long> TianxiaoOrgIds = this.getTianxiaoOrgIds(TianxiaoOrgNumbers);
        List signs = this.orgLessonSignDao.getOrgClassLesson(TianxiaoOrgIds);
        HashSet<Long> userIds = new HashSet<Long>();
        HashSet<Long> orgIds = new HashSet<Long>();
        HashSet<Long> courseIds = new HashSet<Long>();
        HashSet<Long> lessonIds = new HashSet<Long>();
        for (OrgLessonSign sign : signs) {
            Long userId = sign.getUserId();
            userIds.add(userId);
            Long orgId = sign.getOrgId();
            orgIds.add(orgId);
            Long courseId = sign.getCourseId();
            courseIds.add(courseId);
            Long lessonId = sign.getLessonId();
            lessonIds.add(lessonId);
        }
        Map orgNumberMap = this.orgAccountDao.getorgNumbersByOrgIds(orgIds);
        Map orgCourseMap = this.orgCourseDao.getOrgCourseMap(courseIds);
        Map orgStudentMap = this.orgStudentDao.getOrgStudentMapByUserIds(userIds);
        Map orgTeacherLessonMap = this.orgTeacherLessonDao.getOrgTeacherLessonMapByLessonIds(lessonIds);
        HashSet<Long> userIdsofTeacher = new HashSet<Long>();
        for (Long lessonId : orgTeacherLessonMap.keySet()) {
            OrgTeacherLesson orgTeacherLesson = (OrgTeacherLesson)orgTeacherLessonMap.get(lessonId);
            Long userId = orgTeacherLesson.getTeacherId();
            userIdsofTeacher.add(userId);
        }
        Map teacherNameMap = this.teacherDao.getTeacherRealNameMap(userIdsofTeacher);
        log.info("\u5f97\u5230signs\u7684\u957f\u5ea6\u4e3a==========" + signs.size());
        if (GenericsUtils.notNullAndEmpty((Object)signs)) {
            ArrayList rows = new ArrayList();
            for (OrgLessonSign sign : signs) {
                OrgStudent orgStudent = (OrgStudent)orgStudentMap.get(sign.getUserId());
                if (!GenericsUtils.notNullAndEmpty((Object)orgStudent)) continue;
                OrgSignDto orgSignDto = new OrgSignDto();
                String studentName = orgStudent.getName();
                orgSignDto.setStudentId(orgStudent.getId());
                orgSignDto.setStudentName(studentName == null ? "" : studentName);
                Integer orgNumber = (Integer)orgNumberMap.get(sign.getOrgId());
                orgSignDto.setOrgNumber(orgNumber);
                orgSignDto.setLessonId(sign.getLessonId());
                Date date = sign.getCreateTime();
                SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd");
                String signDate = sdf1.format(date);
                SimpleDateFormat sdf2 = new SimpleDateFormat("HH:mm:ss");
                String signTime = sdf2.format(date);
                orgSignDto.setSignDate(signDate);
                orgSignDto.setSignTime(signTime);
                int status = sign.getStatus();
                orgSignDto.setStatusDesc(SignStatus.getSignStatusByCode((Integer)status).getMessage());
                OrgCourse orgCourse = (OrgCourse)orgCourseMap.get(sign.getCourseId());
                if (GenericsUtils.notNullAndEmpty((Object)orgCourse)) {
                    String courseName = orgCourse.getName();
                    orgSignDto.setCourseName(courseName == null ? "" : courseName);
                } else {
                    orgSignDto.setCourseName("");
                }
                OrgTeacherLesson orgTeacherLesson = (OrgTeacherLesson)orgTeacherLessonMap.get(sign.getLessonId());
                if (GenericsUtils.notNullAndEmpty((Object)orgTeacherLesson)) {
                    Long userId = orgTeacherLesson.getTeacherId();
                    String teacherName = (String)teacherNameMap.get(userId);
                    if (teacherName == null || teacherName == "") {
                        // empty if block
                    }
                    orgSignDto.setTeacherName(teacherName == null ? "" : teacherName);
                } else {
                    orgSignDto.setTeacherName("");
                }
                LinkedHashMap<String, String> rowMap = new LinkedHashMap<String, String>();
                rowMap.put("\u673a\u6784number", orgSignDto.getOrgNumber() + "");
                rowMap.put("\u5fae\u5ba2\u540d\u79f0", orgSignDto.getCourseName());
                rowMap.put("\u8bfe\u8282id", orgSignDto.getLessonId() + "");
                rowMap.put("\u7b7e\u5230\u65e5\u671f", orgSignDto.getSignDate());
                rowMap.put("\u7b7e\u5230\u65f6\u95f4", orgSignDto.getSignTime());
                rowMap.put("\u8bfe\u8282\u8001\u5e08", orgSignDto.getTeacherName());
                rowMap.put("\u5b66\u5458\u59d3\u540d", orgSignDto.getStudentName());
                rowMap.put("\u5b66\u5458id", orgSignDto.getStudentId() + "");
                rowMap.put("\u7b7e\u5230\u72b6\u6001", orgSignDto.getStatusDesc());
                rows.add(rowMap);
            }
            String subject = "\u8bfe\u7a0b\u7b7e\u5230\u4fe1\u606f";
            String content = "";
            String mail = "gaodan@baijiahulian.com";
            String fileName = "signInfo";
            ExcelMailSender.sendMail((String)mail, (String)subject, (String)content, (String)fileName, rows);
        }
    }

    @Override
    public void createExcelOrgGroupMsgInfo() {
        List<Integer> TianxiaoOrgNumbers = HagTianxiaoOrgNumber.getOrgNumbers();
        log.info("taixiao\u673a\u6784\u8d26\u53f7\u5217\u8868\u957f\u5ea6==================" + TianxiaoOrgNumbers.size());
        List<Long> TianxiaoOrgIds = this.getTianxiaoOrgIds(TianxiaoOrgNumbers);
        Map orgNumberMap = this.orgAccountDao.getorgNumbersByOrgIds(TianxiaoOrgIds);
        ArrayList rows = new ArrayList();
        Map orgGroupMsgMap = this.orgGroupMsgDao.getOrgGroupMsgMap(null, null, TianxiaoOrgIds);
        for (Long orgId : orgGroupMsgMap.keySet()) {
            List orgGroupMsgs = (List)orgGroupMsgMap.get(orgId);
            HashMap<Long, OrgGroupMsg> orgGroupMsgMapByMsgId = new HashMap<Long, OrgGroupMsg>();
            ArrayList<Long> ids = new ArrayList<Long>();
            if (!GenericsUtils.notNullAndEmpty((Object)orgGroupMsgs)) continue;
            for (OrgGroupMsg orgGroupMsg : orgGroupMsgs) {
                Long id = orgGroupMsg.getId();
                orgGroupMsgMapByMsgId.put(id, orgGroupMsg);
                ids.add(id);
            }
            Map msgReceiverTotalMap = this.orgGroupMsgReceiverDao.getMsgReceiverTotalByMsgId(null, ids);
            Map msgReceiverViewTotalMap = this.orgGroupMsgReceiverDao.getMsgReceiverTotalByMsgId(Boolean.valueOf(true), ids);
            for (Long msgId : ids) {
                LinkedHashMap<String, String> rowMap = new LinkedHashMap<String, String>();
                Integer msgReceiverTotal = (Integer)msgReceiverTotalMap.get(msgId);
                log.info("\u63a5\u6536\u4eba\u6570===========" + msgReceiverTotal);
                Integer msgReceiverViewTotal = (Integer)msgReceiverViewTotalMap.get(msgId);
                log.info("\u67e5\u770b\u5450\u4eba\u6570===========" + msgReceiverViewTotal);
                Integer orgNumber = (Integer)orgNumberMap.get(orgId);
                rowMap.put("\u673a\u6784number", orgNumber + "");
                rowMap.put("\u7fa4\u53d1\u6d88\u606fid", msgId + "");
                String subject = ((OrgGroupMsg)orgGroupMsgMapByMsgId.get(msgId)).getSubject();
                rowMap.put("\u7fa4\u53d1\u6d88\u606f\u540d\u79f0", subject == null ? "" : subject);
                Date time = ((OrgGroupMsg)orgGroupMsgMapByMsgId.get(msgId)).getCreateTime();
                rowMap.put("\u53d1\u9001\u65f6\u95f4", time + "");
                int total1 = msgReceiverTotal == null ? 0 : msgReceiverTotal;
                int total2 = msgReceiverViewTotal == null ? 0 : msgReceiverViewTotal;
                rowMap.put("\u63a5\u6536\u4eba\u6570", total1 + "");
                rowMap.put("\u67e5\u770b\u4eba\u6570", total2 + "");
                rows.add(rowMap);
            }
        }
        String subject = "\u7fa4\u53d1\u6d88\u606f\u4fe1\u606f\u7edf\u8ba1";
        String content = "";
        String mail = "gaodan@baijiahulian.com";
        String fileName = "signInfo";
        ExcelMailSender.sendMail((String)mail, (String)subject, (String)content, (String)fileName, rows);
    }

    private List<Long> getTianxiaoOrgIds(List<Integer> TianxiaoOrgNumbers) {
        List TianxiaoOrgAccounts = this.orgAccountDao.getAccountByNumbers(TianxiaoOrgNumbers, new String[]{"id", "number"});
        List TianxiaoOrgIds = CollectionUtils.extractList((Collection)TianxiaoOrgAccounts, (CollectionUtils.Extracter)new CollectionUtils.Extracter<Long, OrgAccount>(){

            public Long extract(OrgAccount arg0) {
                return arg0.getId().longValue();
            }
        });
        return TianxiaoOrgIds;
    }

    @Override
    public void createExcel(Date startTime, Date endTime) {
        Properties prop = PropertiesReader.fillProperties((String)"upload.properties");
        String url = prop.getProperty("upload.server");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String uid = "tx_statistics_day_" + sdf.format(startTime);
        File file = new File("test.txt");
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        UploadResult result = AliyunUploadUtil.uploadToRemote((String)url, (String)uid, (File)file, (boolean)false);
        if (result.getFiles() != null && result.getFiles().size() > 0) {
            OrgStorage storage = new OrgStorage();
            storage.setFid(((UploadResult.UploadFile)result.getFiles().get(0)).getFid());
            storage.setCreateTime(new Date());
            storage.setUpdateTime(new Date());
            storage.setSize(Integer.valueOf(((UploadResult.UploadFile)result.getFiles().get(0)).getSize()));
            storage.setSn(((UploadResult.UploadFile)result.getFiles().get(0)).getSn());
            storage.setMimeType(Integer.valueOf(0));
            this.orgStorageDao.save(storage);
            UploadRecord record = new UploadRecord();
            record.setCreateTime(new Date());
            record.setFileType(1);
            record.setStorageId(Long.valueOf(storage.getId().longValue()));
            record.setUid(uid);
            this.uploadRecordDao.insertUploadRecord(record);
        }
    }

    @Override
    public List<ExportDto> getExportDtoByDay(Date startTime, Date endTime, int way) {
        Map extensionMap;
        ExportDto exportDto;
        ExportDto exportDto2;
        List txMonitorTypes;
        ExportDto exportDto3;
        Map groupMsgCountMap;
        ExportDto exportDto4;
        ExportDto exportDto5;
        HashMap<Long, ExportDto> exportDtoMap = new HashMap<Long, ExportDto>();
        ArrayList<ExportDto> dataList = new ArrayList<ExportDto>();
        String curDate = null;
        String startDate = null;
        if (GenericsUtils.notNullAndEmpty((Object)startTime)) {
            startDate = this.getDate(startTime);
        }
        if (GenericsUtils.notNullAndEmpty((Object)endTime)) {
            curDate = this.getDate(endTime);
        }
        List<Integer> TianxiaoOrgNumbers = HagTianxiaoOrgNumber.getOrgNumbers();
        log.info("taixiao\u673a\u6784\u8d26\u53f7\u5217\u8868\u957f\u5ea6==================" + TianxiaoOrgNumbers.size());
        List<Long> TianxiaoOrgIds = this.getTianxiaoOrgIds(TianxiaoOrgNumbers);
        long start = System.currentTimeMillis();
        Map activityDatas = this.activityDataExportService.getActivityData(startTime, endTime, startDate, curDate, TianxiaoOrgIds, way);
        if (GenericsUtils.notNullAndEmpty((Object)activityDatas)) {
            for (Long orgId : activityDatas.keySet()) {
                ExportDto exportDto6 = (ExportDto)exportDtoMap.get(orgId);
                ActivityStatisticsData activityStaticData = (ActivityStatisticsData)activityDatas.get(orgId);
                if (exportDto6 == null) {
                    exportDto6 = new ExportDto();
                    this.buidExportDtoByOrgId(exportDto6, orgId, startDate, curDate);
                    exportDtoMap.put(orgId, exportDto6);
                }
                ActivityStatisticsData.setExportDto((ActivityStatisticsData)activityStaticData, (ExportDto)exportDto6);
            }
        }
        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());
        Map drawDatas = this.drawDataExportService.getDrawData(startTime, endTime, TianxiaoOrgIds);
        if (GenericsUtils.notNullAndEmpty((Object)drawDatas)) {
            for (Long orgId : drawDatas.keySet()) {
                ExportDto exportDto7 = (ExportDto)exportDtoMap.get(orgId);
                DrawStatisticData drawData = (DrawStatisticData)drawDatas.get(orgId);
                if (exportDto7 == null) {
                    exportDto7 = new ExportDto();
                    this.buidExportDtoByOrgId(exportDto7, orgId, startDate, curDate);
                    exportDtoMap.put(orgId, exportDto7);
                }
                DrawStatisticData.setExportDto((DrawStatisticData)drawData, (ExportDto)exportDto7);
            }
        }
        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());
        Map voteDatas = this.voteDataStatisticService.getVoteData(startTime, endTime, startDate, curDate, TianxiaoOrgIds, way);
        if (GenericsUtils.notNullAndEmpty((Object)voteDatas)) {
            for (Long orgId : voteDatas.keySet()) {
                ExportDto exportDto8 = (ExportDto)exportDtoMap.get(orgId);
                VoteStatistics voteData = (VoteStatistics)voteDatas.get(orgId);
                if (exportDto8 == null) {
                    exportDto8 = new ExportDto();
                    this.buidExportDtoByOrgId(exportDto8, orgId, startDate, curDate);
                    exportDtoMap.put(orgId, exportDto8);
                }
                VoteStatistics.buildExportDtoByVoteStatistics((ExportDto)exportDto8, (VoteStatistics)voteData);
            }
        }
        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());
        Map referralDatas = this.referralStatisticsService.getPeriodReferralData(startTime, endTime, startDate, curDate, TianxiaoOrgIds, way);
        if (GenericsUtils.notNullAndEmpty((Object)referralDatas)) {
            for (Long orgId : referralDatas.keySet()) {
                ExportDto exportDto9 = (ExportDto)exportDtoMap.get(orgId);
                ReferralStatisticData referralData = (ReferralStatisticData)referralDatas.get(orgId);
                log.info(referralData.getBrokerNum() + ":" + referralData.getBrowseCount() + ":" + referralData.getReferralActivityTotal() + ":" + referralData.getCustomerNum());
                if (exportDto9 == null) {
                    exportDto9 = new ExportDto();
                    this.buidExportDtoByOrgId(exportDto9, orgId, startDate, curDate);
                    exportDtoMap.put(orgId, exportDto9);
                }
                ReferralStatisticData.buildExportDtoByReferralStatisticData((ExportDto)exportDto9, (ReferralStatisticData)referralData);
            }
        }
        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());
        Map<Long, TxBacklogStatisticData> txBacklogDatas = this.txBacklogStatisticService.getTxBacklogData(startTime, endTime, TianxiaoOrgIds, way);
        if (GenericsUtils.notNullAndEmpty(txBacklogDatas)) {
            for (Long orgId : txBacklogDatas.keySet()) {
                TxBacklogStatisticData txBacklogData = txBacklogDatas.get(orgId);
                ExportDto exportDto10 = (ExportDto)exportDtoMap.get(orgId);
                if (exportDto10 == null) {
                    exportDto10 = new ExportDto();
                    this.buidExportDtoByOrgId(exportDto10, orgId, startDate, curDate);
                    exportDtoMap.put(orgId, exportDto10);
                }
                TxBacklogStatisticData.buildExportDtoByTxBacklogStatisticData(exportDto10, txBacklogData);
            }
        }
        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());
        Map<Integer, ConsultMessageStatisticData> consultMessageDatas = this.consultMessageStatisticService.getConsultMessageData(startTime, endTime, TianxiaoOrgNumbers);
        List orgAccounts = this.orgAccountDao.getAccountByNumbers(consultMessageDatas.keySet(), new String[]{"id", "number"});
        if (GenericsUtils.notNullAndEmpty(consultMessageDatas)) {
            for (OrgAccount orgAccount : orgAccounts) {
                ConsultMessageStatisticData consultMessageStatisticData = consultMessageDatas.get(orgAccount.getNumber());
                Long orgId = orgAccount.getId().longValue();
                exportDto5 = (ExportDto)exportDtoMap.get(orgId);
                if (exportDto5 == null) {
                    exportDto5 = new ExportDto();
                    this.buidExportDtoByOrgId(exportDto5, orgId, startDate, curDate);
                    exportDtoMap.put(orgId, exportDto5);
                }
                ConsultMessageStatisticData.buildExportDtoByConsultMessageStatisticData(exportDto5, consultMessageStatisticData);
            }
        }
        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());
        Map<Long, CRMStatisticData> consultUserCounts = this.crmStatisticService.getConsultUserSData(startTime, endTime, TianxiaoOrgIds);
        if (GenericsUtils.notNullAndEmpty(consultUserCounts)) {
            for (Long orgId : consultUserCounts.keySet()) {
                ExportDto exportDto11 = (ExportDto)exportDtoMap.get(orgId);
                CRMStatisticData crmStatisticData = consultUserCounts.get(orgId);
                if (exportDto11 == null) {
                    exportDto11 = new ExportDto();
                    this.buidExportDtoByOrgId(exportDto11, orgId, startDate, curDate);
                    exportDtoMap.put(orgId, exportDto11);
                }
                CRMStatisticData.buidExportDtoByCRMStatisticData(crmStatisticData, exportDto11);
            }
        }
        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());
        Map<Long, WechatStatisticData> wechatDatas = this.wechatStatisticService.getWechatStatisticData(startTime, endTime, TianxiaoOrgIds, way);
        if (GenericsUtils.notNullAndEmpty(wechatDatas)) {
            for (Long orgId : wechatDatas.keySet()) {
                exportDto5 = (ExportDto)exportDtoMap.get(orgId);
                WechatStatisticData wechatData = wechatDatas.get(orgId);
                if (exportDto5 == null) {
                    exportDto5 = new ExportDto();
                    this.buidExportDtoByOrgId(exportDto5, orgId, startDate, curDate);
                    exportDtoMap.put(orgId, exportDto5);
                }
                WechatStatisticData.buildExportDtoByWechatStatisticData(exportDto5, wechatData);
            }
        }
        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());
        Map<Long, ERPStatisticData> ERPDatas = this.erpStatisticService.getERPDatas(startTime, endTime, TianxiaoOrgNumbers, TianxiaoOrgIds);
        if (GenericsUtils.notNullAndEmpty(ERPDatas)) {
            for (Long orgId : ERPDatas.keySet()) {
                ExportDto exportDto12 = (ExportDto)exportDtoMap.get(orgId);
                ERPStatisticData ERPData = ERPDatas.get(orgId);
                if (exportDto12 == null) {
                    exportDto12 = new ExportDto();
                    this.buidExportDtoByOrgId(exportDto12, orgId, startDate, curDate);
                    exportDtoMap.put(orgId, exportDto12);
                }
                ERPStatisticData.buildExportDtoByERPStatisticData(exportDto12, ERPData);
            }
        }
        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());
        Map teacherCountMap = this.teacherDao.getPeriodOrgTeacher(null, startTime, endTime, TianxiaoOrgIds);
        if (GenericsUtils.notNullAndEmpty((Object)teacherCountMap)) {
            for (Long orgId : teacherCountMap.keySet()) {
                Integer teacherCount = (Integer)teacherCountMap.get(orgId);
                ExportDto exportDto13 = (ExportDto)exportDtoMap.get(orgId);
                if (exportDto13 == null) {
                    exportDto13 = new ExportDto();
                    this.buidExportDtoByOrgId(exportDto13, orgId, startDate, curDate);
                    exportDtoMap.put(orgId, exportDto13);
                }
                exportDto13.setTeacherTotal(teacherCount.intValue());
            }
        }
        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());
        Map roomCountMap = this.courseRoomDao.getOrgRoomTotal();
        if (GenericsUtils.notNullAndEmpty((Object)roomCountMap) && way != 0) {
            for (Long orgId : roomCountMap.keySet()) {
                Integer roomCount = (Integer)roomCountMap.get(orgId);
                exportDto4 = (ExportDto)exportDtoMap.get(orgId);
                if (exportDto4 == null) {
                    exportDto4 = new ExportDto();
                    this.buidExportDtoByOrgId(exportDto4, orgId, startDate, curDate);
                    exportDtoMap.put(orgId, exportDto4);
                }
                exportDto4.setRoomTotal(roomCount.intValue());
            }
        }
        if (GenericsUtils.notNullAndEmpty((Object)(groupMsgCountMap = this.groupMsgDao.getOrgGroupMsgTotal(startTime, endTime, TianxiaoOrgIds)))) {
            for (Long orgId : groupMsgCountMap.keySet()) {
                exportDto4 = (ExportDto)exportDtoMap.get(orgId);
                Integer groupMsgCount = (Integer)groupMsgCountMap.get(orgId);
                if (exportDto4 == null) {
                    exportDto4 = new ExportDto();
                    this.buidExportDtoByOrgId(exportDto4, orgId, startDate, curDate);
                    exportDtoMap.put(orgId, exportDto4);
                }
                exportDto4.setGroupMsgTotal(groupMsgCount == null ? 0 : groupMsgCount);
            }
        }
        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());
        Map msgReceiverCountMap = this.groupMsgReceiverDao.getMsgReceiverTotal(Boolean.valueOf(true), startTime, endTime, TianxiaoOrgIds);
        if (GenericsUtils.notNullAndEmpty((Object)msgReceiverCountMap)) {
            for (Long orgId : msgReceiverCountMap.keySet()) {
                Integer msgReceiverCount = (Integer)msgReceiverCountMap.get(orgId);
                log.info("\u65b0\u63a5\u53d7\u4eba\u6570================" + msgReceiverCount);
                exportDto3 = (ExportDto)exportDtoMap.get(orgId);
                if (exportDto3 == null) {
                    exportDto3 = new ExportDto();
                    this.buidExportDtoByOrgId(exportDto3, orgId, startDate, curDate);
                    exportDtoMap.put(orgId, exportDto3);
                }
                exportDto3.setMsgReceiverTotal(msgReceiverCount == null ? 0 : msgReceiverCount);
            }
        }
        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());
        Set useTemplateOrgIds = this.orgHomepageConfigDao.getUseTemplateOrgIds(TianxiaoOrgIds);
        if (GenericsUtils.notNullAndEmpty((Object)useTemplateOrgIds)) {
            for (Long orgId : useTemplateOrgIds) {
                exportDto3 = (ExportDto)exportDtoMap.get(orgId);
                if (exportDto3 == null) {
                    exportDto3 = new ExportDto();
                    this.buidExportDtoByOrgId(exportDto3, orgId, startDate, curDate);
                    exportDtoMap.put(orgId, exportDto3);
                }
                exportDto3.setIsUseHomePage(true);
            }
        }
        if (GenericsUtils.notNullAndEmpty((Object)(txMonitorTypes = this.txMonitorTypeDayDao.listUseMonitorType(startTime, endTime, TianxiaoOrgNumbers)))) {
            Map homePageMonitorOrgNumberMap = CollectionUtils.extractMap((Collection)txMonitorTypes, (CollectionUtils.Extracter)new CollectionUtils.Extracter<Integer, TxMonitorTypeDay>(){

                public Integer extract(TxMonitorTypeDay txMonitorTypeDay) {
                    return txMonitorTypeDay.getOrgNumber().intValue();
                }
            });
            List orgHomePageAccounts = this.orgAccountDao.getAccountByNumbers(homePageMonitorOrgNumberMap.keySet(), new String[]{"id", "number"});
            for (OrgAccount account : orgHomePageAccounts) {
                TxMonitorTypeDay monitorTypeDay;
                exportDto2 = (ExportDto)exportDtoMap.get(account.getId().longValue());
                if (exportDto2 == null) {
                    exportDto2 = new ExportDto();
                    this.buidExportDtoByOrgId(exportDto2, account.getId().longValue(), startDate, curDate);
                    exportDtoMap.put(account.getId().longValue(), exportDto2);
                }
                exportDto2.setPvTotal((monitorTypeDay = (TxMonitorTypeDay)homePageMonitorOrgNumberMap.get(account.getNumber())).getPv() == null ? 0 : monitorTypeDay.getPv());
                exportDto2.setUvTotal(monitorTypeDay.getUv() == null ? 0 : monitorTypeDay.getUv());
            }
        }
        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());
        Map loginCountMap = this.orgAppLoginLogDao.getOrgAppLoginTotal(null, startTime, endTime, TianxiaoOrgIds);
        if (GenericsUtils.notNullAndEmpty((Object)loginCountMap)) {
            for (Long orgId : loginCountMap.keySet()) {
                Integer loginCount = (Integer)loginCountMap.get(orgId);
                exportDto2 = (ExportDto)exportDtoMap.get(orgId);
                if (exportDto2 == null) {
                    exportDto2 = new ExportDto();
                    this.buidExportDtoByOrgId(exportDto2, orgId, startDate, curDate);
                    exportDtoMap.put(orgId, exportDto2);
                }
                exportDto2.setLoginTotal(loginCount == null ? 0 : loginCount);
            }
        }
        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + exportDtoMap.size());
        Map ttsMsgCountMap = this.ttsSmSDao.getOrgTtsSmsCount(startTime, endTime, TianxiaoOrgIds);
        Map txMsgCountMap = this.txSmsDao.getOrgTxSmsCount(startTime, endTime, TianxiaoOrgIds);
        if (GenericsUtils.notNullAndEmpty((Object)ttsMsgCountMap)) {
            for (Long orgId : ttsMsgCountMap.keySet()) {
                if (txMsgCountMap.get(orgId) == null) {
                    txMsgCountMap.put(orgId, ttsMsgCountMap.get(orgId));
                    continue;
                }
                txMsgCountMap.put(orgId, (Integer)txMsgCountMap.get(orgId) + (Integer)ttsMsgCountMap.get(orgId));
            }
        }
        if (GenericsUtils.notNullAndEmpty((Object)txMsgCountMap)) {
            for (Long orgId : txMsgCountMap.keySet()) {
                Integer smsCount = (Integer)txMsgCountMap.get(orgId);
                exportDto = (ExportDto)exportDtoMap.get(orgId);
                if (exportDto == null) {
                    exportDto = new ExportDto();
                    this.buidExportDtoByOrgId(exportDto, orgId, startDate, curDate);
                    exportDtoMap.put(orgId, exportDto);
                }
                exportDto.setSmsTotal(smsCount == null ? 0 : smsCount);
            }
        }
        if (GenericsUtils.notNullAndEmpty((Object)(extensionMap = this.orgInfoDao.getExtentionsByOrgIds(TianxiaoOrgIds)))) {
            for (Long orgId : exportDtoMap.keySet()) {
                String extension = (String)extensionMap.get(orgId);
                Integer orgCallRecordCount = this.OrgCallRecorderDao.getOrgCallRecordCountByExtexsion(startTime, endTime, extension);
                Integer orgCallRecordTime = this.OrgCallRecorderDao.getOrgCallRecordTimeByExtension(startTime, endTime, extension);
                ExportDto exportDto14 = (ExportDto)exportDtoMap.get(orgId);
                if (exportDto14 == null) {
                    exportDto14 = new ExportDto();
                    exportDtoMap.put(orgId, exportDto14);
                    this.buidExportDtoByOrgId(exportDto14, orgId, startDate, curDate);
                }
                exportDto14.setOrgCallRecordCount(orgCallRecordCount == null ? 0 : orgCallRecordCount);
                exportDto14.setOrgCallRecordTime(orgCallRecordTime == null ? 0 : orgCallRecordTime);
            }
        }
        log.info("Cost time = " + (System.currentTimeMillis() - start) + ";size=" + ttsMsgCountMap.size());
        for (Long orgId : TianxiaoOrgIds) {
            exportDto = (ExportDto)exportDtoMap.get(orgId);
            if (exportDto == null) {
                exportDto = new ExportDto();
                this.buidExportDtoByOrgId(exportDto, orgId, startDate, curDate);
            }
            TXStatisticData txStatisticData = ExportDto.buildTXStatisticDataByExportDto((ExportDto)exportDto, (int)way);
            this.txStatisticDataDao.addTXStatisticDataDao(txStatisticData);
            dataList.add(exportDto);
        }
        Comparator<ExportDto> sortOfExportDto = new Comparator<ExportDto>(){

            @Override
            public int compare(ExportDto e1, ExportDto e2) {
                return e1.getLoginTotal() - e2.getLoginTotal() >= 0 ? -1 : 1;
            }
        };
        Collections.sort(dataList, sortOfExportDto);
        return dataList;
    }

    private void buidExportDtoByOrgId(ExportDto exportDto, Long orgId, String startDate, String curDate) {
        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(orgId.intValue()), new String[0]);
        OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgId.intValue(), new String[0]);
        if (orgAccount == null) {
            // empty if block
        }
        exportDto.setOrgNumber(orgAccount.getNumber());
        if (orgInfo == null) {
            exportDto.setOrgShortName("");
        } else {
            exportDto.setOrgShortName(orgInfo.getShortName());
        }
        if (startDate != null) {
            exportDto.setStartDate(startDate);
        }
        if (curDate != null) {
            exportDto.setCurDate(curDate);
        }
    }

    private String getDate(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String curDate = dateFormat.format(date);
        return curDate;
    }

    public List<ExportKeyData> writeDataToSheet0(HSSFSheet sheet, List<ExportDto> data) {
        ArrayList<ExportKeyData> keyDatas = new ArrayList<ExportKeyData>();
        log.info("[Statistics]Day Size=" + data.size());
        for (int i = 3; i < data.size() + 3; ++i) {
            ExportKeyData keyData = new ExportKeyData();
            HSSFRow row = sheet.createRow(i);
            ExportDto exportDto = data.get(i - 3);
            keyData.setOrgShortName(exportDto.getOrgShortName());
            keyData.setOrgNumber(exportDto.getOrgNumber());
            keyData.setLoginTotal(exportDto.getLoginTotal() + keyData.getLoginTotal());
            keyData.setBacklogFinish(exportDto.getBacklogFinish());
            keyData.setClueTotal(exportDto.getClueTotal());
            keyData.setStudentTotal(exportDto.getStudentTotal());
            keyData.setWechatFansTotal(exportDto.getWechatFansTotal());
            keyData.setCourseTotal(exportDto.getCourseTotal());
            keyData.setArrangedClassTotal(exportDto.getArrangedClassTotal());
            keyData.setCourseSmsTotal(exportDto.getCourseSmsTotal());
            keyData.setSignLessonTotal(exportDto.getSignLessonTotal());
            keyData.setSignStudentTotal(exportDto.getSignStudentTotal());
            keyData.setCommentByTeacher(exportDto.getCommentByTeacher());
            int activityTotal = exportDto.getActivityTotal() + exportDto.getDrawActivityTotal() + exportDto.getVoteActivityTotal() + exportDto.getReferralActivityTotal();
            keyData.setActivityTotal(activityTotal);
            int activityAccessTotal = exportDto.getActivityAccessTotal() + exportDto.getReferralAccessTotal() + exportDto.getVoteAccessTotal();
            keyData.setActivityAccessTotal(activityAccessTotal);
            keyData.setCommentByTeacher(exportDto.getCommentByTeacher());
            keyData.setPvTotal(exportDto.getPvTotal());
            keyData.setUvTotal(exportDto.getUvTotal());
            keyData.setWechatAuthorizerOfStudentTotal(exportDto.getWechatAuthorizerOfStudentTotal());
            keyData.setSmsTotal(exportDto.getSmsTotal());
            keyData.setOrgCallRecordCount(exportDto.getOrgCallRecordCount());
            keyData.setOrgCallRecordTime(exportDto.getOrgCallRecordTime());
            ExcelUtil.createCell((HSSFRow)row, (int)0, (String)exportDto.getCurDate());
            ExcelUtil.createCell((HSSFRow)row, (int)1, (String)exportDto.getOrgShortName());
            ExcelUtil.createCell((HSSFRow)row, (int)2, (int)exportDto.getOrgNumber());
            ExcelUtil.createCell((HSSFRow)row, (int)5, (int)exportDto.getBacklogTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)6, (int)exportDto.getBacklogFinish());
            ExcelUtil.createCell((HSSFRow)row, (int)7, (int)exportDto.getBacklogExpire());
            ExcelUtil.createCell((HSSFRow)row, (int)8, (int)exportDto.getClueTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)9, (int)exportDto.getClueWechat());
            ExcelUtil.createCell((HSSFRow)row, (int)10, (int)exportDto.getClueReserve());
            ExcelUtil.createCell((HSSFRow)row, (int)11, (int)exportDto.getClueCall());
            ExcelUtil.createCell((HSSFRow)row, (int)12, (int)exportDto.getConsultUserTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)13, (int)exportDto.getStudentTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)14, (boolean)exportDto.getIsWechatAuthorizer());
            ExcelUtil.createCell((HSSFRow)row, (int)15, (boolean)exportDto.getIsWechatMenu());
            ExcelUtil.createCell((HSSFRow)row, (int)16, (int)exportDto.getWechatFansTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)17, (int)exportDto.getCourseTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)18, (int)exportDto.getArrangedClassTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)19, (int)exportDto.getLessonTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)20, (int)exportDto.getCourseSmsTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)21, (double)exportDto.getIncomeSum());
            ExcelUtil.createCell((HSSFRow)row, (int)22, (int)exportDto.getIncomeTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)23, (int)exportDto.getSignLessonTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)24, (int)exportDto.getSignStudentTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)25, (double)exportDto.getCashPurchaseSum());
            ExcelUtil.createCell((HSSFRow)row, (int)26, (int)exportDto.getCommentByStudent());
            ExcelUtil.createCell((HSSFRow)row, (int)27, (int)exportDto.getCommentByTeacher());
            ExcelUtil.createCell((HSSFRow)row, (int)28, (int)exportDto.getTeacherTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)29, (int)exportDto.getRoomTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)30, (int)exportDto.getActivityTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)31, (int)exportDto.getActivityAccessTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)32, (int)exportDto.getActivityEnrollTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)33, (int)exportDto.getDrawActivityTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)34, (int)exportDto.getDrawUserTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)35, (int)exportDto.getDrawWinnerTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)36, (int)exportDto.getVoteActivityTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)37, (int)exportDto.getVoteAccessTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)38, (int)exportDto.getVoteTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)39, (int)exportDto.getReferralActivityTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)40, (int)exportDto.getReferralAccessTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)41, (int)exportDto.getBrokerTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)42, (int)exportDto.getReferralTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)43, (int)exportDto.getGroupMsgTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)44, (int)exportDto.getMsgReceiverTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)45, (boolean)exportDto.getIsUseHomePage());
            ExcelUtil.createCell((HSSFRow)row, (int)46, (int)exportDto.getUvTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)47, (int)exportDto.getPvTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)48, (int)exportDto.getLoginTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)49, (int)exportDto.getWechatAuthorizerOfStudentTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)50, (int)exportDto.getSmsTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)51, (int)exportDto.getOrgCallRecordCount());
            ExcelUtil.createCell((HSSFRow)row, (int)52, (int)exportDto.getOrgCallRecordTime());
            keyDatas.add(keyData);
        }
        return keyDatas;
    }

    public void writeDataToSheet1(HSSFSheet sheet, List<ExportDto> data) {
        log.info("[Statistics]Total Size=" + data.size());
        for (int i = 3; i < data.size() + 3; ++i) {
            HSSFRow row = sheet.createRow(i);
            ExportDto exportDto = data.get(i - 3);
            ExcelUtil.createCell((HSSFRow)row, (int)0, (String)exportDto.getOrgShortName());
            ExcelUtil.createCell((HSSFRow)row, (int)1, (int)exportDto.getOrgNumber());
            ExcelUtil.createCell((HSSFRow)row, (int)4, (int)exportDto.getBacklogTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)5, (int)exportDto.getBacklogFinish());
            ExcelUtil.createCell((HSSFRow)row, (int)6, (int)exportDto.getBacklogExpire());
            ExcelUtil.createCell((HSSFRow)row, (int)7, (int)exportDto.getClueTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)8, (int)exportDto.getClueWechat());
            ExcelUtil.createCell((HSSFRow)row, (int)9, (int)exportDto.getClueReserve());
            ExcelUtil.createCell((HSSFRow)row, (int)10, (int)exportDto.getClueCall());
            ExcelUtil.createCell((HSSFRow)row, (int)11, (int)exportDto.getConsultUserTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)12, (int)exportDto.getStudentTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)13, (boolean)exportDto.getIsWechatAuthorizer());
            ExcelUtil.createCell((HSSFRow)row, (int)14, (boolean)exportDto.getIsWechatMenu());
            ExcelUtil.createCell((HSSFRow)row, (int)15, (int)exportDto.getWechatFansTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)16, (int)exportDto.getCourseTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)17, (int)exportDto.getArrangedClassTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)18, (int)exportDto.getLessonTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)19, (int)exportDto.getCourseSmsTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)20, (double)exportDto.getIncomeSum());
            ExcelUtil.createCell((HSSFRow)row, (int)21, (int)exportDto.getIncomeTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)22, (int)exportDto.getSignLessonTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)23, (int)exportDto.getSignStudentTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)24, (double)exportDto.getCashPurchaseSum());
            ExcelUtil.createCell((HSSFRow)row, (int)25, (int)exportDto.getCommentByStudent());
            ExcelUtil.createCell((HSSFRow)row, (int)26, (int)exportDto.getCommentByTeacher());
            ExcelUtil.createCell((HSSFRow)row, (int)27, (int)exportDto.getTeacherTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)28, (int)exportDto.getRoomTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)29, (int)exportDto.getActivityTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)30, (int)exportDto.getActivityAccessTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)31, (int)exportDto.getActivityEnrollTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)32, (int)exportDto.getDrawActivityTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)33, (int)exportDto.getDrawUserTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)34, (int)exportDto.getDrawWinnerTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)35, (int)exportDto.getVoteActivityTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)36, (int)exportDto.getVoteAccessTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)37, (int)exportDto.getVoteTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)38, (int)exportDto.getReferralActivityTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)39, (int)exportDto.getReferralAccessTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)40, (int)exportDto.getBrokerTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)41, (int)exportDto.getReferralTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)42, (int)exportDto.getGroupMsgTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)43, (int)exportDto.getMsgReceiverTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)44, (boolean)exportDto.getIsUseHomePage());
            ExcelUtil.createCell((HSSFRow)row, (int)45, (int)exportDto.getUvTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)46, (int)exportDto.getPvTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)47, (int)exportDto.getLoginTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)48, (int)exportDto.getWechatAuthorizerOfStudentTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)49, (int)exportDto.getSmsTotal());
            ExcelUtil.createCell((HSSFRow)row, (int)50, (int)exportDto.getOrgCallRecordCount());
            ExcelUtil.createCell((HSSFRow)row, (int)51, (int)exportDto.getOrgCallRecordTime());
        }
    }

    @Override
    public void createHSSFWorkbook(Date startTime, Date endTime) {
        List<ExportDto> dayData = this.getExportDtoByDay(startTime, endTime, 0);
        List<ExportDto> totalData = this.getExportDtoByDay(null, endTime, 3);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String curDate = dateFormat.format(startTime);
        try {
            HSSFSheet sheet;
            HSSFWorkbook wb;
            InputStream dayIn = this.getClass().getResourceAsStream("/template/template-excelByDay.xls");
            InputStream totaIn = this.getClass().getResourceAsStream("/template/template-excelTotal.xls");
            File[] files = new File[2];
            List<ExportKeyData> keyDatas = new ArrayList<ExportKeyData>();
            if (GenericsUtils.notNullAndEmpty(dayData)) {
                wb = new HSSFWorkbook(dayIn);
                sheet = wb.getSheetAt(0);
                wb.setSheetName(0, wb.getSheetName(0));
                keyDatas = this.writeDataToSheet0(sheet, dayData);
                files[0] = this.createFil(wb, curDate + "excelByDay.xls");
            }
            if (GenericsUtils.notNullAndEmpty(totalData)) {
                wb = new HSSFWorkbook(totaIn);
                sheet = wb.getSheetAt(0);
                wb.setSheetName(0, wb.getSheetName(0));
                this.writeDataToSheet1(sheet, totalData);
                files[1] = this.createFil(wb, curDate + "excelTotal.xls");
            }
            String email = Config.MAIL_CONTACT_TIANXIAO_DATA;
            String content = this.getContent(keyDatas);
            ExcelMailSender.sendMail((String)email, (String)(curDate + "\u5929\u6821\u76d1\u63a7\u6570\u636e"), (String)content, (File[])files);
        }
        catch (FileNotFoundException e) {
            log.warn("excel\u6587\u4ef6\u521b\u5efa\u5931\u8d25");
        }
        catch (IOException e) {
            log.warn("excel\u6587\u4ef6\u521b\u5efa\u5931\u8d25");
        }
    }

    private String getContent(List<ExportKeyData> keyDatas) {
        StringBuffer sb = new StringBuffer("<head style=\"font-size:14px\"> \n<style>.c-gray{ background-color: #D8D9DB;}\n .c-orange{background-color: #FDC20E;}\n .c-yellow{background-color: #FEFF0D;}\n .c-green{background-color: #94D351;}\n .c-blue { background-color: #1AAFF1;}\n .c-purple {background-color: #D9E0F2;}\n </style>\n</head>\n<body>\n <table class=\"table table-bordered\" cellpadding=\"8\" cellspacing=\"0\" style=\"width:100%;text-align:center; border: 1px solid #ddd;font-size:13px\">\n<thead>\n<tr>\n<th width=\"100\" class=\"c-gray\">\u673a\u6784\u540d\u79f0</th>\n <th width=\"100\"class=\"c-gray\">\u673a\u6784ID</th>\n<th width=\"100\" class=\"c-orange\">\u4eca\u65e5\u673a\u6784\u767b\u9646\u6b21\u6570(\u5305\u542b\u5b50\u8d26\u53f7)</th>\n<th width=\"100\" class=\"c-yellow\">\u7ebf\u7d22\u65b0\u589e\u603b\u6570</th>\n<th width=\"100\" class=\"c-yellow\">\u65b0\u589e\u5b66\u5458\u6570</th>\n<th width=\"100\" class=\"c-yellow\">\u5fae\u4fe1\u7c89\u4e1d\u65b0\u589e\u6570\uff08\u51c0\u589e\u957f\uff09</th>\n<th width=\"100\" class=\"c-green\">\u65b0\u589e\u5fae\u8bfe\u6570</th>\n<th width=\"100\" class=\"c-green\">\u65b0\u6392\u8bfe\u73ed\u7ea7\u6570</th>\n<th width=\"100\" class=\"c-green\">\u65b0\u53d1\u9001\u8bfe\u8868\u6570\u91cf</th>\n<th width=\"100\" class=\"c-green\">\u4eca\u65e5\u7b7e\u5230\u8bfe\u8282\u6570</th>\n<th width=\"100\" class=\"c-green\">\u4eca\u65e5\u7b7e\u5230\u4eba\u6b21</th>\n<th width=\"100\" class=\"c-green\">\u4eca\u65e5\u8001\u5e08\u4e3b\u52a8\u70b9\u8bc4\u6570</th>\n<th width=\"100\" class=\"c-blue\">\u4eca\u65e5\u65b0\u589e\u6d3b\u52a8\u603b\u6570</th>\n<th width=\"100\"class=\"c-blue\">\u4eca\u65e5\u65b0\u589e\u8bbf\u95ee\u603b\u6570</th>\n<th width=\"100\" class=\"c-purple\">\u4eca\u65e5\u65b0\u589eUV</th>\n<th width=\"100\" class=\"c-purple\">\u4eca\u65e5\u65b0\u589ePV</th>\n<th width=\"100\" class=\"c-purple\">\u65b0\u589e\u7ed1\u5b9a\u5fae\u4fe1\u516c\u4f17\u53f7\u5b66\u751f\u6570</th>\n<th width=\"100\" class=\"c-purple\">\u65b0\u53d1\u77ed\u4fe1\u6570</th>\n<th width=\"100\" class=\"c-purple\">\u65b0\u589e400\u7535\u8bdd\u603b\u547c\u51fa\u6570</th>\n<th width=\"100\" class=\"c-purple\">\u65b0\u589e400\u7535\u8bdd\u603b\u547c\u51fa\u65f6\u957f</th>\n</tr>\n</thead>\n<tbody>\n");
        for (ExportKeyData keyData : keyDatas) {
            sb.append("<tr>");
            sb.append("<td>" + keyData.getOrgShortName() + "</td>");
            sb.append("<td>" + keyData.getOrgNumber() + "</td>");
            sb.append(this.getTd(keyData.getLoginTotal()));
            sb.append(this.getTd(keyData.getClueTotal()));
            sb.append(this.getTd(keyData.getStudentTotal()));
            sb.append(this.getTd(keyData.getWechatFansTotal()));
            sb.append(this.getTd(keyData.getCourseTotal()));
            sb.append(this.getTd(keyData.getArrangedClassTotal()));
            sb.append(this.getTd(keyData.getCourseSmsTotal()));
            sb.append(this.getTd(keyData.getSignLessonTotal()));
            sb.append(this.getTd(keyData.getSignStudentTotal()));
            sb.append(this.getTd(keyData.getCommentByTeacher()));
            sb.append(this.getTd(keyData.getActivityTotal()));
            sb.append(this.getTd(keyData.getActivityAccessTotal()));
            sb.append(this.getTd(keyData.getUvTotal()));
            sb.append(this.getTd(keyData.getPvTotal()));
            sb.append(this.getTd(keyData.getWechatAuthorizerOfStudentTotal()));
            sb.append(this.getTd(keyData.getSmsTotal()));
            sb.append(this.getTd(keyData.getOrgCallRecordCount()));
            sb.append(this.getTd(keyData.getOrgCallRecordTime()));
            sb.append("</tr>");
        }
        sb.append("</tbody></table></article>");
        return sb.toString();
    }

    private String getTd(int value) {
        if (value == 0) {
            return "<td></td>";
        }
        return "<td>" + value + "</td>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private File createFil(HSSFWorkbook wb, String fileName) {
        File localFile = new File(fileName);
        if (!localFile.exists()) {
            try {
                localFile.createNewFile();
            }
            catch (IOException e) {
                return null;
            }
        }
        FileOutputStream out = null;
        BufferedOutputStream bos = null;
        try {
            out = new FileOutputStream(localFile);
            bos = new BufferedOutputStream(out);
            wb.write((OutputStream)bos);
            wb = null;
        }
        catch (Exception e) {
            IOUtils.closeQuietly(bos);
            IOUtils.closeQuietly((OutputStream)out);
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bos);
                IOUtils.closeQuietly((OutputStream)out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)bos);
        IOUtils.closeQuietly((OutputStream)out);
        return localFile;
    }

    @Override
    public void createMailByWeekAndMonth(Date startTime, Date endTime, int beforeDay) {
        ArrayList<ExportDto> exportDtos = new ArrayList();
        if (beforeDay == 7) {
            exportDtos = this.getExportDtoByDay(startTime, endTime, 1);
        } else if (beforeDay == 30) {
            exportDtos = this.getExportDtoByDay(startTime, endTime, 2);
        }
        int orgTotal = exportDtos.size();
        String startDate = this.getDate(startTime);
        String endDate = this.getDate(endTime);
        StatisticByWeekOrMonthDto statistic = this.getStatisticByWeekOrMonthDto(exportDtos, beforeDay);
        List<ExportClientDemandDto> exportClientDemandDtos = this.getExportClientDemandDtos(statistic, orgTotal, beforeDay);
        try {
            InputStream dayIn = this.getClass().getResourceAsStream("/template/template-excelTotal.xls");
            File[] files = new File[1];
            if (GenericsUtils.notNullAndEmpty(exportDtos)) {
                HSSFWorkbook wb = new HSSFWorkbook(dayIn);
                HSSFSheet sheet = wb.getSheetAt(0);
                wb.setSheetName(0, wb.getSheetName(0));
                this.writeDataToSheet1(sheet, exportDtos);
                files[0] = this.createFil(wb, beforeDay + "excelData.xls");
            }
            Template parentTemplate = this.freeMarkerConfigurer.getConfiguration().getTemplate("exportClientEmail.ftl");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("exportClientDemandDtos", exportClientDemandDtos);
            map.put("startDate", startDate);
            map.put("endDate", endDate);
            map.put("beforeDay", beforeDay);
            String result = FreeMarkerTemplateUtils.processTemplateIntoString((Template)parentTemplate, map);
            String email = Config.MAIL_CONTACT_TIANXIAO_CLIENT;
            log.info("\u5929\u6821\u5ba2\u6237\u4f7f\u7528\u6570\u636e\u6536\u4ef6\u4eba" + email);
            ExcelMailSender.sendMail((String)email, (String)("\u5929\u6821\u5ba2\u6237\u4f7f\u7528\u6570\u636e(" + beforeDay + "\u5929_" + startDate + "~" + endDate + ")"), (String)result, (File[])files);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
    }

    private List<ExportClientDemandDto> getExportClientDemandDtos(StatisticByWeekOrMonthDto statistic, int orgTotal, int beforeDay) {
        ArrayList<ExportClientDemandDto> statisticDatas = new ArrayList<ExportClientDemandDto>();
        ExportClientDemandDto login = new ExportClientDemandDto();
        login.setKeyFunctionName("\u6709\u6548\u767b\u5f55");
        login.setEfficientTotal(statistic.getEfficientTotalLogin());
        login.setCoverageRate(this.getPercentByTwoPrecision(statistic.getEfficientTotalLogin(), orgTotal));
        if (statistic.getEfficientTotalLogin() != 0) {
            login.setAverageUsers(this.getAverageUsers(statistic.getLoginTotal(), statistic.getEfficientTotalLogin()));
        } else {
            login.setAverageUsers("");
        }
        login.setKeyIndex("\u767b\u5f55\u6b21\u6570");
        login.setTotal(statistic.getLoginTotal() + "");
        int loginValid = this.getValidTotal(beforeDay, BIzConf.LOGIN_VALID_7, BIzConf.LOGIN_VALID_30);
        login.setRemarks("\u767b\u5f55\u5929\u6821\u6b21\u6570>=" + loginValid);
        statisticDatas.add(login);
        ExportClientDemandDto finish = new ExportClientDemandDto();
        finish.setKeyFunctionName("\u4eca\u65e5\u4ee3\u529e");
        finish.setEfficientTotal(statistic.getEfficientTotalFinish());
        finish.setCoverageRate(this.getPercentByTwoPrecision(statistic.getEfficientTotalFinish(), orgTotal));
        if (statistic.getEfficientTotalFinish() != 0) {
            finish.setAverageUsers(this.getAverageUsers(statistic.getBacklogFinish(), statistic.getEfficientTotalFinish()));
        } else {
            finish.setAverageUsers("");
        }
        finish.setKeyIndex("\u5b8c\u6210\u4efb\u52a1\u6b21\u6570");
        finish.setTotal(statistic.getBacklogFinish() + "");
        finish.setRemarks("\u622a\u81f3\u76ee\u524d\u5b8c\u6210\u4efb\u52a1\u603b\u6570");
        statisticDatas.add(finish);
        ExportClientDemandDto clueWechat = new ExportClientDemandDto();
        clueWechat.setKeyFunctionName("\u5fae\u4fe1\u7ebf\u7d22");
        clueWechat.setEfficientTotal(statistic.getEfficientTotalClueWechat());
        clueWechat.setCoverageRate(this.getPercentByTwoPrecision(statistic.getEfficientTotalClueWechat(), orgTotal));
        if (statistic.getEfficientTotalClueWechat() != 0) {
            clueWechat.setAverageUsers(this.getAverageUsers(statistic.getClueWechat(), statistic.getEfficientTotalClueWechat()));
        } else {
            clueWechat.setAverageUsers("");
        }
        clueWechat.setKeyIndex("\u5fae\u4fe1\u7ebf\u7d22\u91cf");
        clueWechat.setTotal(statistic.getClueWechat() + "");
        int wechatClueValid = this.getValidTotal(beforeDay, BIzConf.WECHAT_CLUE_VALID_7, BIzConf.WECHAT_CLUE_VALID_30);
        clueWechat.setRemarks("\u5fae\u4fe1\u7ebf\u7d22\u91cf>=" + wechatClueValid);
        statisticDatas.add(clueWechat);
        ExportClientDemandDto clueReserve = new ExportClientDemandDto();
        clueReserve.setKeyFunctionName("\u9884\u7ea6\u7559\u5355");
        clueReserve.setEfficientTotal(statistic.getEfficientTotalClueReserv());
        clueReserve.setCoverageRate(this.getPercentByTwoPrecision(statistic.getEfficientTotalClueReserv(), orgTotal));
        if (statistic.getEfficientTotalClueReserv() != 0) {
            clueReserve.setAverageUsers(this.getAverageUsers(statistic.getClueReserve(), statistic.getEfficientTotalClueReserv()));
        } else {
            clueReserve.setAverageUsers("");
        }
        clueReserve.setKeyIndex("\u7559\u5355\u91cf");
        clueReserve.setTotal(statistic.getClueReserve() + "");
        int clueValid = this.getValidTotal(beforeDay, BIzConf.CLUERESERVE_VALID_7, BIzConf.CLUERESERVE_VALID_30);
        clueReserve.setRemarks("\u7559\u5355\u91cf>=" + clueValid);
        statisticDatas.add(clueReserve);
        ExportClientDemandDto student = new ExportClientDemandDto();
        student.setKeyFunctionName("\u5b66\u5458\u6863\u6848");
        student.setEfficientTotal(statistic.getEfficientTotalStudent());
        student.setCoverageRate(this.getPercentByTwoPrecision(statistic.getEfficientTotalStudent(), orgTotal));
        if (statistic.getEfficientTotalStudent() != 0) {
            student.setAverageUsers(this.getAverageUsers(statistic.getStudentTotal(), statistic.getEfficientTotalStudent()));
        } else {
            student.setAverageUsers("");
        }
        student.setKeyIndex("\u5b66\u5458\u6863\u6848\u6570");
        student.setTotal(statistic.getStudentTotal() + "");
        int studentValid = this.getValidTotal(beforeDay, BIzConf.STUDENT_TOTAL_VALID_7, BIzConf.STUDENT_TOTAL_VALID_30);
        student.setRemarks("\u5b66\u5458\u6863\u6848\u6570>=" + studentValid);
        statisticDatas.add(student);
        ExportClientDemandDto wechatAuthorizer = new ExportClientDemandDto();
        wechatAuthorizer.setKeyFunctionName("\u5fae\u4fe1\u516c\u4f17\u53f7\u6258\u7ba1");
        wechatAuthorizer.setEfficientTotal(statistic.getEfficientTotalWechatAuthorizer());
        wechatAuthorizer.setCoverageRate(this.getPercentByTwoPrecision(statistic.getEfficientTotalWechatAuthorizer(), orgTotal));
        if (statistic.getEfficientTotalWechatAuthorizer() != 0) {
            wechatAuthorizer.setAverageUsers(this.getAverageUsers(statistic.getWechatFansTotal(), statistic.getEfficientTotalWechatAuthorizer()));
        } else {
            wechatAuthorizer.setAverageUsers("");
        }
        wechatAuthorizer.setKeyIndex("\u5fae\u4fe1\u7c89\u4e1d\u6570");
        wechatAuthorizer.setTotal(statistic.getWechatFansTotal() + "");
        wechatAuthorizer.setRemarks("\u5fae\u4fe1\u516c\u4f17\u53f7\u6258\u7ba1\u7ed9\u5929\u6821");
        statisticDatas.add(wechatAuthorizer);
        ExportClientDemandDto course = new ExportClientDemandDto();
        course.setKeyFunctionName("\u8bbe\u73ed");
        course.setEfficientTotal(statistic.getEfficientTotalCourse());
        course.setCoverageRate(this.getPercentByTwoPrecision(statistic.getEfficientTotalCourse(), orgTotal));
        if (statistic.getEfficientTotalCourse() != 0) {
            course.setAverageUsers(this.getAverageUsers(statistic.getCourseTotal(), statistic.getEfficientTotalCourse()));
        } else {
            course.setAverageUsers("");
        }
        course.setKeyIndex("\u6dfb\u52a0\u8bfe\u7a0b\u6570");
        course.setTotal(statistic.getCourseTotal() + "");
        int courseValid = this.getValidTotal(beforeDay, BIzConf.COURSE_TOTAL_VALID_7, BIzConf.COURSE_TOTAL_VALID_30);
        course.setRemarks("\u6dfb\u52a0\u8bfe\u7a0b>=" + courseValid);
        statisticDatas.add(course);
        ExportClientDemandDto arrangeCourse = new ExportClientDemandDto();
        arrangeCourse.setKeyFunctionName("\u6392\u8bfe");
        arrangeCourse.setEfficientTotal(statistic.getEfficientTotalArrangedClassTotal());
        arrangeCourse.setCoverageRate(this.getPercentByTwoPrecision(statistic.getEfficientTotalArrangedClassTotal(), orgTotal));
        if (statistic.getEfficientTotalArrangedClassTotal() != 0) {
            arrangeCourse.setAverageUsers(this.getAverageUsers(statistic.getArrangedClassTotal(), statistic.getEfficientTotalArrangedClassTotal()));
        } else {
            arrangeCourse.setAverageUsers("");
        }
        arrangeCourse.setKeyIndex("\u6392\u8bfe\u73ed\u7ea7\u6570");
        arrangeCourse.setTotal(statistic.getArrangedClassTotal() + "");
        int arrangedClassValid = this.getValidTotal(beforeDay, BIzConf.ARRANGE_CLASS_TOTAL_VALID_7, BIzConf.ARRANGE_CLASS_TOTAL_VALID_30);
        arrangeCourse.setRemarks("\u6392\u8bfe\u73ed\u7ea7>=" + arrangedClassValid);
        statisticDatas.add(arrangeCourse);
        ExportClientDemandDto courseSms = new ExportClientDemandDto();
        courseSms.setKeyFunctionName("\u53d1\u8bfe\u8868");
        courseSms.setEfficientTotal(statistic.getEfficientTotalCourseSms());
        courseSms.setCoverageRate(this.getPercentByTwoPrecision(statistic.getEfficientTotalCourseSms(), orgTotal));
        if (statistic.getEfficientTotalCourseSms() != 0) {
            courseSms.setAverageUsers(this.getAverageUsers(statistic.getCourseSmsTotal(), statistic.getEfficientTotalCourseSms()));
        } else {
            courseSms.setAverageUsers("");
        }
        courseSms.setKeyIndex("\u53d1\u8bfe\u8868\u4eba\u6b21");
        courseSms.setTotal(statistic.getCourseSmsTotal() + "");
        int courseSmsValid = this.getValidTotal(beforeDay, BIzConf.COURSESMS_TOTAL_VALID_7, BIzConf.COURSESMS_TOTAL_VALID_30);
        courseSms.setRemarks("\u53d1\u8bfe\u8868>=" + courseSmsValid);
        statisticDatas.add(courseSms);
        ExportClientDemandDto incomeSum = new ExportClientDemandDto();
        incomeSum.setKeyFunctionName("\u6536\u6b3e");
        incomeSum.setEfficientTotal(statistic.getEfficientTotalIncomeSum());
        incomeSum.setCoverageRate(this.getPercentByTwoPrecision(statistic.getEfficientTotalIncomeSum(), orgTotal));
        if (statistic.getEfficientTotalIncomeSum() != 0) {
            incomeSum.setAverageUsers(this.getAverageUsers(statistic.getIncomeSum(), statistic.getEfficientTotalIncomeSum()));
        } else {
            incomeSum.setAverageUsers("");
        }
        incomeSum.setKeyIndex("\u6536\u6b3e\u91d1\u989d");
        incomeSum.setTotal(statistic.getIncomeSum() + "");
        int incomeSumValid = this.getValidTotal(beforeDay, BIzConf.INCOMESUM_VALID_7, BIzConf.INCOMESUM_VALID_30);
        incomeSum.setRemarks("\u6536\u6b3e>=" + incomeSumValid);
        statisticDatas.add(incomeSum);
        ExportClientDemandDto sign = new ExportClientDemandDto();
        sign.setKeyFunctionName("\u7b7e\u5230");
        sign.setEfficientTotal(statistic.getEfficientTotalSign());
        sign.setCoverageRate(this.getPercentByTwoPrecision(statistic.getEfficientTotalSign(), orgTotal));
        if (statistic.getEfficientTotalSign() != 0) {
            sign.setAverageUsers(this.getAverageUsers(statistic.getSignStudentTotal(), statistic.getEfficientTotalSign()));
        } else {
            sign.setAverageUsers("");
        }
        sign.setKeyIndex("\u7b7e\u5230\u4eba\u6b21");
        sign.setTotal(statistic.getSignStudentTotal() + "");
        int signLessonValid = this.getValidTotal(beforeDay, BIzConf.SIGN_LESSON_VALID_7, BIzConf.SIGN_LESSON_VALID_30);
        sign.setRemarks("\u7b7e\u5230\u73ed\u7ea7>=" + signLessonValid);
        statisticDatas.add(sign);
        ExportClientDemandDto commentByTeacher = new ExportClientDemandDto();
        commentByTeacher.setKeyFunctionName("\u8bc4\u4ef7");
        commentByTeacher.setEfficientTotal(statistic.getEfficientTotalCommentByTeacher());
        commentByTeacher.setCoverageRate(this.getPercentByTwoPrecision(statistic.getEfficientTotalCommentByTeacher(), orgTotal));
        if (statistic.getEfficientTotalCommentByTeacher() != 0) {
            commentByTeacher.setAverageUsers(this.getAverageUsers(statistic.getCommentByTeacher(), statistic.getEfficientTotalCommentByTeacher()));
        } else {
            commentByTeacher.setAverageUsers("");
        }
        commentByTeacher.setKeyIndex("\u8001\u5e08\u8bc4\u4ef7\u6570");
        commentByTeacher.setTotal(statistic.getCommentByTeacher() + "");
        int teacherCommentValid = this.getValidTotal(beforeDay, BIzConf.TEACHER_COMMENT_VALID_7, BIzConf.TEACHER_COMMENT_VALID_30);
        commentByTeacher.setRemarks("\u8001\u5e08\u8bc4\u4ef7>=" + teacherCommentValid);
        statisticDatas.add(commentByTeacher);
        ExportClientDemandDto commentByStudent = new ExportClientDemandDto();
        commentByStudent.setKeyFunctionName("");
        commentByStudent.setEfficientTotal(statistic.getEfficientTotalCommentByStudent());
        commentByStudent.setCoverageRate("");
        commentByStudent.setKeyIndex("\u5b66\u751f\u8bc4\u4ef7\u6570");
        commentByStudent.setTotal(statistic.getCommentByStudent() + "");
        if (statistic.getEfficientTotalCommentByStudent() != 0) {
            commentByStudent.setAverageUsers(this.getAverageUsers(statistic.getCommentByStudent(), statistic.getEfficientTotalCommentByStudent()));
        } else {
            commentByStudent.setAverageUsers("");
        }
        commentByStudent.setRemarks("");
        statisticDatas.add(commentByStudent);
        ExportClientDemandDto activity = new ExportClientDemandDto();
        activity.setKeyFunctionName("\u53d1\u6d3b\u52a8");
        activity.setEfficientTotal(statistic.getEfficientTotalActivity());
        activity.setCoverageRate(this.getPercentByTwoPrecision(statistic.getEfficientTotalActivity(), orgTotal));
        if (statistic.getEfficientTotalActivity() != 0) {
            activity.setAverageUsers(this.getAverageUsers(statistic.getActivityAccessTotal(), statistic.getEfficientTotalActivity()));
        } else {
            activity.setAverageUsers("");
        }
        activity.setKeyIndex("\u6d3b\u52a8\u8bbf\u95ee\u91cf(UV)");
        activity.setTotal(statistic.getActivityAccessTotal() + "");
        int activityTotalValid = this.getValidTotal(beforeDay, BIzConf.ACTIVITY_TOTAL_VALID_7, BIzConf.ACTIVITY_TOTAL_VALID_30);
        activity.setRemarks("\u53d1\u6d3b\u52a8>=" + activityTotalValid);
        statisticDatas.add(activity);
        ExportClientDemandDto draw = new ExportClientDemandDto();
        draw.setKeyFunctionName("\u62bd\u5956");
        draw.setEfficientTotal(statistic.getEfficientTotalDrawActivity());
        draw.setCoverageRate(this.getPercentByTwoPrecision(statistic.getEfficientTotalDrawActivity(), orgTotal));
        if (statistic.getEfficientTotalDrawActivity() != 0) {
            draw.setAverageUsers(this.getAverageUsers(statistic.getDrawUserTotal(), statistic.getEfficientTotalDrawActivity()));
        } else {
            draw.setAverageUsers("");
        }
        draw.setKeyIndex("\u62bd\u5956\u53c2\u4e0e\u91cf");
        draw.setTotal(statistic.getDrawUserTotal() + "");
        int drawTotalValid = this.getValidTotal(beforeDay, BIzConf.DRAW_AVTIVITY_TOTAL_VALID_7, BIzConf.DRAW_AVTIVITY_TOTAL_VALID_30);
        draw.setRemarks("\u62bd\u5956\u6d3b\u52a8 >=" + drawTotalValid);
        statisticDatas.add(draw);
        ExportClientDemandDto vote = new ExportClientDemandDto();
        vote.setKeyFunctionName("\u6295\u7968");
        vote.setEfficientTotal(statistic.getEfficientTotalvoteActivity());
        vote.setCoverageRate(this.getPercentByTwoPrecision(statistic.getEfficientTotalvoteActivity(), orgTotal));
        if (statistic.getEfficientTotalvoteActivity() != 0) {
            vote.setAverageUsers(this.getAverageUsers(statistic.getVoteAccessTotal(), statistic.getEfficientTotalvoteActivity()));
        } else {
            vote.setAverageUsers("");
        }
        vote.setKeyIndex("\u6295\u7968\u8bbf\u95ee\u91cf(UV)");
        vote.setTotal(statistic.getVoteAccessTotal() + "");
        int voteTotalValid = this.getValidTotal(beforeDay, BIzConf.VOTE_AVTIVITY_TOTAL_VALID_7, BIzConf.VOTE_AVTIVITY_TOTAL_VALID_30);
        vote.setRemarks("\u6295\u7968\u6d3b\u52a8>=" + voteTotalValid);
        statisticDatas.add(vote);
        ExportClientDemandDto referral = new ExportClientDemandDto();
        referral.setKeyFunctionName("\u8f6c\u4ecb\u7ecd");
        referral.setEfficientTotal(statistic.getEfficientTotalReferralActivity());
        referral.setCoverageRate(this.getPercentByTwoPrecision(statistic.getEfficientTotalReferralActivity(), orgTotal));
        if (statistic.getEfficientTotalReferralActivity() != 0) {
            referral.setAverageUsers(this.getAverageUsers(statistic.getReferralAccessTotal(), statistic.getEfficientTotalReferralActivity()));
        } else {
            referral.setAverageUsers("");
        }
        referral.setKeyIndex("\u8f6c\u4ecb\u7ecd\u8bbf\u95ee\u91cf(UV)");
        referral.setTotal(statistic.getReferralAccessTotal() + "");
        int referralTotalValid = this.getValidTotal(beforeDay, BIzConf.REFERRAL_ACTIVITY_VALID_7, BIzConf.REFERRAL_ACTIVITY_VALID_30);
        referral.setRemarks("\u8f6c\u4ecb\u7ecd\u6d3b\u52a8>=" + referralTotalValid);
        statisticDatas.add(referral);
        ExportClientDemandDto groupMsg = new ExportClientDemandDto();
        groupMsg.setKeyFunctionName("\u7fa4\u53d1\u6d88\u606f");
        groupMsg.setEfficientTotal(statistic.getEfficientTotalGroupMsg());
        groupMsg.setCoverageRate(this.getPercentByTwoPrecision(statistic.getEfficientTotalGroupMsg(), orgTotal));
        if (statistic.getEfficientTotalGroupMsg() != 0) {
            groupMsg.setAverageUsers(this.getAverageUsers(statistic.getGroupMsgTotal(), statistic.getEfficientTotalGroupMsg()));
        } else {
            groupMsg.setAverageUsers("");
        }
        groupMsg.setKeyIndex("\u7fa4\u53d1\u6d88\u606f\u4eba\u6b21");
        groupMsg.setTotal(statistic.getGroupMsgTotal() + "");
        int groupMsgTotalValid = this.getValidTotal(beforeDay, BIzConf.GROUP_MESSAGE_TOTAL_VALID_7, BIzConf.GROUP_MESSAGE_TOTAL_VALID_30);
        groupMsg.setRemarks("\u7fa4\u53d1\u6d88\u606f>=" + groupMsgTotalValid);
        statisticDatas.add(groupMsg);
        ExportClientDemandDto useHomePage = new ExportClientDemandDto();
        useHomePage.setKeyFunctionName("\u4e3b\u9875\u88c5\u4fee");
        useHomePage.setEfficientTotal(statistic.getEfficientTotalUseHomePage());
        useHomePage.setKeyIndex("");
        useHomePage.setCoverageRate(this.getPercentByTwoPrecision(statistic.getEfficientTotalUseHomePage(), orgTotal));
        useHomePage.setAverageUsers("");
        useHomePage.setTotal("");
        useHomePage.setRemarks("\u4f7f\u7528\u8fc7\u4e3b\u9875\u6a21\u677f");
        statisticDatas.add(useHomePage);
        ExportClientDemandDto UV = new ExportClientDemandDto();
        UV.setKeyFunctionName("\u4e3b\u9875\u6709\u6548");
        UV.setEfficientTotal(statistic.getEfficientTotalUV());
        UV.setCoverageRate(this.getPercentByTwoPrecision(statistic.getEfficientTotalUV(), orgTotal));
        if (statistic.getEfficientTotalUV() != 0) {
            UV.setAverageUsers(this.getAverageUsers(statistic.getUvTotal(), statistic.getEfficientTotalUV()));
        } else {
            UV.setAverageUsers("");
        }
        UV.setKeyIndex("\u4e3b\u9875\u8bbf\u95ee\u91cf(UV)");
        UV.setTotal(statistic.getUvTotal() + "");
        int uvTotalValid = this.getValidTotal(beforeDay, BIzConf.UV_TOTAL_VALID_7, BIzConf.UV_TOTAL_VALID_30);
        UV.setRemarks("\u4e3b\u9875\u8bbf\u95ee>=" + uvTotalValid);
        statisticDatas.add(UV);
        ExportClientDemandDto wechatAuthorizerOfStudent = new ExportClientDemandDto();
        wechatAuthorizerOfStudent.setKeyFunctionName("\u5b66\u751f\u7ed1\u5b9a\u4e2a\u4eba\u4e2d\u5fc3");
        wechatAuthorizerOfStudent.setEfficientTotal(statistic.getEfficientTotalWechatAuthorizerOfStudent());
        wechatAuthorizerOfStudent.setCoverageRate(this.getPercentByTwoPrecision(statistic.getEfficientTotalWechatAuthorizerOfStudent(), orgTotal));
        if (statistic.getEfficientTotalWechatAuthorizerOfStudent() != 0) {
            wechatAuthorizerOfStudent.setAverageUsers(this.getAverageUsers(statistic.getWechatAuthorizerOfStudentTotal(), statistic.getEfficientTotalWechatAuthorizerOfStudent()));
        } else {
            wechatAuthorizerOfStudent.setAverageUsers("");
        }
        wechatAuthorizerOfStudent.setKeyIndex("\u5b66\u751f\u7ed1\u5b9a\u4e2a\u4eba\u4e2d\u5fc3\u4eba\u6570");
        wechatAuthorizerOfStudent.setTotal(statistic.getWechatAuthorizerOfStudentTotal() + "");
        wechatAuthorizerOfStudent.setRemarks("\u603b\u91cf\u4e3a\u622a\u81f3\u76ee\u524d\u603b\u4eba\u6570");
        statisticDatas.add(wechatAuthorizerOfStudent);
        ExportClientDemandDto orgCall = new ExportClientDemandDto();
        orgCall.setKeyFunctionName("400\u7535\u8bdd\u547c\u51fa");
        orgCall.setEfficientTotal(statistic.getEfficientTotalorgCallRecordCount());
        orgCall.setCoverageRate(this.getPercentByTwoPrecision(statistic.getEfficientTotalorgCallRecordCount(), orgTotal));
        if (statistic.getEfficientTotalorgCallRecordCount() != 0) {
            orgCall.setAverageUsers(this.getAverageUsers(statistic.getOrgCallRecordCount(), statistic.getEfficientTotalorgCallRecordCount()));
        } else {
            orgCall.setAverageUsers("");
        }
        orgCall.setKeyIndex("400\u7535\u8bdd\u547c\u51fa\u91cf");
        orgCall.setTotal(statistic.getOrgCallRecordCount() + "");
        orgCall.setRemarks("\u4f7f\u7528\u8fc7400\u7535\u8bdd");
        statisticDatas.add(orgCall);
        return statisticDatas;
    }

    private String getPercentByTwoPrecision(int num1, int num2) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(2);
        String result = numberFormat.format((float)num1 / (float)num2 * 100.0f);
        return result + "%";
    }

    private String getAverageUsers(double num1, double num2) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(0);
        double data = num1 / num2;
        data = Math.ceil(data);
        String result = numberFormat.format(data);
        return result;
    }

    private StatisticByWeekOrMonthDto getStatisticByWeekOrMonthDto(List<ExportDto> exportDtos, int beforeDay) {
        StatisticByWeekOrMonthDto statistic = new StatisticByWeekOrMonthDto();
        for (ExportDto exportDto : exportDtos) {
            int loginValid = this.getValidTotal(beforeDay, BIzConf.LOGIN_VALID_7, BIzConf.LOGIN_VALID_30);
            if (exportDto.getLoginTotal() >= loginValid) {
                statistic.setEfficientTotalLogin(statistic.getEfficientTotalLogin() + 1);
                statistic.setLoginTotal(statistic.getLoginTotal() + exportDto.getLoginTotal());
            }
            if (exportDto.getBacklogFinish() != 0) {
                statistic.setEfficientTotalFinish(statistic.getEfficientTotalFinish() + 1);
            }
            statistic.setBacklogFinish(statistic.getBacklogFinish() + exportDto.getBacklogFinish());
            int wechatClueValid = this.getValidTotal(beforeDay, BIzConf.WECHAT_CLUE_VALID_7, BIzConf.WECHAT_CLUE_VALID_30);
            if (exportDto.getClueWechat() >= wechatClueValid) {
                statistic.setEfficientTotalClueWechat(statistic.getEfficientTotalClueWechat() + 1);
                statistic.setClueWechat(statistic.getClueWechat() + exportDto.getClueWechat());
            }
            int clueValid = this.getValidTotal(beforeDay, BIzConf.CLUERESERVE_VALID_7, BIzConf.CLUERESERVE_VALID_30);
            if (exportDto.getClueReserve() >= clueValid) {
                statistic.setEfficientTotalClueReserv(statistic.getEfficientTotalClueReserv() + 1);
                statistic.setClueReserve(statistic.getClueReserve() + exportDto.getClueReserve());
            }
            int studentValid = this.getValidTotal(beforeDay, BIzConf.STUDENT_TOTAL_VALID_7, BIzConf.STUDENT_TOTAL_VALID_30);
            if (exportDto.getStudentTotal() >= studentValid) {
                statistic.setEfficientTotalStudent(statistic.getEfficientTotalStudent() + 1);
                statistic.setStudentTotal(statistic.getStudentTotal() + exportDto.getStudentTotal());
            }
            if (exportDto.getIsWechatAuthorizer()) {
                statistic.setEfficientTotalWechatAuthorizer(statistic.getEfficientTotalWechatAuthorizer() + 1);
                statistic.setWechatFansTotal(statistic.getWechatFansTotal() + exportDto.getWechatFansTotal());
            }
            int courseValid = this.getValidTotal(beforeDay, BIzConf.COURSE_TOTAL_VALID_7, BIzConf.COURSE_TOTAL_VALID_30);
            if (exportDto.getCourseTotal() >= courseValid) {
                statistic.setEfficientTotalCourse(statistic.getEfficientTotalCourse() + 1);
                statistic.setCourseTotal(statistic.getCourseTotal() + exportDto.getCourseTotal());
            }
            int arrangedClassValid = this.getValidTotal(beforeDay, BIzConf.ARRANGE_CLASS_TOTAL_VALID_7, BIzConf.ARRANGE_CLASS_TOTAL_VALID_30);
            if (exportDto.getArrangedClassTotal() >= arrangedClassValid) {
                statistic.setEfficientTotalArrangedClassTotal(statistic.getEfficientTotalArrangedClassTotal() + 1);
                statistic.setArrangedClassTotal(statistic.getArrangedClassTotal() + exportDto.getArrangedClassTotal());
            }
            int courseSmsValid = this.getValidTotal(beforeDay, BIzConf.COURSESMS_TOTAL_VALID_7, BIzConf.COURSESMS_TOTAL_VALID_30);
            if (exportDto.getCourseSmsTotal() >= courseSmsValid) {
                statistic.setEfficientTotalCourseSms(statistic.getEfficientTotalCourseSms() + 1);
                statistic.setCourseSmsTotal(statistic.getCourseSmsTotal() + exportDto.getCourseSmsTotal());
            }
            int incomeSumValid = this.getValidTotal(beforeDay, BIzConf.INCOMESUM_VALID_7, BIzConf.INCOMESUM_VALID_30);
            if (exportDto.getIncomeSum() > (double)incomeSumValid) {
                statistic.setEfficientTotalIncomeSum(statistic.getEfficientTotalIncomeSum() + 1);
                statistic.setIncomeSum(statistic.getIncomeSum() + (double)((int)Math.ceil(exportDto.getIncomeSum())));
            }
            int signLessonValid = this.getValidTotal(beforeDay, BIzConf.SIGN_LESSON_VALID_7, BIzConf.SIGN_LESSON_VALID_30);
            if (exportDto.getSignLessonTotal() >= signLessonValid) {
                statistic.setEfficientTotalSign(statistic.getEfficientTotalSign() + 1);
                statistic.setSignStudentTotal(statistic.getSignStudentTotal() + exportDto.getSignStudentTotal());
            }
            int teacherCommentValid = this.getValidTotal(beforeDay, BIzConf.TEACHER_COMMENT_VALID_7, BIzConf.TEACHER_COMMENT_VALID_30);
            if (exportDto.getCommentByTeacher() >= teacherCommentValid) {
                statistic.setEfficientTotalCommentByTeacher(statistic.getEfficientTotalCommentByTeacher() + 1);
                statistic.setCommentByTeacher(statistic.getCommentByTeacher() + exportDto.getCommentByTeacher());
            }
            statistic.setCommentByStudent(statistic.getCommentByStudent() + exportDto.getCommentByStudent());
            int activityTotalValid = this.getValidTotal(beforeDay, BIzConf.ACTIVITY_TOTAL_VALID_7, BIzConf.ACTIVITY_TOTAL_VALID_30);
            if (exportDto.getActivityTotal() >= activityTotalValid) {
                statistic.setEfficientTotalActivity(statistic.getEfficientTotalActivity() + 1);
                statistic.setActivityAccessTotal(statistic.getActivityAccessTotal() + exportDto.getActivityAccessTotal());
            }
            int drawTotalValid = this.getValidTotal(beforeDay, BIzConf.DRAW_AVTIVITY_TOTAL_VALID_7, BIzConf.DRAW_AVTIVITY_TOTAL_VALID_30);
            if (exportDto.getDrawActivityTotal() >= drawTotalValid) {
                statistic.setEfficientTotalDrawActivity(statistic.getEfficientTotalDrawActivity() + 1);
                statistic.setDrawUserTotal(statistic.getDrawUserTotal() + exportDto.getDrawUserTotal());
            }
            int voteTotalValid = this.getValidTotal(beforeDay, BIzConf.VOTE_AVTIVITY_TOTAL_VALID_7, BIzConf.VOTE_AVTIVITY_TOTAL_VALID_30);
            if (exportDto.getVoteActivityTotal() >= voteTotalValid) {
                statistic.setEfficientTotalvoteActivity(statistic.getEfficientTotalvoteActivity() + 1);
                statistic.setVoteAccessTotal(statistic.getVoteAccessTotal() + exportDto.getVoteAccessTotal());
            }
            int referralTotalValid = this.getValidTotal(beforeDay, BIzConf.REFERRAL_ACTIVITY_VALID_7, BIzConf.REFERRAL_ACTIVITY_VALID_30);
            if (exportDto.getReferralActivityTotal() >= referralTotalValid) {
                statistic.setEfficientTotalReferralActivity(statistic.getEfficientTotalReferralActivity() + 1);
                statistic.setReferralAccessTotal(statistic.getReferralAccessTotal() + exportDto.getReferralAccessTotal());
            }
            int groupMsgValid = this.getValidTotal(beforeDay, BIzConf.GROUP_MESSAGE_TOTAL_VALID_7, BIzConf.GROUP_MESSAGE_TOTAL_VALID_30);
            if (exportDto.getGroupMsgTotal() >= groupMsgValid) {
                statistic.setEfficientTotalGroupMsg(statistic.getEfficientTotalGroupMsg() + 1);
                statistic.setGroupMsgTotal(statistic.getGroupMsgTotal() + exportDto.getGroupMsgTotal());
            }
            if (exportDto.getIsUseHomePage()) {
                statistic.setEfficientTotalUseHomePage(statistic.getEfficientTotalUseHomePage() + 1);
            }
            int uvTotalValid = this.getValidTotal(beforeDay, BIzConf.UV_TOTAL_VALID_7, BIzConf.UV_TOTAL_VALID_30);
            if (exportDto.getUvTotal() >= uvTotalValid) {
                statistic.setEfficientTotalUV(statistic.getEfficientTotalUV() + 1);
                statistic.setUvTotal(statistic.getUvTotal() + exportDto.getUvTotal());
            }
            if (exportDto.getWechatAuthorizerOfStudentTotal() != 0) {
                statistic.setEfficientTotalWechatAuthorizerOfStudent(statistic.getEfficientTotalWechatAuthorizerOfStudent() + 1);
            }
            statistic.setWechatAuthorizerOfStudentTotal(statistic.getWechatAuthorizerOfStudentTotal() + exportDto.getWechatAuthorizerOfStudentTotal());
            if (exportDto.getOrgCallRecordCount() < 1) continue;
            statistic.setEfficientTotalorgCallRecordCount(statistic.getEfficientTotalorgCallRecordCount() + 1);
            statistic.setOrgCallRecordCount(statistic.getOrgCallRecordCount() + exportDto.getOrgCallRecordCount());
        }
        return statistic;
    }

    private int getValidTotal(int dayNum, int data7, int data30) {
        int result = 0;
        result = dayNum == 7 ? data7 : data30;
        return result;
    }

    public static void main(String[] args) {
        HagTianxiaoOrgNumber.getOrgNumbers();
    }

    @Override
    public void getMonitorData(Date startTime, Date endTime) {
        Integer activityUserTotal;
        Integer activityTotal;
        ExportDto exportDto;
        List<Integer> TianxiaoOrgNumbers = HagTianxiaoOrgNumber.getOrgNumbers();
        log.info("taixiao\u673a\u6784\u8d26\u53f7\u5217\u8868\u957f\u5ea6==================" + TianxiaoOrgNumbers.size());
        List<Long> TianxiaoOrgIds = this.getTianxiaoOrgIds(TianxiaoOrgNumbers);
        Map txMonitorTypeDayMap = this.txMonitorTypeDayDao.mapUseMonitorType(startTime, endTime, TianxiaoOrgNumbers);
        Map consultTotalMap = this.messageDao.getConsultTotalMap(startTime, endTime, TianxiaoOrgNumbers);
        Map studentTotalMap = this.orgStudentDao.getStudentTotalMap(startTime, endTime, TianxiaoOrgIds);
        Map courseTotalMap = this.orgCourseDao.getCourseTotalMap(startTime, endTime, TianxiaoOrgNumbers);
        Map activityIdsMap = this.activityDao.getActivityIdByOrgIds(TianxiaoOrgIds, null, null);
        ArrayList activityIds = new ArrayList();
        if (GenericsUtils.notNullAndEmpty((Object)activityIdsMap)) {
            for (Long orgId : activityIdsMap.keySet()) {
                List ids = (List)activityIdsMap.get(orgId);
                if (!GenericsUtils.notNullAndEmpty((Object)ids)) continue;
                activityIds.addAll(ids);
            }
        }
        Map activityTotalMap = this.activityAccessLogDao.getActivityAccessLogTotalMap(activityIds, Integer.valueOf(TemplateTypeCategory.COMMON_TYPE.getType()), startTime, endTime);
        Map activityUserTotalMap = this.activityUserDao.getUserTotalMap(activityIds, Integer.valueOf(TemplateTypeCategory.COMMON_TYPE.getType()), startTime, endTime);
        Map drawActivityIdsMap = this.drawActivityDao.getDrawActivitysByIds(TianxiaoOrgIds, null, null);
        ArrayList drawActivityIds = new ArrayList();
        if (GenericsUtils.notNullAndEmpty((Object)drawActivityIdsMap)) {
            for (Long orgId : drawActivityIdsMap.keySet()) {
                List ids = (List)drawActivityIdsMap.get(orgId);
                if (!GenericsUtils.notNullAndEmpty((Object)ids)) continue;
                drawActivityIds.addAll(ids);
            }
        }
        Map drawActivityTotalMap = this.activityAccessLogDao.getActivityAccessLogTotalMap(drawActivityIds, Integer.valueOf(TemplateTypeCategory.DRAW_TYPE.getType()), startTime, endTime);
        Map drawActivityUserTotalMap = this.activityUserDao.getUserTotalMap(drawActivityIds, Integer.valueOf(TemplateTypeCategory.DRAW_TYPE.getType()), startTime, endTime);
        Map voteActivityIdsMap = this.voteInfoDao.getVoteActivityIdsByOrgIds(TianxiaoOrgIds, null, null);
        ArrayList voteActivityIds = new ArrayList();
        if (GenericsUtils.notNullAndEmpty((Object)voteActivityIdsMap)) {
            for (Long orgId : voteActivityIdsMap.keySet()) {
                List ids = (List)voteActivityIdsMap.get(orgId);
                if (!GenericsUtils.notNullAndEmpty((Object)ids)) continue;
                voteActivityIds.addAll(ids);
            }
        }
        Map voteActivityTotalMap = this.activityAccessLogDao.getActivityAccessLogTotalMap(voteActivityIds, Integer.valueOf(TemplateTypeCategory.VOTE_TYPE.getType()), startTime, endTime);
        Map voteActivityUserTotalMap = this.activityUserDao.getUserTotalMap(voteActivityIds, Integer.valueOf(TemplateTypeCategory.VOTE_TYPE.getType()), startTime, endTime);
        Map referralActivityIdsMap = this.referralInfoDao.getReferralActivityIdsByOrgIds(TianxiaoOrgIds, null, null);
        ArrayList referralActivityIds = new ArrayList();
        if (GenericsUtils.notNullAndEmpty((Object)referralActivityIdsMap)) {
            for (Long orgId : referralActivityIdsMap.keySet()) {
                List ids = (List)referralActivityIdsMap.get(orgId);
                if (!GenericsUtils.notNullAndEmpty((Object)ids)) continue;
                referralActivityIds.addAll(ids);
            }
        }
        Map referralActivityTotalMap = this.activityAccessLogDao.getActivityAccessLogTotalMap(referralActivityIds, Integer.valueOf(TemplateTypeCategory.REFERRAL_TYPE.getType()), startTime, endTime);
        Map referralActivityUserTotalMap = this.activityUserDao.getUserTotalMap(referralActivityIds, Integer.valueOf(TemplateTypeCategory.REFERRAL_TYPE.getType()), startTime, endTime);
        HashMap<String, ExportDto> exportDtoMap = new HashMap<String, ExportDto>();
        for (String date : txMonitorTypeDayMap.keySet()) {
            TxMonitorTypeDay txMonitorTypeDay = (TxMonitorTypeDay)txMonitorTypeDayMap.get(date);
            exportDto = (ExportDto)exportDtoMap.get(date);
            if (exportDto == null) {
                exportDto = new ExportDto();
                exportDtoMap.put(date, exportDto);
                exportDto.setCurDate(date);
            }
            exportDto.setPvTotal(txMonitorTypeDay.getPv() == null ? 0 : txMonitorTypeDay.getPv());
            exportDto.setUvTotal(txMonitorTypeDay.getUv() == null ? 0 : txMonitorTypeDay.getUv());
        }
        for (String date : consultTotalMap.keySet()) {
            Integer consultTotal = (Integer)consultTotalMap.get(date);
            exportDto = (ExportDto)exportDtoMap.get(date);
            if (exportDto == null) {
                log.info("");
                exportDto = new ExportDto();
                exportDtoMap.put(date, exportDto);
                exportDto.setCurDate(date);
            }
            exportDto.setClueTotal(consultTotal == null ? 0 : consultTotal);
        }
        for (String date : studentTotalMap.keySet()) {
            Integer studentTotal = (Integer)studentTotalMap.get(date);
            exportDto = (ExportDto)exportDtoMap.get(date);
            if (exportDto == null) {
                exportDto = new ExportDto();
                exportDtoMap.put(date, exportDto);
                exportDto.setCurDate(date);
            }
            exportDto.setStudentTotal(studentTotal == null ? 0 : studentTotal);
        }
        for (String date : courseTotalMap.keySet()) {
            Integer courseTotal = (Integer)courseTotalMap.get(date);
            exportDto = (ExportDto)exportDtoMap.get(date);
            if (exportDto == null) {
                exportDto = new ExportDto();
                exportDtoMap.put(date, exportDto);
                exportDto.setCurDate(date);
            }
            exportDto.setCourseTotal(courseTotal == null ? 0 : courseTotal);
        }
        for (String date : activityTotalMap.keySet()) {
            activityTotal = (Integer)activityTotalMap.get(date);
            log.info("date========" + date + "\u5fae\u6d3b\u52a8\u8bbf\u95ee\u91cf" + activityTotal);
            exportDto = (ExportDto)exportDtoMap.get(date);
            if (exportDto == null) {
                exportDto = new ExportDto();
                exportDtoMap.put(date, exportDto);
                exportDto.setCurDate(date);
            }
            exportDto.setActivityTotal((activityTotal = Integer.valueOf(exportDto.getActivityTotal() + activityTotal)) == null ? 0 : activityTotal);
        }
        for (String date : drawActivityTotalMap.keySet()) {
            activityTotal = (Integer)drawActivityTotalMap.get(date);
            log.info("date========" + date + "\u62bd\u5956\u6d3b\u52a8\u8bbf\u95ee\u91cf" + activityTotal);
            exportDto = (ExportDto)exportDtoMap.get(date);
            if (exportDto == null) {
                exportDto = new ExportDto();
                exportDtoMap.put(date, exportDto);
                exportDto.setCurDate(date);
            }
            exportDto.setActivityTotal((activityTotal = Integer.valueOf(exportDto.getActivityTotal() + activityTotal)) == null ? 0 : activityTotal);
        }
        for (String date : voteActivityTotalMap.keySet()) {
            activityTotal = (Integer)voteActivityTotalMap.get(date);
            log.info("date========" + date + "toupiao\u6d3b\u52a8\u8bbf\u95ee\u91cf" + activityTotal);
            exportDto = (ExportDto)exportDtoMap.get(date);
            if (exportDto == null) {
                exportDto = new ExportDto();
                exportDtoMap.put(date, exportDto);
                exportDto.setCurDate(date);
            }
            exportDto.setActivityTotal((activityTotal = Integer.valueOf(exportDto.getActivityTotal() + activityTotal)) == null ? 0 : activityTotal);
        }
        for (String date : referralActivityTotalMap.keySet()) {
            activityTotal = (Integer)referralActivityTotalMap.get(date);
            log.info("date========" + date + "referral\u6d3b\u52a8\u8bbf\u95ee\u91cf" + activityTotal);
            exportDto = (ExportDto)exportDtoMap.get(date);
            if (exportDto == null) {
                exportDto = new ExportDto();
                exportDtoMap.put(date, exportDto);
                exportDto.setCurDate(date);
            }
            exportDto.setActivityTotal((activityTotal = Integer.valueOf(exportDto.getActivityTotal() + activityTotal)) == null ? 0 : activityTotal);
        }
        for (String date : activityUserTotalMap.keySet()) {
            activityUserTotal = (Integer)activityUserTotalMap.get(date);
            log.info("date========" + date + "\u5fae\u6d3b\u52a8\u53c2\u4e0e\u91cf" + activityUserTotal);
            exportDto = (ExportDto)exportDtoMap.get(date);
            if (exportDto == null) {
                exportDto = new ExportDto();
                exportDtoMap.put(date, exportDto);
                exportDto.setCurDate(date);
            }
            exportDto.setDrawUserTotal((activityUserTotal = Integer.valueOf(exportDto.getDrawUserTotal() + activityUserTotal)) == null ? 0 : activityUserTotal);
        }
        for (String date : drawActivityUserTotalMap.keySet()) {
            activityUserTotal = (Integer)drawActivityUserTotalMap.get(date);
            log.info("date========" + date + "\u62bd\u5956\u6d3b\u52a8\u53c2\u4e0e\u91cf" + activityUserTotal);
            exportDto = (ExportDto)exportDtoMap.get(date);
            if (exportDto == null) {
                exportDto = new ExportDto();
                exportDtoMap.put(date, exportDto);
                exportDto.setCurDate(date);
            }
            exportDto.setDrawUserTotal((activityUserTotal = Integer.valueOf(exportDto.getDrawUserTotal() + activityUserTotal)) == null ? 0 : activityUserTotal);
        }
        for (String date : voteActivityUserTotalMap.keySet()) {
            activityUserTotal = (Integer)voteActivityUserTotalMap.get(date);
            log.info("date========" + date + "toupiao\u6d3b\u52a8\u53c2\u4e0e\u91cf" + activityUserTotal);
            exportDto = (ExportDto)exportDtoMap.get(date);
            if (exportDto == null) {
                exportDto = new ExportDto();
                exportDtoMap.put(date, exportDto);
                exportDto.setCurDate(date);
            }
            exportDto.setDrawUserTotal((activityUserTotal = Integer.valueOf(exportDto.getDrawUserTotal() + activityUserTotal)) == null ? 0 : activityUserTotal);
        }
        for (String date : referralActivityUserTotalMap.keySet()) {
            activityUserTotal = (Integer)referralActivityUserTotalMap.get(date);
            log.info("date========" + date + "toupiao\u6d3b\u52a8\u53c2\u4e0e\u91cf" + activityUserTotal);
            exportDto = (ExportDto)exportDtoMap.get(date);
            if (exportDto == null) {
                exportDto = new ExportDto();
                exportDtoMap.put(date, exportDto);
                exportDto.setCurDate(date);
            }
            exportDto.setDrawUserTotal((activityUserTotal = Integer.valueOf(exportDto.getDrawUserTotal() + activityUserTotal)) == null ? 0 : activityUserTotal);
        }
        ArrayList rows = new ArrayList();
        for (String date : exportDtoMap.keySet()) {
            log.info("exportDtoMap=========changduwei======" + exportDtoMap.size());
            exportDto = (ExportDto)exportDtoMap.get(date);
            LinkedHashMap<String, String> rowMap = new LinkedHashMap<String, String>();
            rowMap.put("\u65e5\u671f", exportDto.getCurDate());
            rowMap.put("\u65b0\u589e\u7ebf\u7d22", exportDto.getClueTotal() + "");
            rowMap.put("\u65b0\u589e\u5b66\u5458", exportDto.getStudentTotal() + "");
            rowMap.put("\u673a\u6784\u4e3b\u9875UV", exportDto.getUvTotal() + "");
            rowMap.put("\u673a\u6784\u4e3b\u9875PV", exportDto.getPvTotal() + "");
            rowMap.put("\u65b0\u589e\u5fae\u8bfe\u6570\u91cf", exportDto.getCourseTotal() + "");
            rowMap.put("\u6d3b\u52a8PV", exportDto.getActivityTotal() + "");
            rowMap.put("\u6d3b\u52a8UV", exportDto.getDrawUserTotal() + "");
            rows.add(rowMap);
        }
        String subject = "\u673a\u6784\u4e3b\u9875\u8bbf\u95ee\u4fe1\u606f(2016-03~2016-04)";
        String content = "";
        String mail = "gaodan@baijiahulian.com";
        String fileName = "orgInfo";
        ExcelMailSender.sendMail((String)mail, (String)subject, (String)content, (String)fileName, rows);
    }
}

