/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.marketing.activity.service.impl;

import com.baijia.tianxiao.biz.marketing.activity.service.BizActivityService;
import com.baijia.tianxiao.biz.marketing.utils.PictureUtil;
import com.baijia.tianxiao.dal.activity.dao.ActivityConfDao;
import com.baijia.tianxiao.dal.activity.dao.ActivityDao;
import com.baijia.tianxiao.dal.activity.dao.EnrollDao;
import com.baijia.tianxiao.dal.activity.po.Activity;
import com.baijia.tianxiao.dal.activity.po.ActivityConf;
import com.baijia.tianxiao.sal.marketing.activity.dto.ActivityDetailDto;
import com.baijia.tianxiao.sal.marketing.activity.dto.ActivityEnrollDto;
import com.baijia.tianxiao.sal.marketing.activity.dto.ActivityRenderDto;
import com.baijia.tianxiao.sal.marketing.activity.dto.ActivitySearchRequest;
import com.baijia.tianxiao.sal.marketing.activity.dto.ResultWrapper;
import com.baijia.tianxiao.sal.marketing.activity.dto.ShareDto;
import com.baijia.tianxiao.sal.marketing.activity.service.ActivityService;
import com.baijia.tianxiao.sal.marketing.activity.service.EnrollService;
import com.baijia.tianxiao.sal.marketing.commons.constants.Config;
import com.baijia.tianxiao.sal.marketing.commons.enums.ConstantEnums;
import com.baijia.tianxiao.sal.marketing.commons.enums.EmailType;
import com.baijia.tianxiao.sal.marketing.commons.enums.ResultType;
import com.baijia.tianxiao.sal.marketing.commons.service.RedisService;
import com.baijia.tianxiao.sal.marketing.commons.utils.AttachBean;
import com.baijia.tianxiao.sal.marketing.commons.utils.CsvUtils;
import com.baijia.tianxiao.sal.marketing.commons.utils.Mail;
import com.baijia.tianxiao.sal.marketing.commons.utils.MailSendExecutor;
import com.baijia.tianxiao.sal.marketing.commons.utils.MailUtils;
import com.baijia.tianxiao.sal.organization.org.dto.OrgInfoSimpleDto;
import com.baijia.tianxiao.sal.organization.org.service.OrgInfoService;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.date.DateUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.mail.Session;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BizActivityServiceImpl
implements BizActivityService {
    private static final Logger log = LoggerFactory.getLogger(BizActivityServiceImpl.class);
    @Autowired
    private OrgInfoService orgInfoService;
    @Autowired
    private EnrollService enrollService;
    @Autowired
    private RedisService redisService;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private EnrollDao enrollDao;
    @Autowired
    private ActivityDao activityDao;
    @Autowired
    private ActivityConfDao activityConfDao;

    @Override
    public ActivityRenderDto renderActivity(Long activityId, Integer orgId) {
        if (activityId == null) {
            return null;
        }
        Activity activity = this.activityDao.getActivityByIdAndOrgId(activityId, orgId);
        if (activity == null) {
            return null;
        }
        Map confMap = this.activityConfDao.getConfigMapByActivityIds(Arrays.asList(activityId));
        ActivityDetailDto tempDto = new ActivityDetailDto();
        if (activity != null && confMap != null) {
            tempDto = confMap.get(activityId) != null ? ActivityDetailDto.buildResponse((Activity)activity, (ActivityConf)((ActivityConf)confMap.get(activityId))) : ActivityDetailDto.buildResponse((Activity)activity);
        }
        ActivityRenderDto dto = new ActivityRenderDto();
        try {
            BeanUtils.copyProperties((Object)dto, (Object)tempDto);
            int enrollCount = this.enrollDao.getEnrollCount(activityId.longValue());
            dto.setEnrollCount(enrollCount);
            OrgInfoSimpleDto simple = this.orgInfoService.getOrgInfo(Long.valueOf(activity.getOrgId().intValue()));
            dto.setOrgLogo(simple.getLogo());
            dto.setOrgName(simple.getShortName());
        }
        catch (Exception e) {
            log.error("renderActivity error!", (Throwable)e);
        }
        return dto;
    }

    @Override
    public ResultWrapper<String> sendEmail(ActivitySearchRequest request) {
        log.info(" begin to send mail ");
        Long orgId = request.getOrgId();
        Long activityId = request.getId();
        ResultWrapper rr = new ResultWrapper();
        rr.setRetType(ResultType.FAIL);
        rr.setRetDesc("\u53c2\u6570\u5f02\u5e38");
        OrgInfoSimpleDto simple = null;
        try {
            simple = this.orgInfoService.getOrgInfo(orgId);
        }
        catch (Exception e) {
            log.info("can not find an org with org_ID {}", (Object)orgId);
            return rr;
        }
        final String orgName = simple.getShortName();
        final ActivityDetailDto activityDetail = this.activityService.getActivityDetail(request);
        if (activityDetail == null) {
            log.info("can not find activityDetial with id : {} ", (Object)request.getId());
            return rr;
        }
        final List enrollList = this.enrollService.getEnrollList(request.getId().longValue(), null);
        if (GenericsUtils.isNullOrEmpty((Object)enrollList)) {
            log.info(" enroll is empty  ");
            return rr;
        }
        log.info("can send mail ");
        boolean isNotLimited = this.redisService.addOrgEmailCount(orgId.longValue(), activityId.longValue(), activityDetail.getTemplateTypeId(), EmailType.ACCESS);
        if (!isNotLimited) {
            log.info("\u6b21\u6570\u5df2\u8fbe\u4e0a\u9650\uff0c\u8bf7\u660e\u5929\u518d\u53d1");
            return ResultWrapper.getInstance((boolean)false).setRetDesc("\u4eca\u65e5\u5df2\u53d1\u9001" + ConstantEnums.EMAIL_COUNT_LIMIT.value() + "\u6b21\uff0c\u8bf7\u660e\u65e5\u518d\u8bd5");
        }
        final String email = request.getEmail();
        MailSendExecutor.execute((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                File csvFile = null;
                try {
                    Mail mail = new Mail();
                    String from = ConstantEnums.MAILBOX_FROM.value();
                    String host = ConstantEnums.MAILBOX_SMTPSERVIER.value();
                    String username = ConstantEnums.MAILBOX_USERNAME.value();
                    String password = ConstantEnums.MAILBOX_PASSWORD.value();
                    String subject = ConstantEnums.MAILBOX_SUBJECT.value();
                    String content = ConstantEnums.MAILBOX_CONTENT.value();
                    content = content.replace("{#ORG_NAME#}", orgName);
                    mail.setFrom(from);
                    mail.setContent(content);
                    mail.addToAddress(email);
                    mail.setSubject(subject);
                    CsvUtils.CsvContent csvContent = BizActivityServiceImpl.this.getCsvFileContent(activityDetail, enrollList);
                    try {
                        String filename = activityDetail.getId() + "_" + DateUtil.getStrByDate((Date)new Date()) + ".csv";
                        csvFile = CsvUtils.writerToCsvFile(null, (CsvUtils.CsvContent)csvContent, (String)filename);
                        if (csvFile == null) {
                            log.info("csvFile is null ");
                        }
                        log.info("csvFile path is : {}", (Object)csvFile.getAbsolutePath());
                        if (csvFile.exists()) {
                            AttachBean fileAttach = new AttachBean();
                            fileAttach.setCid(csvFile.getName());
                            fileAttach.setFile(csvFile);
                            fileAttach.setFileName(csvFile.getName());
                            mail.addAttach(fileAttach);
                        }
                    }
                    catch (Exception e) {
                        log.error("error :", (Throwable)e);
                    }
                    Session session = null;
                    session = GenericsUtils.notNullAndEmpty((Object)username) && GenericsUtils.notNullAndEmpty((Object)password) ? MailUtils.createSession((String)host, (String)username, (String)password) : MailUtils.createSession((String)host);
                    MailUtils.send((Session)session, (Mail)mail);
                    log.info("send successful");
                }
                catch (Exception ex) {
                    log.error("can not send email cause by {}", (Throwable)ex);
                }
                finally {
                    if (csvFile != null) {
                        csvFile.delete();
                    }
                }
            }
        });
        return ResultWrapper.getInstance((boolean)true).setRetDesc("\u53d1\u9001\u6210\u529f");
    }

    private CsvUtils.CsvContent getCsvFileContent(ActivityDetailDto activityDetail, List<ActivityEnrollDto> enrollList) {
        String activityName = activityDetail.getName();
        CsvUtils.CsvContent csvContent = new CsvUtils.CsvContent();
        String headRow = "\u6d3b\u52a8\u540d\u79f0:" + activityName;
        csvContent.addRowBean(CsvUtils.RowBean.createRowType((String)headRow));
        String[] heads = "\u59d3\u540d,\u7535\u8bdd,\u5176\u4ed6,\u62a5\u540d\u65f6\u95f4".split(",");
        ArrayList<String> rowLists = new ArrayList<String>();
        for (ActivityEnrollDto aed : enrollList) {
            StringBuilder sb = new StringBuilder();
            sb.append(aed.getName()).append(",").append(aed.getMobile()).append(",");
            List<String> otherInfos = this.getOtherInfosFromJson(String.valueOf(aed.getContent()));
            if (GenericsUtils.notNullAndEmpty(otherInfos)) {
                for (String info : otherInfos) {
                    sb.append(info).append("/");
                }
                sb.deleteCharAt(sb.toString().length() - 1);
            } else {
                sb.append("\u65e0");
            }
            sb.append(",").append(DateUtil.getStrByDateFormate((Date)new Date(aed.getCreateTime()), (String)"yyyy/MM/dd HH:mm:ss"));
            rowLists.add(sb.toString());
        }
        csvContent.addRowBean(CsvUtils.RowBean.createTableType((String[])heads, rowLists));
        return csvContent;
    }

    private List<String> getOtherInfosFromJson(String content) {
        return Arrays.asList(content.split(","));
    }

    @Override
    public ShareDto getShareInfo(long activityId, long orgId) {
        ShareDto dto = new ShareDto();
        Activity activity = this.activityDao.getActivityByIdAndOrgId(Long.valueOf(activityId), Long.valueOf(orgId));
        dto.setTitle(activity.getTitle());
        try {
            String logo = this.orgInfoService.getOrgInfo(Long.valueOf(activity.getOrgId().longValue())).getLogo();
            dto.setImageUrl(PictureUtil.handlePictureSize(logo));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        dto.setContent(this.getContent(activity.getTitle()));
        dto.setShareUrl(this.getUrl(activityId));
        return dto;
    }

    private String getContent(String name) {
        String str = "\u6211\u521a\u53c2\u52a0\u4e86\u8fd9\u4e2a\u5f88\u68d2\u7684\u6d3b\u52a8\uff0c\u9080\u60a8\u4e5f\u6765\u53c2\u52a0\u201c" + name + "\u201d\uff0c\u673a\u4f1a\u4e0d\u662f\u5929\u5929\u6709\uff0c\u8be5\u51fa\u624b\u65f6\u5c31\u51fa\u624b\u54e6...";
        return str;
    }

    private String getUrl(long activityId) {
        StringBuilder sb = new StringBuilder();
        sb.append(Config.DOMAIN);
        sb.append("/activity.html?activityId=").append(activityId);
        return sb.toString();
    }
}

