/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.marketing.export.service.impl;

import com.baijia.tianxiao.biz.marketing.export.dto.ERPStatisticData;
import com.baijia.tianxiao.biz.marketing.export.service.ERPStatisticService;
import com.baijia.tianxiao.dal.org.dao.CoursePurchaseDao;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseSmsDao;
import com.baijia.tianxiao.dal.org.dao.OrgFinanceAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgFinanceAccountRecordDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonCommentDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonSignDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.util.GenericsUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ERPStatisticServiceImpl
implements ERPStatisticService {
    private static final Logger log = LoggerFactory.getLogger(ERPStatisticServiceImpl.class);
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private OrgClassLessonDao orgClassLessonDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgCourseSmsDao orgCourseSmsDao;
    @Autowired
    private OrgLessonCommentDao OrgLessonCommentDao;
    @Autowired
    private OrgLessonSignDao orgLessonSignDao;
    @Autowired
    private OrgFinanceAccountRecordDao orgFinanceAccountRecordDao;
    @Autowired
    private CoursePurchaseDao coursePurchaseDao;
    @Autowired
    private OrgFinanceAccountDao OrgFinanceAccountDao;

    @Override
    public Map<Long, ERPStatisticData> getERPDatas(Date startTime, Date endTime, List<Integer> TianxiaoOrgNumbers, List<Long> TianxiaoOrgIds) {
        Map commentByTeachers;
        Map commentByStudents;
        Map cashPurchaseSums;
        Map signStudentTotals;
        Map signLessonTotals;
        Map incomeTotals;
        Map sumIncomeTotals;
        Map courseSmsTotals;
        Map lessonTotals;
        Map arrangedClassTotals;
        ERPStatisticData erpStatisticData;
        HashMap<Long, ERPStatisticData> ERPDataMap = new HashMap<Long, ERPStatisticData>();
        Map courseTotals = this.orgCourseDao.getCourseTotal(startTime, endTime, TianxiaoOrgNumbers);
        if (GenericsUtils.notNullAndEmpty((Object)courseTotals)) {
            Object orgNumber2;
            ArrayList<Integer> orgNumbers = new ArrayList<Integer>();
            for (Object orgNumber2 : courseTotals.keySet()) {
                orgNumbers.add((Integer)orgNumber2);
            }
            List orgAccounts = this.orgAccountDao.getAccountByNumbers(orgNumbers, new String[0]);
            orgNumber2 = orgAccounts.iterator();
            while (orgNumber2.hasNext()) {
                OrgAccount orgAccount = (OrgAccount)orgNumber2.next();
                Integer number = orgAccount.getNumber();
                Object orgId = orgAccount.getId().longValue();
                erpStatisticData = (ERPStatisticData)ERPDataMap.get(orgId);
                if (erpStatisticData == null) {
                    erpStatisticData = new ERPStatisticData();
                    ERPDataMap.put((Long)orgId, erpStatisticData);
                }
                erpStatisticData.setCourseTotal(courseTotals.get(number) == null ? 0 : (Integer)courseTotals.get(number));
            }
        }
        if (GenericsUtils.notNullAndEmpty((Object)(arrangedClassTotals = this.orgClassLessonDao.getArrangedClassCount(startTime, endTime, TianxiaoOrgIds)))) {
            for (Object orgId : arrangedClassTotals.keySet()) {
                ERPStatisticData erpStatisticData2 = (ERPStatisticData)ERPDataMap.get(orgId);
                if (erpStatisticData2 == null) {
                    erpStatisticData2 = new ERPStatisticData();
                    ERPDataMap.put((Long)orgId, erpStatisticData2);
                }
                erpStatisticData2.setArrangedClassTotal(arrangedClassTotals.get(orgId) == null ? 0 : (Integer)arrangedClassTotals.get(orgId));
            }
        }
        if (GenericsUtils.notNullAndEmpty((Object)(lessonTotals = this.orgClassLessonDao.getLessonTotal(startTime, endTime, TianxiaoOrgIds)))) {
            for (Object orgId : lessonTotals.keySet()) {
                ERPStatisticData erpStatisticData3 = (ERPStatisticData)ERPDataMap.get(orgId);
                if (erpStatisticData3 == null) {
                    erpStatisticData3 = new ERPStatisticData();
                    ERPDataMap.put((Long)orgId, erpStatisticData3);
                }
                erpStatisticData3.setLessonTotal(lessonTotals.get(orgId) == null ? 0 : (Integer)lessonTotals.get(orgId));
            }
        }
        if (GenericsUtils.notNullAndEmpty((Object)(courseSmsTotals = this.orgCourseSmsDao.courseSmsTotal(startTime, endTime, TianxiaoOrgIds)))) {
            for (Object orgId : courseSmsTotals.keySet()) {
                ERPStatisticData erpStatisticData4 = (ERPStatisticData)ERPDataMap.get(orgId);
                if (erpStatisticData4 == null) {
                    erpStatisticData4 = new ERPStatisticData();
                    ERPDataMap.put((Long)orgId, erpStatisticData4);
                }
                erpStatisticData4.setCourseSmsTotal(courseSmsTotals.get(orgId) == null ? 0 : (Integer)courseSmsTotals.get(orgId));
            }
        }
        if (GenericsUtils.notNullAndEmpty((Object)(sumIncomeTotals = this.orgFinanceAccountRecordDao.sumIncomeTotal(startTime, endTime, TianxiaoOrgIds)))) {
            for (Object orgId : sumIncomeTotals.keySet()) {
                erpStatisticData = (ERPStatisticData)ERPDataMap.get(orgId);
                if (erpStatisticData == null) {
                    erpStatisticData = new ERPStatisticData();
                    ERPDataMap.put((Long)orgId, erpStatisticData);
                }
                erpStatisticData.setIncomeSum(sumIncomeTotals.get(orgId) == null ? 0.0 : (Double)sumIncomeTotals.get(orgId));
            }
        }
        if (GenericsUtils.notNullAndEmpty((Object)(incomeTotals = this.coursePurchaseDao.getIncomeTotal(startTime, endTime, TianxiaoOrgIds)))) {
            for (Object orgId : incomeTotals.keySet()) {
                ERPStatisticData erpStatisticData5 = (ERPStatisticData)ERPDataMap.get(orgId);
                if (erpStatisticData5 == null) {
                    erpStatisticData5 = new ERPStatisticData();
                    ERPDataMap.put((Long)orgId, erpStatisticData5);
                }
                erpStatisticData5.setIncomeTotal(incomeTotals.get(orgId) == null ? 0 : (Integer)incomeTotals.get(orgId));
            }
        }
        if (GenericsUtils.notNullAndEmpty((Object)(signLessonTotals = this.orgLessonSignDao.getOrgSignLessonTotal(startTime, endTime, TianxiaoOrgIds)))) {
            for (Object orgId : signLessonTotals.keySet()) {
                ERPStatisticData erpStatisticData6 = (ERPStatisticData)ERPDataMap.get(orgId);
                if (erpStatisticData6 == null) {
                    erpStatisticData6 = new ERPStatisticData();
                    ERPDataMap.put((Long)orgId, erpStatisticData6);
                }
                erpStatisticData6.setSignLessonTotal(signLessonTotals.get(orgId) == null ? 0 : (Integer)signLessonTotals.get(orgId));
            }
        }
        if (GenericsUtils.notNullAndEmpty((Object)(signStudentTotals = this.orgLessonSignDao.getOrgSignStudentTotal(startTime, endTime, TianxiaoOrgIds)))) {
            for (Object orgId : signStudentTotals.keySet()) {
                ERPStatisticData erpStatisticData7 = (ERPStatisticData)ERPDataMap.get(orgId);
                if (erpStatisticData7 == null) {
                    erpStatisticData7 = new ERPStatisticData();
                    ERPDataMap.put((Long)orgId, erpStatisticData7);
                }
                erpStatisticData7.setSignStudentTotal(signStudentTotals.get(orgId) == null ? 0 : (Integer)signStudentTotals.get(orgId));
            }
        }
        if (GenericsUtils.notNullAndEmpty((Object)(cashPurchaseSums = this.OrgFinanceAccountDao.getcashPurchaseSum(TianxiaoOrgIds)))) {
            for (Object orgId : cashPurchaseSums.keySet()) {
                ERPStatisticData erpStatisticData8 = (ERPStatisticData)ERPDataMap.get(orgId);
                if (erpStatisticData8 == null) {
                    erpStatisticData8 = new ERPStatisticData();
                    ERPDataMap.put((Long)orgId, erpStatisticData8);
                }
                erpStatisticData8.setCashPurchaseSum(cashPurchaseSums.get(orgId) == null ? 0.0 : (Double)cashPurchaseSums.get(orgId));
            }
        }
        if (GenericsUtils.notNullAndEmpty((Object)(commentByStudents = this.OrgLessonCommentDao.getComment(2, startTime, endTime, TianxiaoOrgIds)))) {
            for (Long orgId : commentByStudents.keySet()) {
                ERPStatisticData erpStatisticData9 = (ERPStatisticData)ERPDataMap.get(orgId);
                if (erpStatisticData9 == null) {
                    erpStatisticData9 = new ERPStatisticData();
                    ERPDataMap.put(orgId, erpStatisticData9);
                }
                erpStatisticData9.setCommentByStudent(commentByStudents.get(orgId) == null ? 0 : (Integer)commentByStudents.get(orgId));
            }
        }
        if (GenericsUtils.notNullAndEmpty((Object)(commentByTeachers = this.OrgLessonCommentDao.getComment(0, startTime, endTime, TianxiaoOrgIds)))) {
            for (Long orgId : commentByTeachers.keySet()) {
                ERPStatisticData erpStatisticData10 = (ERPStatisticData)ERPDataMap.get(orgId);
                if (erpStatisticData10 == null) {
                    erpStatisticData10 = new ERPStatisticData();
                    ERPDataMap.put(orgId, erpStatisticData10);
                }
                erpStatisticData10.setCommentByTeacher(commentByTeachers.get(orgId) == null ? 0 : (Integer)commentByTeachers.get(orgId));
            }
        }
        return ERPDataMap;
    }
}

