/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.marketing.export.service.impl;

import com.baijia.tianxiao.biz.marketing.export.dto.ConsultMessageStatisticData;
import com.baijia.tianxiao.biz.marketing.export.service.ConsultMessageStatisticService;
import com.baijia.tianxiao.dal.push.dao.MessageDao;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConsultMessageStatisticServiceImpl
implements ConsultMessageStatisticService {
    private static final Logger log = LoggerFactory.getLogger(ConsultMessageStatisticServiceImpl.class);
    @Autowired
    private MessageDao messageDao;

    @Override
    public Map<Integer, ConsultMessageStatisticData> getConsultMessageData(Date startDate, Date endDate, List<Integer> TianxiaoOrgNumbers) {
        ConsultMessageStatisticData consultMessage;
        HashMap<Integer, ConsultMessageStatisticData> consultMessageDatas = new HashMap<Integer, ConsultMessageStatisticData>();
        Map leaveBillCountMap = this.messageDao.getConsultCountByType(startDate, endDate, 3, TianxiaoOrgNumbers);
        Map wechatCountMap = this.messageDao.getConsultCountByType(startDate, endDate, 2, TianxiaoOrgNumbers);
        Map callCountMap = this.messageDao.getConsultCountByType(startDate, endDate, 1, TianxiaoOrgNumbers);
        Map clueTotalCountMap = this.messageDao.getConsultTotal(startDate, endDate, TianxiaoOrgNumbers);
        for (Integer number : leaveBillCountMap.keySet()) {
            Integer leaveBillCount;
            consultMessage = (ConsultMessageStatisticData)consultMessageDatas.get(number);
            if (consultMessage == null) {
                consultMessage = new ConsultMessageStatisticData();
                consultMessageDatas.put(number, consultMessage);
            }
            consultMessage.setClueReserve((leaveBillCount = (Integer)leaveBillCountMap.get(number)) == null ? 0 : leaveBillCount);
        }
        for (Integer number : wechatCountMap.keySet()) {
            consultMessage = (ConsultMessageStatisticData)consultMessageDatas.get(number);
            if (consultMessage == null) {
                consultMessage = new ConsultMessageStatisticData();
                consultMessageDatas.put(number, consultMessage);
            }
            Integer wechatCount = (Integer)wechatCountMap.get(number);
            log.info("\u7ebf\u7d22\u5fae\u4fe1\u65b0\u589e\u4eba\u6570================" + wechatCount);
            consultMessage.setClueWechat(wechatCount == null ? 0 : wechatCount);
        }
        for (Integer number : callCountMap.keySet()) {
            Integer callCount;
            consultMessage = (ConsultMessageStatisticData)consultMessageDatas.get(number);
            if (consultMessage == null) {
                consultMessage = new ConsultMessageStatisticData();
                consultMessageDatas.put(number, consultMessage);
            }
            consultMessage.setClueCall((callCount = (Integer)callCountMap.get(number)) == null ? 0 : callCount);
        }
        for (Integer number : clueTotalCountMap.keySet()) {
            Integer clueTotal;
            consultMessage = (ConsultMessageStatisticData)consultMessageDatas.get(number);
            if (consultMessage == null) {
                consultMessage = new ConsultMessageStatisticData();
                consultMessageDatas.put(number, consultMessage);
            }
            consultMessage.setClueTotal((clueTotal = (Integer)clueTotalCountMap.get(number)) == null ? 0 : clueTotal);
        }
        return consultMessageDatas;
    }
}

