/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.assignment.sal.thirdpart.util;

import com.baijia.doorgod.dto.RestfulResult;
import com.baijia.doorgod.utils.CommonUtils;
import com.baijia.tianxiao.assignment.common.enums.AssignmentErrorCode;
import com.baijia.tianxiao.assignment.common.errorcode.UniverseErrorCode;
import com.baijia.tianxiao.assignment.common.exception.BusinessException;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;
import com.beust.jcommander.internal.Lists;
import java.util.Collection;
import java.util.Map;
import net.sf.json.JSONArray;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThirdCallUtil {
    private static final Logger log = LoggerFactory.getLogger(ThirdCallUtil.class);

    public static <T> Collection<T> callReturnListData(CommonUtils.RestMethod request, String callUrl, String controller, String method, Map<String, String> params, Class<T> valueType) throws Exception {
        RestfulResult<T> result = ThirdCallUtil.rest(callUrl, controller, method, params);
        if (result.getCode() != 1) {
            JSONArray jsonArray = JSONArray.fromObject((Object)result.getData());
            Collection classinfos = JSONArray.toCollection((JSONArray)jsonArray, valueType);
            return classinfos;
        }
        return Lists.newArrayList();
    }

    public static <T> T callReturnData(CommonUtils.RestMethod request, String callUrl, String controller, String method, Map<String, String> params, Class<T> valueType) throws Exception {
        RestfulResult result = CommonUtils.rest((CommonUtils.RestMethod)request, (String)callUrl, (String)controller, (String)method, null, params, valueType);
        return (T)result.getData();
    }

    public static <T> RestfulResult<T> rest(String baseUrl, String controller, String method, Map<String, String> params) {
        RestfulResult result = null;
        try {
            StringBuilder loginUrl = new StringBuilder();
            loginUrl.append(baseUrl);
            loginUrl.append("/").append(controller);
            loginUrl.append("/").append(method);
            log.debug("request url ={},param={}", (Object)loginUrl.toString(), params);
            String resultJson = HttpClientUtils.doGet((String)loginUrl.toString(), params, (String)"UTF-8");
            ObjectMapper mapper = new ObjectMapper();
            log.info("rest.resultJson:{}", (Object)resultJson);
            mapper.disable(new DeserializationConfig.Feature[]{DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES});
            if (StringUtils.isNotBlank((CharSequence)resultJson) && !resultJson.equals("null")) {
                result = (RestfulResult)mapper.readValue(resultJson, RestfulResult.class);
            } else {
                result = new RestfulResult();
                result.setCode(1);
                result.setMsg("\u8fd4\u56de\u4fe1\u606f\u5f02\u5e38");
            }
        }
        catch (Exception e) {
            log.info("httpclient catch {}", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)AssignmentErrorCode.SYSTEM_ERROR, "502\uff0cerp\u6302\u4e86");
        }
        log.info("-------------------------");
        return result;
    }
}

