/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.assignment.sal.thirdpart.service.impl;

import com.baijia.doorgod.dto.RestfulResult;
import com.baijia.doorgod.utils.CommonUtils;
import com.baijia.tianxiao.assignment.common.constants.BizConf;
import com.baijia.tianxiao.assignment.common.enums.AssignmentErrorCode;
import com.baijia.tianxiao.assignment.common.errorcode.UniverseErrorCode;
import com.baijia.tianxiao.assignment.common.exception.BusinessException;
import com.baijia.tianxiao.assignment.common.model.BaseLoginUser;
import com.baijia.tianxiao.assignment.common.util.BaseLoginUtil;
import com.baijia.tianxiao.assignment.common.util.BaseUtils;
import com.baijia.tianxiao.assignment.sal.thirdpart.constants.AssignmentThirdUrl;
import com.baijia.tianxiao.assignment.sal.thirdpart.dto.StudentInfo;
import com.baijia.tianxiao.assignment.sal.thirdpart.dto.Userinfo;
import com.baijia.tianxiao.assignment.sal.thirdpart.service.StudentInfoService;
import com.baijia.tianxiao.assignment.sal.thirdpart.util.ThirdCallUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class StudentInfoServiceImpl
implements StudentInfoService {
    private static final Logger log = LoggerFactory.getLogger(StudentInfoServiceImpl.class);
    @Resource
    private StringRedisTemplate redisTemplate;

    @Override
    public Collection<StudentInfo> getStudentInfos(List<Long> studentIds) throws Exception {
        Preconditions.checkArgument((!CollectionUtils.isEmpty(studentIds) ? 1 : 0) != 0, (Object)"\u5b66\u751f\u96c6\u5408\u4e3a\u7a7a");
        BaseLoginUser user = BaseLoginUtil.getCurrentUser();
        String idStr = BaseUtils.listToStr(studentIds, (String)",");
        HashMap params = Maps.newHashMap();
        params.put("ids", idStr);
        params.put("orgId", String.valueOf(user.getOrgId()));
        params.put("userId", String.valueOf(user.getUserId()));
        params.put("userRole", String.valueOf(user.getUserRole()));
        params.put("version", "hw");
        Collection<StudentInfo> studentInfos = ThirdCallUtil.callReturnListData(CommonUtils.RestMethod.POST, AssignmentThirdUrl.getThirdUrl(), "assignment", "studentInfos", params, StudentInfo.class);
        return studentInfos;
    }

    @Override
    public Collection<StudentInfo> getStudentInfosByClass(long classId) throws Exception {
        BaseLoginUser user = BaseLoginUtil.getCurrentUser();
        HashMap params = Maps.newHashMap();
        params.put("orgId", String.valueOf(user.getOrgId()));
        params.put("userId", String.valueOf(user.getUserId()));
        params.put("userRole", String.valueOf(user.getUserRole()));
        params.put("classId", String.valueOf(classId));
        params.put("version", "hw");
        Collection<StudentInfo> studentInfos = ThirdCallUtil.callReturnListData(CommonUtils.RestMethod.POST, AssignmentThirdUrl.getThirdUrl(), "assignment", "studentInfos", params, StudentInfo.class);
        return studentInfos;
    }

    @Override
    public Long addStudent(String name, String mobile, Long orgId) {
        HashMap params = Maps.newHashMap();
        params.put("orgId", String.valueOf(orgId));
        params.put("name", name);
        params.put("mobile", mobile);
        params.put("version", "hw");
        RestfulResult result = ThirdCallUtil.rest(AssignmentThirdUrl.getThirdUrl(), "assignment", "saveStudent", params);
        log.debug("[save tianxiao student result]={}", result);
        if (result.getCode() != 0) {
            return null;
        }
        Integer studentId = (Integer)result.getData();
        return studentId.longValue();
    }

    @Override
    public void checkStudent(Long userId) {
        HashMap params = Maps.newHashMap();
        params.put("userId", String.valueOf(userId));
        params.put("version", "hw");
        RestfulResult result = ThirdCallUtil.rest(AssignmentThirdUrl.getThirdUrl(), "assignment", "checkStudent", params);
        if (result.getCode() == BizConf.SIGN_INVALIDATE.intValue()) {
            throw new BusinessException((UniverseErrorCode)AssignmentErrorCode.PARAM_ERROR, "\u5b66\u751f\u5e76\u672a\u7ed1\u5b9a\u4e2a\u4eba\u4e2d\u5fc3");
        }
    }

    @Override
    public Userinfo getChangedStudentInfo(Userinfo users) throws Exception {
        Iterator<Userinfo> iterator;
        HashMap params = Maps.newHashMap();
        params.put("userId", String.valueOf(users.getUserId()));
        params.put("userName", users.getUserName());
        params.put("userMobile", users.getUserMobile());
        params.put("headUrl", users.getHeadUrl());
        params.put("version", "hw");
        Collection<Userinfo> userlist = ThirdCallUtil.callReturnListData(null, AssignmentThirdUrl.getThirdUrl(), "assignment", "getStudent", params, Userinfo.class);
        if (userlist.size() > 0 && (iterator = userlist.iterator()).hasNext()) {
            Userinfo u = iterator.next();
            return u;
        }
        return null;
    }

    private boolean saveContent(final String MKEY, final byte[] contents) {
        boolean result = (Boolean)this.redisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

            public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                boolean result = connection.setNX(MKEY.getBytes(), contents);
                connection.expire(MKEY.getBytes(), 300L);
                return result;
            }
        });
        return result;
    }
}

