/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.assignment.sal.thirdpart.service.impl;

import com.baijia.doorgod.dto.RestfulResult;
import com.baijia.tianxiao.assignment.common.constants.BizConf;
import com.baijia.tianxiao.assignment.common.dto.AuthToken;
import com.baijia.tianxiao.assignment.common.enums.AssignmentErrorCode;
import com.baijia.tianxiao.assignment.common.enums.ClientType;
import com.baijia.tianxiao.assignment.common.errorcode.UniverseErrorCode;
import com.baijia.tianxiao.assignment.common.exception.BusinessException;
import com.baijia.tianxiao.assignment.sal.thirdpart.constants.AssignmentThirdUrl;
import com.baijia.tianxiao.assignment.sal.thirdpart.dto.GradeMessageDto;
import com.baijia.tianxiao.assignment.sal.thirdpart.dto.HomeworkTeacherStudentDto;
import com.baijia.tianxiao.assignment.sal.thirdpart.service.SendMessageService;
import com.baijia.tianxiao.assignment.sal.thirdpart.util.ThirdCallUtil;
import com.beust.jcommander.internal.Lists;
import com.google.common.collect.Maps;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SendMessageServiceImpl
implements SendMessageService {
    private static final Logger log = LoggerFactory.getLogger(SendMessageServiceImpl.class);
    public static final String TO_REPLACE = "%s";
    public static final String PUBLISH_HOMEWORK_TEMPLATE = "11";
    public static final String FINISH_HOMEWORK_TEMPLATE = "12";
    public static final String CORRECT_HOMEWORK_TEMPLATE = "13";
    public static final String PUBLISH_EXAM_TEMPLATE = "14";
    public static final String CORRECT_EXAM_TEMPLATE = "15";
    public static final String GRADE_TEMPLATE = "16";
    public static final String PUBLISH_HOMEWORK_FIRST = "\u8001\u5e08\u5e03\u7f6e\u4e86\u4f5c\u4e1a";
    public static final String PUBLISH_HOMEWORK_REMARK = "\u70b9\u51fb\u6d88\u606f\u67e5\u770b\u4f5c\u4e1a\u8be6\u60c5";
    public static final String PUBLISH_HOMEWORK_KEYWORK3 = "\u8bf7\u8ba4\u771f\u5b8c\u6210\u5e76\u5728\u7ebf\u63d0\u4ea4\u4f5c\u4e1a\u54e6";
    public static final String PUBLISH_EXAM_FIRST = "\u4f60\u5728%s\u673a\u6784\u6709\u4e00\u573a\u65b0\u7684\u8003\u8bd5";
    public static final String PUBLISH_EXAM_REMARK = "\u8bf7\u5c3d\u5feb\u5728\u7ebf\u5b8c\u6210\u8003\u8bd5~";
    public static final String FINISH_HOMEWORK_FIRST = "\u60a8\u7684\u5b66\u751f\u4f5c\u4e1a\u63d0\u4ea4\u6210\u529f";
    public static final String FINISH_HOMEWORK_REMARK = "\u8bf7\u767b\u5f55www.tianxiao100.com\uff0c\u5728\u4f5c\u4e1a\u7cfb\u7edf\u5185\u5b8c\u6210\u6279\u6539";
    public static final String CORRECT_HOMEWORK_FIRST = "%s\u540c\u5b66\u4f60\u597d\uff0c\u8001\u5e08\u5df2\u7ecf\u6279\u6539\u5b8c\u4f60\u7684\u4f5c\u4e1a\uff0c\u8bf7\u67e5\u770b";
    public static final String CORRECT_HOMEWORK_REMARK = "\u8bf7\u70b9\u51fb\u67e5\u770b\u4f5c\u4e1a\u5f97\u5206\u53ca\u8bc4\u8bed";
    public static final String CORRECT_EXAM_FIRST = "%s\u4f60\u597d\uff0c\u8bd5\u5377\u6279\u6539\u5b8c\u6210";
    public static final String CORRECT_EXAM_REMARK = "\u8bf7\u70b9\u51fb\u67e5\u770b\u8bd5\u5377\u8be6\u60c5";
    public static final String GRADE_FIRST = "\u540c\u5b66\uff0c\u60a8\u7684\u8003\u8bd5\u6210\u7ee9\u5df2\u516c\u5e03";
    public static final String GRADE_REMARK = "\u8bf7\u70b9\u51fb\u67e5\u770b\u8be6\u7ec6\u6210\u7ee9\u53ca\u8001\u5e08\u8bc4\u8bed~";

    @Override
    public List<Long> sendAfterPublish(List<HomeworkTeacherStudentDto> teacherStudentDtos) {
        List successHomeworkId = Lists.newArrayList();
        for (HomeworkTeacherStudentDto teacherStudent : teacherStudentDtos) {
            RestfulResult result;
            HashMap params = Maps.newHashMap();
            params.put("orgId", String.valueOf(teacherStudent.getOrgId()));
            params.put("studentId", String.valueOf(teacherStudent.getStudentId()));
            params.put("teacherId", String.valueOf(teacherStudent.getTeacherId()));
            params.put("version", "hw");
            params.put("url", AuthToken.assignMentStudentToken((Long)teacherStudent.getOrgId(), (Long)teacherStudent.getStudentId(), (Long)teacherStudent.getHomeworkStudentId(), (Integer)teacherStudent.getType()));
            if (teacherStudent.getType().intValue() == ClientType.HW.getCode()) {
                params.put("templateId", PUBLISH_HOMEWORK_TEMPLATE);
                params.put("first", teacherStudent.getTeacherName() + PUBLISH_HOMEWORK_FIRST);
                params.put("remark", PUBLISH_HOMEWORK_REMARK);
                params.put("keyword1", teacherStudent.getLatestTime() != null ? new SimpleDateFormat("yyyy-MM-dd HH:mm").format(teacherStudent.getLatestTime()) : "\u8001\u5e08\u672a\u8bbe\u7f6e\u622a\u6b62\u65f6\u95f4");
                params.put("keyword2", teacherStudent.getHomeworkName());
                params.put("keyword3", PUBLISH_HOMEWORK_KEYWORK3);
            } else {
                params.put("templateId", PUBLISH_EXAM_TEMPLATE);
                params.put("first", PUBLISH_EXAM_FIRST);
                params.put("remark", PUBLISH_EXAM_REMARK);
                params.put("keyword1", teacherStudent.getHomeworkName());
                params.put("keyword2", new SimpleDateFormat("yyyy-MM-dd HH:mm").format(teacherStudent.getBeginTime()));
                params.put("keyword3", String.valueOf(teacherStudent.getExamDuration()));
            }
            if ((result = ThirdCallUtil.rest(AssignmentThirdUrl.getThirdUrl(), "common", "sendMessage", params)).getCode() != 0) continue;
            successHomeworkId.add(teacherStudent.getHomeworkId());
        }
        return successHomeworkId;
    }

    @Override
    public List<Long> sendAfterFinish(List<HomeworkTeacherStudentDto> teacherStudentDtos) {
        List successHomeworkId = Lists.newArrayList();
        for (HomeworkTeacherStudentDto teacherStudent : teacherStudentDtos) {
            HashMap params = Maps.newHashMap();
            params.put("orgId", String.valueOf(teacherStudent.getOrgId()));
            params.put("studentId", String.valueOf(teacherStudent.getStudentId()));
            params.put("teacherId", String.valueOf(teacherStudent.getTeacherId()));
            params.put("templateId", FINISH_HOMEWORK_TEMPLATE);
            params.put("url", "");
            params.put("first", FINISH_HOMEWORK_FIRST);
            params.put("remark", FINISH_HOMEWORK_REMARK);
            params.put("keyword1", TO_REPLACE);
            params.put("keyword2", teacherStudent.getHomeworkName());
            params.put("keyword3", new SimpleDateFormat("yyyy-MM-dd HH:mm").format(teacherStudent.getSubmitTime()));
            params.put("version", "hw");
            RestfulResult result = ThirdCallUtil.rest(AssignmentThirdUrl.getThirdUrl(), "common", "sendMessage", params);
            if (result.getCode() != 0) continue;
            successHomeworkId.add(teacherStudent.getHomeworkId());
        }
        return successHomeworkId;
    }

    @Override
    public List<Long> sendAfterCorrect(List<HomeworkTeacherStudentDto> teacherStudentDtos) {
        List successHomeworkId = Lists.newArrayList();
        for (HomeworkTeacherStudentDto teacherStudent : teacherStudentDtos) {
            HashMap params = Maps.newHashMap();
            params.put("orgId", String.valueOf(teacherStudent.getOrgId()));
            params.put("studentId", String.valueOf(teacherStudent.getStudentId()));
            params.put("teacherId", String.valueOf(teacherStudent.getTeacherId()));
            params.put("classId", String.valueOf(teacherStudent.getClassId()));
            params.put("url", AuthToken.assignMentStudentToken((Long)teacherStudent.getOrgId(), (Long)teacherStudent.getStudentId(), (Long)teacherStudent.getHomeworkStudentId(), (Integer)teacherStudent.getType()));
            if (teacherStudent.getType().intValue() == ClientType.HW.getCode()) {
                params.put("templateId", CORRECT_HOMEWORK_TEMPLATE);
                params.put("first", CORRECT_HOMEWORK_FIRST);
                params.put("remark", CORRECT_HOMEWORK_REMARK);
                params.put("keyword1", teacherStudent.getHomeworkName());
                params.put("keyword2", TO_REPLACE);
                params.put("keyword3", teacherStudent.getTeacherName());
            } else {
                params.put("templateId", CORRECT_EXAM_TEMPLATE);
                params.put("first", CORRECT_EXAM_FIRST);
                params.put("remark", CORRECT_EXAM_REMARK);
                params.put("keyword1", teacherStudent.getHomeworkName());
                params.put("keyword2", new SimpleDateFormat("yyyy-MM-dd HH:mm").format(teacherStudent.getCorrectTime()));
                params.put("keyword3", String.valueOf(teacherStudent.getScore()));
            }
            params.put("version", "hw");
            RestfulResult result = ThirdCallUtil.rest(AssignmentThirdUrl.getThirdUrl(), "common", "sendMessage", params);
            if (result.getCode() != 0) continue;
            successHomeworkId.add(teacherStudent.getHomeworkId());
        }
        return successHomeworkId;
    }

    @Override
    public void sendGrade(List<GradeMessageDto> list) {
        for (GradeMessageDto dto : list) {
            HashMap params = Maps.newHashMap();
            params.put("studentId", String.valueOf(dto.getStudentId()));
            params.put("templateId", GRADE_TEMPLATE);
            params.put("orgId", String.valueOf(dto.getOrgId()));
            params.put("url", AuthToken.gradeMentStudentToken((Long)dto.getOrgId(), (Long)dto.getStudentId(), (Long)dto.getGradeStudentId()));
            params.put("first", dto.getStudentName() + GRADE_FIRST);
            params.put("remark", GRADE_REMARK);
            params.put("keyword1", dto.getGradeName());
            params.put("keyword2", dto.getScore());
            params.put("version", "hw");
            RestfulResult result = ThirdCallUtil.rest(AssignmentThirdUrl.getThirdUrl(), "common", "sendMessage", params);
            if (result.getCode() != BizConf.INVALIDATE_CLIENTID.intValue()) continue;
            throw new BusinessException((UniverseErrorCode)AssignmentErrorCode.PARAM_ERROR, "\u673a\u6784\u672a\u7ed1\u5b9a\u516c\u4f17\u53f7");
        }
    }
}

