/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.assignment.sal.thirdpart.service.impl;

import com.baijia.doorgod.utils.CommonUtils;
import com.baijia.tianxiao.assignment.common.model.BaseLoginUser;
import com.baijia.tianxiao.assignment.common.util.BaseLoginUtil;
import com.baijia.tianxiao.assignment.common.util.BaseUtils;
import com.baijia.tianxiao.assignment.sal.thirdpart.constants.AssignmentThirdUrl;
import com.baijia.tianxiao.assignment.sal.thirdpart.dto.ClassInfo;
import com.baijia.tianxiao.assignment.sal.thirdpart.service.ClassInfoService;
import com.baijia.tianxiao.assignment.sal.thirdpart.util.ThirdCallUtil;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ClassinfoServiceImpl
implements ClassInfoService {
    private static final Logger log = LoggerFactory.getLogger(ClassinfoServiceImpl.class);

    @Override
    public Collection<ClassInfo> getClassInfos(String className) {
        BaseLoginUser user = BaseLoginUtil.getCurrentUser();
        HashMap params = Maps.newHashMap();
        params.put("orgId", String.valueOf(user.getOrgId()));
        params.put("userId", String.valueOf(user.getUserId()));
        params.put("userRole", String.valueOf(user.getUserRole()));
        params.put("version", "hw");
        if (StringUtils.isNotEmpty((String)className)) {
            params.put("className", className);
        }
        Collection<ClassInfo> classinfos = null;
        try {
            classinfos = ThirdCallUtil.callReturnListData(CommonUtils.RestMethod.GET, AssignmentThirdUrl.getThirdUrl(), "assignment", "classInfos", params, ClassInfo.class);
        }
        catch (Exception e) {
            log.debug("[call assignment/classInfos catch exception={}", (Throwable)e);
        }
        return classinfos;
    }

    @Override
    public Collection<ClassInfo> getClassInfos(List<Long> classIds) throws Exception {
        BaseLoginUser user = BaseLoginUtil.getCurrentUser();
        HashMap params = Maps.newHashMap();
        String idStr = BaseUtils.listToStr(classIds, (String)",");
        params.put("orgId", String.valueOf(user.getOrgId()));
        params.put("userId", String.valueOf(user.getUserId()));
        params.put("userRole", String.valueOf(user.getUserRole()));
        params.put("ids", idStr);
        params.put("version", "hw");
        Collection<ClassInfo> classinfos = ThirdCallUtil.callReturnListData(CommonUtils.RestMethod.POST, AssignmentThirdUrl.getThirdUrl(), "assignment", "studentInfos", params, ClassInfo.class);
        return classinfos;
    }
}

