/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.assignment.sal.thirdpart.constants;

import com.google.common.collect.Maps;
import java.util.Map;

public enum UserRoleEnum {
    ANONYMOUS(-1, "\u533f\u540d"),
    TEACHER(0, "\u8001\u5e08"),
    STUDENT(2, "\u5b66\u751f"),
    ORG(6, "\u673a\u6784"),
    KEFU(7, "\u5ba2\u670d"),
    CUSTOMER(8, "\u5ba2\u6237"),
    System(100, "\u7cfb\u7edf\u4fe1\u606f"),
    Admin(101, "\u7fa4\u7ec4\u7ba1\u7406\u901a\u77e5"),
    Operator(127, "\u5e08\u8d44");

    private static final Map<Integer, UserRoleEnum> map;
    private int code;
    private String note;

    private UserRoleEnum(int code, String note) {
        this.code = code;
        this.note = note;
    }

    public int getCode() {
        return this.code;
    }

    public String getNote() {
        return this.note;
    }

    public static String getNote(Integer code) {
        if (map.containsKey(code)) {
            return map.get(code).getNote();
        }
        return null;
    }

    public static UserRoleEnum getByCode(Integer code) {
        return map.get(code);
    }

    static {
        map = Maps.newHashMap();
        for (UserRoleEnum userRole : UserRoleEnum.values()) {
            map.put(userRole.getCode(), userRole);
        }
    }
}

