/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.connect.common.util;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class Image {
    private BufferedImage bufferedImage;
    private String fileName;

    public Image(File imageFile) {
        try {
            this.bufferedImage = ImageIO.read(imageFile);
            this.fileName = imageFile.getAbsolutePath();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.bufferedImage = null;
            imageFile = null;
        }
    }

    public Image(String imageFilePath) {
        this(new File(imageFilePath));
    }

    public BufferedImage getAsBufferedImage() {
        return this.bufferedImage;
    }

    public void saveAs(String fileName) {
        this.saveImage(new File(fileName));
        this.fileName = fileName;
    }

    public void save() {
        this.saveImage(new File(this.fileName));
    }

    public void resize(int percentOfOriginal) {
        int newWidth = this.bufferedImage.getWidth() * percentOfOriginal / 100;
        int newHeight = this.bufferedImage.getHeight() * percentOfOriginal / 100;
        this.resize(newWidth, newHeight);
    }

    public void resize(int newWidth, int newHeight) {
        int oldWidth = this.bufferedImage.getWidth();
        int oldHeight = this.bufferedImage.getHeight();
        if (newWidth == -1 || newHeight == -1) {
            if (newWidth == -1) {
                if (newHeight == -1) {
                    return;
                }
                newWidth = newHeight * oldWidth / oldHeight;
            } else {
                newHeight = newWidth * oldHeight / oldWidth;
            }
        }
        BufferedImage result = new BufferedImage(newWidth, newHeight, 4);
        double widthSkip = new Double(oldWidth - newWidth) / new Double(newWidth);
        double heightSkip = new Double(oldHeight - newHeight) / new Double(newHeight);
        double widthCounter = 0.0;
        double heightCounter = 0.0;
        int newY = 0;
        boolean isNewImageWidthSmaller = widthSkip > 0.0;
        boolean isNewImageHeightSmaller = heightSkip > 0.0;
        for (int y = 0; y < oldHeight && newY < newHeight; ++y) {
            if (isNewImageHeightSmaller && heightCounter > 1.0) {
                heightCounter -= 1.0;
                continue;
            }
            if (heightCounter < -1.0) {
                heightCounter += 1.0;
                if (y > 1) {
                    y -= 2;
                    continue;
                }
                --y;
                continue;
            }
            heightCounter += heightSkip;
            int newX = 0;
            for (int x = 0; x < oldWidth && newX < newWidth; ++x) {
                if (isNewImageWidthSmaller && widthCounter > 1.0) {
                    widthCounter -= 1.0;
                    continue;
                }
                if (widthCounter < -1.0) {
                    widthCounter += 1.0;
                    if (x > 1) {
                        x -= 2;
                        continue;
                    }
                    --x;
                    continue;
                }
                int rgb = this.bufferedImage.getRGB(x, y);
                result.setRGB(newX, newY, rgb);
                ++newX;
                widthCounter += widthSkip;
            }
            ++newY;
        }
        this.bufferedImage = result;
    }

    public void addPixelColor(int numToAdd) {
        int width = this.bufferedImage.getWidth();
        int height = this.bufferedImage.getHeight();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int rgb = this.bufferedImage.getRGB(x, y);
                this.bufferedImage.setRGB(x, y, rgb + numToAdd);
            }
        }
    }

    public void convertToBlackAndWhite() {
        ColorSpace gray_space = ColorSpace.getInstance(1003);
        ColorConvertOp convert_to_gray_op = new ColorConvertOp(gray_space, null);
        convert_to_gray_op.filter(this.bufferedImage, this.bufferedImage);
    }

    public void rotateLeft() {
        int width = this.bufferedImage.getWidth();
        int height = this.bufferedImage.getHeight();
        BufferedImage result = new BufferedImage(height, width, 4);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int rgb = this.bufferedImage.getRGB(x, y);
                result.setRGB(y, x, rgb);
            }
        }
        this.bufferedImage = result;
    }

    public void rotateRight() {
        int width = this.bufferedImage.getWidth();
        int height = this.bufferedImage.getHeight();
        BufferedImage result = new BufferedImage(height, width, 4);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int rgb = this.bufferedImage.getRGB(x, y);
                result.setRGB(height - y - 1, x, rgb);
            }
        }
        this.bufferedImage = result;
    }

    public void rotate180() {
        int width = this.bufferedImage.getWidth();
        int height = this.bufferedImage.getHeight();
        BufferedImage result = new BufferedImage(width, height, 4);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int rgb = this.bufferedImage.getRGB(x, y);
                result.setRGB(width - x - 1, height - y - 1, rgb);
            }
        }
        this.bufferedImage = result;
    }

    public void flipHorizontally() {
        int width = this.bufferedImage.getWidth();
        int height = this.bufferedImage.getHeight();
        BufferedImage result = new BufferedImage(width, height, 4);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int rgb = this.bufferedImage.getRGB(x, y);
                result.setRGB(width - x - 1, y, rgb);
            }
        }
        this.bufferedImage = result;
    }

    public void flipVertically() {
        int width = this.bufferedImage.getWidth();
        int height = this.bufferedImage.getHeight();
        BufferedImage result = new BufferedImage(width, height, 4);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int rgb = this.bufferedImage.getRGB(x, y);
                result.setRGB(x, height - y - 1, rgb);
            }
        }
        this.bufferedImage = result;
    }

    public void multiply(int timesToMultiplyVertically, int timesToMultiplyHorizantelly) {
        this.multiply(timesToMultiplyVertically, timesToMultiplyHorizantelly, 0);
    }

    public void multiply(int timesToMultiplyVertically, int timesToMultiplyHorizantelly, int colorToHenhancePerPixel) {
        int width = this.bufferedImage.getWidth();
        int height = this.bufferedImage.getHeight();
        BufferedImage result = new BufferedImage(width * timesToMultiplyVertically, height * timesToMultiplyHorizantelly, 4);
        for (int xx = 0; xx < timesToMultiplyVertically; ++xx) {
            for (int yy = 0; yy < timesToMultiplyHorizantelly; ++yy) {
                for (int x = 0; x < width; ++x) {
                    for (int y = 0; y < height; ++y) {
                        int rgb = this.bufferedImage.getRGB(x, y);
                        result.setRGB(width * xx + x, height * yy + y, rgb + colorToHenhancePerPixel * (yy + xx));
                    }
                }
            }
        }
        this.bufferedImage = result;
    }

    public void combineWithPicture(String newImagePath) {
        this.combineWithPicture(newImagePath, 2);
    }

    public void combineWithPicture(String newImagePath, int jump) {
        try {
            BufferedImage bufferedImage2 = ImageIO.read(new File(newImagePath));
            this.combineWithPicture(bufferedImage2, jump, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void combineWithPicture(Image image2) {
        this.combineWithPicture(image2.getAsBufferedImage(), 2, null);
    }

    public void combineWithPicture(Image image2, int jump) {
        this.combineWithPicture(image2.getAsBufferedImage(), jump, null);
    }

    public void combineWithPicture(Image image2, Color ignoreColor) {
        this.combineWithPicture(image2.getAsBufferedImage(), 2, ignoreColor);
    }

    public void combineWithPicture(Image image2, int jump, Color ignoreColor) {
        this.combineWithPicture(image2.getAsBufferedImage(), jump, ignoreColor);
    }

    private void combineWithPicture(BufferedImage bufferedImage2, int jump, Color ignoreColor) {
        this.checkJump(jump);
        int width = this.bufferedImage.getWidth();
        int height = this.bufferedImage.getHeight();
        int width2 = bufferedImage2.getWidth();
        int height2 = bufferedImage2.getHeight();
        int ignoreColorRgb = -1;
        if (ignoreColor != null) {
            ignoreColorRgb = ignoreColor.getRGB();
        }
        for (int y = 0; y < height; ++y) {
            for (int x = y % jump; x < width; x += jump) {
                int rgb;
                if (x >= width2 || y >= height2 || (rgb = bufferedImage2.getRGB(x, y)) == ignoreColorRgb) continue;
                this.bufferedImage.setRGB(x, y, rgb);
            }
        }
    }

    public void crop(int startX, int startY, int endX, int endY) {
        int width = this.bufferedImage.getWidth();
        int height = this.bufferedImage.getHeight();
        if (startX == -1) {
            startX = 0;
        }
        if (startY == -1) {
            startY = 0;
        }
        if (endX == -1) {
            endX = width - 1;
        }
        if (endY == -1) {
            endY = height - 1;
        }
        BufferedImage result = new BufferedImage(endX - startX + 1, endY - startY + 1, 4);
        for (int y = startY; y < endY; ++y) {
            for (int x = startX; x < endX; ++x) {
                int rgb = this.bufferedImage.getRGB(x, y);
                result.setRGB(x - startX, y - startY, rgb);
            }
        }
        this.bufferedImage = result;
    }

    private void saveImage(File file) {
        try {
            ImageIO.write((RenderedImage)this.bufferedImage, this.getFileType(file), file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void converToByte(String format, OutputStream out) {
        try {
            ImageIO.write((RenderedImage)this.bufferedImage, format, out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void emphasize(int startX, int startY, int endX, int endY) {
        this.emphasize(startX, startY, endX, endY, Color.BLACK, 3);
    }

    public void emphasize(int startX, int startY, int endX, int endY, Color backgroundColor) {
        this.emphasize(startX, startY, endX, endY, backgroundColor, 3);
    }

    public void emphasize(int startX, int startY, int endX, int endY, int jump) {
        this.emphasize(startX, startY, endX, endY, Color.BLACK, jump);
    }

    public void emphasize(int startX, int startY, int endX, int endY, Color backgroundColor, int jump) {
        this.checkJump(jump);
        int width = this.bufferedImage.getWidth();
        int height = this.bufferedImage.getHeight();
        if (startX == -1) {
            startX = 0;
        }
        if (startY == -1) {
            startY = 0;
        }
        if (endX == -1) {
            endX = width - 1;
        }
        if (endY == -1) {
            endY = height - 1;
        }
        for (int y = 0; y < height; ++y) {
            for (int x = y % jump; x < width; x += jump) {
                if (y >= startY && y <= endY && x >= startX && x <= endX) continue;
                this.bufferedImage.setRGB(x, y, backgroundColor.getRGB());
            }
        }
    }

    private void checkJump(int jump) {
        if (jump < 1) {
            throw new RuntimeException("Error: jump can not be less than 1");
        }
    }

    public void addColorToImage(Color color, int jump) {
        this.addColorToImage(color.getRGB(), jump);
    }

    public void addColorToImage(int rgb, int jump) {
        this.checkJump(jump);
        int width = this.bufferedImage.getWidth();
        int height = this.bufferedImage.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = y % jump; x < width; x += jump) {
                this.bufferedImage.setRGB(x, y, rgb);
            }
        }
    }

    public void affineTransform(double fShxFactor, double fShyFactor) {
        try {
            AffineTransform shearer = AffineTransform.getShearInstance(fShxFactor, fShyFactor);
            AffineTransformOp shear_op = new AffineTransformOp(shearer, null);
            this.bufferedImage = shear_op.filter(this.bufferedImage, null);
        }
        catch (Exception e) {
            System.out.println("Shearing exception = " + e);
        }
    }

    private String getFileType(File file) {
        String fileName = file.getName();
        int idx = fileName.lastIndexOf(".");
        if (idx == -1) {
            throw new RuntimeException("Invalid file name");
        }
        return fileName.substring(idx + 1);
    }

    public int getWidth() {
        return this.bufferedImage.getWidth();
    }

    public int getHeight() {
        return this.bufferedImage.getHeight();
    }

    public static void main(String[] args) {
    }
}

