/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.connect.common.util;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class HttpCommonUtil {
    static long aBegin = HttpCommonUtil.getIpNum("10.0.0.0");
    static long aEnd = HttpCommonUtil.getIpNum("10.255.255.255");
    static long bBegin = HttpCommonUtil.getIpNum("172.16.0.0");
    static long bEnd = HttpCommonUtil.getIpNum("172.31.255.255");
    static long cBegin = HttpCommonUtil.getIpNum("192.168.0.0");
    static long cEnd = HttpCommonUtil.getIpNum("192.168.255.255");

    public static boolean isAjaxRequest(HttpServletRequest request) {
        String requestedWith = request.getHeader("x-requested-with");
        if (StringUtils.isEmpty((CharSequence)requestedWith)) {
            return false;
        }
        return StringUtils.isNotEmpty((CharSequence)requestedWith) && requestedWith.equals("XMLHttpRequest");
    }

    public static String getRemoteIp(HttpServletRequest request) {
        String remoteIp = request.getHeader("x-forwarded-for");
        if (remoteIp == null || remoteIp.isEmpty() || "unknown".equalsIgnoreCase(remoteIp)) {
            remoteIp = request.getHeader("X-Real-IP");
        }
        if (remoteIp == null || remoteIp.isEmpty() || "unknown".equalsIgnoreCase(remoteIp)) {
            remoteIp = request.getHeader("Proxy-Client-IP");
        }
        if (remoteIp == null || remoteIp.isEmpty() || "unknown".equalsIgnoreCase(remoteIp)) {
            remoteIp = request.getHeader("WL-Proxy-Client-IP");
        }
        if (remoteIp == null || remoteIp.isEmpty() || "unknown".equalsIgnoreCase(remoteIp)) {
            remoteIp = request.getHeader("HTTP_CLIENT_IP");
        }
        if (remoteIp == null || remoteIp.isEmpty() || "unknown".equalsIgnoreCase(remoteIp)) {
            remoteIp = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (remoteIp == null || remoteIp.isEmpty() || "unknown".equalsIgnoreCase(remoteIp)) {
            remoteIp = request.getRemoteAddr();
        }
        if (remoteIp == null || remoteIp.isEmpty() || "unknown".equalsIgnoreCase(remoteIp)) {
            remoteIp = request.getRemoteHost();
        }
        if (remoteIp != null && remoteIp.indexOf(",") != -1) {
            remoteIp = remoteIp.substring(remoteIp.lastIndexOf(",") + 1, remoteIp.length()).trim();
        }
        return remoteIp;
    }

    public static boolean isInnerIP(String ipAddress) {
        boolean isInnerIp = false;
        long ipNum = HttpCommonUtil.getIpNum(ipAddress);
        isInnerIp = HttpCommonUtil.isInner(ipNum, aBegin, aEnd) || HttpCommonUtil.isInner(ipNum, bBegin, bEnd) || HttpCommonUtil.isInner(ipNum, cBegin, cEnd) || ipAddress.equals("127.0.0.1");
        return isInnerIp;
    }

    private static long getIpNum(String ipAddress) {
        String[] ip = ipAddress.split("\\.");
        long a = Integer.parseInt(ip[0]);
        long b = Integer.parseInt(ip[1]);
        long c = Integer.parseInt(ip[2]);
        long d = Integer.parseInt(ip[3]);
        long ipNum = a * 256L * 256L * 256L + b * 256L * 256L + c * 256L + d;
        return ipNum;
    }

    private static boolean isInner(long userIp, long begin, long end) {
        return userIp >= begin && userIp <= end;
    }
}

