/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.connect.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class DateUtil {
    private static final SimpleDateFormat dayFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat yyyyMMddFormat = new SimpleDateFormat("yyyyMMdd");
    private static final SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
    private static final SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final SimpleDateFormat minuteFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");

    public static long buildLastTime(long initTime, long addTime) {
        long nowTime = System.currentTimeMillis();
        if (nowTime < initTime) {
            return initTime + addTime;
        }
        return nowTime + addTime;
    }

    public static long getNowTime() {
        return System.currentTimeMillis();
    }

    public static boolean isAlive(long time) {
        return DateUtil.getNowTime() >= time;
    }

    public static Date addDay(Date date, int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(6, days);
        return calendar.getTime();
    }

    public static Date addMonth(Date date, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, month);
        return calendar.getTime();
    }

    public static Date getTheDayStartTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getTheDayEndTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static long getTheDayEndTime(long date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        return calendar.getTimeInMillis();
    }

    public static long getTheDayStartTime(long dateTime) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(dateTime);
        calendar.set(14, 0);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(11, 0);
        return calendar.getTimeInMillis();
    }

    public static Long getMillisBetweenTwoDate(long firstTime, long lastTime) {
        return firstTime - lastTime;
    }

    public static Long getMinutesBetweenTwoDate(long firstTime, long lastTime) {
        long millis = DateUtil.getMillisBetweenTwoDate(firstTime, lastTime);
        Long minutes = millis / 60000L;
        return minutes;
    }

    public static Long getSecondsBetweenTwoDate(long firstTime, long lastTime) {
        long millis = DateUtil.getMillisBetweenTwoDate(firstTime, lastTime);
        Long minutes = millis / 1000L;
        return minutes;
    }

    public static int getDayBetweenTwoDate(Date firstTime, Date lastTime) throws Exception {
        if (firstTime == null || lastTime == null) {
            throw new Exception("param can not null");
        }
        return DateUtil.getDayBetweenTwoDate(firstTime.getTime(), lastTime.getTime());
    }

    public static Double getDayBetweenTwoDateDouble(Date firstTime, Date lastTime) throws Exception {
        if (firstTime == null || lastTime == null) {
            throw new Exception("param can not null");
        }
        return DateUtil.getDayBetweenTwoDateDouble(firstTime.getTime(), lastTime.getTime());
    }

    public static Double getDayBetweenTwoDateDouble(long firstTime, long lastTime) {
        long firstCalendaStartTime = DateUtil.getTheDayStartTime(firstTime);
        long lastCalendaStartTime = DateUtil.getTheDayStartTime(lastTime);
        Double days = (double)(firstCalendaStartTime - lastCalendaStartTime) * 1.0 / 8.64E7;
        return days;
    }

    public static int getDayBetweenTwoDate(long firstTime, long lastTime) {
        long firstCalendaStartTime = DateUtil.getTheDayStartTime(firstTime);
        long lastCalendaStartTime = DateUtil.getTheDayStartTime(lastTime);
        Long days = new Long((firstCalendaStartTime - lastCalendaStartTime) / 86400000L);
        return days.intValue();
    }

    public static long getMinutesBetweenTwoDate(Date firstTime, Date lastTime) throws Exception {
        if (firstTime == null || lastTime == null) {
            throw new Exception("param can not null");
        }
        return DateUtil.getMinutesBetweenTwoDate(firstTime.getTime(), lastTime.getTime());
    }

    public static long getSecondsBetweenTwoDate(Date firstTime, Date lastTime) throws Exception {
        if (firstTime == null || lastTime == null) {
            throw new Exception("param can not null");
        }
        return DateUtil.getSecondsBetweenTwoDate(firstTime.getTime(), lastTime.getTime());
    }

    public static long getMillisBetweenTwoDate(Date firstTime, Date lastTime) throws Exception {
        if (firstTime == null || lastTime == null) {
            throw new Exception("param can not null");
        }
        return DateUtil.getMillisBetweenTwoDate(firstTime.getTime(), lastTime.getTime());
    }

    public static boolean isSameDay(Date date1, Date date2) {
        String strDate2;
        String strDate1 = DateUtil.getDateStr(date1);
        return StringUtils.equals((CharSequence)strDate1, (CharSequence)(strDate2 = DateUtil.getDateStr(date2)));
    }

    public static boolean isSameDay(long time1, long time2) {
        return DateUtil.isSameDay(new Date(time1), new Date(time2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDateStr(Object date) {
        SimpleDateFormat simpleDateFormat = dayFormat;
        synchronized (simpleDateFormat) {
            String strDate = dayFormat.format(date);
            return strDate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTimeStr(Object date) {
        SimpleDateFormat simpleDateFormat = timeFormat;
        synchronized (simpleDateFormat) {
            String strDate = timeFormat.format(date);
            return strDate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDateTime(Object date) {
        SimpleDateFormat simpleDateFormat = dateTimeFormat;
        synchronized (simpleDateFormat) {
            String strDate = dateTimeFormat.format(date);
            return strDate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getYYYYMMDDHHMMStr(Object date) {
        SimpleDateFormat simpleDateFormat = minuteFormat;
        synchronized (simpleDateFormat) {
            String strDate = minuteFormat.format(date);
            return strDate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getYYYYMMDDStr(Object date) {
        SimpleDateFormat simpleDateFormat = yyyyMMddFormat;
        synchronized (simpleDateFormat) {
            String strDate = yyyyMMddFormat.format(date);
            return strDate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseYYYYMMDDStr(String String2) {
        SimpleDateFormat simpleDateFormat = yyyyMMddFormat;
        synchronized (simpleDateFormat) {
            Date date = null;
            try {
                date = yyyyMMddFormat.parse(String2);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            return date;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseStandardDate(String str) throws ParseException {
        SimpleDateFormat simpleDateFormat = dayFormat;
        synchronized (simpleDateFormat) {
            Date date = dayFormat.parse(str);
            return date;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseDateTime(String str) {
        SimpleDateFormat simpleDateFormat = dateTimeFormat;
        synchronized (simpleDateFormat) {
            try {
                Date date = dateTimeFormat.parse(str);
                return date;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static void main(String[] args) {
        Date now = new Date();
        Date d2 = DateUtil.addMonth(now, 1);
        System.out.println(now.toString());
        System.out.println(d2.toString());
        int days = DateUtil.getDayBetweenTwoDate(now.getTime(), d2.getTime());
        System.out.println(days);
    }
}

