/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.connect.common.auth;

import com.alibaba.fastjson.JSON;
import com.baijia.tianxiao.connect.common.util.ConnectUtil;
import com.baijia.tianxiao.connect.common.util.HttpCommonUtil;
import com.baijia.tianxiao.connect.common.util.InnerAuthToken;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InnerTokenUtil {
    private static Logger logger = LoggerFactory.getLogger(InnerTokenUtil.class);

    public static boolean checkInnerIpOrToken(HttpServletRequest request) {
        String clientIp = HttpCommonUtil.getRemoteIp(request);
        boolean bool = HttpCommonUtil.isInnerIP(clientIp);
        if (!bool) {
            bool = InnerTokenUtil.checkToken(request);
        }
        return bool;
    }

    public static boolean checkToken(HttpServletRequest request) {
        String token = request.getParameter("token");
        if (StringUtils.isBlank((CharSequence)token)) {
            return false;
        }
        InnerAuthToken authToken = null;
        try {
            String jsonStr = ConnectUtil.getBizNameByToken(token);
            authToken = (InnerAuthToken)JSON.parseObject((String)jsonStr, InnerAuthToken.class);
        }
        catch (Exception e) {
            logger.error("TianxiaoWebNormalInterceptor check error", (Throwable)e);
            return false;
        }
        return authToken != null && InnerTokenUtil.checkTime(authToken.getTime(), 10) && InnerTokenUtil.checkDomain(authToken.getDomain()) && InnerTokenUtil.checkUser(authToken.getUserType());
    }

    private static boolean checkDomain(String domain) {
        String defaultDomain = "inner";
        return StringUtils.equals((CharSequence)defaultDomain, (CharSequence)domain);
    }

    private static boolean checkUser(String user) {
        String defaultUser = "tianxiao";
        return StringUtils.equals((CharSequence)defaultUser, (CharSequence)user);
    }

    public static boolean checkTime(Long time, int expireMin) {
        if (time == null) {
            return false;
        }
        long expire = System.currentTimeMillis() - time;
        return expire < (long)(expireMin * 60 * 1000);
    }
}

