/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.storm.sun.api.common.util;

import com.baijia.storm.sun.api.common.model.QueueKey;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class QueueKeyGenerator {
    public static final String SEPARATOR = "_";
    public static final String QUEUE_KEY_TYPE_CHATROOM = "c";
    public static final String QUEUE_KEY_TYPE_FRIEND = "f";
    public static final String QUEUE_KEY_TYPE_XROBOT = "x";
    public static final String QUEUE_KEY_TYPE_LOGICID = "l";
    public static final Set<String> SET_QUEUE_KEY_TYPE = new HashSet<String>(){
        {
            this.add(QueueKeyGenerator.QUEUE_KEY_TYPE_CHATROOM);
            this.add(QueueKeyGenerator.QUEUE_KEY_TYPE_FRIEND);
            this.add(QueueKeyGenerator.QUEUE_KEY_TYPE_XROBOT);
            this.add(QueueKeyGenerator.QUEUE_KEY_TYPE_LOGICID);
        }
    };
    public static final String QUEUE_KEY_ROLE_MASTER = "m";
    public static final String QUEUE_KEY_ROLE_SLAVE = "s";
    public static final Set<String> SET_QUEUE_KEY_ROLE = new HashSet<String>(){
        {
            this.add(QueueKeyGenerator.QUEUE_KEY_ROLE_MASTER);
            this.add(QueueKeyGenerator.QUEUE_KEY_ROLE_SLAVE);
        }
    };
    public static final String QUEUE_KEY_CHATROOM_PREFIX = "c_";
    public static final String QUEUE_KEY_FRIEND_PREFIX = "f_";
    public static final String QUEUE_KEY_XROBOT_PREFIX = "x_";
    public static final String QUEUE_KEY_LOGICID_PREFIX = "l_";
    public static final String QUEUE_KEY_LIKE_CHATROOM = "c_%";
    public static final String QUEUE_KEY_LIKE_FRIEND = "f_%";
    public static final String QUEUE_KEY_LIKE_CHATROOM_MASTER = "c_%_m";
    public static final String QUEUE_KEY_LIKE_CHATROOM_SLAVE = "c_%_s";

    public static String genChatroomQueueKey(String chatroom, boolean isMaster) {
        String role = isMaster ? QUEUE_KEY_ROLE_MASTER : QUEUE_KEY_ROLE_SLAVE;
        return QUEUE_KEY_CHATROOM_PREFIX + chatroom + SEPARATOR + role;
    }

    public static List<String> genChatroomQueueKeyAll(String chatroom) {
        return Arrays.asList(QueueKeyGenerator.genChatroomQueueKey(chatroom, false), QueueKeyGenerator.genChatroomQueueKey(chatroom, true));
    }

    public static String genFriendQueueKey(String username) {
        return QUEUE_KEY_FRIEND_PREFIX + username;
    }

    public static String genXRobotQueueKey(int logicId) {
        return QUEUE_KEY_XROBOT_PREFIX + logicId;
    }

    public static String genLogicIdQueueKey(int logicId) {
        return QUEUE_KEY_LOGICID_PREFIX + logicId;
    }

    public static String s2m(String slaveQueueKey) {
        QueueKey queueKey = new QueueKey(slaveQueueKey);
        return QueueKeyGenerator.genChatroomQueueKey(queueKey.getEntity(), true);
    }

    public static String m2s(String masterQueueKey) {
        QueueKey queueKey = new QueueKey(masterQueueKey);
        return QueueKeyGenerator.genChatroomQueueKey(queueKey.getEntity(), false);
    }
}

