/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.storm.sun.api.common.util;

import com.baijia.storm.sun.api.common.behavior.Validatable;
import com.baijia.storm.sun.api.common.exception.CustomException;
import com.baijia.storm.sun.api.common.util.LogUtil;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListUtil {
    private static final Logger log = LoggerFactory.getLogger(ListUtil.class);

    public static <T> List<T> compact(List<T> list) {
        if (list == null) {
            return list;
        }
        LinkedList<T> newList = new LinkedList<T>();
        for (T t : list) {
            if (t == null) continue;
            newList.add(t);
        }
        return newList;
    }

    public static <T extends Validatable> boolean validate(List<T> list) {
        if (list == null) {
            return false;
        }
        for (Validatable t : list) {
            if (t != null && t.isValid()) continue;
            return false;
        }
        return true;
    }

    public static <T extends Validatable> void validate(List<T> list, CustomException e, String clazz, String method, String sign) throws CustomException {
        if (!ListUtil.validate(list)) {
            log.error("[VALIDATE ERROR] clazz[{}] method[{}] sign[{}] list[{}]", new Object[]{clazz, method, sign, LogUtil.toString(list)});
            throw e;
        }
    }

    public static <T> void assertLen(List<T> list, int expected, CustomException e, String clazz, String method, String sign) throws CustomException {
        if (list == null || list.size() != expected) {
            log.error("[ASSERT LEN ERROR] expected[{}] actual[{}] clazz[{}] method[{}] sign[{}]", new Object[]{expected, list == null ? "null" : String.valueOf(list.size()), clazz, method, sign});
            throw e;
        }
    }

    public static <T extends Validatable> List<T> compactAndValidate(List<T> list, CustomException e, String clazz, String method, String sign) throws CustomException {
        list = ListUtil.compact(list);
        ListUtil.validate(list, e, clazz, method, sign);
        return list;
    }

    public static <T> List<T> compactAndAssertLen(List<T> list, int expected, CustomException e, String clazz, String method, String sign) throws CustomException {
        list = ListUtil.compact(list);
        ListUtil.assertLen(list, expected, e, clazz, method, sign);
        return list;
    }

    public static <T extends Validatable> void assertLenAndValidate(List<T> list, int expected, CustomException e, String clazz, String method, String sign) throws CustomException {
        ListUtil.assertLen(list, expected, e, clazz, method, sign);
        ListUtil.validate(list, e, clazz, method, sign);
    }

    public static <T extends Validatable> List<T> compactAndAssertLenAndValidate(List<T> list, int expected, CustomException e, String clazz, String method, String sign) throws CustomException {
        list = ListUtil.compact(list);
        ListUtil.assertLenAndValidate(list, expected, e, clazz, method, sign);
        return list;
    }

    public static boolean isBlank(List list) {
        return list == null || list.isEmpty();
    }

    public static int sum(Collection<Integer> list) {
        int sum = 0;
        if (list == null) {
            return sum;
        }
        for (Integer item : list) {
            sum += item.intValue();
        }
        return sum;
    }
}

