/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.storm.sun.api.common.proto;

import com.baijia.storm.lib.constant.WeChatMsgType;
import com.baijia.storm.sun.api.common.behavior.Validatable;
import com.baijia.storm.sun.api.common.constant.AddressType;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class SunChat
implements Validatable,
Serializable {
    private Integer weChatMsgType;
    private String content;
    private List<String> addressList;
    private Integer addressType;

    public SunChat() {
    }

    public SunChat(Integer weChatMsgType, String content, List<String> addressList, Integer addressType) {
        this.weChatMsgType = weChatMsgType;
        this.content = content;
        this.addressList = addressList;
        this.addressType = addressType;
    }

    @Override
    public boolean isValid() {
        if (!WeChatMsgType.CHAT_MSG_TYPE_SET.contains(this.weChatMsgType)) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)this.content)) {
            return false;
        }
        if (CollectionUtils.isEmpty(this.addressList)) {
            return false;
        }
        return AddressType.ALL_TYPE.contains(this.addressType);
    }

    public Integer getWeChatMsgType() {
        return this.weChatMsgType;
    }

    public String getContent() {
        return this.content;
    }

    public List<String> getAddressList() {
        return this.addressList;
    }

    public Integer getAddressType() {
        return this.addressType;
    }

    public void setWeChatMsgType(Integer weChatMsgType) {
        this.weChatMsgType = weChatMsgType;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setAddressList(List<String> addressList) {
        this.addressList = addressList;
    }

    public void setAddressType(Integer addressType) {
        this.addressType = addressType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SunChat)) {
            return false;
        }
        SunChat other = (SunChat)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$weChatMsgType = this.getWeChatMsgType();
        Integer other$weChatMsgType = other.getWeChatMsgType();
        if (this$weChatMsgType == null ? other$weChatMsgType != null : !((Object)this$weChatMsgType).equals(other$weChatMsgType)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        List<String> this$addressList = this.getAddressList();
        List<String> other$addressList = other.getAddressList();
        if (this$addressList == null ? other$addressList != null : !((Object)this$addressList).equals(other$addressList)) {
            return false;
        }
        Integer this$addressType = this.getAddressType();
        Integer other$addressType = other.getAddressType();
        return !(this$addressType == null ? other$addressType != null : !((Object)this$addressType).equals(other$addressType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SunChat;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $weChatMsgType = this.getWeChatMsgType();
        result = result * 59 + ($weChatMsgType == null ? 43 : ((Object)$weChatMsgType).hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        List<String> $addressList = this.getAddressList();
        result = result * 59 + ($addressList == null ? 43 : ((Object)$addressList).hashCode());
        Integer $addressType = this.getAddressType();
        result = result * 59 + ($addressType == null ? 43 : ((Object)$addressType).hashCode());
        return result;
    }

    public String toString() {
        return "SunChat(weChatMsgType=" + this.getWeChatMsgType() + ", content=" + this.getContent() + ", addressList=" + this.getAddressList() + ", addressType=" + this.getAddressType() + ")";
    }
}

