/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.storm.sun.api.common.model;

import com.baijia.storm.sun.api.common.behavior.Validatable;
import com.baijia.storm.sun.api.common.util.QueueKeyGenerator;
import sword.lib.Defaultor;

public class QueueKey
implements Validatable {
    private String origin;
    private String type;
    private String entity;
    private String role;
    private Integer priority;

    public QueueKey(String origin) {
        this.origin = origin;
        if (origin == null) {
            return;
        }
        this.type = origin.substring(0, 1);
        if ("c".equals(this.type)) {
            String[] terms = origin.split("_");
            this.entity = terms[1];
            this.role = terms[2];
        } else {
            this.entity = origin.substring(2);
        }
    }

    @Override
    public boolean isValid() {
        if (this.origin == null) {
            return false;
        }
        if (!QueueKeyGenerator.SET_QUEUE_KEY_TYPE.contains(this.type)) {
            return false;
        }
        if (this.entity == null || this.entity.trim().isEmpty()) {
            return false;
        }
        return !"c".equals(this.type) || QueueKeyGenerator.SET_QUEUE_KEY_ROLE.contains(this.role);
    }

    public Integer getPriority() {
        return (Integer)Defaultor.get((Object)this.priority, (Object)20);
    }

    public String getOrigin() {
        return this.origin;
    }

    public String getType() {
        return this.type;
    }

    public String getEntity() {
        return this.entity;
    }

    public String getRole() {
        return this.role;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setEntity(String entity) {
        this.entity = entity;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueueKey)) {
            return false;
        }
        QueueKey other = (QueueKey)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$origin = this.getOrigin();
        String other$origin = other.getOrigin();
        if (this$origin == null ? other$origin != null : !this$origin.equals(other$origin)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$entity = this.getEntity();
        String other$entity = other.getEntity();
        if (this$entity == null ? other$entity != null : !this$entity.equals(other$entity)) {
            return false;
        }
        String this$role = this.getRole();
        String other$role = other.getRole();
        if (this$role == null ? other$role != null : !this$role.equals(other$role)) {
            return false;
        }
        Integer this$priority = this.getPriority();
        Integer other$priority = other.getPriority();
        return !(this$priority == null ? other$priority != null : !((Object)this$priority).equals(other$priority));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QueueKey;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $origin = this.getOrigin();
        result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $entity = this.getEntity();
        result = result * 59 + ($entity == null ? 43 : $entity.hashCode());
        String $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : $role.hashCode());
        Integer $priority = this.getPriority();
        result = result * 59 + ($priority == null ? 43 : ((Object)$priority).hashCode());
        return result;
    }

    public String toString() {
        return "QueueKey(origin=" + this.getOrigin() + ", type=" + this.getType() + ", entity=" + this.getEntity() + ", role=" + this.getRole() + ", priority=" + this.getPriority() + ")";
    }
}

