/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.storm.sun.api.common.model;

import com.baijia.storm.lib.constant.WeChatMsgType;
import com.baijia.storm.sun.api.common.behavior.Validatable;
import com.baijia.storm.sun.api.common.constant.PrismRecordType;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class PrismRecord
implements Validatable,
Serializable {
    private Long id;
    private Integer type;
    private Long createTime;
    private Integer logicId;
    private String chatroom;
    private String fromUsername;
    private List<String> toUsernames;
    private Integer weChatMsgType;
    private Integer byQRCode;
    private Integer byOwner;
    private String content;
    private String md5;
    private Long packageId;
    private String whatever;

    @Override
    public boolean isValid() {
        return this.basicValid() && this.personalValid();
    }

    private boolean basicValid() {
        if (this.id == null || this.id < 0L) {
            return false;
        }
        if (this.type == null || !PrismRecordType.TYPE_SET_ALL.contains(this.type)) {
            return false;
        }
        if (this.createTime == null) {
            return false;
        }
        return this.logicId != null && this.logicId >= 0;
    }

    private boolean personalValid() {
        switch (this.type) {
            case 1: {
                return this.chatroom != null && this.fromUsername != null && WeChatMsgType.CHAT_MSG_TYPE_SET.contains(this.weChatMsgType) && this.content != null && this.md5 != null;
            }
            case 2: {
                return this.chatroom != null && CollectionUtils.isNotEmpty(this.toUsernames);
            }
            case 4: {
                return this.chatroom != null && CollectionUtils.isNotEmpty(this.toUsernames);
            }
            case 5: {
                return this.chatroom != null;
            }
            case 6: {
                return this.chatroom != null && this.fromUsername != null && CollectionUtils.isNotEmpty(this.toUsernames);
            }
            case 7: {
                return this.chatroom != null && this.fromUsername != null && this.content != null;
            }
            case 8: {
                return this.chatroom != null && this.fromUsername != null && CollectionUtils.isNotEmpty(this.toUsernames);
            }
            case 10: {
                return this.chatroom != null && this.content != null;
            }
            case 9: {
                return this.fromUsername != null;
            }
            case 100: {
                return CollectionUtils.isNotEmpty(this.toUsernames) && this.fromUsername != null && WeChatMsgType.CHAT_MSG_TYPE_SET.contains(this.weChatMsgType) && this.content != null && this.md5 != null;
            }
            case 11: {
                return this.chatroom != null && this.content != null;
            }
            case 12: {
                return this.chatroom != null && CollectionUtils.isNotEmpty(this.toUsernames);
            }
            case 101: {
                return this.packageId != null;
            }
            case 102: {
                return this.content != null;
            }
            case 50: {
                return this.content != null;
            }
            case 51: {
                return this.content != null;
            }
            case 40: {
                return this.fromUsername != null;
            }
            case 14: {
                return this.chatroom != null;
            }
        }
        return false;
    }

    public Long getId() {
        return this.id;
    }

    public Integer getType() {
        return this.type;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public Integer getLogicId() {
        return this.logicId;
    }

    public String getChatroom() {
        return this.chatroom;
    }

    public String getFromUsername() {
        return this.fromUsername;
    }

    public List<String> getToUsernames() {
        return this.toUsernames;
    }

    public Integer getWeChatMsgType() {
        return this.weChatMsgType;
    }

    public Integer getByQRCode() {
        return this.byQRCode;
    }

    public Integer getByOwner() {
        return this.byOwner;
    }

    public String getContent() {
        return this.content;
    }

    public String getMd5() {
        return this.md5;
    }

    public Long getPackageId() {
        return this.packageId;
    }

    public String getWhatever() {
        return this.whatever;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public void setLogicId(Integer logicId) {
        this.logicId = logicId;
    }

    public void setChatroom(String chatroom) {
        this.chatroom = chatroom;
    }

    public void setFromUsername(String fromUsername) {
        this.fromUsername = fromUsername;
    }

    public void setToUsernames(List<String> toUsernames) {
        this.toUsernames = toUsernames;
    }

    public void setWeChatMsgType(Integer weChatMsgType) {
        this.weChatMsgType = weChatMsgType;
    }

    public void setByQRCode(Integer byQRCode) {
        this.byQRCode = byQRCode;
    }

    public void setByOwner(Integer byOwner) {
        this.byOwner = byOwner;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }

    public void setPackageId(Long packageId) {
        this.packageId = packageId;
    }

    public void setWhatever(String whatever) {
        this.whatever = whatever;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PrismRecord)) {
            return false;
        }
        PrismRecord other = (PrismRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$type = this.getType();
        Integer other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        Long this$createTime = this.getCreateTime();
        Long other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        Integer this$logicId = this.getLogicId();
        Integer other$logicId = other.getLogicId();
        if (this$logicId == null ? other$logicId != null : !((Object)this$logicId).equals(other$logicId)) {
            return false;
        }
        String this$chatroom = this.getChatroom();
        String other$chatroom = other.getChatroom();
        if (this$chatroom == null ? other$chatroom != null : !this$chatroom.equals(other$chatroom)) {
            return false;
        }
        String this$fromUsername = this.getFromUsername();
        String other$fromUsername = other.getFromUsername();
        if (this$fromUsername == null ? other$fromUsername != null : !this$fromUsername.equals(other$fromUsername)) {
            return false;
        }
        List<String> this$toUsernames = this.getToUsernames();
        List<String> other$toUsernames = other.getToUsernames();
        if (this$toUsernames == null ? other$toUsernames != null : !((Object)this$toUsernames).equals(other$toUsernames)) {
            return false;
        }
        Integer this$weChatMsgType = this.getWeChatMsgType();
        Integer other$weChatMsgType = other.getWeChatMsgType();
        if (this$weChatMsgType == null ? other$weChatMsgType != null : !((Object)this$weChatMsgType).equals(other$weChatMsgType)) {
            return false;
        }
        Integer this$byQRCode = this.getByQRCode();
        Integer other$byQRCode = other.getByQRCode();
        if (this$byQRCode == null ? other$byQRCode != null : !((Object)this$byQRCode).equals(other$byQRCode)) {
            return false;
        }
        Integer this$byOwner = this.getByOwner();
        Integer other$byOwner = other.getByOwner();
        if (this$byOwner == null ? other$byOwner != null : !((Object)this$byOwner).equals(other$byOwner)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$md5 = this.getMd5();
        String other$md5 = other.getMd5();
        if (this$md5 == null ? other$md5 != null : !this$md5.equals(other$md5)) {
            return false;
        }
        Long this$packageId = this.getPackageId();
        Long other$packageId = other.getPackageId();
        if (this$packageId == null ? other$packageId != null : !((Object)this$packageId).equals(other$packageId)) {
            return false;
        }
        String this$whatever = this.getWhatever();
        String other$whatever = other.getWhatever();
        return !(this$whatever == null ? other$whatever != null : !this$whatever.equals(other$whatever));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PrismRecord;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        Long $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        Integer $logicId = this.getLogicId();
        result = result * 59 + ($logicId == null ? 43 : ((Object)$logicId).hashCode());
        String $chatroom = this.getChatroom();
        result = result * 59 + ($chatroom == null ? 43 : $chatroom.hashCode());
        String $fromUsername = this.getFromUsername();
        result = result * 59 + ($fromUsername == null ? 43 : $fromUsername.hashCode());
        List<String> $toUsernames = this.getToUsernames();
        result = result * 59 + ($toUsernames == null ? 43 : ((Object)$toUsernames).hashCode());
        Integer $weChatMsgType = this.getWeChatMsgType();
        result = result * 59 + ($weChatMsgType == null ? 43 : ((Object)$weChatMsgType).hashCode());
        Integer $byQRCode = this.getByQRCode();
        result = result * 59 + ($byQRCode == null ? 43 : ((Object)$byQRCode).hashCode());
        Integer $byOwner = this.getByOwner();
        result = result * 59 + ($byOwner == null ? 43 : ((Object)$byOwner).hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $md5 = this.getMd5();
        result = result * 59 + ($md5 == null ? 43 : $md5.hashCode());
        Long $packageId = this.getPackageId();
        result = result * 59 + ($packageId == null ? 43 : ((Object)$packageId).hashCode());
        String $whatever = this.getWhatever();
        result = result * 59 + ($whatever == null ? 43 : $whatever.hashCode());
        return result;
    }

    public String toString() {
        return "PrismRecord(id=" + this.getId() + ", type=" + this.getType() + ", createTime=" + this.getCreateTime() + ", logicId=" + this.getLogicId() + ", chatroom=" + this.getChatroom() + ", fromUsername=" + this.getFromUsername() + ", toUsernames=" + this.getToUsernames() + ", weChatMsgType=" + this.getWeChatMsgType() + ", byQRCode=" + this.getByQRCode() + ", byOwner=" + this.getByOwner() + ", content=" + this.getContent() + ", md5=" + this.getMd5() + ", packageId=" + this.getPackageId() + ", whatever=" + this.getWhatever() + ")";
    }
}

