package com.baijia.storm.sun.api.robot;

import com.baijia.storm.lib.model.QrCodeChatroomRel;
import com.baijia.storm.lib.model.UsernameChatroomRel;
import com.baijia.storm.lib.model.WeChatFriend;
import com.baijia.storm.lib.model.WeChatroom;
import com.baijia.storm.sun.api.common.dto.request.RegisterRequest;
import com.baijia.storm.sun.api.common.model.PrismRecord;
import com.baijia.storm.sun.api.common.model.SunTaskFeedback;
import com.baijia.storm.sun.api.common.proto.SunApiRequest;
import com.baijia.storm.sun.api.common.proto.SunApiResponse;
import sun.security.provider.Sun;

import java.util.List;

/**
 * @Author KaiJia
 * @DATE 2016-08-31
 * @DESC to support robot
 */
public interface RobotApi {
    /**
     * 获取任务
     * @param logicId 获取任务的机器人的逻辑id
     * @param n 试图获取的任务数
     * @return List<SunTask>
     */
    SunApiResponse pickTask(Integer logicId, Integer n);

    /**
     * 任务完成回执
     * @param taskIdList 执行成功的任务id
     * @return none
     */
    @Deprecated
    SunApiResponse feedbackTask(List<Long> taskIdList);

    /**
     * 任务完成回执v2
     * @param sunTaskFeedbackList 回执队列
     * @return none
     */
    SunApiResponse feedbackTaskV2(List<SunTaskFeedback> sunTaskFeedbackList);

    /**
     * 写棱镜记录
     * @param recordList 棱镜记录列表
     * @return none
     */
    SunApiResponse writePrismRecord(List<PrismRecord> recordList);

    /**
     * 更新群信息
     * @param weChatroomList 待更新数据
     * @return none
     */
    SunApiResponse updateWeChatroom(List<WeChatroom> weChatroomList);

    /**
     * 更新群二维码信息
     * @param qrCodeChatroomRelList 待更新数据
     * @return none
     */
    SunApiResponse updateQrCodeChatroomRel(Integer logicId, List<QrCodeChatroomRel> qrCodeChatroomRelList);

    /**
     * 更新用户信息
     * @param weChatFriendList 待更新数据
     * @return none
     */
    SunApiResponse updateWeChatFriend(List<WeChatFriend> weChatFriendList);

    /**
     * 更新群维度用户信息
     * @param usernameChatroomRelList 待更新数据
     * @return none
     */
    SunApiResponse updateUsernameChatroomRel(List<UsernameChatroomRel> usernameChatroomRelList);

    /**
     * 更新机器人的ip
     * @param logicId 机器人的逻辑id
     * @param ip id-address
     * @return none
     */
    SunApiResponse updateRobotIp(Integer logicId, String ip);

    /**
     * 回调-拉人
     * @param logicId 机器人的逻辑id
     * @param chatroom 目标群
     * @return List<SunTask>
     */
    SunApiResponse callback4Invite(Integer logicId, String chatroom);

    /**
     * 查询机器人username列表
     * 注:
     * 该接口返回的username列表发的语音和图片, 上报的机器人不会上传阿里云.
     * 该接口可能因为hack的原因不会返回所有的机器人, hack的目的是让杨小运可以压测.
     * @return List<String>
     */
    SunApiResponse queryRobotUsernames();

    /**
     * 注册新的机器人接口，完成
     * 1. 确定安插LogicId
     *
     * @param registerRequest 注册设备请求
     * @return {@link com.baijia.storm.sun.api.common.dto.response.RegisterResult}
     */
    SunApiResponse regist(RegisterRequest registerRequest);

    /**
     * 下岗, 机器人下线或被封禁时调用该方法, 会将该节点的状态置为失效
     *
     * @param logicId 机器人的logic id
     * @return {@link com.baijia.storm.sun.api.common.dto.response.LaidOffResult }
     */
    SunApiResponse laidOff(int logicId);

    /**
     * 更新机器人基础信息, 包括:
     * 1. IP
     * 2. 版本号
     * @param request 更新请求 payload
     */
    SunApiResponse updateBasicInfo(SunApiRequest request);
}
