package com.baijia.storm.sun.api.open;

import com.baijia.storm.sun.api.common.model.ChatroomUnitRel;
import com.baijia.storm.sun.api.common.model.LaunchChatroomStuff;
import com.baijia.storm.sun.api.common.proto.QueryCondition;
import com.baijia.storm.sun.api.common.proto.SunApiResponse;
import com.baijia.storm.sun.api.common.proto.SunChat;

import org.apache.commons.lang3.tuple.Pair;

import java.util.Collection;
import java.util.List;

/**
 * @Author KaiJia
 * @DATE 2016-09-01
 * @DESC to support business-side
 */
public interface OpenApi {

    /**
     * 群发消息
     * @param sunChat 聊天消息
     * @return none
     */
    SunApiResponse send(SunChat sunChat);

    /**
     * 群发消息 - 经由master
     * @param sunChat 聊天消息
     * @return none
     */
    SunApiResponse sendViaMaster(SunChat sunChat);

    /**
     * 打包群发
     * @param sunChatList 聊天消息队列
     * @return package_id : Long
     */
    SunApiResponse batchSend(List<SunChat> sunChatList, Long packageId);

    /**
     * 打包群发 - 经由master
     * @param sunChatList 聊天消息队列
     * @return package_id : Long
     */
    SunApiResponse batchSendViaMaster(List<SunChat> sunChatList, Long packageId);

    /**
     * 修改群公告
     * @param content 内容
     * @param chatroomList 目标群
     * @return none
     */
    SunApiResponse alterChatroomNotice(String content, List<String> chatroomList);

    /**
     * 修改机器人在群内昵称
     * @param names 昵称[masterName] or [masterName, slaveName]
     * @param chatroomList 目标群
     * @return none
     */
    SunApiResponse alterSelfDisplayName(String[] names, List<String> chatroomList);

    /**
     * 修改群名称
     * @param content 群名称
     * @param chatroomList 目标群
     * @return none
     */
    SunApiResponse alterChatroomName(String content, List<String> chatroomList);

    /**
     * 踢人
     * @param username 目标人的username
     * @param chatroom 目标群
     * @return none
     */
    SunApiResponse kickSomeBody(String username, String chatroom);

    /**
     * 转让群主
     * @param username 目标人的username
     * @param chatroom 目标群
     * @return none
     */
    SunApiResponse transferOwner(String username, String chatroom);

    /**
     * 管理该群
     * @param chatroom 目标群
     * @param xLogicId 群中x机器人
     * @param unit 客户单元
     * @return none
     */
    SunApiResponse manage(String chatroom, Integer xLogicId, Integer unit);

    /**
     * 群内提示
     * @param chatroom 目标群
     * @param xLogicId 群中的x机器人
     * @param content 内容
     * @return none
     */
    SunApiResponse prompt(String chatroom, Integer xLogicId, String content);

    /**
     * 群状态查询
     * @param chatroomList 目标群列表
     * @return Map<String, ChatroomStatus.status>
     */
    SunApiResponse status(List<String> chatroomList);

    /**
     * 取消管理
     * @param chatroom 目标群
     * @return none
     */
    SunApiResponse liberate(String chatroom);

    /**
     * 获取群信息
     * @param chatroomList 目标群
     * @param condition 条件
     * @return Map<String, Object> | "data" -- Map<String, SunWeChatroom>, "len" -- Integer
     */
    SunApiResponse queryChatroomInfo(List<String> chatroomList, QueryCondition condition);

    /**
     * 获取群成员数
     * @param chatroomList 目标群
     * @return Map<String, Integer>
     */
    SunApiResponse queryChatrommMemberCount(List<String> chatroomList);

    /**
     * 获取用户信息
     * @param usernameList 目标人
     * @return Map<String, WeChatFriend>
     */
    SunApiResponse queryFriendInfo(List<String> usernameList);

    /**
     * 获取群维度的用户信息
     * @param chatroom 目标群
     * @param usernameList 目标人
     * @return Map<String, UsernameChatroomRel>
     */
    SunApiResponse queryUsernameChatroomInfo(String chatroom, List<String> usernameList);

    /**
     * 获取用户在群中的信息
     * {@link #queryUsernameChatroomInfo(String, List)} 的批量接口
     *
     * @param chatroomUserListPairList  List< Pair(chatroom, usernameList) >
     * @return {@code Map<String, Map<String, UsernameChatroomRel> }  chatroom -> username -> usernameChatroomRel
     */
    SunApiResponse queryUsernameChatroomInfo(List<Pair<String, List<String>>> chatroomUserListPairList);

    /**
     * 申请x-robot
     * @param n 申请数目
     * @return List<SunDevice>
     */
    SunApiResponse applyXRobot(Integer n);

    /**
     * 修改实体优先级
     * @param entityList 目标实体
     * @param priority 优先级, 枚举参见QueueKeyPriority
     * @return none
     */
    SunApiResponse alterEntityPriority(List<String> entityList, Integer priority);

    /**
     * 解雇机器人
     * @param chatroom 目标群
     * @param logicId 目标机器人
     * @return none
     */
    SunApiResponse fire(String chatroom, Integer logicId);

    /**
     * 启动群
     * @param stuff 启动群需要的物料
     * @return chatroom
     */
    SunApiResponse launchChatroom(LaunchChatroomStuff stuff);

    /**
     * 查询机器人ip列表
     * @return List<String>
     */
    SunApiResponse queryRobotIpList();

    /**
     * 直播负载调优
     * @param chatroomList 目标群
     * @param max 最大负载
     * @return none
     */
    SunApiResponse optimize4Live(List<String> chatroomList, Integer max);

//    /**
//     * 替换master
//     * @param chatroomList 目标群
//     * @return none
//     */
//    SunApiResponse replaceMaster(List<String> chatroomList);

    /**
     * 归还群主
     * @return none
     */
    SunApiResponse givebackChatroomOwner();

    /**
     * 撤退: 当机器人不负责群中工作的时候, 退出该群
     * @return none
     */
    SunApiResponse retreat();

    /**
     * 浮出水面
     * @param logicIdList 目标机器人
     * @param chatroom 目标群
     * @return none
     */
    @Deprecated
    SunApiResponse surface(List<Integer> logicIdList, String chatroom);

    /**
     * 浮出水面2好友
     * @param logicId 机器人的逻辑id
     * @param toUsername 目标人
     * @param content 浮出水面后说的话
     * @return none
     */
    @Deprecated
    SunApiResponse surface2Friend(Integer logicId, String toUsername, String content);

    /**
     * 更新chatroom-unit关系
     * @param rels 待更新关系
     * @return none
     */
    SunApiResponse updateChatroomUnitRel(List<ChatroomUnitRel> rels);

    /**
     * 批量查询可达性 (可达, 即有x机器人为好友)
     * @param usernameList
     * @return Set<String>, 可达的usernames
     */
    SunApiResponse contactable(List<String> usernameList);

    /**
     * 获取用户
     * @return Collection<String> X机器人的好友列表
     */
    SunApiResponse getXRobotFriendList();

    /**
     * 清理X机器人好友列表
     * @param usernameList 需要删除的用户名列表
     * @return
     */
    SunApiResponse cleanUpXRobotFriend(Collection<String> usernameList);
}
