package com.baijia.storm.sun.api.common.util;

import com.baijia.storm.sun.api.common.model.QueueKey;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * @Author KaiJia
 * @DATE 2016-09-05
 */
public class QueueKeyGenerator {
    public static final String SEPARATOR = "_";

    /**
     * TYPE
     */
    public static final String QUEUE_KEY_TYPE_CHATROOM = "c";
    public static final String QUEUE_KEY_TYPE_FRIEND = "f";
    public static final String QUEUE_KEY_TYPE_XROBOT = "x";
    public static final String QUEUE_KEY_TYPE_LOGICID = "l";
    public static final Set<String> SET_QUEUE_KEY_TYPE = new HashSet<String>() {{
        add(QUEUE_KEY_TYPE_CHATROOM);
        add(QUEUE_KEY_TYPE_FRIEND);
        add(QUEUE_KEY_TYPE_XROBOT);
        add(QUEUE_KEY_TYPE_LOGICID);
    }};

    /**
     * ROLE
     */
    public static final String QUEUE_KEY_ROLE_MASTER = "m";
    public static final String QUEUE_KEY_ROLE_SLAVE = "s";
    public static final Set<String> SET_QUEUE_KEY_ROLE = new HashSet<String>() {{
        add(QUEUE_KEY_ROLE_MASTER);
        add(QUEUE_KEY_ROLE_SLAVE);
    }};


    /**
     * QueueKey Prefix
     */
    public static final String QUEUE_KEY_CHATROOM_PREFIX = QUEUE_KEY_TYPE_CHATROOM + SEPARATOR;
    public static final String QUEUE_KEY_FRIEND_PREFIX = QUEUE_KEY_TYPE_FRIEND + SEPARATOR;
    public static final String QUEUE_KEY_XROBOT_PREFIX = QUEUE_KEY_TYPE_XROBOT + SEPARATOR;
    public static final String QUEUE_KEY_LOGICID_PREFIX = QUEUE_KEY_TYPE_LOGICID + SEPARATOR;

    /**
     * LIKE
     */
    public static final String QUEUE_KEY_LIKE_CHATROOM = QUEUE_KEY_TYPE_CHATROOM + SEPARATOR + '%';
    public static final String QUEUE_KEY_LIKE_FRIEND = QUEUE_KEY_TYPE_FRIEND + SEPARATOR + "%";
    public static final String QUEUE_KEY_LIKE_CHATROOM_MASTER = QUEUE_KEY_TYPE_CHATROOM + SEPARATOR + '%' + SEPARATOR + QUEUE_KEY_ROLE_MASTER;
    public static final String QUEUE_KEY_LIKE_CHATROOM_SLAVE = QUEUE_KEY_TYPE_CHATROOM + SEPARATOR + '%' + SEPARATOR + QUEUE_KEY_ROLE_SLAVE;

    /**
     * GEN
     */
    public static String genChatroomQueueKey(String chatroom, boolean isMaster) {
        String role = isMaster ? QUEUE_KEY_ROLE_MASTER : QUEUE_KEY_ROLE_SLAVE;
        return QUEUE_KEY_TYPE_CHATROOM + SEPARATOR +
                chatroom + SEPARATOR +
                role;
    }

    public static String genChatroomQueueKeyLike(String chatroom) {
        return QUEUE_KEY_TYPE_CHATROOM + SEPARATOR +
                chatroom + SEPARATOR +
                '%';
    }

    public static String genChatroomMasterQueueKey(String chatroom) {
        return genChatroomQueueKey(chatroom, true);
    }

    public static String genChatroomSlaveQueueKey(String chatroom) {
        return genChatroomQueueKey(chatroom, false);
    }

    public static List<String> genChatroomQueueKeyAll(String chatroom) {
        return Arrays.asList(genChatroomQueueKey(chatroom, false),
                genChatroomQueueKey(chatroom, true));
    }

    public static String genFriendQueueKey(String username) {
        return QUEUE_KEY_TYPE_FRIEND + SEPARATOR + username;
    }

    public static String genXRobotQueueKey(int logicId) {
        return QUEUE_KEY_TYPE_XROBOT + SEPARATOR + logicId;
    }

    public static String genLogicIdQueueKey(int logicId) {
        return QUEUE_KEY_TYPE_LOGICID + SEPARATOR + logicId;
    }

    public static String s2m(String slaveQueueKey) {
        QueueKey queueKey = new QueueKey(slaveQueueKey);
        return genChatroomQueueKey(queueKey.getEntity(), true);
    }

    public static String m2s(String masterQueueKey) {
        QueueKey queueKey = new QueueKey(masterQueueKey);
        return genChatroomQueueKey(queueKey.getEntity(), false);
    }
}
