package com.baijia.storm.sun.api.common.util;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

import com.baijia.storm.sun.api.common.behavior.Validatable;
import com.baijia.storm.sun.api.common.exception.CustomException;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.RandomUtils;
import org.slf4j.LoggerFactory;
import org.slf4j.Logger;

/**
 * @Author KaiJia
 * @DATE 2016-04-08
 * @DESC 列表工具
 */
public class ListUtil {
    private static final Logger log = LoggerFactory.getLogger(ListUtil.class);

    public static <T> List<T> compact(List<T> list) {
        if (list == null) {
            return list;
        }
        List<T> newList = new LinkedList<T>();
        for (T t : list) {
            if (t != null){
                newList.add(t);
            }
        }
        return newList;
    }

    public static <T extends Validatable> boolean validate(List<T> list) {
        if (list == null) {
            return false;
        }
        for (T t : list) {
            if (t == null || !t.isValid()) {
                return false;
            }
        }
        return true;
    }

    public static <T extends Validatable> void validate(List<T> list,
                                                        CustomException e,
                                                        String clazz,
                                                        String method,
                                                        String sign) throws CustomException {
        if (!validate(list)) {
            log.error("[VALIDATE ERROR] clazz[{}] method[{}] sign[{}] list[{}]",
                    clazz,
                    method,
                    sign,
                    LogUtil.toString(list));
            throw e;
        }
    }

    public static <T> void assertLen(List<T> list,
                                     int expected,
                                     CustomException e,
                                     String clazz,
                                     String method,
                                     String sign) throws CustomException {
        if (list == null || list.size() != expected) {
            log.error("[ASSERT LEN ERROR] expected[{}] actual[{}] clazz[{}] method[{}] sign[{}]",
                    expected,
                    list == null ? "null" : String.valueOf(list.size()),
                    clazz,
                    method,
                    sign);
            throw e;
        }
    }

    public static <T extends Validatable> List<T> compactAndValidate(List<T> list,
                                                                     CustomException e,
                                                                     String clazz,
                                                                     String method,
                                                                     String sign) throws CustomException {
        list = compact(list);
        validate(list, e, clazz, method, sign);
        return list;
    }

    public static <T> List<T> compactAndAssertLen(List<T> list,
                                                  int expected,
                                                  CustomException e,
                                                  String clazz,
                                                  String method,
                                                  String sign) throws CustomException {
        list = compact(list);
        assertLen(list, expected, e, clazz, method, sign);
        return list;
    }

    public static <T extends Validatable> void assertLenAndValidate(List<T> list,
                                                                      int expected,
                                                                      CustomException e,
                                                                      String clazz,
                                                                      String method,
                                                                      String sign) throws CustomException {
        assertLen(list, expected, e, clazz, method, sign);
        validate(list, e, clazz, method, sign);
    }

    public static <T extends Validatable> List<T> compactAndAssertLenAndValidate(List<T> list,
                                                                     int expected,
                                                                     CustomException e,
                                                                     String clazz,
                                                                     String method,
                                                                     String sign) throws CustomException {
        list = compact(list);
        assertLenAndValidate(list, expected, e, clazz, method, sign);
        return list;
    }

    public static boolean isBlank(List list) {
        return list == null || list.isEmpty();
    }

    public static int sum(Collection<Integer> list) {
        int sum = 0;
        if (list == null) {
            return sum;
        }
        for (Integer item : list) {
            sum += item;
        }
        return sum;
    }

    public static  <T> T getRandom(List<T> list) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.get(RandomUtils.nextInt(0, list.size()));
    }

}
