package com.baijia.storm.sun.api.common.proto;

import com.baijia.storm.lib.constant.WeChatMsgType;
import com.baijia.storm.sun.api.common.behavior.Validatable;
import com.baijia.storm.sun.api.common.constant.AddressType;
import lombok.Data;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.List;

/**
 * @Author KaiJia
 * @DATE 2016-09-28
 * @DESC 聊天消息
 */
@Data
public class SunChat implements Validatable, Serializable {
    private Integer weChatMsgType;
    private String content;
    private List<String> addressList;
    private Integer addressType;

    public SunChat() {}

    public SunChat(Integer weChatMsgType, String content, List<String> addressList, Integer addressType) {
        this.weChatMsgType = weChatMsgType;
        this.content = content;
        this.addressList = addressList;
        this.addressType = addressType;
    }

    @Override
    public boolean isValid() {
        if (!WeChatMsgType.CHAT_MSG_TYPE_SET.contains(weChatMsgType)) {
            return false;
        }
        if (StringUtils.isBlank(content)) {
            return false;
        }
        if (CollectionUtils.isEmpty(addressList)) {
            return false;
        }
        if (!AddressType.ALL_TYPE.contains(addressType)) {
            return false;
        }
        return true;
    }
}
