package com.baijia.storm.sun.api.common.proto;

import org.apache.commons.lang3.StringUtils;

import lombok.Data;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * @Author KaiJia
 * @DATE 2016-08-31
 */
@Data
public class SunApiResponse implements Serializable {
    private Integer code;
    private String msg;
    private Object data;

    public SunApiResponse() {}

    public static final int CODE_SUCCESS = 0;
    public static final String MSG_SUCCESS = "success";

    public static final int CODE_PARAM_ERROR = -1;
    public static final String MSG_PARAM_ERROR = "param error";

    public static final int CODE_BIZ_ERROR = -2;
    public static final String MSG_BIZ_ERROR = "biz error";

    public static final int CODE_SYS_ERROR = -3;
    public static final String MSG_SYS_ERROR = "sys error";

    public static final int CODE_CUSTOM_ERROR = -4;
    public static final String MSG_CUSTOM_ERROR = "custom error";

    public static final int CODE_RESOURCE_NOT_ENOUGH_ERROR = -5;
    public static final String MSG_RESOURCE_NOT_ENOUGH_ERROR = "resource not enough error";

    public static final int CODE_NOT_OWN_CHATROOM_ERROR = -6;
    public static final String MSG_NOT_OWN_CHATROOM_ERROR = "not own chatroom error";

    public static final int CODE_INVALID_IP_ERROR = -7;
    public static final String MSG_INVALID_IP_ERROR = "invalid ip address";

    public static final int CODE_NOT_EXIST_X_FRIEND = -8;
    public static final String MSG_NOT_EXIST_X_FRIEND = "not exist x friend";

    public static final int CODE_DEPRECATED_FUNCTION = -9;
    public static final String MSG_DEPRECATED_FUNCTION = "deprecated function";

    public static final int CODE_DUPLICATED_RESOURCE = -10;
    public static final String MSG_DUPLICATED_RESOURCE = "duplicated resource";

    public static final int CODE_RESOURCE_LOCKED = -11;
    public static final String MSG_RESOURCE_LOCKED = "resource is locked.";

    private static final Map<Integer, String> CODE_2_MSG;

    static {
        CODE_2_MSG = new HashMap<>();
        CODE_2_MSG.put(CODE_SUCCESS, MSG_SUCCESS);
        CODE_2_MSG.put(CODE_PARAM_ERROR, MSG_PARAM_ERROR);
        CODE_2_MSG.put(CODE_BIZ_ERROR, MSG_BIZ_ERROR);
        CODE_2_MSG.put(CODE_SYS_ERROR, MSG_SYS_ERROR);
        CODE_2_MSG.put(CODE_CUSTOM_ERROR, MSG_CUSTOM_ERROR);
        CODE_2_MSG.put(CODE_RESOURCE_NOT_ENOUGH_ERROR, MSG_RESOURCE_NOT_ENOUGH_ERROR);
        CODE_2_MSG.put(CODE_NOT_OWN_CHATROOM_ERROR, MSG_NOT_OWN_CHATROOM_ERROR);
        CODE_2_MSG.put(CODE_INVALID_IP_ERROR, MSG_INVALID_IP_ERROR);
        CODE_2_MSG.put(CODE_NOT_EXIST_X_FRIEND, MSG_NOT_EXIST_X_FRIEND);
        CODE_2_MSG.put(CODE_DEPRECATED_FUNCTION, MSG_DEPRECATED_FUNCTION);
        CODE_2_MSG.put(CODE_DUPLICATED_RESOURCE, MSG_DUPLICATED_RESOURCE);
        CODE_2_MSG.put(CODE_RESOURCE_LOCKED, MSG_RESOURCE_LOCKED);
    }

    public static SunApiResponse createResponse(int code) {
        return createResponse(code, CODE_2_MSG.get(code));
    }

    public static SunApiResponse createResponse(int code, String msg) {
        SunApiResponse response = new SunApiResponse();
        response.setCode(code);
        if (StringUtils.isNotBlank(msg)) {
            response.setMsg(msg);
        } else {
            response.setMsg(CODE_2_MSG.get(code));
        }
        response.setData(null);
        return response;
    }
}
