package com.baijia.storm.sun.api.common.model;

import com.baijia.storm.sun.api.common.behavior.Validatable;
import com.baijia.storm.sun.api.common.constant.SunTaskType;
import lombok.Data;

/**
 * @Author KaiJia
 * @DATE 2016/10/17
 */
@Data
public class SunTaskFeedback implements Validatable {
    private Long id;
    private Integer type;
    private Integer logicId;
    private String chatroom;
    private String md5;

    public SunTaskFeedback() {}

    public SunTaskFeedback(Integer logicId, String chatroom, String md5) {
        this.logicId = logicId;
        this.chatroom = chatroom;
        this.md5 = md5;
    }

    @Override
    public boolean isValid() {
        if (id == null) {
            return false;
        }
        if (!SunTaskType.SET_ALL.contains(type)) {
            return false;
        }
        if (logicId == null) {
            return false;
        }
        if (type == SunTaskType.CHATROOM_SEND_MSG && chatroom == null) {
            return false;
        }
        if (type == SunTaskType.CHATROOM_SEND_MSG && md5 == null) {
            return false;
        }
        return true;
    }
}
