package com.baijia.storm.sun.api.common.model;

import java.io.Serializable;
import java.util.List;

import lombok.Data;

/**
 * @Author KaiJia
 * @DATE 2016-09-01
 * @DESC Task for robot
 */
@Data
public class SunTask implements Serializable {
    private Long id;
    private Integer type;
    private Long createTime;  // unix时间戳

    private String chatroom;
    private List<String> toUsernames;

    private Integer weChatMsgType;
    private String content;

    private Long packageId;

    private String owner;
    private String whatever;

    public SunTask() {
        this.createTime = System.currentTimeMillis() / 1000;
    }

    public SunTask(Integer type) {
        this(type, null);
    }

    public SunTask(Integer type, String chatroom) {
        super();
        this.type = type;
        this.chatroom = chatroom;
        this.createTime = System.currentTimeMillis() / 1000;
    }
}
