package com.baijia.storm.sun.api.common.model;

import com.baijia.storm.sun.api.common.behavior.Validatable;
import com.baijia.storm.sun.api.common.efficient.QueueKeyPriority;
import com.baijia.storm.sun.api.common.util.QueueKeyGenerator;
import lombok.Data;

/**
 * @Author KaiJia
 * @DATE 2016/10/13
 */
@Data
public class QueueKey implements Validatable {
    private String origin;
    private String type;
    private String entity;
    private String role;
    private Integer priority;

    public QueueKey(String origin) {
        this.origin = origin;
        if (origin == null) {
            return;
        }
        type = origin.substring(0, 1);
        if (QueueKeyGenerator.QUEUE_KEY_TYPE_CHATROOM.equals(type)) {
            String[] terms = origin.split(QueueKeyGenerator.SEPARATOR);
            entity = terms[1];
            role = terms[2];
        } else {
            entity = origin.substring(2);
        }
    }

    @Override
    public boolean isValid() {
        if (origin == null) {
            return false;
        }
        if (!QueueKeyGenerator.SET_QUEUE_KEY_TYPE.contains(type)) {
            return false;
        }
        if (entity == null || entity.trim().isEmpty()) {
            return false;
        }
        if (QueueKeyGenerator.QUEUE_KEY_TYPE_CHATROOM.equals(type)
                && !QueueKeyGenerator.SET_QUEUE_KEY_ROLE.contains(role)) {
            return false;
        }
        return true;
    }

    public Integer getPriority() {
        return priority != null ? priority : QueueKeyPriority.LEVEL_NORMAL;
    }
}
