package com.baijia.storm.sun.api.common.model;

import com.baijia.storm.lib.constant.WeChatMsgType;
import com.baijia.storm.sun.api.common.behavior.Validatable;
import com.baijia.storm.sun.api.common.constant.PrismRecordType;
import lombok.Data;
import org.apache.commons.collections4.CollectionUtils;

import java.io.Serializable;
import java.util.List;

/**
 * @Author KaiJia
 * @DATE 2016-09-01
 * @DESC 棱镜记录
 */
@Data
public class PrismRecord implements Validatable, Serializable {
    private Long id;
    private Integer type;
    private Long createTime;  // unix时间戳
    private Integer logicId;

    private String chatroom;

    private String fromUsername;
    private String fromNickname;
    private List<String> toUsernames;
    private Byte toUserType;
    private Boolean isRobotMentioned; // 是否有机器人被提及

    private Integer weChatMsgType;
    private Integer byQRCode;
    private Integer byOwner;

    private String content;
    private String md5; // 语音图片为文件的MD5,其余类型为文本内容的MD5

    private Long packageId;

    private String whatever;

    public PrismRecord() {
    }

    @Override
    public boolean isValid() {
        return basicValid() && personalValid();
    }

    private boolean basicValid() {
        if (id == null || id < 0) {
            return false;
        }
        if (type == null || !PrismRecordType.TYPE_SET_ALL.contains(type)) {
            return false;
        }
        if (createTime == null) {
            return false;
        }
        if (logicId == null || logicId < 0) {
            return false;
        }
        return true;
    }

    private boolean personalValid() {
        switch (type) {
            case PrismRecordType.CHAT_MSG:
                return chatroom != null
                        && fromUsername != null
                        && WeChatMsgType.CHAT_MSG_TYPE_SET.contains(weChatMsgType)
                        && content != null
                        && md5 != null;
            case PrismRecordType.JOIN_CHATROOM:
                return chatroom != null
                        && CollectionUtils.isNotEmpty(toUsernames);
            case PrismRecordType.JOIN_CHATROOM_V2:
                return chatroom != null
                        && CollectionUtils.isNotEmpty(toUsernames);
            case PrismRecordType.TRANSFER_OWNER:
                return chatroom != null
                        && CollectionUtils.isNotEmpty(toUsernames);
            case PrismRecordType.INITIATIVE_LEAVE_CHATROOM:
                return chatroom != null;
            case PrismRecordType.PASSIVITY_LEAVE_CHATROOM:
                return chatroom != null
                        && fromUsername != null
                        && CollectionUtils.isNotEmpty(toUsernames);
            case PrismRecordType.UPDATE_CHATROOM_QRCODE:
                return chatroom != null
                        && fromUsername != null
                        && content != null;
            case PrismRecordType.KICK_OUT_MEMBER:
                return chatroom != null
                        && fromUsername != null
                        && CollectionUtils.isNotEmpty(toUsernames);
            case PrismRecordType.MODIFY_CHATROOM_NICKNAME:
                return chatroom != null
                        && content != null;
            case PrismRecordType.ADDED_FRIEND:
                return fromUsername != null;
            case PrismRecordType.FRIEND_CHAT_MSG:
                return CollectionUtils.isNotEmpty(toUsernames)
                        && fromUsername != null
                        && WeChatMsgType.CHAT_MSG_TYPE_SET.contains(weChatMsgType)
                        && content != null
                        && md5 != null;
            case PrismRecordType.MODIFY_SELF_DISPLAYNAME:
                return chatroom != null
                        && content != null;
            case PrismRecordType.CHATROOM_NEW_USERNAME:
                return chatroom != null
                        && CollectionUtils.isNotEmpty(toUsernames);
            case PrismRecordType.TASK_FINISHED:
                return packageId != null;
            case PrismRecordType.ROBOT_SAID:
                return content != null;
            case PrismRecordType.WARNING_OTHER_ACCOUNT:
                return content != null;
            case PrismRecordType.DIALOG_MESSAGE:
                return content != null;
            case PrismRecordType.FRIEND_BE_DELETED:
                return fromUsername != null;
            case PrismRecordType.CHATROOM_PREPARE:
                return chatroom != null;
            default:
                return false;
        }
    }
}