package com.baijia.storm.sun.api.common.model;

import com.baijia.storm.sun.api.common.behavior.Validatable;
import lombok.Data;
import org.apache.commons.collections4.CollectionUtils;

import java.io.Serializable;
import java.util.List;

/**
 * @Author KaiJia
 * @DATE 2016/10/26
 * @DESC 启动群的原料
 */
@Data
public class LaunchChatroomStuff implements Validatable, Serializable {
    private List<String> founders;  // 创始人, 一般指需要拉进来的客户
    private String name;  // 群名
    private Integer unit;  // 客户单元, 用来做资源的最优分配

    @Override
    public boolean isValid() {
        if (CollectionUtils.isEmpty(founders)) {
            return false;
        }
        if (unit == null || unit < 0) {
            return false;
        }
        return true;
    }
}
