package com.baijia.storm.sun.api.common.model;

import com.baijia.storm.sun.api.common.behavior.Validatable;
import lombok.Data;

import java.io.Serializable;

/**
 * @Author KaiJia
 * @DATE 2016/11/17
 */
@Data
public class ChatroomUnitRel implements Validatable, Serializable {
    private String chatroom;
    private Integer unit;

    @Override
    public boolean isValid() {
        if (chatroom == null || !chatroom.contains("@")) {
            return false;
        }
        if (unit == null || unit < 0) {
            return false;
        }
        return true;
    }
}
