package com.baijia.storm.sun.api.common.model;

import com.baijia.storm.sun.api.common.conf.BizConf;

import java.io.Serializable;

import lombok.Data;

/**
 * 回调参数
 * @author fangwentong
 */
@Data
public class CallbackInfo implements Serializable {
    private String className;   // 类名
    private String methodName;  // 方法名
    private String param;       // 参数, JSON格式

    public CallbackInfo() {}

    public CallbackInfo(String className, String methodName, Object param) {
        this.className = className;
        this.methodName = methodName;
        this.param = BizConf.gson.toJson(param);
    }

    public <T> T originParam(Class<T> clazz) {
        if (this.param == null) {
            return null;
        }
        return BizConf.gson.fromJson(this.param, clazz);
    }
}
