package com.baijia.storm.sun.api.common.efficient;

import lombok.Data;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * @Author KaiJia
 * @DATE 2016/10/13
 * @DESC 任务优先级
 */
@Data
public class QueueKeyPriority {
    public static final int LEVEL_VERY_HIGH = 0;
    public static final int LEVEL_HIGH = 10;
    public static final int LEVEL_NORMAL = 20;
    public static final Set<Integer> SET_ALL_LEVEL = new HashSet<Integer>() {{
        add(LEVEL_VERY_HIGH);
        add(LEVEL_HIGH);
        add(LEVEL_NORMAL);
    }};

    private int level;
    private double ratio;

    private QueueKeyPriority(int level, double ratio) {
        this.level = level;
        this.ratio = ratio;
    }

    public static final List<QueueKeyPriority> QUEUE_KEY_PRIORITY_LIST = new ArrayList<QueueKeyPriority>() {{
        add(new QueueKeyPriority(LEVEL_VERY_HIGH, 0.00));
        add(new QueueKeyPriority(LEVEL_HIGH, 0.90));
        add(new QueueKeyPriority(LEVEL_NORMAL, 0.10));
    }};
}
