package com.baijia.storm.sun.api.common.dto.request;

import java.io.Serializable;

import com.baijia.storm.sun.api.common.behavior.Validatable;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

/**
 * 注册新设备的请求
 *
 * @author fangwentong
 */
@Data
public class RegisterRequest implements Serializable, Validatable {
    private static final long serialVersionUID = 8470275508716248020L;

    private String wechatUsername;

    private String wechatAlias;

    private Byte machineIsVirtual;

    private String machineInfo;

    private Byte specialized;

    private Integer cluster;

    private String qrCode;

    private String ip;


    @Override
    public boolean isValid() {
        return StringUtils.isNotBlank(wechatUsername)
                && cluster != null
                && specialized != null
                ;
    }
}
