package com.baijia.storm.sun.api.common.constant;

import java.util.HashSet;
import java.util.Set;

/**
 * @Author KaiJia
 * @DATE 2016-09-01
 * @DESC type enum for SunTask
 */
public class SunTaskType {
    public static final int CHATROOM_SEND_MSG = 1; // 发送消息
    public static final int CHATROOM_INVITE = 2; // 邀请人
    public static final int CHATROOM_KICK_OUT = 3;  // 踢人
    public static final int CHATROOM_TRANSFER_OWNER = 4;  // 更换群主
    public static final int CHATROOM_UPDATE_NOTICE = 5;  // 更新群公告
    public static final int CHATROOM_UPDATE_NAME = 6;  // 更新群名称
    public static final int CHATROOM_LEAVE = 7;  // 退群
    public static final int CHATROOM_ALTER_SELF_DISPLAYNAME = 8;  // 更新群内的昵称
    public static final int CHATROOM_CALLBACK_INVITE = 10; // 回调-邀请人
    public static final int CHATROOM_PREPARE = 11; // 建群
    public static final int CHATROOM_UPDATE_QRCODE_REL = 12;  // 更新群邀请二维码的任务
    public static final int CHATROOM_LEAVE_ALL = 13;  // 退出所有群

    public static final int FRIEND_SEND_MSG = 100; // 给好友发送消息
    public static final int DELETE_FRIEND = 101; // 主动删除好友
    public static final int ADD_FRIEND = 102; // 主动添加好友

    // ==================== 管理任务
    public static final int UPDATE_IP = 200; // 更新IP
    public static final int CLEAR_CHAT_MSG = 201; // 清空聊天记录

    public static final Set<Integer> SET_ALL = new HashSet<Integer>() {{
        add(CHATROOM_SEND_MSG);
        add(CHATROOM_INVITE);
        add(CHATROOM_KICK_OUT);
        add(CHATROOM_TRANSFER_OWNER);
        add(CHATROOM_UPDATE_NOTICE);
        add(CHATROOM_UPDATE_NAME);
        add(CHATROOM_LEAVE);
        add(CHATROOM_ALTER_SELF_DISPLAYNAME);
        add(FRIEND_SEND_MSG);
        add(CHATROOM_CALLBACK_INVITE);
        add(CHATROOM_PREPARE);
        add(CHATROOM_UPDATE_QRCODE_REL);
        add(DELETE_FRIEND);
        add(ADD_FRIEND);
        add(CHATROOM_LEAVE_ALL);
        add(UPDATE_IP);
        add(CLEAR_CHAT_MSG);
    }};
}
