package com.baijia.storm.sun.api.common.constant;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/**
 * @Author KaiJia
 * @DATE 2016-09-01
 * @DESC type enum for PrismRecord
 */
public class PrismRecordType {
    public static final int CHAT_MSG = 1; // 群聊天消息
    public static final int FRIEND_CHAT_MSG = 100; // 好友聊天消息

    /**
     * 配置文件使用了这些数值。修改时请同步。详见ctx-prism.xml
     */
    public static final int JOIN_CHATROOM = 2; // 进群
    public static final int TRANSFER_OWNER = 4; // 群主转让
    public static final int INITIATIVE_LEAVE_CHATROOM = 5; // 主动退群
    public static final int PASSIVITY_LEAVE_CHATROOM = 6; // 你被谁踢出了群
    public static final int UPDATE_CHATROOM_QRCODE = 7; // 更新群二维码
    public static final int KICK_OUT_MEMBER = 8; // 踢人出群
    public static final int ADDED_FRIEND = 9; // 加好友通知
    public static final int MODIFY_CHATROOM_NICKNAME = 10; // 更改群名称
    public static final int MODIFY_SELF_DISPLAYNAME = 11; // 更改群内自己的昵称
    public static final int CHATROOM_NEW_USERNAME = 12; // 群内新成员Username
    public static final int CHATROOM_PREPARE = 14; // 建群
    public static final int CHATROOM_QRCODE_DELETED = 15;  // 群二维码被删除
    public static final int JOIN_CHATROOM_V2 = 16;  // 进群

    public static final int FRIEND_BE_DELETED = 40; // 被好友删除
    public static final int INITIATIVE_DELETE_FRIEND = 41; // 主动删除好友

    public static final int WARNING_OTHER_ACCOUNT = 50; // 风险提示
    public static final int DIALOG_MESSAGE = 51; // 对话框

    public static final int TASK_FINISHED = 101; // 任务处理完成
    public static final int ROBOT_SAID = 102; // anyway


    public static final Set<Integer> TYPE_SET_ALL = new HashSet<Integer>() {
        {
            add(CHAT_MSG);
            add(JOIN_CHATROOM);
            add(TRANSFER_OWNER);
            add(INITIATIVE_LEAVE_CHATROOM);
            add(PASSIVITY_LEAVE_CHATROOM);
            add(UPDATE_CHATROOM_QRCODE);
            add(KICK_OUT_MEMBER);
            add(ADDED_FRIEND);
            add(MODIFY_CHATROOM_NICKNAME);
            add(FRIEND_CHAT_MSG);
            add(TASK_FINISHED);
            add(MODIFY_SELF_DISPLAYNAME);
            add(CHATROOM_NEW_USERNAME);
            add(ROBOT_SAID);
            add(WARNING_OTHER_ACCOUNT);
            add(DIALOG_MESSAGE);
            add(FRIEND_BE_DELETED);
            add(CHATROOM_PREPARE);
            add(CHATROOM_QRCODE_DELETED);
            add(JOIN_CHATROOM_V2);
            add(INITIATIVE_DELETE_FRIEND);
        }
    };

    public static final Set<Integer> TYPE_SET_ACT = new HashSet<Integer>() {
        {
//            add(JOIN_CHATROOM);  // 目前仅处理 JOIN_CHATROOM_V2
            add(TRANSFER_OWNER);
            add(INITIATIVE_LEAVE_CHATROOM);
            add(PASSIVITY_LEAVE_CHATROOM);
            add(ADDED_FRIEND);
            add(CHATROOM_PREPARE);
            add(JOIN_CHATROOM_V2);
            add(FRIEND_BE_DELETED);
            add(DIALOG_MESSAGE);
            add(ROBOT_SAID);
            add(INITIATIVE_DELETE_FRIEND);
        }
    };

    /**
     * 所有需要检查事件回调的prism记录类型
     */
    public static final Set<Integer> TYPE_SET_TASK_CALLBACK = Collections.unmodifiableSet(
            new HashSet<Integer>() {
                {
                    add(JOIN_CHATROOM_V2);
                }
            }
    );
}