package com.baijia.storm.sun.api.common.constant;

import lombok.Data;

/**
 * @Author KaiJia
 * @DATE 2016-11-11
 * @DESC 群状态
 */
@Data
public class ChatroomStatus {
    public static final int NONE = 0b00;
    public static final int NONE_MASTER = 0b01;
    public static final int NONE_SLAVE = 0b10;
    public static final int OK = 0b11;

    private int status;

    public ChatroomStatus() {
        this.status = 0;
    }

    public ChatroomStatus(int status) {
        this.status = status;
    }

    public void setExistMaster() {
        status |= 0b10;
    }

    public void setExistSlave() {
        status |= 0b01;
    }

    public boolean existMaster() {
        return (status & 0b10) != 0;
    }

    public boolean existSlave() {
        return (status & 0b01) != 0;
    }

    public boolean notExistMaster() {
        return !existMaster();
    }

    public boolean notExistSlave() {
        return !existSlave();
    }

    public boolean isOk() {
        return existMaster() && existSlave();
    }
}
