/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.orgclass.common.utils;

import com.baijia.orgclass.common.enums.OrgClassCourseEnums;
import java.util.Arrays;

public class SerialNumberUtil {
    public static final int MAX = 999999999;
    private static final int power = (int)(Math.log(9.99999999E8) / Math.log(2.0));
    private static final int[] bitMap = SerialNumberUtil.mapBit(power - 1);

    public static long generateNumber(int id, OrgClassCourseEnums enums) {
        return SerialNumberUtil.generateNumber(id, enums.getCode());
    }

    public static long generateGradeNumber(int id, OrgClassCourseEnums enums) {
        return SerialNumberUtil.generateNumber(id, enums.getGradeSuffix());
    }

    public static long generateClassInfoNumber(int id, OrgClassCourseEnums enums) {
        return SerialNumberUtil.generateNumber(id, enums.getInfoSuffix());
    }

    public static long generateNumber(int id, int suffix) {
        SerialNumberUtil.assertId(id, 999999999);
        int encodedId = SerialNumberUtil.encode(id, 999999999);
        int number = SerialNumberUtil.allocateStart(999999999) + encodedId;
        Long serialNum = Integer.valueOf(number).longValue() * 100000L + (long)SerialNumberUtil.getRandom() + (long)suffix;
        return serialNum;
    }

    private static int allocateMax(int max) {
        return (int)Math.pow(2.0, SerialNumberUtil.power(max)) - 1;
    }

    private static int power(int max) {
        return (int)(Math.log(max) / Math.log(2.0));
    }

    private static int allocateStart(int max) {
        return max - (int)Math.pow(2.0, SerialNumberUtil.power(max)) + 1;
    }

    private static void assertId(int id, int max) {
        int allocateMax = SerialNumberUtil.allocateMax(max);
        if (id > allocateMax) {
            throw new RuntimeException("generateNumber by id:" + id + " out of range [1," + allocateMax + "] ...");
        }
    }

    private static int encode(int id, int max) {
        int encodedId = 0;
        int i = 0;
        while (i < SerialNumberUtil.power(max)) {
            int tmp = id >> i & 1;
            encodedId |= tmp << bitMap[i];
            ++i;
        }
        return encodedId;
    }

    private static int[] mapBit(int power) {
        int[] bit = new int[power + 1];
        int i = 0;
        while (i <= power / 2) {
            if (i % 2 == 0) {
                bit[i] = power - i;
                bit[power - i] = i;
            } else {
                bit[i] = i;
                bit[power - i] = power - i;
            }
            ++i;
        }
        return bit;
    }

    private static final int getRandom() {
        Double r = Math.random();
        int v = Integer.parseInt(r.toString().substring(3, 5));
        return v * 1000;
    }

    public static void main(String[] args) {
        System.out.println(SerialNumberUtil.power(999999999));
        System.out.println(Arrays.toString(bitMap));
        int i = 0;
        while (i < 100) {
            System.out.println(SerialNumberUtil.generateNumber(i, OrgClassCourseEnums.OVO));
            ++i;
        }
    }
}

