/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.commons.lang.utils.mq.mns;

import com.aliyun.mns.client.AsyncCallback;
import com.aliyun.mns.client.AsyncResult;
import com.aliyun.mns.client.CloudAccount;
import com.aliyun.mns.client.CloudQueue;
import com.aliyun.mns.common.BatchDeleteException;
import com.aliyun.mns.common.BatchSendException;
import com.aliyun.mns.common.ServiceException;
import com.aliyun.mns.model.ErrorMessageResult;
import com.aliyun.mns.model.Message;
import com.baijia.commons.lang.utils.mq.MsgQueue;
import com.baijia.commons.lang.utils.mq.mns.MnsMsg;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class MnsMsgQueue
implements MsgQueue<Message, MnsMsg> {
    private static final int MAX_SIZE = 16;
    private static final long DEF_TIMEOUT = 35000L;
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private String queueName;
    private CloudAccount account;
    private CloudQueue queue;
    private long timeout = 35000L;

    public MnsMsgQueue(String queueName, CloudAccount account) {
        this.queueName = queueName;
        this.account = account;
        this.queue = account.getMNSClient().getQueueRef(queueName);
    }

    @Override
    public String getQueueName() {
        return this.queueName;
    }

    public CloudAccount getAccount() {
        return this.account;
    }

    public CloudQueue getQueue() {
        return this.queue;
    }

    @Override
    public List<MnsMsg> push(List<MnsMsg> msgs) {
        List<Message> messages = this.toMessage(msgs);
        if (messages.isEmpty()) {
            return Collections.emptyList();
        }
        List<List<Message>> splits = com.baijia.commons.lang.utils.collection.CollectionUtils.split(messages, 16);
        ArrayList<MnsMsg> result = new ArrayList<MnsMsg>(messages.size());
        for (List<Message> split : splits) {
            BatchSendException ex = this.push(split, result);
            if (ex == null) continue;
            throw ex;
        }
        return result;
    }

    private BatchSendException push(List<Message> messages, List<MnsMsg> result) {
        AsyncPutCallback putCallback = new AsyncPutCallback(result, messages);
        AsyncQueueSyncCallback<List<Message>> syncCallback = new AsyncQueueSyncCallback<List<Message>>(putCallback);
        AsyncResult asyncBatchPutMessage = this.queue.asyncBatchPutMessage(messages, syncCallback);
        asyncBatchPutMessage.getResult(this.timeout);
        syncCallback.setIsRun(false);
        if (!syncCallback.isSuccess() && putCallback.ex == null) {
            BatchSendException ex = new BatchSendException(messages);
            return ex;
        }
        return putCallback.ex;
    }

    @Override
    public List<MnsMsg> peek(int size) throws Exception {
        if (size > 16) {
            size = 16;
        }
        AsyncGetCallback callback = new AsyncGetCallback();
        AsyncQueueSyncCallback<List<Message>> syncCallback = new AsyncQueueSyncCallback<List<Message>>(callback);
        AsyncResult asyncBatchPeekMessage = this.queue.asyncBatchPeekMessage(size, syncCallback);
        asyncBatchPeekMessage.getResult(this.timeout);
        syncCallback.setIsRun(false);
        if (!syncCallback.isSuccess()) {
            ServiceException sex;
            if (callback.ex == null) {
                throw new TimeoutException("timeout over " + this.timeout + "ms");
            }
            if (callback.ex instanceof ServiceException && (sex = (ServiceException)callback.ex).getErrorCode().equalsIgnoreCase("MessageNotExist")) {
                return Collections.emptyList();
            }
            throw callback.ex;
        }
        return callback.result;
    }

    @Override
    public List<MnsMsg> pop(int size) throws Exception {
        if (size > 16) {
            size = 16;
        }
        AsyncGetCallback callback = new AsyncGetCallback();
        AsyncQueueSyncCallback<List<Message>> syncCallback = new AsyncQueueSyncCallback<List<Message>>(callback);
        AsyncResult asyncBatchPeekMessage = this.queue.asyncBatchPopMessage(size, syncCallback);
        asyncBatchPeekMessage.getResult(this.timeout);
        syncCallback.setIsRun(false);
        if (!syncCallback.isSuccess()) {
            ServiceException sex;
            if (callback.ex == null) {
                throw new TimeoutException("timeout over " + this.timeout + "ms");
            }
            if (callback.ex instanceof ServiceException && (sex = (ServiceException)callback.ex).getErrorCode().equalsIgnoreCase("MessageNotExist")) {
                return Collections.emptyList();
            }
            throw callback.ex;
        }
        return callback.result;
    }

    @Override
    public boolean delete(List<MnsMsg> msgs) {
        if (msgs == null || msgs.isEmpty()) {
            return true;
        }
        ArrayList<String> receiptHandles = new ArrayList<String>(msgs.size());
        for (MnsMsg msg : msgs) {
            String receiptHandle = ((Message)msg.getOriginMsg()).getReceiptHandle();
            if (StringUtils.isBlank((CharSequence)receiptHandle)) {
                this.log.warn("queue[{}] invalid delete msg[{}]", (Object)this.queueName, (Object)((Message)msg.getOriginMsg()).getMessageId());
                continue;
            }
            receiptHandles.add(receiptHandle);
        }
        if (receiptHandles.isEmpty()) {
            return true;
        }
        List splits = com.baijia.commons.lang.utils.collection.CollectionUtils.split(receiptHandles, 16);
        for (List<String> list : splits) {
            this.deleteByHandles(list);
        }
        return true;
    }

    private Exception deleteByHandles(List<String> receiptHandles) {
        AsyncDelCallback callback = new AsyncDelCallback();
        AsyncQueueSyncCallback<Void> syncCallback = new AsyncQueueSyncCallback<Void>(callback);
        AsyncResult asyncBatchDeleteMessage = this.queue.asyncBatchDeleteMessage(receiptHandles, syncCallback);
        asyncBatchDeleteMessage.getResult(this.timeout);
        syncCallback.setIsRun(false);
        if (!syncCallback.isSuccess() && callback.ex == null) {
            return new TimeoutException("delete timeout over " + this.timeout + "ms");
        }
        return callback.ex;
    }

    private List<MnsMsg> toMnsMsg(List<Message> messages) {
        if (messages == null || messages.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<MnsMsg> result = new ArrayList<MnsMsg>(messages.size());
        for (Message message : messages) {
            result.add(new MnsMsg(message));
        }
        return result;
    }

    private List<Message> toMessage(List<MnsMsg> msgs) {
        if (msgs == null || msgs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Message> messages = new ArrayList<Message>(msgs.size());
        for (MnsMsg msg : msgs) {
            messages.add((Message)msg.getOriginMsg());
        }
        return messages;
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(long timeout) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout can't be less than 0.");
        }
        this.timeout = timeout;
    }

    private class AsyncDelCallback
    implements AsyncCallback<Void> {
        Exception ex = null;

        private AsyncDelCallback() {
        }

        public void onSuccess(Void result) {
        }

        public void onFail(Exception ex) {
            this.ex = ex;
            if (ex instanceof BatchDeleteException) {
                Map errorMessages = ((BatchDeleteException)ex).getErrorMessages();
                for (String receiptHandle : errorMessages.keySet()) {
                    ErrorMessageResult error = (ErrorMessageResult)errorMessages.get(receiptHandle);
                    MnsMsgQueue.this.log.warn("ReceiptHandle to delete[{}], errorcode[{}], errormessage[{}]", new Object[]{receiptHandle, error.getErrorCode(), error.getErrorMessage()});
                }
            } else {
                MnsMsgQueue.this.log.warn("AsyncBatchDeleteMessage Exception: ", (Throwable)ex);
            }
        }
    }

    private class AsyncGetCallback
    implements AsyncCallback<List<Message>> {
        Exception ex = null;
        List<MnsMsg> result = Collections.emptyList();

        private AsyncGetCallback() {
        }

        public void onSuccess(List<Message> msgs) {
            if (CollectionUtils.isEmpty(msgs)) {
                return;
            }
            this.result = MnsMsgQueue.this.toMnsMsg(msgs);
        }

        public void onFail(Exception ex) {
            this.ex = ex;
        }
    }

    private class AsyncPutCallback
    implements AsyncCallback<List<Message>> {
        BatchSendException ex = null;
        List<MnsMsg> result;
        List<Message> messages;

        public AsyncPutCallback(List<MnsMsg> result, List<Message> messages) {
            this.result = result;
            this.messages = messages;
        }

        public void onSuccess(List<Message> msgs) {
            this.result.addAll(MnsMsgQueue.this.toMnsMsg(msgs));
        }

        public void onFail(Exception ex) {
            if (ex instanceof BatchSendException) {
                this.ex = (BatchSendException)ex;
            } else {
                this.ex = new BatchSendException(this.messages);
                this.ex.setStackTrace(ex.getStackTrace());
            }
        }
    }

    private class AsyncQueueSyncCallback<T>
    implements AsyncCallback<T> {
        private ReentrantLock rlock = new ReentrantLock();
        volatile boolean isRun = true;
        boolean isSuccess = false;
        AsyncCallback<T> orgCallBack;

        public AsyncQueueSyncCallback(AsyncCallback<T> orgCallBack) {
            this.orgCallBack = orgCallBack;
        }

        public void setIsRun(boolean isRun) {
            try {
                this.rlock.lock();
                this.isRun = isRun;
            }
            finally {
                this.rlock.unlock();
            }
        }

        public boolean isSuccess() {
            try {
                this.rlock.lock();
                boolean bl = this.isSuccess;
                return bl;
            }
            finally {
                this.rlock.unlock();
            }
        }

        public void onSuccess(T msgs) {
            try {
                this.rlock.lock();
                if (!this.isRun) {
                    return;
                }
                this.orgCallBack.onSuccess(msgs);
                this.isSuccess = true;
            }
            finally {
                this.rlock.unlock();
            }
        }

        public void onFail(Exception ex) {
            try {
                this.rlock.lock();
                if (!this.isRun) {
                    return;
                }
                this.isSuccess = false;
                this.orgCallBack.onFail(ex);
            }
            finally {
                this.rlock.unlock();
            }
        }
    }
}

