/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.commons.lang.utils.mq;

import com.baijia.commons.lang.utils.mq.ConsumeCallback;
import com.baijia.commons.lang.utils.mq.Msg;
import com.baijia.commons.lang.utils.mq.MsgQueue;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MsgQueueReceiver<M, T extends Msg<M>> {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected MsgQueue<M, T> queue;
    protected ConsumeCallback<M, T> callback;
    protected int batchSize;

    public MsgQueueReceiver(MsgQueue<M, T> queue, ConsumeCallback<M, T> callback, int batchSize) {
        this.queue = queue;
        this.callback = callback;
        this.batchSize = batchSize;
    }

    public abstract void excute();

    protected List<T> getMsgs() throws Exception {
        return this.queue.peek(this.batchSize);
    }

    protected void finishMsgs(List<T> msgs) throws Exception {
        this.queue.pop(msgs.size());
    }
}

