/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.commons.lang.utils.mail;

import com.baijia.commons.lang.utils.mail.PasswordAuthenticator;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailService {
    private static final Logger logger = LoggerFactory.getLogger(MailService.class);

    public static void send(Properties props, String subject, String content) {
        MailService.send(props, subject, content, null);
    }

    public static void send(Properties props, String subject, String content, String attachFile) {
        String[] attachFiles = null;
        if (StringUtils.isNotEmpty((CharSequence)attachFile)) {
            attachFiles = new String[]{attachFile};
        }
        MailService.send(props, subject, content, attachFiles);
    }

    public static void send(Properties props, String subject, String content, String[] attachFiles) {
        MailService.send(props, subject, content, attachFiles, null, true, true);
    }

    public static void sendAndDeleteFile(Properties props, String subject, String content, File file) {
        MailService.send(props, subject, content, Arrays.asList(file), true);
    }

    public static void sendAndKeepFile(Properties props, String subject, String content, File file) {
        MailService.send(props, subject, content, Arrays.asList(file), false);
    }

    public static void send(Properties props, String subject, String content, Collection<File> files, boolean deleteFiles) {
        MailService.send(props, subject, content, null, files, true, deleteFiles);
    }

    /*
     * Unable to fully structure code
     */
    public static void send(Properties props, String subject, String content, String[] attachFiles, Collection<File> files, boolean isHtml, boolean deleteFiles) {
        block26: {
            transport = null;
            try {
                try {
                    session = Session.getDefaultInstance((Properties)props, (Authenticator)new PasswordAuthenticator(props));
                    msg = new MimeMessage(session);
                    msg.setFrom((Address)new InternetAddress(props.getProperty("mail.from")));
                    mailto = props.getProperty("mail.to");
                    toAddr = mailto.split(",");
                    addrs = new Address[toAddr.length];
                    i = 0;
                    while (i < toAddr.length) {
                        addrs[i] = new InternetAddress(toAddr[i]);
                        ++i;
                    }
                    msg.setRecipients(Message.RecipientType.TO, addrs);
                    mailcc = props.getProperty("mail.cc");
                    if (StringUtils.isNotEmpty((CharSequence)mailcc)) {
                        ccAddr = mailcc.split(",");
                        ccAddrs = new Address[ccAddr.length];
                        i = 0;
                        while (i < ccAddr.length) {
                            ccAddrs[i] = new InternetAddress(ccAddr[i]);
                            ++i;
                        }
                        msg.setRecipients(Message.RecipientType.CC, ccAddrs);
                    }
                    mmp = new MimeMultipart();
                    msg.setContent((Multipart)mmp);
                    if (subject != null) {
                        msg.setSubject(subject);
                    }
                    if (content != null) {
                        contentMbp = new MimeBodyPart();
                        if (isHtml) {
                            contentMbp.setContent((Object)content, "text/html;charset=utf-8");
                        } else {
                            contentMbp.setContent((Object)content, "text/plain");
                        }
                        mmp.addBodyPart((BodyPart)contentMbp);
                    }
                    if (attachFiles != null) {
                        var18_20 = attachFiles;
                        var17_21 = attachFiles.length;
                        var16_18 = 0;
                        while (var16_18 < var17_21) {
                            attachFile = var18_20[var16_18];
                            mbp = new MimeBodyPart();
                            fds = new FileDataSource(attachFile);
                            mbp.setDataHandler(new DataHandler((DataSource)fds));
                            try {
                                mbp.setFileName(MimeUtility.encodeText((String)fds.getName()));
                            }
                            catch (UnsupportedEncodingException e) {
                                MailService.logger.error("encode file name:{} catch error:{}", (Object)fds.getName(), (Object)e);
                                mbp.setFileName(fds.getName());
                            }
                            mmp.addBodyPart((BodyPart)mbp);
                            ++var16_18;
                        }
                    }
                    if (files != null && !files.isEmpty()) {
                        for (File file : files) {
                            mbp = new MimeBodyPart();
                            fds = new FileDataSource(file);
                            mbp.setDataHandler(new DataHandler((DataSource)fds));
                            try {
                                mbp.setFileName(MimeUtility.encodeText((String)fds.getName()));
                            }
                            catch (UnsupportedEncodingException e) {
                                MailService.logger.error("encode file name:{} catch error:{}", (Object)fds.getName(), (Object)e);
                                mbp.setFileName(fds.getName());
                            }
                            mmp.addBodyPart((BodyPart)mbp);
                        }
                    }
                    msg.setSentDate(new Date());
                    transport = session.getTransport("smtp");
                    Transport.send((Message)msg);
                    MailService.logger.info("mail has been sent - subject:{}", (Object)subject);
                }
                catch (MessagingException e) {
                    MailService.logger.error("send exception - ", (Throwable)e);
                    throw new RuntimeException("send mail exception - ", e);
                }
            }
            finally {
                try {
                    if (transport != null) {
                        transport.close();
                    }
                }
                catch (Exception e) {
                    MailService.logger.error("send exception - ", (Throwable)e);
                    throw new RuntimeException("send mail exception - ", e);
                }
                if (!deleteFiles || files == null || files.isEmpty()) break block26;
                ** for (file : files)
            }
lbl-1000:
            // 1 sources

            {
                if (file == null) continue;
                file.delete();
                continue;
            }
        }
    }
}

