/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.commons.lang.utils.http;

import javax.servlet.http.HttpServletRequest;

public class IpUtils {
    public static String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    public static long ip2Long(String ip) {
        String[] ips = ip.split("\\.");
        long i1 = Long.valueOf(ips[0]);
        long i2 = Long.valueOf(ips[1]);
        long i3 = Long.valueOf(ips[2]);
        long i4 = Long.valueOf(ips[3]);
        return i1 << 24 | i2 << 16 | i3 << 8 | i4;
    }

    public static String long2Ip(long ip) {
        int i1 = (int)(ip >> 24) & 0xFF;
        int i2 = (int)(ip >> 16) & 0xFF;
        int i3 = (int)(ip >> 8) & 0xFF;
        int i4 = (int)ip & 0xFF;
        StringBuilder sb = new StringBuilder();
        sb.append(i1).append(".").append(i2).append(".").append(i3).append(".").append(i4);
        return sb.toString();
    }
}

